/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.format.enigma.EnigmaDirWriter;
import net.fabricmc.mappingio.format.enigma.EnigmaFileWriter;
import net.fabricmc.mappingio.format.proguard.ProGuardFileWriter;
import net.fabricmc.mappingio.format.tiny.Tiny1FileWriter;
import net.fabricmc.mappingio.format.tiny.Tiny2FileWriter;

public interface MappingWriter
extends Closeable,
MappingVisitor {
    public static MappingWriter create(Path file, MappingFormat format) throws IOException {
        if (format.hasSingleFile()) {
            return MappingWriter.create(Files.newBufferedWriter(file, new OpenOption[0]), format);
        }
        switch (format) {
            case ENIGMA_DIR: {
                return new EnigmaDirWriter(file, true);
            }
        }
        throw new UnsupportedOperationException("format " + (Object)((Object)format) + " is not implemented");
    }

    public static MappingWriter create(Writer writer, MappingFormat format) throws IOException {
        if (!format.hasSingleFile()) {
            throw new IllegalArgumentException("format " + (Object)((Object)format) + " is not applicable to a single writer");
        }
        switch (format) {
            case TINY_FILE: {
                return new Tiny1FileWriter(writer);
            }
            case TINY_2_FILE: {
                return new Tiny2FileWriter(writer, false);
            }
            case ENIGMA_FILE: {
                return new EnigmaFileWriter(writer);
            }
            case PROGUARD_FILE: {
                return new ProGuardFileWriter(writer);
            }
        }
        throw new UnsupportedOperationException("format " + (Object)((Object)format) + " is not implemented");
    }

    @Override
    default public boolean visitEnd() throws IOException {
        this.close();
        return true;
    }
}

