/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.format.enigma;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.format.enigma.EnigmaWriterBase;

public final class EnigmaDirWriter
extends EnigmaWriterBase {
    private final Path dir;

    public EnigmaDirWriter(final Path dir, boolean deleteExistingFiles) throws IOException {
        super(null);
        this.dir = dir.toAbsolutePath().normalize();
        if (deleteExistingFiles && Files.exists(dir, new LinkOption[0])) {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().endsWith("." + MappingFormat.ENIGMA_FILE.fileExt)) {
                        Files.delete(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path file, IOException exc) throws IOException {
                    try {
                        if (!dir.equals(file)) {
                            Files.delete(file);
                        }
                    }
                    catch (DirectoryNotEmptyException directoryNotEmptyException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
            this.currentClass = null;
        }
    }

    @Override
    public boolean visitElementContent(MappedElementKind targetKind) throws IOException {
        if (targetKind == MappedElementKind.CLASS) {
            String name;
            String string = name = this.dstName != null ? this.dstName : this.srcClassName;
            if (this.currentClass == null || !name.startsWith(this.currentClass) || name.length() > this.currentClass.length() && name.charAt(this.currentClass.length()) != '$') {
                Path file;
                int pos = EnigmaDirWriter.getNextOuterEnd(name, 0);
                if (pos >= 0) {
                    name = name.substring(0, pos);
                }
                if (!(file = this.dir.resolve(name + "." + MappingFormat.ENIGMA_FILE.fileExt).normalize()).startsWith(this.dir)) {
                    throw new RuntimeException("invalid name: " + name);
                }
                if (this.writer != null) {
                    this.writer.close();
                }
                this.currentClass = name;
                if (Files.exists(file, new LinkOption[0])) {
                    ArrayList<String> writtenClassParts = new ArrayList<String>();
                    try (BufferedReader reader = Files.newBufferedReader(file);){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            int offset;
                            for (offset = 0; offset < line.length() && line.charAt(offset) == '\t'; ++offset) {
                            }
                            if (!line.startsWith("CLASS ", offset)) continue;
                            int start = offset + 6;
                            int end = line.indexOf(32, start);
                            if (end < 0) {
                                end = line.length();
                            }
                            String part = line.substring(start, end);
                            while (writtenClassParts.size() > offset) {
                                writtenClassParts.remove(writtenClassParts.size() - 1);
                            }
                            writtenClassParts.add(part);
                        }
                    }
                    this.lastWrittenClass = String.join((CharSequence)"$", writtenClassParts);
                } else {
                    this.lastWrittenClass = "";
                    Files.createDirectories(file.getParent(), new FileAttribute[0]);
                }
                this.writer = Files.newBufferedWriter(file, StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
            }
            this.writeMismatchedOrMissingClasses();
        } else if (targetKind == MappedElementKind.FIELD || targetKind == MappedElementKind.METHOD) {
            this.writer.write(32);
            this.writer.write(this.desc);
            this.writer.write(10);
        } else {
            this.writer.write(10);
        }
        return true;
    }
}

