/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.format.srg;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Set;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingFlag;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.ColumnFileReader;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;

public final class SrgFileReader {
    private SrgFileReader() {
    }

    public static void read(Reader reader, MappingVisitor visitor) throws IOException {
        SrgFileReader.read(reader, "source", "target", visitor);
    }

    public static void read(Reader reader, String sourceNs, String targetNs, MappingVisitor visitor) throws IOException {
        SrgFileReader.read(new ColumnFileReader(reader, ' '), sourceNs, targetNs, visitor);
    }

    private static void read(ColumnFileReader reader, String sourceNs, String targetNs, MappingVisitor visitor) throws IOException {
        Set<MappingFlag> flags = visitor.getFlags();
        MappingVisitor parentVisitor = null;
        if (flags.contains((Object)MappingFlag.NEEDS_ELEMENT_UNIQUENESS)) {
            parentVisitor = visitor;
            visitor = new MemoryMappingTree();
        } else if (flags.contains((Object)MappingFlag.NEEDS_MULTIPLE_PASSES)) {
            reader.mark();
        }
        while (true) {
            boolean visitHeader;
            if (visitHeader = visitor.visitHeader()) {
                visitor.visitNamespaces(sourceNs, Collections.singletonList(targetNs));
            }
            if (visitor.visitContent()) {
                String lastClass = null;
                boolean visitLastClass = false;
                do {
                    String dst;
                    String srcDesc;
                    if (reader.nextCol("CL:")) {
                        String srcName = reader.nextCol();
                        if (srcName == null || srcName.isEmpty()) {
                            throw new IOException("missing class-name-a in line " + reader.getLineNumber());
                        }
                        if (srcName.equals(lastClass)) continue;
                        lastClass = srcName;
                        visitLastClass = visitor.visitClass(srcName);
                        if (!visitLastClass) continue;
                        String dstName = reader.nextCol();
                        if (dstName == null || dstName.isEmpty()) {
                            throw new IOException("missing class-name-b in line " + reader.getLineNumber());
                        }
                        visitor.visitDstName(MappedElementKind.CLASS, 0, dstName);
                        visitLastClass = visitor.visitElementContent(MappedElementKind.CLASS);
                        continue;
                    }
                    boolean isMethod = reader.nextCol("MD:");
                    if (!isMethod && !reader.nextCol("FD:")) continue;
                    String src = reader.nextCol();
                    if (src == null) {
                        throw new IOException("missing class/name a in line " + reader.getLineNumber());
                    }
                    int srcSepPos = src.lastIndexOf(47);
                    if (srcSepPos <= 0 || srcSepPos == src.length() - 1) {
                        throw new IOException("invalid class/name a in line " + reader.getLineNumber());
                    }
                    if (isMethod) {
                        srcDesc = reader.nextCol();
                        if (srcDesc == null || srcDesc.isEmpty()) {
                            throw new IOException("missing desc a in line " + reader.getLineNumber());
                        }
                    } else {
                        srcDesc = null;
                    }
                    if ((dst = reader.nextCol()) == null) {
                        throw new IOException("missing class/name b in line " + reader.getLineNumber());
                    }
                    int dstSepPos = dst.lastIndexOf(47);
                    if (dstSepPos <= 0 || dstSepPos == dst.length() - 1) {
                        throw new IOException("invalid class/name b in line " + reader.getLineNumber());
                    }
                    String srcOwner = src.substring(0, srcSepPos);
                    if (!srcOwner.equals(lastClass)) {
                        lastClass = srcOwner;
                        visitLastClass = visitor.visitClass(srcOwner);
                        if (visitLastClass) {
                            visitor.visitDstName(MappedElementKind.CLASS, 0, dst.substring(0, dstSepPos));
                            visitLastClass = visitor.visitElementContent(MappedElementKind.CLASS);
                        }
                    }
                    if (!visitLastClass) continue;
                    String srcName = src.substring(srcSepPos + 1);
                    if ((!isMethod || !visitor.visitMethod(srcName, srcDesc)) && (isMethod || !visitor.visitField(srcName, srcDesc))) continue;
                    MappedElementKind kind = isMethod ? MappedElementKind.METHOD : MappedElementKind.FIELD;
                    visitor.visitDstName(kind, 0, dst.substring(dstSepPos + 1));
                    visitor.visitElementContent(kind);
                } while (reader.nextLine(0));
            }
            if (visitor.visitEnd()) break;
            reader.reset();
        }
        if (parentVisitor != null) {
            ((MappingTree)((Object)visitor)).accept(parentVisitor);
        }
    }
}

