/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.format.srg;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingFlag;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.ColumnFileReader;

public final class TsrgFileReader {
    private TsrgFileReader() {
    }

    public static List<String> getNamespaces(Reader reader) throws IOException {
        return TsrgFileReader.getNamespaces(new ColumnFileReader(reader, ' '));
    }

    private static List<String> getNamespaces(ColumnFileReader reader) throws IOException {
        if (reader.nextCol("tsrg2")) {
            String ns;
            ArrayList<String> ret = new ArrayList<String>();
            while ((ns = reader.nextCol()) != null) {
                ret.add(ns);
            }
            return ret;
        }
        return Arrays.asList("source", "target");
    }

    public static void read(Reader reader, MappingVisitor visitor) throws IOException {
        TsrgFileReader.read(reader, "source", "target", visitor);
    }

    public static void read(Reader reader, String sourceNs, String targetNs, MappingVisitor visitor) throws IOException {
        TsrgFileReader.read(new ColumnFileReader(reader, ' '), sourceNs, targetNs, visitor);
    }

    private static void read(ColumnFileReader reader, String sourceNs, String targetNs, MappingVisitor visitor) throws IOException {
        ArrayList<String> nameTmp;
        List<String> dstNamespaces;
        String srcNamespace;
        boolean isTsrg2 = reader.nextCol("tsrg2");
        if (isTsrg2) {
            String dstNamespace;
            srcNamespace = reader.nextCol();
            dstNamespaces = new ArrayList<String>();
            while ((dstNamespace = reader.nextCol()) != null) {
                dstNamespaces.add(dstNamespace);
            }
            reader.nextLine(0);
        } else {
            srcNamespace = sourceNs;
            dstNamespaces = Collections.singletonList(targetNs);
        }
        int dstNsCount = dstNamespaces.size();
        if (visitor.getFlags().contains((Object)MappingFlag.NEEDS_MULTIPLE_PASSES)) {
            reader.mark();
        }
        ArrayList<String> arrayList = nameTmp = dstNamespaces.size() > 1 ? new ArrayList<String>(dstNamespaces.size() - 1) : null;
        while (true) {
            boolean visitHeader;
            if (visitHeader = visitor.visitHeader()) {
                visitor.visitNamespaces(srcNamespace, dstNamespaces);
            }
            if (visitor.visitContent()) {
                do {
                    String srcName;
                    if (reader.hasExtraIndents() || (srcName = reader.nextCol()) == null || srcName.endsWith("/")) continue;
                    if (srcName.isEmpty()) {
                        throw new IOException("missing class-name-a in line " + reader.getLineNumber());
                    }
                    if (!visitor.visitClass(srcName)) continue;
                    TsrgFileReader.readClass(reader, isTsrg2, dstNsCount, nameTmp, visitor);
                } while (reader.nextLine(0));
            }
            if (visitor.visitEnd()) break;
            reader.reset();
        }
    }

    private static void readClass(ColumnFileReader reader, boolean isTsrg2, int dstNsCount, List<String> nameTmp, MappingVisitor visitor) throws IOException {
        TsrgFileReader.readDstNames(reader, MappedElementKind.CLASS, 0, dstNsCount, visitor);
        if (!visitor.visitElementContent(MappedElementKind.CLASS)) {
            return;
        }
        while (reader.nextLine(1)) {
            String desc;
            int offset;
            if (reader.hasExtraIndents()) continue;
            String srcName = reader.nextCol();
            if (srcName == null || srcName.isEmpty()) {
                throw new IOException("missing name-a in line " + reader.getLineNumber());
            }
            String arg = reader.nextCol();
            if (arg == null) {
                throw new IOException("missing desc/name-b in line " + reader.getLineNumber());
            }
            if (arg.startsWith("(")) {
                if (!visitor.visitMethod(srcName, arg)) continue;
                TsrgFileReader.readMethod(reader, dstNsCount, visitor);
                continue;
            }
            if (!isTsrg2) {
                if (!visitor.visitField(srcName, null)) continue;
                if (!arg.isEmpty()) {
                    visitor.visitDstName(MappedElementKind.FIELD, 0, arg);
                }
                TsrgFileReader.readElement(reader, MappedElementKind.FIELD, 1, dstNsCount, visitor);
                continue;
            }
            for (int i = 0; i < dstNsCount - 1; ++i) {
                String name = reader.nextCol();
                if (name == null) {
                    throw new IOException("missing name columns in line " + reader.getLineNumber());
                }
                nameTmp.add(name);
            }
            String lastName = reader.nextCol();
            if (lastName == null) {
                offset = 1;
                desc = null;
            } else {
                offset = 0;
                desc = arg;
                if (desc.isEmpty()) {
                    throw new IOException("empty field desc in line " + reader.getLineNumber());
                }
            }
            if (visitor.visitField(srcName, desc)) {
                if (lastName == null && !arg.isEmpty()) {
                    visitor.visitDstName(MappedElementKind.FIELD, 0, arg);
                }
                for (int i = 0; i < dstNsCount - 1; ++i) {
                    String name = nameTmp.get(i);
                    if (name.isEmpty()) continue;
                    visitor.visitDstName(MappedElementKind.FIELD, i + offset, name);
                }
                if (lastName != null && !lastName.isEmpty()) {
                    visitor.visitDstName(MappedElementKind.FIELD, dstNsCount - 1, lastName);
                }
                visitor.visitElementContent(MappedElementKind.FIELD);
            }
            if (nameTmp == null) continue;
            nameTmp.clear();
        }
    }

    private static void readMethod(ColumnFileReader reader, int dstNsCount, MappingVisitor visitor) throws IOException {
        TsrgFileReader.readDstNames(reader, MappedElementKind.METHOD, 0, dstNsCount, visitor);
        if (!visitor.visitElementContent(MappedElementKind.METHOD)) {
            return;
        }
        while (reader.nextLine(2)) {
            if (reader.hasExtraIndents() || reader.nextCol("static")) continue;
            int lvIndex = reader.nextIntCol();
            if (lvIndex < 0) {
                throw new IOException("missing/invalid parameter lv-index in line " + reader.getLineNumber());
            }
            String srcName = reader.nextCol();
            if (srcName == null) {
                throw new IOException("missing var-name-a column in line " + reader.getLineNumber());
            }
            if (srcName.isEmpty()) {
                srcName = null;
            }
            if (!visitor.visitMethodArg(-1, lvIndex, srcName)) continue;
            TsrgFileReader.readElement(reader, MappedElementKind.METHOD_ARG, 0, dstNsCount, visitor);
        }
    }

    private static void readElement(ColumnFileReader reader, MappedElementKind kind, int dstNsOffset, int dstNsCount, MappingVisitor visitor) throws IOException {
        TsrgFileReader.readDstNames(reader, kind, dstNsOffset, dstNsCount, visitor);
        visitor.visitElementContent(kind);
    }

    private static void readDstNames(ColumnFileReader reader, MappedElementKind subjectKind, int dstNsOffset, int dstNsCount, MappingVisitor visitor) throws IOException {
        for (int dstNs = dstNsOffset; dstNs < dstNsCount; ++dstNs) {
            String name = reader.nextCol();
            if (name == null) {
                throw new IOException("missing name columns in line " + reader.getLineNumber());
            }
            if (name.isEmpty()) continue;
            visitor.visitDstName(subjectKind, dstNs, name);
        }
    }
}

