/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.tree;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import net.fabricmc.mappingio.tree.HierarchyInfoProvider;
import net.fabricmc.mappingio.tree.MappingTreeView;
import net.fabricmc.tinyremapper.api.TrClass;
import net.fabricmc.tinyremapper.api.TrEnvironment;
import net.fabricmc.tinyremapper.api.TrField;
import net.fabricmc.tinyremapper.api.TrMethod;

public final class TinyRemapperHierarchyProvider
implements HierarchyInfoProvider<HierarchyData> {
    private final TrEnvironment env;
    private final String namespace;

    public TinyRemapperHierarchyProvider(TrEnvironment env, String namespace) {
        this.env = env;
        this.namespace = namespace;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String resolveField(String owner, String name, String desc) {
        TrClass cls = this.env.getClass(owner);
        if (cls == null) {
            return null;
        }
        TrField field = cls.resolveField(name, desc);
        return field != null ? field.getOwner().getName() : null;
    }

    @Override
    public String resolveMethod(String owner, String name, String desc) {
        TrClass cls = this.env.getClass(owner);
        if (cls == null) {
            return null;
        }
        TrMethod method = cls.resolveMethod(name, desc);
        return method != null ? method.getOwner().getName() : null;
    }

    @Override
    public HierarchyData getMethodHierarchy(String owner, String name, String desc) {
        TrClass cls = this.env.getClass(owner);
        if (cls == null) {
            return null;
        }
        TrMethod method = cls.resolveMethod(name, desc);
        if (method == null) {
            return null;
        }
        if (!method.isVirtual()) {
            return new HierarchyData(Collections.singletonList(method));
        }
        cls = method.getOwner();
        ArrayList<TrMethod> methods = new ArrayList<TrMethod>();
        methods.add(method);
        ArrayDeque<TrClass> toCheckUp = new ArrayDeque<TrClass>();
        ArrayDeque<TrClass> toCheckDown = new ArrayDeque<TrClass>();
        Set queuedUp = Collections.newSetFromMap(new IdentityHashMap());
        Set queuedDown = Collections.newSetFromMap(new IdentityHashMap());
        toCheckUp.add(cls);
        toCheckDown.add(cls);
        queuedUp.add(cls);
        queuedDown.add(cls);
        block0: while (true) {
            if ((cls = (TrClass)toCheckUp.poll()) != null) {
                Iterator iterator = cls.getParents().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    TrClass parent = (TrClass)iterator.next();
                    method = parent.getMethod(name, desc);
                    if (method != null && method.isVirtual() && queuedDown.add(parent)) {
                        methods.add(method);
                        toCheckDown.add(parent);
                    }
                    if (!queuedUp.add(parent)) continue;
                    toCheckUp.add(parent);
                }
            }
            while ((cls = (TrClass)toCheckDown.poll()) != null) {
                for (TrClass child : cls.getChildren()) {
                    method = child.getMethod(name, desc);
                    if (method != null && method.isVirtual() && queuedUp.add(child)) {
                        methods.add(method);
                        toCheckUp.add(child);
                    }
                    if (!queuedDown.add(child)) continue;
                    toCheckDown.add(child);
                }
            }
            if (toCheckUp.isEmpty() && toCheckDown.isEmpty()) break;
        }
        assert (methods.size() == new HashSet<TrMethod>(methods).size());
        return new HierarchyData(methods);
    }

    @Override
    public int getHierarchySize(HierarchyData hierarchy) {
        return hierarchy != null ? hierarchy.methods.size() : 0;
    }

    @Override
    public Collection<? extends MappingTreeView.MethodMappingView> getHierarchyMethods(HierarchyData hierarchy, MappingTreeView tree) {
        if (hierarchy == null) {
            return Collections.emptyList();
        }
        ArrayList<MappingTreeView.MethodMappingView> ret = new ArrayList<MappingTreeView.MethodMappingView>(hierarchy.methods.size());
        int ns = tree.getNamespaceId(this.namespace);
        assert (ns != -2);
        for (TrMethod method : hierarchy.methods) {
            MappingTreeView.MethodMappingView m = tree.getMethod(method.getOwner().getName(), method.getName(), method.getDesc(), ns);
            if (m == null) continue;
            ret.add(m);
        }
        return ret;
    }

    public static final class HierarchyData {
        final Collection<TrMethod> methods;

        HierarchyData(Collection<TrMethod> methods) {
            this.methods = methods;
        }
    }
}

