package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiAlphanum {

    /**
     * 🔠
     */
    Emoji INPUT_LATIN_UPPERCASE = new Emoji("🔠", "\uD83D\uDD20", Collections.singletonList(":capital_abcd:"), Collections.singletonList(":capital_abcd:"), Collections.singletonList(":capital_abcd:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "input latin uppercase", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🔡
     */
    Emoji INPUT_LATIN_LOWERCASE = new Emoji("🔡", "\uD83D\uDD21", Collections.singletonList(":abcd:"), Collections.singletonList(":abcd:"), Collections.singletonList(":abcd:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "input latin lowercase", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🔢
     */
    Emoji INPUT_NUMBERS = new Emoji("🔢", "\uD83D\uDD22", Collections.unmodifiableList(Arrays.asList(":1234:", ":input_numbers:")), Collections.singletonList(":1234:"), Collections.singletonList(":1234:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "input numbers", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🔣
     */
    Emoji INPUT_SYMBOLS = new Emoji("🔣", "\uD83D\uDD23", Collections.unmodifiableList(Arrays.asList(":symbols:", ":input_symbols:")), Collections.singletonList(":symbols:"), Collections.singletonList(":symbols:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "input symbols", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🔤
     */
    Emoji INPUT_LATIN_LETTERS = new Emoji("🔤", "\uD83D\uDD24", Collections.singletonList(":abc:"), Collections.singletonList(":abc:"), Collections.singletonList(":abc:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "input latin letters", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🅰️
     */
    Emoji A_BUTTON_BLOOD_TYPE = new Emoji("🅰️", "\uD83C\uDD70\uFE0F", Collections.singletonList(":a:"), Collections.singletonList(":a:"), Collections.singletonList(":a:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "A button (blood type)", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🅰
     */
    Emoji A_BUTTON_BLOOD_TYPE_UNQUALIFIED = new Emoji("🅰", "\uD83C\uDD70", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":a:"), false, false, 0.6, Qualification.fromString("unqualified"), "A button (blood type)", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, true);

    /**
     * 🆎
     */
    Emoji AB_BUTTON_BLOOD_TYPE = new Emoji("🆎", "\uD83C\uDD8E", Collections.singletonList(":ab:"), Collections.singletonList(":ab:"), Collections.singletonList(":ab:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "AB button (blood type)", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🅱️
     */
    Emoji B_BUTTON_BLOOD_TYPE = new Emoji("🅱️", "\uD83C\uDD71\uFE0F", Collections.singletonList(":b:"), Collections.singletonList(":b:"), Collections.singletonList(":b:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "B button (blood type)", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🅱
     */
    Emoji B_BUTTON_BLOOD_TYPE_UNQUALIFIED = new Emoji("🅱", "\uD83C\uDD71", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":b:"), false, false, 0.6, Qualification.fromString("unqualified"), "B button (blood type)", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, true);

    /**
     * 🆑
     */
    Emoji CL_BUTTON = new Emoji("🆑", "\uD83C\uDD91", Collections.singletonList(":cl:"), Collections.singletonList(":cl:"), Collections.singletonList(":cl:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "CL button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🆒
     */
    Emoji COOL_BUTTON = new Emoji("🆒", "\uD83C\uDD92", Collections.singletonList(":cool:"), Collections.singletonList(":cool:"), Collections.singletonList(":cool:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "COOL button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🆓
     */
    Emoji FREE_BUTTON = new Emoji("🆓", "\uD83C\uDD93", Collections.singletonList(":free:"), Collections.singletonList(":free:"), Collections.singletonList(":free:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "FREE button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * ℹ️
     */
    Emoji INFORMATION = new Emoji("ℹ️", "\u2139\uFE0F", Collections.unmodifiableList(Arrays.asList(":information_source:", ":information:")), Collections.singletonList(":information_source:"), Collections.singletonList(":information_source:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "information", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * ℹ
     */
    Emoji INFORMATION_UNQUALIFIED = new Emoji("ℹ", "\u2139", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":information_source:"), false, false, 0.6, Qualification.fromString("unqualified"), "information", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, true);

    /**
     * 🆔
     */
    Emoji ID_BUTTON = new Emoji("🆔", "\uD83C\uDD94", Collections.singletonList(":id:"), Collections.singletonList(":id:"), Collections.singletonList(":id:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "ID button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * Ⓜ️
     */
    Emoji CIRCLED_M = new Emoji("Ⓜ️", "\u24C2\uFE0F", Collections.unmodifiableList(Arrays.asList(":m:", ":circled_m:")), Collections.singletonList(":m:"), Collections.singletonList(":m:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "circled M", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * Ⓜ
     */
    Emoji CIRCLED_M_UNQUALIFIED = new Emoji("Ⓜ", "\u24C2", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":m:"), false, false, 0.6, Qualification.fromString("unqualified"), "circled M", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, true);

    /**
     * 🆕
     */
    Emoji NEW_BUTTON = new Emoji("🆕", "\uD83C\uDD95", Collections.singletonList(":new:"), Collections.singletonList(":new:"), Collections.singletonList(":new:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "NEW button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🆖
     */
    Emoji NG_BUTTON = new Emoji("🆖", "\uD83C\uDD96", Collections.singletonList(":ng:"), Collections.singletonList(":ng:"), Collections.singletonList(":ng:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "NG button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🅾️
     */
    Emoji O_BUTTON_BLOOD_TYPE = new Emoji("🅾️", "\uD83C\uDD7E\uFE0F", Collections.singletonList(":o2:"), Collections.singletonList(":o2:"), Collections.singletonList(":o2:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "O button (blood type)", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🅾
     */
    Emoji O_BUTTON_BLOOD_TYPE_UNQUALIFIED = new Emoji("🅾", "\uD83C\uDD7E", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":o2:"), false, false, 0.6, Qualification.fromString("unqualified"), "O button (blood type)", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, true);

    /**
     * 🆗
     */
    Emoji OK_BUTTON = new Emoji("🆗", "\uD83C\uDD97", Collections.singletonList(":ok:"), Collections.singletonList(":ok:"), Collections.singletonList(":ok:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "OK button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🅿️
     */
    Emoji P_BUTTON = new Emoji("🅿️", "\uD83C\uDD7F\uFE0F", Collections.singletonList(":parking:"), Collections.singletonList(":parking:"), Collections.singletonList(":parking:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "P button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🅿
     */
    Emoji P_BUTTON_UNQUALIFIED = new Emoji("🅿", "\uD83C\uDD7F", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":parking:"), false, false, 0.6, Qualification.fromString("unqualified"), "P button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, true);

    /**
     * 🆘
     */
    Emoji SOS_BUTTON = new Emoji("🆘", "\uD83C\uDD98", Collections.singletonList(":sos:"), Collections.singletonList(":sos:"), Collections.singletonList(":sos:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "SOS button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🆙
     */
    Emoji UP_BUTTON = new Emoji("🆙", "\uD83C\uDD99", Collections.singletonList(":up:"), Collections.singletonList(":up:"), Collections.singletonList(":up:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "UP! button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🆚
     */
    Emoji VS_BUTTON = new Emoji("🆚", "\uD83C\uDD9A", Collections.singletonList(":vs:"), Collections.singletonList(":vs:"), Collections.singletonList(":vs:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "VS button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🈁
     */
    Emoji JAPANESE_HERE_BUTTON = new Emoji("🈁", "\uD83C\uDE01", Collections.singletonList(":koko:"), Collections.singletonList(":koko:"), Collections.singletonList(":koko:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese “here” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🈂️
     */
    Emoji JAPANESE_SERVICE_CHARGE_BUTTON = new Emoji("🈂️", "\uD83C\uDE02\uFE0F", Collections.singletonList(":sa:"), Collections.singletonList(":sa:"), Collections.singletonList(":sa:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese “service charge” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🈂
     */
    Emoji JAPANESE_SERVICE_CHARGE_BUTTON_UNQUALIFIED = new Emoji("🈂", "\uD83C\uDE02", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":sa:"), false, false, 0.6, Qualification.fromString("unqualified"), "Japanese “service charge” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, true);

    /**
     * 🈷️
     */
    Emoji JAPANESE_MONTHLY_AMOUNT_BUTTON = new Emoji("🈷️", "\uD83C\uDE37\uFE0F", Collections.singletonList(":u6708:"), Collections.singletonList(":u6708:"), Collections.singletonList(":u6708:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese “monthly amount” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🈷
     */
    Emoji JAPANESE_MONTHLY_AMOUNT_BUTTON_UNQUALIFIED = new Emoji("🈷", "\uD83C\uDE37", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":u6708:"), false, false, 0.6, Qualification.fromString("unqualified"), "Japanese “monthly amount” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, true);

    /**
     * 🈶
     */
    Emoji JAPANESE_NOT_FREE_OF_CHARGE_BUTTON = new Emoji("🈶", "\uD83C\uDE36", Collections.singletonList(":u6709:"), Collections.singletonList(":u6709:"), Collections.singletonList(":u6709:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese “not free of charge” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🈯
     */
    Emoji JAPANESE_RESERVED_BUTTON = new Emoji("🈯", "\uD83C\uDE2F", Collections.singletonList(":u6307:"), Collections.singletonList(":u6307:"), Collections.singletonList(":u6307:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese “reserved” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, true);

    /**
     * 🉐
     */
    Emoji JAPANESE_BARGAIN_BUTTON = new Emoji("🉐", "\uD83C\uDE50", Collections.singletonList(":ideograph_advantage:"), Collections.singletonList(":ideograph_advantage:"), Collections.singletonList(":ideograph_advantage:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese “bargain” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🈹
     */
    Emoji JAPANESE_DISCOUNT_BUTTON = new Emoji("🈹", "\uD83C\uDE39", Collections.singletonList(":u5272:"), Collections.singletonList(":u5272:"), Collections.singletonList(":u5272:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese “discount” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🈚
     */
    Emoji JAPANESE_FREE_OF_CHARGE_BUTTON = new Emoji("🈚", "\uD83C\uDE1A", Collections.singletonList(":u7121:"), Collections.singletonList(":u7121:"), Collections.singletonList(":u7121:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese “free of charge” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, true);

    /**
     * 🈲
     */
    Emoji JAPANESE_PROHIBITED_BUTTON = new Emoji("🈲", "\uD83C\uDE32", Collections.singletonList(":u7981:"), Collections.singletonList(":u7981:"), Collections.singletonList(":u7981:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese “prohibited” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🉑
     */
    Emoji JAPANESE_ACCEPTABLE_BUTTON = new Emoji("🉑", "\uD83C\uDE51", Collections.singletonList(":accept:"), Collections.singletonList(":accept:"), Collections.singletonList(":accept:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese “acceptable” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🈸
     */
    Emoji JAPANESE_APPLICATION_BUTTON = new Emoji("🈸", "\uD83C\uDE38", Collections.singletonList(":u7533:"), Collections.singletonList(":u7533:"), Collections.singletonList(":u7533:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese “application” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🈴
     */
    Emoji JAPANESE_PASSING_GRADE_BUTTON = new Emoji("🈴", "\uD83C\uDE34", Collections.singletonList(":u5408:"), Collections.singletonList(":u5408:"), Collections.singletonList(":u5408:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese “passing grade” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🈳
     */
    Emoji JAPANESE_VACANCY_BUTTON = new Emoji("🈳", "\uD83C\uDE33", Collections.singletonList(":u7a7a:"), Collections.singletonList(":u7a7a:"), Collections.singletonList(":u7a7a:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese “vacancy” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * ㊗️
     */
    Emoji JAPANESE_CONGRATULATIONS_BUTTON = new Emoji("㊗️", "\u3297\uFE0F", Collections.singletonList(":congratulations:"), Collections.singletonList(":congratulations:"), Collections.singletonList(":congratulations:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese “congratulations” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * ㊗
     */
    Emoji JAPANESE_CONGRATULATIONS_BUTTON_UNQUALIFIED = new Emoji("㊗", "\u3297", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":congratulations:"), false, false, 0.6, Qualification.fromString("unqualified"), "Japanese “congratulations” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, true);

    /**
     * ㊙️
     */
    Emoji JAPANESE_SECRET_BUTTON = new Emoji("㊙️", "\u3299\uFE0F", Collections.singletonList(":secret:"), Collections.singletonList(":secret:"), Collections.singletonList(":secret:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese “secret” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * ㊙
     */
    Emoji JAPANESE_SECRET_BUTTON_UNQUALIFIED = new Emoji("㊙", "\u3299", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":secret:"), false, false, 0.6, Qualification.fromString("unqualified"), "Japanese “secret” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, true);

    /**
     * 🈺
     */
    Emoji JAPANESE_OPEN_FOR_BUSINESS_BUTTON = new Emoji("🈺", "\uD83C\uDE3A", Collections.singletonList(":u55b6:"), Collections.singletonList(":u55b6:"), Collections.singletonList(":u55b6:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese “open for business” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);

    /**
     * 🈵
     */
    Emoji JAPANESE_NO_VACANCY_BUTTON = new Emoji("🈵", "\uD83C\uDE35", Collections.singletonList(":u6e80:"), Collections.singletonList(":u6e80:"), Collections.singletonList(":u6e80:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese “no vacancy” button", EmojiGroup.SYMBOLS, EmojiSubGroup.ALPHANUM, false);
}
