package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiAnimalBug {

    /**
     * 🐌
     */
    Emoji SNAIL = new Emoji("🐌", "\uD83D\uDC0C", Collections.singletonList(":snail:"), Collections.singletonList(":snail:"), Collections.singletonList(":snail:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "snail", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BUG, false);

    /**
     * 🦋
     */
    Emoji BUTTERFLY = new Emoji("🦋", "\uD83E\uDD8B", Collections.singletonList(":butterfly:"), Collections.singletonList(":butterfly:"), Collections.singletonList(":butterfly:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "butterfly", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BUG, false);

    /**
     * 🐛
     */
    Emoji BUG = new Emoji("🐛", "\uD83D\uDC1B", Collections.singletonList(":bug:"), Collections.singletonList(":bug:"), Collections.singletonList(":bug:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "bug", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BUG, false);

    /**
     * 🐜
     */
    Emoji ANT = new Emoji("🐜", "\uD83D\uDC1C", Collections.singletonList(":ant:"), Collections.singletonList(":ant:"), Collections.singletonList(":ant:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "ant", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BUG, false);

    /**
     * 🐝
     */
    Emoji HONEYBEE = new Emoji("🐝", "\uD83D\uDC1D", Collections.unmodifiableList(Arrays.asList(":bee:", ":honeybee:")), Collections.singletonList(":bee:"), Collections.unmodifiableList(Arrays.asList(":bee:", ":honeybee:")), false, false, 0.6, Qualification.fromString("fully-qualified"), "honeybee", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BUG, false);

    /**
     * 🪲
     */
    Emoji BEETLE = new Emoji("🪲", "\uD83E\uDEB2", Collections.singletonList(":beetle:"), Collections.singletonList(":beetle:"), Collections.singletonList(":beetle:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "beetle", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BUG, false);

    /**
     * 🐞
     */
    Emoji LADY_BEETLE = new Emoji("🐞", "\uD83D\uDC1E", Collections.singletonList(":lady_beetle:"), Collections.singletonList(":ladybug:"), Collections.singletonList(":lady_beetle:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "lady beetle", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BUG, false);

    /**
     * 🦗
     */
    Emoji CRICKET = new Emoji("🦗", "\uD83E\uDD97", Collections.singletonList(":cricket:"), Collections.singletonList(":cricket:"), Collections.singletonList(":cricket:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "cricket", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BUG, false);

    /**
     * 🪳
     */
    Emoji COCKROACH = new Emoji("🪳", "\uD83E\uDEB3", Collections.singletonList(":cockroach:"), Collections.singletonList(":cockroach:"), Collections.singletonList(":cockroach:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "cockroach", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BUG, false);

    /**
     * 🕷️
     */
    Emoji SPIDER = new Emoji("🕷️", "\uD83D\uDD77\uFE0F", Collections.singletonList(":spider:"), Collections.singletonList(":spider:"), Collections.singletonList(":spider:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "spider", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BUG, false);

    /**
     * 🕷
     */
    Emoji SPIDER_UNQUALIFIED = new Emoji("🕷", "\uD83D\uDD77", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":spider:"), false, false, 0.7, Qualification.fromString("unqualified"), "spider", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BUG, true);

    /**
     * 🕸️
     */
    Emoji SPIDER_WEB = new Emoji("🕸️", "\uD83D\uDD78\uFE0F", Collections.singletonList(":spider_web:"), Collections.singletonList(":spider_web:"), Collections.singletonList(":spider_web:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "spider web", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BUG, false);

    /**
     * 🕸
     */
    Emoji SPIDER_WEB_UNQUALIFIED = new Emoji("🕸", "\uD83D\uDD78", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":spider_web:"), false, false, 0.7, Qualification.fromString("unqualified"), "spider web", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BUG, true);

    /**
     * 🦂
     */
    Emoji SCORPION = new Emoji("🦂", "\uD83E\uDD82", Collections.singletonList(":scorpion:"), Collections.singletonList(":scorpion:"), Collections.singletonList(":scorpion:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "scorpion", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BUG, false);

    /**
     * 🦟
     */
    Emoji MOSQUITO = new Emoji("🦟", "\uD83E\uDD9F", Collections.singletonList(":mosquito:"), Collections.singletonList(":mosquito:"), Collections.singletonList(":mosquito:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "mosquito", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BUG, false);

    /**
     * 🪰
     */
    Emoji FLY = new Emoji("🪰", "\uD83E\uDEB0", Collections.singletonList(":fly:"), Collections.singletonList(":fly:"), Collections.singletonList(":fly:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "fly", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BUG, false);

    /**
     * 🪱
     */
    Emoji WORM = new Emoji("🪱", "\uD83E\uDEB1", Collections.singletonList(":worm:"), Collections.singletonList(":worm:"), Collections.singletonList(":worm:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "worm", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BUG, false);

    /**
     * 🦠
     */
    Emoji MICROBE = new Emoji("🦠", "\uD83E\uDDA0", Collections.singletonList(":microbe:"), Collections.singletonList(":microbe:"), Collections.singletonList(":microbe:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "microbe", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BUG, false);
}
