package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiArtsAndCrafts {

    /**
     * 🎭
     */
    Emoji PERFORMING_ARTS = new Emoji("🎭", "\uD83C\uDFAD", Collections.singletonList(":performing_arts:"), Collections.singletonList(":performing_arts:"), Collections.singletonList(":performing_arts:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "performing arts", EmojiGroup.ACTIVITIES, EmojiSubGroup.ARTS_AND_CRAFTS, true);

    /**
     * 🖼️
     */
    Emoji FRAMED_PICTURE = new Emoji("🖼️", "\uD83D\uDDBC\uFE0F", Collections.unmodifiableList(Arrays.asList(":frame_photo:", ":frame_with_picture:")), Collections.singletonList(":frame_with_picture:"), Collections.singletonList(":framed_picture:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "framed picture", EmojiGroup.ACTIVITIES, EmojiSubGroup.ARTS_AND_CRAFTS, false);

    /**
     * 🖼
     */
    Emoji FRAMED_PICTURE_UNQUALIFIED = new Emoji("🖼", "\uD83D\uDDBC", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":framed_picture:"), false, false, 0.7, Qualification.fromString("unqualified"), "framed picture", EmojiGroup.ACTIVITIES, EmojiSubGroup.ARTS_AND_CRAFTS, true);

    /**
     * 🎨
     */
    Emoji ARTIST_PALETTE = new Emoji("🎨", "\uD83C\uDFA8", Collections.singletonList(":art:"), Collections.singletonList(":art:"), Collections.singletonList(":art:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "artist palette", EmojiGroup.ACTIVITIES, EmojiSubGroup.ARTS_AND_CRAFTS, false);

    /**
     * 🧵
     */
    Emoji THREAD = new Emoji("🧵", "\uD83E\uDDF5", Collections.singletonList(":thread:"), Collections.singletonList(":thread:"), Collections.singletonList(":thread:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "thread", EmojiGroup.ACTIVITIES, EmojiSubGroup.ARTS_AND_CRAFTS, false);

    /**
     * 🪡
     */
    Emoji SEWING_NEEDLE = new Emoji("🪡", "\uD83E\uDEA1", Collections.singletonList(":sewing_needle:"), Collections.singletonList(":sewing_needle:"), Collections.singletonList(":sewing_needle:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "sewing needle", EmojiGroup.ACTIVITIES, EmojiSubGroup.ARTS_AND_CRAFTS, false);

    /**
     * 🧶
     */
    Emoji YARN = new Emoji("🧶", "\uD83E\uDDF6", Collections.singletonList(":yarn:"), Collections.singletonList(":yarn:"), Collections.singletonList(":yarn:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "yarn", EmojiGroup.ACTIVITIES, EmojiSubGroup.ARTS_AND_CRAFTS, false);

    /**
     * 🪢
     */
    Emoji KNOT = new Emoji("🪢", "\uD83E\uDEA2", Collections.singletonList(":knot:"), Collections.singletonList(":knot:"), Collections.singletonList(":knot:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "knot", EmojiGroup.ACTIVITIES, EmojiSubGroup.ARTS_AND_CRAFTS, false);
}
