package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiAvSymbol {

    /**
     * 🔀
     */
    Emoji SHUFFLE_TRACKS_BUTTON = new Emoji("🔀", "\uD83D\uDD00", Collections.singletonList(":twisted_rightwards_arrows:"), Collections.singletonList(":twisted_rightwards_arrows:"), Collections.singletonList(":twisted_rightwards_arrows:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "shuffle tracks button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);

    /**
     * 🔁
     */
    Emoji REPEAT_BUTTON = new Emoji("🔁", "\uD83D\uDD01", Collections.singletonList(":repeat:"), Collections.singletonList(":repeat:"), Collections.singletonList(":repeat:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "repeat button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);

    /**
     * 🔂
     */
    Emoji REPEAT_SINGLE_BUTTON = new Emoji("🔂", "\uD83D\uDD02", Collections.singletonList(":repeat_one:"), Collections.singletonList(":repeat_one:"), Collections.singletonList(":repeat_one:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "repeat single button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);

    /**
     * ▶️
     */
    Emoji PLAY_BUTTON = new Emoji("▶️", "\u25B6\uFE0F", Collections.singletonList(":arrow_forward:"), Collections.singletonList(":arrow_forward:"), Collections.singletonList(":arrow_forward:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "play button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);

    /**
     * ▶
     */
    Emoji PLAY_BUTTON_UNQUALIFIED = new Emoji("▶", "\u25B6", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":arrow_forward:"), false, false, 0.6, Qualification.fromString("unqualified"), "play button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, true);

    /**
     * ⏩
     */
    Emoji FAST_FORWARD_BUTTON = new Emoji("⏩", "\u23E9", Collections.singletonList(":fast_forward:"), Collections.singletonList(":fast_forward:"), Collections.singletonList(":fast_forward:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "fast-forward button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, true);

    /**
     * ⏭️
     */
    Emoji NEXT_TRACK_BUTTON = new Emoji("⏭️", "\u23ED\uFE0F", Collections.unmodifiableList(Arrays.asList(":track_next:", ":next_track:")), Collections.singletonList(":black_right_pointing_double_triangle_with_vertical_bar:"), Collections.singletonList(":next_track_button:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "next track button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);

    /**
     * ⏭
     */
    Emoji NEXT_TRACK_BUTTON_UNQUALIFIED = new Emoji("⏭", "\u23ED", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":next_track_button:"), false, false, 0.7, Qualification.fromString("unqualified"), "next track button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, true);

    /**
     * ⏯️
     */
    Emoji PLAY_OR_PAUSE_BUTTON = new Emoji("⏯️", "\u23EF\uFE0F", Collections.singletonList(":play_pause:"), Collections.singletonList(":black_right_pointing_triangle_with_double_vertical_bar:"), Collections.singletonList(":play_or_pause_button:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "play or pause button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);

    /**
     * ⏯
     */
    Emoji PLAY_OR_PAUSE_BUTTON_UNQUALIFIED = new Emoji("⏯", "\u23EF", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":play_or_pause_button:"), false, false, 1.0, Qualification.fromString("unqualified"), "play or pause button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, true);

    /**
     * ◀️
     */
    Emoji REVERSE_BUTTON = new Emoji("◀️", "\u25C0\uFE0F", Collections.singletonList(":arrow_backward:"), Collections.singletonList(":arrow_backward:"), Collections.singletonList(":arrow_backward:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "reverse button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);

    /**
     * ◀
     */
    Emoji REVERSE_BUTTON_UNQUALIFIED = new Emoji("◀", "\u25C0", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":arrow_backward:"), false, false, 0.6, Qualification.fromString("unqualified"), "reverse button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, true);

    /**
     * ⏪
     */
    Emoji FAST_REVERSE_BUTTON = new Emoji("⏪", "\u23EA", Collections.singletonList(":rewind:"), Collections.singletonList(":rewind:"), Collections.singletonList(":rewind:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "fast reverse button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, true);

    /**
     * ⏮️
     */
    Emoji LAST_TRACK_BUTTON = new Emoji("⏮️", "\u23EE\uFE0F", Collections.unmodifiableList(Arrays.asList(":track_previous:", ":previous_track:")), Collections.singletonList(":black_left_pointing_double_triangle_with_vertical_bar:"), Collections.singletonList(":previous_track_button:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "last track button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);

    /**
     * ⏮
     */
    Emoji LAST_TRACK_BUTTON_UNQUALIFIED = new Emoji("⏮", "\u23EE", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":previous_track_button:"), false, false, 0.7, Qualification.fromString("unqualified"), "last track button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, true);

    /**
     * 🔼
     */
    Emoji UPWARDS_BUTTON = new Emoji("🔼", "\uD83D\uDD3C", Collections.singletonList(":arrow_up_small:"), Collections.singletonList(":arrow_up_small:"), Collections.singletonList(":arrow_up_small:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "upwards button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);

    /**
     * ⏫
     */
    Emoji FAST_UP_BUTTON = new Emoji("⏫", "\u23EB", Collections.singletonList(":arrow_double_up:"), Collections.singletonList(":arrow_double_up:"), Collections.singletonList(":arrow_double_up:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "fast up button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, true);

    /**
     * 🔽
     */
    Emoji DOWNWARDS_BUTTON = new Emoji("🔽", "\uD83D\uDD3D", Collections.singletonList(":arrow_down_small:"), Collections.singletonList(":arrow_down_small:"), Collections.singletonList(":arrow_down_small:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "downwards button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);

    /**
     * ⏬
     */
    Emoji FAST_DOWN_BUTTON = new Emoji("⏬", "\u23EC", Collections.singletonList(":arrow_double_down:"), Collections.singletonList(":arrow_double_down:"), Collections.singletonList(":arrow_double_down:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "fast down button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, true);

    /**
     * ⏸️
     */
    Emoji PAUSE_BUTTON = new Emoji("⏸️", "\u23F8\uFE0F", Collections.unmodifiableList(Arrays.asList(":pause_button:", ":double_vertical_bar:")), Collections.singletonList(":double_vertical_bar:"), Collections.singletonList(":pause_button:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "pause button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);

    /**
     * ⏸
     */
    Emoji PAUSE_BUTTON_UNQUALIFIED = new Emoji("⏸", "\u23F8", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":pause_button:"), false, false, 0.7, Qualification.fromString("unqualified"), "pause button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, true);

    /**
     * ⏹️
     */
    Emoji STOP_BUTTON = new Emoji("⏹️", "\u23F9\uFE0F", Collections.singletonList(":stop_button:"), Collections.singletonList(":black_square_for_stop:"), Collections.singletonList(":stop_button:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "stop button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);

    /**
     * ⏹
     */
    Emoji STOP_BUTTON_UNQUALIFIED = new Emoji("⏹", "\u23F9", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":stop_button:"), false, false, 0.7, Qualification.fromString("unqualified"), "stop button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, true);

    /**
     * ⏺️
     */
    Emoji RECORD_BUTTON = new Emoji("⏺️", "\u23FA\uFE0F", Collections.singletonList(":record_button:"), Collections.singletonList(":black_circle_for_record:"), Collections.singletonList(":record_button:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "record button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);

    /**
     * ⏺
     */
    Emoji RECORD_BUTTON_UNQUALIFIED = new Emoji("⏺", "\u23FA", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":record_button:"), false, false, 0.7, Qualification.fromString("unqualified"), "record button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, true);

    /**
     * ⏏️
     */
    Emoji EJECT_BUTTON = new Emoji("⏏️", "\u23CF\uFE0F", Collections.unmodifiableList(Arrays.asList(":eject:", ":eject_symbol:")), Collections.singletonList(":eject:"), Collections.singletonList(":eject_button:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "eject button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);

    /**
     * ⏏
     */
    Emoji EJECT_BUTTON_UNQUALIFIED = new Emoji("⏏", "\u23CF", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":eject_button:"), false, false, 1.0, Qualification.fromString("unqualified"), "eject button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, true);

    /**
     * 🎦
     */
    Emoji CINEMA = new Emoji("🎦", "\uD83C\uDFA6", Collections.singletonList(":cinema:"), Collections.singletonList(":cinema:"), Collections.singletonList(":cinema:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "cinema", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);

    /**
     * 🔅
     */
    Emoji DIM_BUTTON = new Emoji("🔅", "\uD83D\uDD05", Collections.singletonList(":low_brightness:"), Collections.singletonList(":low_brightness:"), Collections.singletonList(":low_brightness:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "dim button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);

    /**
     * 🔆
     */
    Emoji BRIGHT_BUTTON = new Emoji("🔆", "\uD83D\uDD06", Collections.singletonList(":high_brightness:"), Collections.singletonList(":high_brightness:"), Collections.singletonList(":high_brightness:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "bright button", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);

    /**
     * 📶
     */
    Emoji ANTENNA_BARS = new Emoji("📶", "\uD83D\uDCF6", Collections.unmodifiableList(Arrays.asList(":signal_strength:", ":antenna_bars:")), Collections.singletonList(":signal_strength:"), Collections.singletonList(":signal_strength:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "antenna bars", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);

    /**
     * 🛜
     */
    Emoji WIRELESS = new Emoji("🛜", "\uD83D\uDEDC", Collections.singletonList(":wireless:"), Collections.emptyList(), Collections.singletonList(":wireless:"), false, false, 15.0, Qualification.fromString("fully-qualified"), "wireless", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);

    /**
     * 📳
     */
    Emoji VIBRATION_MODE = new Emoji("📳", "\uD83D\uDCF3", Collections.singletonList(":vibration_mode:"), Collections.singletonList(":vibration_mode:"), Collections.singletonList(":vibration_mode:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "vibration mode", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);

    /**
     * 📴
     */
    Emoji MOBILE_PHONE_OFF = new Emoji("📴", "\uD83D\uDCF4", Collections.singletonList(":mobile_phone_off:"), Collections.singletonList(":mobile_phone_off:"), Collections.singletonList(":mobile_phone_off:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "mobile phone off", EmojiGroup.SYMBOLS, EmojiSubGroup.AV_SYMBOL, false);
}
