package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiAwardMedal {

    /**
     * 🎖️
     */
    Emoji MILITARY_MEDAL = new Emoji("🎖️", "\uD83C\uDF96\uFE0F", Collections.singletonList(":military_medal:"), Collections.singletonList(":medal:"), Collections.singletonList(":medal_military:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "military medal", EmojiGroup.ACTIVITIES, EmojiSubGroup.AWARD_MEDAL, false);

    /**
     * 🎖
     */
    Emoji MILITARY_MEDAL_UNQUALIFIED = new Emoji("🎖", "\uD83C\uDF96", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":medal_military:"), false, false, 0.7, Qualification.fromString("unqualified"), "military medal", EmojiGroup.ACTIVITIES, EmojiSubGroup.AWARD_MEDAL, true);

    /**
     * 🏆
     */
    Emoji TROPHY = new Emoji("🏆", "\uD83C\uDFC6", Collections.singletonList(":trophy:"), Collections.singletonList(":trophy:"), Collections.singletonList(":trophy:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "trophy", EmojiGroup.ACTIVITIES, EmojiSubGroup.AWARD_MEDAL, true);

    /**
     * 🏅
     */
    Emoji SPORTS_MEDAL = new Emoji("🏅", "\uD83C\uDFC5", Collections.unmodifiableList(Arrays.asList(":medal:", ":sports_medal:")), Collections.singletonList(":sports_medal:"), Collections.singletonList(":medal_sports:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "sports medal", EmojiGroup.ACTIVITIES, EmojiSubGroup.AWARD_MEDAL, false);

    /**
     * 🥇
     */
    Emoji FIRST_PLACE_MEDAL = new Emoji("🥇", "\uD83E\uDD47", Collections.unmodifiableList(Arrays.asList(":first_place:", ":first_place_medal:")), Collections.singletonList(":first_place_medal:"), Collections.singletonList(":1st_place_medal:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "1st place medal", EmojiGroup.ACTIVITIES, EmojiSubGroup.AWARD_MEDAL, false);

    /**
     * 🥈
     */
    Emoji SECOND_PLACE_MEDAL = new Emoji("🥈", "\uD83E\uDD48", Collections.unmodifiableList(Arrays.asList(":second_place:", ":second_place_medal:")), Collections.singletonList(":second_place_medal:"), Collections.singletonList(":2nd_place_medal:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "2nd place medal", EmojiGroup.ACTIVITIES, EmojiSubGroup.AWARD_MEDAL, false);

    /**
     * 🥉
     */
    Emoji THIRD_PLACE_MEDAL = new Emoji("🥉", "\uD83E\uDD49", Collections.unmodifiableList(Arrays.asList(":third_place:", ":third_place_medal:")), Collections.singletonList(":third_place_medal:"), Collections.singletonList(":3rd_place_medal:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "3rd place medal", EmojiGroup.ACTIVITIES, EmojiSubGroup.AWARD_MEDAL, false);
}
