package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiClothing {

    /**
     * 👓
     */
    Emoji GLASSES = new Emoji("👓", "\uD83D\uDC53", Collections.unmodifiableList(Arrays.asList(":eyeglasses:", ":glasses:")), Collections.singletonList(":eyeglasses:"), Collections.singletonList(":eyeglasses:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "glasses", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, true);

    /**
     * 🕶️
     */
    Emoji SUNGLASSES = new Emoji("🕶️", "\uD83D\uDD76\uFE0F", Collections.singletonList(":dark_sunglasses:"), Collections.singletonList(":dark_sunglasses:"), Collections.singletonList(":dark_sunglasses:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "sunglasses", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🕶
     */
    Emoji SUNGLASSES_UNQUALIFIED = new Emoji("🕶", "\uD83D\uDD76", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":dark_sunglasses:"), false, false, 0.7, Qualification.fromString("unqualified"), "sunglasses", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, true);

    /**
     * 🥽
     */
    Emoji GOGGLES = new Emoji("🥽", "\uD83E\uDD7D", Collections.singletonList(":goggles:"), Collections.singletonList(":goggles:"), Collections.singletonList(":goggles:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "goggles", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🥼
     */
    Emoji LAB_COAT = new Emoji("🥼", "\uD83E\uDD7C", Collections.singletonList(":lab_coat:"), Collections.singletonList(":lab_coat:"), Collections.singletonList(":lab_coat:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "lab coat", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🦺
     */
    Emoji SAFETY_VEST = new Emoji("🦺", "\uD83E\uDDBA", Collections.singletonList(":safety_vest:"), Collections.singletonList(":safety_vest:"), Collections.singletonList(":safety_vest:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "safety vest", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 👔
     */
    Emoji NECKTIE = new Emoji("👔", "\uD83D\uDC54", Collections.singletonList(":necktie:"), Collections.singletonList(":necktie:"), Collections.singletonList(":necktie:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "necktie", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 👕
     */
    Emoji T_SHIRT = new Emoji("👕", "\uD83D\uDC55", Collections.unmodifiableList(Arrays.asList(":shirt:", ":t_shirt:")), Collections.singletonList(":shirt:"), Collections.unmodifiableList(Arrays.asList(":shirt:", ":tshirt:")), false, false, 0.6, Qualification.fromString("fully-qualified"), "t-shirt", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 👖
     */
    Emoji JEANS = new Emoji("👖", "\uD83D\uDC56", Collections.singletonList(":jeans:"), Collections.singletonList(":jeans:"), Collections.singletonList(":jeans:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "jeans", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🧣
     */
    Emoji SCARF = new Emoji("🧣", "\uD83E\uDDE3", Collections.singletonList(":scarf:"), Collections.singletonList(":scarf:"), Collections.singletonList(":scarf:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "scarf", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🧤
     */
    Emoji GLOVES = new Emoji("🧤", "\uD83E\uDDE4", Collections.singletonList(":gloves:"), Collections.singletonList(":gloves:"), Collections.singletonList(":gloves:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "gloves", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🧥
     */
    Emoji COAT = new Emoji("🧥", "\uD83E\uDDE5", Collections.singletonList(":coat:"), Collections.singletonList(":coat:"), Collections.singletonList(":coat:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "coat", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🧦
     */
    Emoji SOCKS = new Emoji("🧦", "\uD83E\uDDE6", Collections.singletonList(":socks:"), Collections.singletonList(":socks:"), Collections.singletonList(":socks:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "socks", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 👗
     */
    Emoji DRESS = new Emoji("👗", "\uD83D\uDC57", Collections.singletonList(":dress:"), Collections.singletonList(":dress:"), Collections.singletonList(":dress:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "dress", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 👘
     */
    Emoji KIMONO = new Emoji("👘", "\uD83D\uDC58", Collections.singletonList(":kimono:"), Collections.singletonList(":kimono:"), Collections.singletonList(":kimono:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "kimono", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🥻
     */
    Emoji SARI = new Emoji("🥻", "\uD83E\uDD7B", Collections.singletonList(":sari:"), Collections.singletonList(":sari:"), Collections.singletonList(":sari:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "sari", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🩱
     */
    Emoji ONE_PIECE_SWIMSUIT = new Emoji("🩱", "\uD83E\uDE71", Collections.singletonList(":one_piece_swimsuit:"), Collections.singletonList(":one-piece_swimsuit:"), Collections.singletonList(":one_piece_swimsuit:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "one-piece swimsuit", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🩲
     */
    Emoji BRIEFS = new Emoji("🩲", "\uD83E\uDE72", Collections.singletonList(":briefs:"), Collections.singletonList(":briefs:"), Collections.singletonList(":swim_brief:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "briefs", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🩳
     */
    Emoji SHORTS = new Emoji("🩳", "\uD83E\uDE73", Collections.singletonList(":shorts:"), Collections.singletonList(":shorts:"), Collections.singletonList(":shorts:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "shorts", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 👙
     */
    Emoji BIKINI = new Emoji("👙", "\uD83D\uDC59", Collections.singletonList(":bikini:"), Collections.singletonList(":bikini:"), Collections.singletonList(":bikini:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "bikini", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 👚
     */
    Emoji WOMAN_S_CLOTHES = new Emoji("👚", "\uD83D\uDC5A", Collections.singletonList(":womans_clothes:"), Collections.singletonList(":womans_clothes:"), Collections.singletonList(":womans_clothes:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "woman’s clothes", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🪭
     */
    Emoji FOLDING_HAND_FAN = new Emoji("🪭", "\uD83E\uDEAD", Collections.singletonList(":folding_hand_fan:"), Collections.emptyList(), Collections.singletonList(":folding_hand_fan:"), false, false, 15.0, Qualification.fromString("fully-qualified"), "folding hand fan", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 👛
     */
    Emoji PURSE = new Emoji("👛", "\uD83D\uDC5B", Collections.singletonList(":purse:"), Collections.singletonList(":purse:"), Collections.singletonList(":purse:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "purse", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 👜
     */
    Emoji HANDBAG = new Emoji("👜", "\uD83D\uDC5C", Collections.singletonList(":handbag:"), Collections.singletonList(":handbag:"), Collections.singletonList(":handbag:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "handbag", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 👝
     */
    Emoji CLUTCH_BAG = new Emoji("👝", "\uD83D\uDC5D", Collections.unmodifiableList(Arrays.asList(":pouch:", ":clutch_bag:")), Collections.singletonList(":pouch:"), Collections.singletonList(":pouch:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "clutch bag", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🛍️
     */
    Emoji SHOPPING_BAGS = new Emoji("🛍️", "\uD83D\uDECD\uFE0F", Collections.singletonList(":shopping_bags:"), Collections.singletonList(":shopping_bags:"), Collections.singletonList(":shopping:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "shopping bags", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🛍
     */
    Emoji SHOPPING_BAGS_UNQUALIFIED = new Emoji("🛍", "\uD83D\uDECD", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":shopping:"), false, false, 0.7, Qualification.fromString("unqualified"), "shopping bags", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, true);

    /**
     * 🎒
     */
    Emoji BACKPACK = new Emoji("🎒", "\uD83C\uDF92", Collections.unmodifiableList(Arrays.asList(":school_satchel:", ":backpack:")), Collections.singletonList(":school_satchel:"), Collections.singletonList(":school_satchel:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "backpack", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🩴
     */
    Emoji THONG_SANDAL = new Emoji("🩴", "\uD83E\uDE74", Collections.singletonList(":thong_sandal:"), Collections.singletonList(":thong_sandal:"), Collections.singletonList(":thong_sandal:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "thong sandal", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 👞
     */
    Emoji MAN_S_SHOE = new Emoji("👞", "\uD83D\uDC5E", Collections.singletonList(":mans_shoe:"), Collections.singletonList(":mans_shoe:"), Collections.unmodifiableList(Arrays.asList(":mans_shoe:", ":shoe:")), false, false, 0.6, Qualification.fromString("fully-qualified"), "man’s shoe", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 👟
     */
    Emoji RUNNING_SHOE = new Emoji("👟", "\uD83D\uDC5F", Collections.unmodifiableList(Arrays.asList(":athletic_shoe:", ":running_shoe:")), Collections.singletonList(":athletic_shoe:"), Collections.singletonList(":athletic_shoe:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "running shoe", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🥾
     */
    Emoji HIKING_BOOT = new Emoji("🥾", "\uD83E\uDD7E", Collections.singletonList(":hiking_boot:"), Collections.singletonList(":hiking_boot:"), Collections.singletonList(":hiking_boot:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "hiking boot", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🥿
     */
    Emoji FLAT_SHOE = new Emoji("🥿", "\uD83E\uDD7F", Collections.unmodifiableList(Arrays.asList(":womans_flat_shoe:", ":flat_shoe:")), Collections.singletonList(":womans_flat_shoe:"), Collections.singletonList(":flat_shoe:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "flat shoe", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 👠
     */
    Emoji HIGH_HEELED_SHOE = new Emoji("👠", "\uD83D\uDC60", Collections.singletonList(":high_heel:"), Collections.singletonList(":high_heel:"), Collections.singletonList(":high_heel:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "high-heeled shoe", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 👡
     */
    Emoji WOMAN_S_SANDAL = new Emoji("👡", "\uD83D\uDC61", Collections.unmodifiableList(Arrays.asList(":sandal:", ":womans_sandal:")), Collections.singletonList(":sandal:"), Collections.singletonList(":sandal:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "woman’s sandal", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🩰
     */
    Emoji BALLET_SHOES = new Emoji("🩰", "\uD83E\uDE70", Collections.singletonList(":ballet_shoes:"), Collections.singletonList(":ballet_shoes:"), Collections.singletonList(":ballet_shoes:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "ballet shoes", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 👢
     */
    Emoji WOMAN_S_BOOT = new Emoji("👢", "\uD83D\uDC62", Collections.unmodifiableList(Arrays.asList(":boot:", ":womans_boot:")), Collections.singletonList(":boot:"), Collections.singletonList(":boot:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "woman’s boot", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🪮
     */
    Emoji HAIR_PICK = new Emoji("🪮", "\uD83E\uDEAE", Collections.singletonList(":hair_pick:"), Collections.emptyList(), Collections.singletonList(":hair_pick:"), false, false, 15.0, Qualification.fromString("fully-qualified"), "hair pick", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 👑
     */
    Emoji CROWN = new Emoji("👑", "\uD83D\uDC51", Collections.singletonList(":crown:"), Collections.singletonList(":crown:"), Collections.singletonList(":crown:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "crown", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 👒
     */
    Emoji WOMAN_S_HAT = new Emoji("👒", "\uD83D\uDC52", Collections.singletonList(":womans_hat:"), Collections.singletonList(":womans_hat:"), Collections.singletonList(":womans_hat:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "woman’s hat", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🎩
     */
    Emoji TOP_HAT = new Emoji("🎩", "\uD83C\uDFA9", Collections.unmodifiableList(Arrays.asList(":tophat:", ":top_hat:")), Collections.singletonList(":tophat:"), Collections.singletonList(":tophat:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "top hat", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🎓
     */
    Emoji GRADUATION_CAP = new Emoji("🎓", "\uD83C\uDF93", Collections.singletonList(":mortar_board:"), Collections.singletonList(":mortar_board:"), Collections.singletonList(":mortar_board:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "graduation cap", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, true);

    /**
     * 🧢
     */
    Emoji BILLED_CAP = new Emoji("🧢", "\uD83E\uDDE2", Collections.singletonList(":billed_cap:"), Collections.singletonList(":billed_cap:"), Collections.singletonList(":billed_cap:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "billed cap", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 🪖
     */
    Emoji MILITARY_HELMET = new Emoji("🪖", "\uD83E\uDE96", Collections.singletonList(":military_helmet:"), Collections.singletonList(":military_helmet:"), Collections.singletonList(":military_helmet:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "military helmet", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * ⛑️
     */
    Emoji RESCUE_WORKER_S_HELMET = new Emoji("⛑️", "\u26D1\uFE0F", Collections.unmodifiableList(Arrays.asList(":helmet_with_cross:", ":helmet_with_white_cross:")), Collections.singletonList(":helmet_with_white_cross:"), Collections.singletonList(":rescue_worker_helmet:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "rescue worker’s helmet", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * ⛑
     */
    Emoji RESCUE_WORKER_S_HELMET_UNQUALIFIED = new Emoji("⛑", "\u26D1", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":rescue_worker_helmet:"), false, false, 0.7, Qualification.fromString("unqualified"), "rescue worker’s helmet", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, true);

    /**
     * 📿
     */
    Emoji PRAYER_BEADS = new Emoji("📿", "\uD83D\uDCFF", Collections.singletonList(":prayer_beads:"), Collections.singletonList(":prayer_beads:"), Collections.singletonList(":prayer_beads:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "prayer beads", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 💄
     */
    Emoji LIPSTICK = new Emoji("💄", "\uD83D\uDC84", Collections.singletonList(":lipstick:"), Collections.singletonList(":lipstick:"), Collections.singletonList(":lipstick:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "lipstick", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 💍
     */
    Emoji RING = new Emoji("💍", "\uD83D\uDC8D", Collections.singletonList(":ring:"), Collections.singletonList(":ring:"), Collections.singletonList(":ring:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "ring", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);

    /**
     * 💎
     */
    Emoji GEM_STONE = new Emoji("💎", "\uD83D\uDC8E", Collections.unmodifiableList(Arrays.asList(":gem:", ":gem_stone:")), Collections.singletonList(":gem:"), Collections.singletonList(":gem:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "gem stone", EmojiGroup.OBJECTS, EmojiSubGroup.CLOTHING, false);
}
