package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiComputer {

    /**
     * 🔋
     */
    Emoji BATTERY = new Emoji("🔋", "\uD83D\uDD0B", Collections.singletonList(":battery:"), Collections.singletonList(":battery:"), Collections.singletonList(":battery:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "battery", EmojiGroup.OBJECTS, EmojiSubGroup.COMPUTER, false);

    /**
     * 🪫
     */
    Emoji LOW_BATTERY = new Emoji("🪫", "\uD83E\uDEAB", Collections.singletonList(":low_battery:"), Collections.emptyList(), Collections.singletonList(":low_battery:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "low battery", EmojiGroup.OBJECTS, EmojiSubGroup.COMPUTER, false);

    /**
     * 🔌
     */
    Emoji ELECTRIC_PLUG = new Emoji("🔌", "\uD83D\uDD0C", Collections.singletonList(":electric_plug:"), Collections.singletonList(":electric_plug:"), Collections.singletonList(":electric_plug:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "electric plug", EmojiGroup.OBJECTS, EmojiSubGroup.COMPUTER, false);

    /**
     * 💻
     */
    Emoji LAPTOP = new Emoji("💻", "\uD83D\uDCBB", Collections.singletonList(":computer:"), Collections.singletonList(":computer:"), Collections.singletonList(":computer:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "laptop", EmojiGroup.OBJECTS, EmojiSubGroup.COMPUTER, true);

    /**
     * 🖥️
     */
    Emoji DESKTOP_COMPUTER = new Emoji("🖥️", "\uD83D\uDDA5\uFE0F", Collections.unmodifiableList(Arrays.asList(":desktop:", ":desktop_computer:")), Collections.singletonList(":desktop_computer:"), Collections.singletonList(":desktop_computer:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "desktop computer", EmojiGroup.OBJECTS, EmojiSubGroup.COMPUTER, false);

    /**
     * 🖥
     */
    Emoji DESKTOP_COMPUTER_UNQUALIFIED = new Emoji("🖥", "\uD83D\uDDA5", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":desktop_computer:"), false, false, 0.7, Qualification.fromString("unqualified"), "desktop computer", EmojiGroup.OBJECTS, EmojiSubGroup.COMPUTER, true);

    /**
     * 🖨️
     */
    Emoji PRINTER = new Emoji("🖨️", "\uD83D\uDDA8\uFE0F", Collections.singletonList(":printer:"), Collections.singletonList(":printer:"), Collections.singletonList(":printer:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "printer", EmojiGroup.OBJECTS, EmojiSubGroup.COMPUTER, false);

    /**
     * 🖨
     */
    Emoji PRINTER_UNQUALIFIED = new Emoji("🖨", "\uD83D\uDDA8", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":printer:"), false, false, 0.7, Qualification.fromString("unqualified"), "printer", EmojiGroup.OBJECTS, EmojiSubGroup.COMPUTER, true);

    /**
     * ⌨️
     */
    Emoji KEYBOARD = new Emoji("⌨️", "\u2328\uFE0F", Collections.singletonList(":keyboard:"), Collections.singletonList(":keyboard:"), Collections.singletonList(":keyboard:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "keyboard", EmojiGroup.OBJECTS, EmojiSubGroup.COMPUTER, false);

    /**
     * ⌨
     */
    Emoji KEYBOARD_UNQUALIFIED = new Emoji("⌨", "\u2328", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":keyboard:"), false, false, 1.0, Qualification.fromString("unqualified"), "keyboard", EmojiGroup.OBJECTS, EmojiSubGroup.COMPUTER, true);

    /**
     * 🖱️
     */
    Emoji COMPUTER_MOUSE = new Emoji("🖱️", "\uD83D\uDDB1\uFE0F", Collections.unmodifiableList(Arrays.asList(":mouse_three_button:", ":three_button_mouse:")), Collections.singletonList(":three_button_mouse:"), Collections.singletonList(":computer_mouse:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "computer mouse", EmojiGroup.OBJECTS, EmojiSubGroup.COMPUTER, false);

    /**
     * 🖱
     */
    Emoji COMPUTER_MOUSE_UNQUALIFIED = new Emoji("🖱", "\uD83D\uDDB1", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":computer_mouse:"), false, false, 0.7, Qualification.fromString("unqualified"), "computer mouse", EmojiGroup.OBJECTS, EmojiSubGroup.COMPUTER, true);

    /**
     * 🖲️
     */
    Emoji TRACKBALL = new Emoji("🖲️", "\uD83D\uDDB2\uFE0F", Collections.singletonList(":trackball:"), Collections.singletonList(":trackball:"), Collections.singletonList(":trackball:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "trackball", EmojiGroup.OBJECTS, EmojiSubGroup.COMPUTER, false);

    /**
     * 🖲
     */
    Emoji TRACKBALL_UNQUALIFIED = new Emoji("🖲", "\uD83D\uDDB2", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":trackball:"), false, false, 0.7, Qualification.fromString("unqualified"), "trackball", EmojiGroup.OBJECTS, EmojiSubGroup.COMPUTER, true);

    /**
     * 💽
     */
    Emoji COMPUTER_DISK = new Emoji("💽", "\uD83D\uDCBD", Collections.unmodifiableList(Arrays.asList(":minidisc:", ":computer_disk:")), Collections.singletonList(":minidisc:"), Collections.singletonList(":minidisc:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "computer disk", EmojiGroup.OBJECTS, EmojiSubGroup.COMPUTER, false);

    /**
     * 💾
     */
    Emoji FLOPPY_DISK = new Emoji("💾", "\uD83D\uDCBE", Collections.singletonList(":floppy_disk:"), Collections.singletonList(":floppy_disk:"), Collections.singletonList(":floppy_disk:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "floppy disk", EmojiGroup.OBJECTS, EmojiSubGroup.COMPUTER, false);

    /**
     * 💿
     */
    Emoji OPTICAL_DISK = new Emoji("💿", "\uD83D\uDCBF", Collections.unmodifiableList(Arrays.asList(":cd:", ":optical_disk:")), Collections.singletonList(":cd:"), Collections.singletonList(":cd:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "optical disk", EmojiGroup.OBJECTS, EmojiSubGroup.COMPUTER, true);

    /**
     * 📀
     */
    Emoji DVD = new Emoji("📀", "\uD83D\uDCC0", Collections.singletonList(":dvd:"), Collections.singletonList(":dvd:"), Collections.singletonList(":dvd:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "dvd", EmojiGroup.OBJECTS, EmojiSubGroup.COMPUTER, false);

    /**
     * 🧮
     */
    Emoji ABACUS = new Emoji("🧮", "\uD83E\uDDEE", Collections.singletonList(":abacus:"), Collections.singletonList(":abacus:"), Collections.singletonList(":abacus:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "abacus", EmojiGroup.OBJECTS, EmojiSubGroup.COMPUTER, false);
}
