package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiCountryFlag {

    /**
     * 🇦🇨
     */
    Emoji FLAG_ASCENSION_ISLAND = new Emoji("🇦🇨", "\uD83C\uDDE6\uD83C\uDDE8", Collections.singletonList(":flag_ac:"), Collections.singletonList(":flag-ac:"), Collections.singletonList(":ascension_island:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Ascension Island", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇦🇩
     */
    Emoji FLAG_ANDORRA = new Emoji("🇦🇩", "\uD83C\uDDE6\uD83C\uDDE9", Collections.singletonList(":flag_ad:"), Collections.singletonList(":flag-ad:"), Collections.singletonList(":andorra:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Andorra", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇦🇪
     */
    Emoji FLAG_UNITED_ARAB_EMIRATES = new Emoji("🇦🇪", "\uD83C\uDDE6\uD83C\uDDEA", Collections.singletonList(":flag_ae:"), Collections.singletonList(":flag-ae:"), Collections.singletonList(":united_arab_emirates:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: United Arab Emirates", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇦🇫
     */
    Emoji FLAG_AFGHANISTAN = new Emoji("🇦🇫", "\uD83C\uDDE6\uD83C\uDDEB", Collections.singletonList(":flag_af:"), Collections.singletonList(":flag-af:"), Collections.singletonList(":afghanistan:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Afghanistan", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇦🇬
     */
    Emoji FLAG_ANTIGUA_BARBUDA = new Emoji("🇦🇬", "\uD83C\uDDE6\uD83C\uDDEC", Collections.singletonList(":flag_ag:"), Collections.singletonList(":flag-ag:"), Collections.singletonList(":antigua_barbuda:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Antigua & Barbuda", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇦🇮
     */
    Emoji FLAG_ANGUILLA = new Emoji("🇦🇮", "\uD83C\uDDE6\uD83C\uDDEE", Collections.singletonList(":flag_ai:"), Collections.singletonList(":flag-ai:"), Collections.singletonList(":anguilla:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Anguilla", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇦🇱
     */
    Emoji FLAG_ALBANIA = new Emoji("🇦🇱", "\uD83C\uDDE6\uD83C\uDDF1", Collections.singletonList(":flag_al:"), Collections.singletonList(":flag-al:"), Collections.singletonList(":albania:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Albania", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇦🇲
     */
    Emoji FLAG_ARMENIA = new Emoji("🇦🇲", "\uD83C\uDDE6\uD83C\uDDF2", Collections.singletonList(":flag_am:"), Collections.singletonList(":flag-am:"), Collections.singletonList(":armenia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Armenia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇦🇴
     */
    Emoji FLAG_ANGOLA = new Emoji("🇦🇴", "\uD83C\uDDE6\uD83C\uDDF4", Collections.singletonList(":flag_ao:"), Collections.singletonList(":flag-ao:"), Collections.singletonList(":angola:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Angola", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇦🇶
     */
    Emoji FLAG_ANTARCTICA = new Emoji("🇦🇶", "\uD83C\uDDE6\uD83C\uDDF6", Collections.singletonList(":flag_aq:"), Collections.singletonList(":flag-aq:"), Collections.singletonList(":antarctica:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Antarctica", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇦🇷
     */
    Emoji FLAG_ARGENTINA = new Emoji("🇦🇷", "\uD83C\uDDE6\uD83C\uDDF7", Collections.singletonList(":flag_ar:"), Collections.singletonList(":flag-ar:"), Collections.singletonList(":argentina:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Argentina", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇦🇸
     */
    Emoji FLAG_AMERICAN_SAMOA = new Emoji("🇦🇸", "\uD83C\uDDE6\uD83C\uDDF8", Collections.singletonList(":flag_as:"), Collections.singletonList(":flag-as:"), Collections.singletonList(":american_samoa:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: American Samoa", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇦🇹
     */
    Emoji FLAG_AUSTRIA = new Emoji("🇦🇹", "\uD83C\uDDE6\uD83C\uDDF9", Collections.singletonList(":flag_at:"), Collections.singletonList(":flag-at:"), Collections.singletonList(":austria:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Austria", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇦🇺
     */
    Emoji FLAG_AUSTRALIA = new Emoji("🇦🇺", "\uD83C\uDDE6\uD83C\uDDFA", Collections.singletonList(":flag_au:"), Collections.singletonList(":flag-au:"), Collections.singletonList(":australia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Australia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇦🇼
     */
    Emoji FLAG_ARUBA = new Emoji("🇦🇼", "\uD83C\uDDE6\uD83C\uDDFC", Collections.singletonList(":flag_aw:"), Collections.singletonList(":flag-aw:"), Collections.singletonList(":aruba:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Aruba", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇦🇽
     */
    Emoji FLAG_LAND_ISLANDS = new Emoji("🇦🇽", "\uD83C\uDDE6\uD83C\uDDFD", Collections.singletonList(":flag_ax:"), Collections.singletonList(":flag-ax:"), Collections.singletonList(":aland_islands:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Åland Islands", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇦🇿
     */
    Emoji FLAG_AZERBAIJAN = new Emoji("🇦🇿", "\uD83C\uDDE6\uD83C\uDDFF", Collections.singletonList(":flag_az:"), Collections.singletonList(":flag-az:"), Collections.singletonList(":azerbaijan:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Azerbaijan", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇦
     */
    Emoji FLAG_BOSNIA_HERZEGOVINA = new Emoji("🇧🇦", "\uD83C\uDDE7\uD83C\uDDE6", Collections.singletonList(":flag_ba:"), Collections.singletonList(":flag-ba:"), Collections.singletonList(":bosnia_herzegovina:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Bosnia & Herzegovina", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇧
     */
    Emoji FLAG_BARBADOS = new Emoji("🇧🇧", "\uD83C\uDDE7\uD83C\uDDE7", Collections.singletonList(":flag_bb:"), Collections.singletonList(":flag-bb:"), Collections.singletonList(":barbados:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Barbados", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇩
     */
    Emoji FLAG_BANGLADESH = new Emoji("🇧🇩", "\uD83C\uDDE7\uD83C\uDDE9", Collections.singletonList(":flag_bd:"), Collections.singletonList(":flag-bd:"), Collections.singletonList(":bangladesh:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Bangladesh", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇪
     */
    Emoji FLAG_BELGIUM = new Emoji("🇧🇪", "\uD83C\uDDE7\uD83C\uDDEA", Collections.singletonList(":flag_be:"), Collections.singletonList(":flag-be:"), Collections.singletonList(":belgium:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Belgium", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇫
     */
    Emoji FLAG_BURKINA_FASO = new Emoji("🇧🇫", "\uD83C\uDDE7\uD83C\uDDEB", Collections.singletonList(":flag_bf:"), Collections.singletonList(":flag-bf:"), Collections.singletonList(":burkina_faso:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Burkina Faso", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇬
     */
    Emoji FLAG_BULGARIA = new Emoji("🇧🇬", "\uD83C\uDDE7\uD83C\uDDEC", Collections.singletonList(":flag_bg:"), Collections.singletonList(":flag-bg:"), Collections.singletonList(":bulgaria:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Bulgaria", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇭
     */
    Emoji FLAG_BAHRAIN = new Emoji("🇧🇭", "\uD83C\uDDE7\uD83C\uDDED", Collections.singletonList(":flag_bh:"), Collections.singletonList(":flag-bh:"), Collections.singletonList(":bahrain:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Bahrain", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇮
     */
    Emoji FLAG_BURUNDI = new Emoji("🇧🇮", "\uD83C\uDDE7\uD83C\uDDEE", Collections.singletonList(":flag_bi:"), Collections.singletonList(":flag-bi:"), Collections.singletonList(":burundi:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Burundi", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇯
     */
    Emoji FLAG_BENIN = new Emoji("🇧🇯", "\uD83C\uDDE7\uD83C\uDDEF", Collections.singletonList(":flag_bj:"), Collections.singletonList(":flag-bj:"), Collections.singletonList(":benin:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Benin", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇱
     */
    Emoji FLAG_ST_BARTH_LEMY = new Emoji("🇧🇱", "\uD83C\uDDE7\uD83C\uDDF1", Collections.singletonList(":flag_bl:"), Collections.singletonList(":flag-bl:"), Collections.singletonList(":st_barthelemy:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: St. Barthélemy", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇲
     */
    Emoji FLAG_BERMUDA = new Emoji("🇧🇲", "\uD83C\uDDE7\uD83C\uDDF2", Collections.singletonList(":flag_bm:"), Collections.singletonList(":flag-bm:"), Collections.singletonList(":bermuda:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Bermuda", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇳
     */
    Emoji FLAG_BRUNEI = new Emoji("🇧🇳", "\uD83C\uDDE7\uD83C\uDDF3", Collections.singletonList(":flag_bn:"), Collections.singletonList(":flag-bn:"), Collections.singletonList(":brunei:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Brunei", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇴
     */
    Emoji FLAG_BOLIVIA = new Emoji("🇧🇴", "\uD83C\uDDE7\uD83C\uDDF4", Collections.singletonList(":flag_bo:"), Collections.singletonList(":flag-bo:"), Collections.singletonList(":bolivia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Bolivia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇶
     */
    Emoji FLAG_CARIBBEAN_NETHERLANDS = new Emoji("🇧🇶", "\uD83C\uDDE7\uD83C\uDDF6", Collections.singletonList(":flag_bq:"), Collections.singletonList(":flag-bq:"), Collections.singletonList(":caribbean_netherlands:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Caribbean Netherlands", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇷
     */
    Emoji FLAG_BRAZIL = new Emoji("🇧🇷", "\uD83C\uDDE7\uD83C\uDDF7", Collections.singletonList(":flag_br:"), Collections.singletonList(":flag-br:"), Collections.singletonList(":brazil:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Brazil", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇸
     */
    Emoji FLAG_BAHAMAS = new Emoji("🇧🇸", "\uD83C\uDDE7\uD83C\uDDF8", Collections.singletonList(":flag_bs:"), Collections.singletonList(":flag-bs:"), Collections.singletonList(":bahamas:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Bahamas", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇹
     */
    Emoji FLAG_BHUTAN = new Emoji("🇧🇹", "\uD83C\uDDE7\uD83C\uDDF9", Collections.singletonList(":flag_bt:"), Collections.singletonList(":flag-bt:"), Collections.singletonList(":bhutan:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Bhutan", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇻
     */
    Emoji FLAG_BOUVET_ISLAND = new Emoji("🇧🇻", "\uD83C\uDDE7\uD83C\uDDFB", Collections.singletonList(":flag_bv:"), Collections.singletonList(":flag-bv:"), Collections.singletonList(":bouvet_island:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Bouvet Island", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇼
     */
    Emoji FLAG_BOTSWANA = new Emoji("🇧🇼", "\uD83C\uDDE7\uD83C\uDDFC", Collections.singletonList(":flag_bw:"), Collections.singletonList(":flag-bw:"), Collections.singletonList(":botswana:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Botswana", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇾
     */
    Emoji FLAG_BELARUS = new Emoji("🇧🇾", "\uD83C\uDDE7\uD83C\uDDFE", Collections.singletonList(":flag_by:"), Collections.singletonList(":flag-by:"), Collections.singletonList(":belarus:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Belarus", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇧🇿
     */
    Emoji FLAG_BELIZE = new Emoji("🇧🇿", "\uD83C\uDDE7\uD83C\uDDFF", Collections.singletonList(":flag_bz:"), Collections.singletonList(":flag-bz:"), Collections.singletonList(":belize:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Belize", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇨🇦
     */
    Emoji FLAG_CANADA = new Emoji("🇨🇦", "\uD83C\uDDE8\uD83C\uDDE6", Collections.singletonList(":flag_ca:"), Collections.singletonList(":flag-ca:"), Collections.singletonList(":canada:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Canada", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇨🇨
     */
    Emoji FLAG_COCOS_KEELING_ISLANDS = new Emoji("🇨🇨", "\uD83C\uDDE8\uD83C\uDDE8", Collections.singletonList(":flag_cc:"), Collections.singletonList(":flag-cc:"), Collections.singletonList(":cocos_islands:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Cocos (Keeling) Islands", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇨🇩
     */
    Emoji FLAG_CONGO_KINSHASA = new Emoji("🇨🇩", "\uD83C\uDDE8\uD83C\uDDE9", Collections.singletonList(":flag_cd:"), Collections.singletonList(":flag-cd:"), Collections.singletonList(":congo_kinshasa:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Congo - Kinshasa", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇨🇫
     */
    Emoji FLAG_CENTRAL_AFRICAN_REPUBLIC = new Emoji("🇨🇫", "\uD83C\uDDE8\uD83C\uDDEB", Collections.singletonList(":flag_cf:"), Collections.singletonList(":flag-cf:"), Collections.singletonList(":central_african_republic:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Central African Republic", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇨🇬
     */
    Emoji FLAG_CONGO_BRAZZAVILLE = new Emoji("🇨🇬", "\uD83C\uDDE8\uD83C\uDDEC", Collections.singletonList(":flag_cg:"), Collections.singletonList(":flag-cg:"), Collections.singletonList(":congo_brazzaville:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Congo - Brazzaville", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇨🇭
     */
    Emoji FLAG_SWITZERLAND = new Emoji("🇨🇭", "\uD83C\uDDE8\uD83C\uDDED", Collections.singletonList(":flag_ch:"), Collections.singletonList(":flag-ch:"), Collections.singletonList(":switzerland:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Switzerland", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇨🇮
     */
    Emoji FLAG_C_TE_D_IVOIRE = new Emoji("🇨🇮", "\uD83C\uDDE8\uD83C\uDDEE", Collections.singletonList(":flag_ci:"), Collections.singletonList(":flag-ci:"), Collections.singletonList(":cote_divoire:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Côte d’Ivoire", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇨🇰
     */
    Emoji FLAG_COOK_ISLANDS = new Emoji("🇨🇰", "\uD83C\uDDE8\uD83C\uDDF0", Collections.singletonList(":flag_ck:"), Collections.singletonList(":flag-ck:"), Collections.singletonList(":cook_islands:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Cook Islands", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇨🇱
     */
    Emoji FLAG_CHILE = new Emoji("🇨🇱", "\uD83C\uDDE8\uD83C\uDDF1", Collections.singletonList(":flag_cl:"), Collections.singletonList(":flag-cl:"), Collections.singletonList(":chile:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Chile", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇨🇲
     */
    Emoji FLAG_CAMEROON = new Emoji("🇨🇲", "\uD83C\uDDE8\uD83C\uDDF2", Collections.singletonList(":flag_cm:"), Collections.singletonList(":flag-cm:"), Collections.singletonList(":cameroon:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Cameroon", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇨🇳
     */
    Emoji FLAG_CHINA = new Emoji("🇨🇳", "\uD83C\uDDE8\uD83C\uDDF3", Collections.singletonList(":flag_cn:"), Collections.singletonList(":cn:"), Collections.singletonList(":cn:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "flag: China", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇨🇴
     */
    Emoji FLAG_COLOMBIA = new Emoji("🇨🇴", "\uD83C\uDDE8\uD83C\uDDF4", Collections.singletonList(":flag_co:"), Collections.singletonList(":flag-co:"), Collections.singletonList(":colombia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Colombia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇨🇵
     */
    Emoji FLAG_CLIPPERTON_ISLAND = new Emoji("🇨🇵", "\uD83C\uDDE8\uD83C\uDDF5", Collections.singletonList(":flag_cp:"), Collections.singletonList(":flag-cp:"), Collections.singletonList(":clipperton_island:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Clipperton Island", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇨🇷
     */
    Emoji FLAG_COSTA_RICA = new Emoji("🇨🇷", "\uD83C\uDDE8\uD83C\uDDF7", Collections.singletonList(":flag_cr:"), Collections.singletonList(":flag-cr:"), Collections.singletonList(":costa_rica:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Costa Rica", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇨🇺
     */
    Emoji FLAG_CUBA = new Emoji("🇨🇺", "\uD83C\uDDE8\uD83C\uDDFA", Collections.singletonList(":flag_cu:"), Collections.singletonList(":flag-cu:"), Collections.singletonList(":cuba:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Cuba", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇨🇻
     */
    Emoji FLAG_CAPE_VERDE = new Emoji("🇨🇻", "\uD83C\uDDE8\uD83C\uDDFB", Collections.singletonList(":flag_cv:"), Collections.singletonList(":flag-cv:"), Collections.singletonList(":cape_verde:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Cape Verde", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇨🇼
     */
    Emoji FLAG_CURA_AO = new Emoji("🇨🇼", "\uD83C\uDDE8\uD83C\uDDFC", Collections.singletonList(":flag_cw:"), Collections.singletonList(":flag-cw:"), Collections.singletonList(":curacao:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Curaçao", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇨🇽
     */
    Emoji FLAG_CHRISTMAS_ISLAND = new Emoji("🇨🇽", "\uD83C\uDDE8\uD83C\uDDFD", Collections.singletonList(":flag_cx:"), Collections.singletonList(":flag-cx:"), Collections.singletonList(":christmas_island:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Christmas Island", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇨🇾
     */
    Emoji FLAG_CYPRUS = new Emoji("🇨🇾", "\uD83C\uDDE8\uD83C\uDDFE", Collections.singletonList(":flag_cy:"), Collections.singletonList(":flag-cy:"), Collections.singletonList(":cyprus:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Cyprus", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇨🇿
     */
    Emoji FLAG_CZECHIA = new Emoji("🇨🇿", "\uD83C\uDDE8\uD83C\uDDFF", Collections.singletonList(":flag_cz:"), Collections.singletonList(":flag-cz:"), Collections.singletonList(":czech_republic:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Czechia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇩🇪
     */
    Emoji FLAG_GERMANY = new Emoji("🇩🇪", "\uD83C\uDDE9\uD83C\uDDEA", Collections.singletonList(":flag_de:"), Collections.singletonList(":de:"), Collections.singletonList(":de:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "flag: Germany", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇩🇬
     */
    Emoji FLAG_DIEGO_GARCIA = new Emoji("🇩🇬", "\uD83C\uDDE9\uD83C\uDDEC", Collections.singletonList(":flag_dg:"), Collections.singletonList(":flag-dg:"), Collections.singletonList(":diego_garcia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Diego Garcia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇩🇯
     */
    Emoji FLAG_DJIBOUTI = new Emoji("🇩🇯", "\uD83C\uDDE9\uD83C\uDDEF", Collections.singletonList(":flag_dj:"), Collections.singletonList(":flag-dj:"), Collections.singletonList(":djibouti:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Djibouti", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇩🇰
     */
    Emoji FLAG_DENMARK = new Emoji("🇩🇰", "\uD83C\uDDE9\uD83C\uDDF0", Collections.singletonList(":flag_dk:"), Collections.singletonList(":flag-dk:"), Collections.singletonList(":denmark:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Denmark", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇩🇲
     */
    Emoji FLAG_DOMINICA = new Emoji("🇩🇲", "\uD83C\uDDE9\uD83C\uDDF2", Collections.singletonList(":flag_dm:"), Collections.singletonList(":flag-dm:"), Collections.singletonList(":dominica:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Dominica", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇩🇴
     */
    Emoji FLAG_DOMINICAN_REPUBLIC = new Emoji("🇩🇴", "\uD83C\uDDE9\uD83C\uDDF4", Collections.singletonList(":flag_do:"), Collections.singletonList(":flag-do:"), Collections.singletonList(":dominican_republic:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Dominican Republic", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇩🇿
     */
    Emoji FLAG_ALGERIA = new Emoji("🇩🇿", "\uD83C\uDDE9\uD83C\uDDFF", Collections.singletonList(":flag_dz:"), Collections.singletonList(":flag-dz:"), Collections.singletonList(":algeria:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Algeria", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇪🇦
     */
    Emoji FLAG_CEUTA_MELILLA = new Emoji("🇪🇦", "\uD83C\uDDEA\uD83C\uDDE6", Collections.singletonList(":flag_ea:"), Collections.singletonList(":flag-ea:"), Collections.singletonList(":ceuta_melilla:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Ceuta & Melilla", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇪🇨
     */
    Emoji FLAG_ECUADOR = new Emoji("🇪🇨", "\uD83C\uDDEA\uD83C\uDDE8", Collections.singletonList(":flag_ec:"), Collections.singletonList(":flag-ec:"), Collections.singletonList(":ecuador:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Ecuador", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇪🇪
     */
    Emoji FLAG_ESTONIA = new Emoji("🇪🇪", "\uD83C\uDDEA\uD83C\uDDEA", Collections.singletonList(":flag_ee:"), Collections.singletonList(":flag-ee:"), Collections.singletonList(":estonia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Estonia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇪🇬
     */
    Emoji FLAG_EGYPT = new Emoji("🇪🇬", "\uD83C\uDDEA\uD83C\uDDEC", Collections.singletonList(":flag_eg:"), Collections.singletonList(":flag-eg:"), Collections.singletonList(":egypt:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Egypt", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇪🇭
     */
    Emoji FLAG_WESTERN_SAHARA = new Emoji("🇪🇭", "\uD83C\uDDEA\uD83C\uDDED", Collections.singletonList(":flag_eh:"), Collections.singletonList(":flag-eh:"), Collections.singletonList(":western_sahara:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Western Sahara", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇪🇷
     */
    Emoji FLAG_ERITREA = new Emoji("🇪🇷", "\uD83C\uDDEA\uD83C\uDDF7", Collections.singletonList(":flag_er:"), Collections.singletonList(":flag-er:"), Collections.singletonList(":eritrea:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Eritrea", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇪🇸
     */
    Emoji FLAG_SPAIN = new Emoji("🇪🇸", "\uD83C\uDDEA\uD83C\uDDF8", Collections.singletonList(":flag_es:"), Collections.singletonList(":es:"), Collections.singletonList(":es:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "flag: Spain", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇪🇹
     */
    Emoji FLAG_ETHIOPIA = new Emoji("🇪🇹", "\uD83C\uDDEA\uD83C\uDDF9", Collections.singletonList(":flag_et:"), Collections.singletonList(":flag-et:"), Collections.singletonList(":ethiopia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Ethiopia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇪🇺
     */
    Emoji FLAG_EUROPEAN_UNION = new Emoji("🇪🇺", "\uD83C\uDDEA\uD83C\uDDFA", Collections.singletonList(":flag_eu:"), Collections.singletonList(":flag-eu:"), Collections.unmodifiableList(Arrays.asList(":eu:", ":european_union:")), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: European Union", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇫🇮
     */
    Emoji FLAG_FINLAND = new Emoji("🇫🇮", "\uD83C\uDDEB\uD83C\uDDEE", Collections.singletonList(":flag_fi:"), Collections.singletonList(":flag-fi:"), Collections.singletonList(":finland:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Finland", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇫🇯
     */
    Emoji FLAG_FIJI = new Emoji("🇫🇯", "\uD83C\uDDEB\uD83C\uDDEF", Collections.singletonList(":flag_fj:"), Collections.singletonList(":flag-fj:"), Collections.singletonList(":fiji:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Fiji", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇫🇰
     */
    Emoji FLAG_FALKLAND_ISLANDS = new Emoji("🇫🇰", "\uD83C\uDDEB\uD83C\uDDF0", Collections.singletonList(":flag_fk:"), Collections.singletonList(":flag-fk:"), Collections.singletonList(":falkland_islands:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Falkland Islands", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇫🇲
     */
    Emoji FLAG_MICRONESIA = new Emoji("🇫🇲", "\uD83C\uDDEB\uD83C\uDDF2", Collections.singletonList(":flag_fm:"), Collections.singletonList(":flag-fm:"), Collections.singletonList(":micronesia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Micronesia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇫🇴
     */
    Emoji FLAG_FAROE_ISLANDS = new Emoji("🇫🇴", "\uD83C\uDDEB\uD83C\uDDF4", Collections.singletonList(":flag_fo:"), Collections.singletonList(":flag-fo:"), Collections.singletonList(":faroe_islands:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Faroe Islands", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇫🇷
     */
    Emoji FLAG_FRANCE = new Emoji("🇫🇷", "\uD83C\uDDEB\uD83C\uDDF7", Collections.singletonList(":flag_fr:"), Collections.singletonList(":fr:"), Collections.singletonList(":fr:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "flag: France", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇬🇦
     */
    Emoji FLAG_GABON = new Emoji("🇬🇦", "\uD83C\uDDEC\uD83C\uDDE6", Collections.singletonList(":flag_ga:"), Collections.singletonList(":flag-ga:"), Collections.singletonList(":gabon:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Gabon", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇬🇧
     */
    Emoji FLAG_UNITED_KINGDOM = new Emoji("🇬🇧", "\uD83C\uDDEC\uD83C\uDDE7", Collections.singletonList(":flag_gb:"), Collections.singletonList(":gb:"), Collections.unmodifiableList(Arrays.asList(":gb:", ":uk:")), false, false, 0.6, Qualification.fromString("fully-qualified"), "flag: United Kingdom", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇬🇩
     */
    Emoji FLAG_GRENADA = new Emoji("🇬🇩", "\uD83C\uDDEC\uD83C\uDDE9", Collections.singletonList(":flag_gd:"), Collections.singletonList(":flag-gd:"), Collections.singletonList(":grenada:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Grenada", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇬🇪
     */
    Emoji FLAG_GEORGIA = new Emoji("🇬🇪", "\uD83C\uDDEC\uD83C\uDDEA", Collections.singletonList(":flag_ge:"), Collections.singletonList(":flag-ge:"), Collections.singletonList(":georgia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Georgia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇬🇫
     */
    Emoji FLAG_FRENCH_GUIANA = new Emoji("🇬🇫", "\uD83C\uDDEC\uD83C\uDDEB", Collections.singletonList(":flag_gf:"), Collections.singletonList(":flag-gf:"), Collections.singletonList(":french_guiana:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: French Guiana", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇬🇬
     */
    Emoji FLAG_GUERNSEY = new Emoji("🇬🇬", "\uD83C\uDDEC\uD83C\uDDEC", Collections.singletonList(":flag_gg:"), Collections.singletonList(":flag-gg:"), Collections.singletonList(":guernsey:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Guernsey", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇬🇭
     */
    Emoji FLAG_GHANA = new Emoji("🇬🇭", "\uD83C\uDDEC\uD83C\uDDED", Collections.singletonList(":flag_gh:"), Collections.singletonList(":flag-gh:"), Collections.singletonList(":ghana:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Ghana", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇬🇮
     */
    Emoji FLAG_GIBRALTAR = new Emoji("🇬🇮", "\uD83C\uDDEC\uD83C\uDDEE", Collections.singletonList(":flag_gi:"), Collections.singletonList(":flag-gi:"), Collections.singletonList(":gibraltar:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Gibraltar", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇬🇱
     */
    Emoji FLAG_GREENLAND = new Emoji("🇬🇱", "\uD83C\uDDEC\uD83C\uDDF1", Collections.singletonList(":flag_gl:"), Collections.singletonList(":flag-gl:"), Collections.singletonList(":greenland:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Greenland", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇬🇲
     */
    Emoji FLAG_GAMBIA = new Emoji("🇬🇲", "\uD83C\uDDEC\uD83C\uDDF2", Collections.singletonList(":flag_gm:"), Collections.singletonList(":flag-gm:"), Collections.singletonList(":gambia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Gambia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇬🇳
     */
    Emoji FLAG_GUINEA = new Emoji("🇬🇳", "\uD83C\uDDEC\uD83C\uDDF3", Collections.singletonList(":flag_gn:"), Collections.singletonList(":flag-gn:"), Collections.singletonList(":guinea:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Guinea", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇬🇵
     */
    Emoji FLAG_GUADELOUPE = new Emoji("🇬🇵", "\uD83C\uDDEC\uD83C\uDDF5", Collections.singletonList(":flag_gp:"), Collections.singletonList(":flag-gp:"), Collections.singletonList(":guadeloupe:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Guadeloupe", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇬🇶
     */
    Emoji FLAG_EQUATORIAL_GUINEA = new Emoji("🇬🇶", "\uD83C\uDDEC\uD83C\uDDF6", Collections.singletonList(":flag_gq:"), Collections.singletonList(":flag-gq:"), Collections.singletonList(":equatorial_guinea:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Equatorial Guinea", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇬🇷
     */
    Emoji FLAG_GREECE = new Emoji("🇬🇷", "\uD83C\uDDEC\uD83C\uDDF7", Collections.singletonList(":flag_gr:"), Collections.singletonList(":flag-gr:"), Collections.singletonList(":greece:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Greece", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇬🇸
     */
    Emoji FLAG_SOUTH_GEORGIA_SOUTH_SANDWICH_ISLANDS = new Emoji("🇬🇸", "\uD83C\uDDEC\uD83C\uDDF8", Collections.singletonList(":flag_gs:"), Collections.singletonList(":flag-gs:"), Collections.singletonList(":south_georgia_south_sandwich_islands:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: South Georgia & South Sandwich Islands", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇬🇹
     */
    Emoji FLAG_GUATEMALA = new Emoji("🇬🇹", "\uD83C\uDDEC\uD83C\uDDF9", Collections.singletonList(":flag_gt:"), Collections.singletonList(":flag-gt:"), Collections.singletonList(":guatemala:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Guatemala", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇬🇺
     */
    Emoji FLAG_GUAM = new Emoji("🇬🇺", "\uD83C\uDDEC\uD83C\uDDFA", Collections.singletonList(":flag_gu:"), Collections.singletonList(":flag-gu:"), Collections.singletonList(":guam:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Guam", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇬🇼
     */
    Emoji FLAG_GUINEA_BISSAU = new Emoji("🇬🇼", "\uD83C\uDDEC\uD83C\uDDFC", Collections.singletonList(":flag_gw:"), Collections.singletonList(":flag-gw:"), Collections.singletonList(":guinea_bissau:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Guinea-Bissau", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇬🇾
     */
    Emoji FLAG_GUYANA = new Emoji("🇬🇾", "\uD83C\uDDEC\uD83C\uDDFE", Collections.singletonList(":flag_gy:"), Collections.singletonList(":flag-gy:"), Collections.singletonList(":guyana:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Guyana", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇭🇰
     */
    Emoji FLAG_HONG_KONG_SAR_CHINA = new Emoji("🇭🇰", "\uD83C\uDDED\uD83C\uDDF0", Collections.singletonList(":flag_hk:"), Collections.singletonList(":flag-hk:"), Collections.singletonList(":hong_kong:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Hong Kong SAR China", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇭🇲
     */
    Emoji FLAG_HEARD_MCDONALD_ISLANDS = new Emoji("🇭🇲", "\uD83C\uDDED\uD83C\uDDF2", Collections.singletonList(":flag_hm:"), Collections.singletonList(":flag-hm:"), Collections.singletonList(":heard_mcdonald_islands:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Heard & McDonald Islands", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇭🇳
     */
    Emoji FLAG_HONDURAS = new Emoji("🇭🇳", "\uD83C\uDDED\uD83C\uDDF3", Collections.singletonList(":flag_hn:"), Collections.singletonList(":flag-hn:"), Collections.singletonList(":honduras:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Honduras", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇭🇷
     */
    Emoji FLAG_CROATIA = new Emoji("🇭🇷", "\uD83C\uDDED\uD83C\uDDF7", Collections.singletonList(":flag_hr:"), Collections.singletonList(":flag-hr:"), Collections.singletonList(":croatia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Croatia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇭🇹
     */
    Emoji FLAG_HAITI = new Emoji("🇭🇹", "\uD83C\uDDED\uD83C\uDDF9", Collections.singletonList(":flag_ht:"), Collections.singletonList(":flag-ht:"), Collections.singletonList(":haiti:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Haiti", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇭🇺
     */
    Emoji FLAG_HUNGARY = new Emoji("🇭🇺", "\uD83C\uDDED\uD83C\uDDFA", Collections.singletonList(":flag_hu:"), Collections.singletonList(":flag-hu:"), Collections.singletonList(":hungary:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Hungary", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇮🇨
     */
    Emoji FLAG_CANARY_ISLANDS = new Emoji("🇮🇨", "\uD83C\uDDEE\uD83C\uDDE8", Collections.singletonList(":flag_ic:"), Collections.singletonList(":flag-ic:"), Collections.singletonList(":canary_islands:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Canary Islands", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇮🇩
     */
    Emoji FLAG_INDONESIA = new Emoji("🇮🇩", "\uD83C\uDDEE\uD83C\uDDE9", Collections.singletonList(":flag_id:"), Collections.singletonList(":flag-id:"), Collections.singletonList(":indonesia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Indonesia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇮🇪
     */
    Emoji FLAG_IRELAND = new Emoji("🇮🇪", "\uD83C\uDDEE\uD83C\uDDEA", Collections.singletonList(":flag_ie:"), Collections.singletonList(":flag-ie:"), Collections.singletonList(":ireland:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Ireland", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇮🇱
     */
    Emoji FLAG_ISRAEL = new Emoji("🇮🇱", "\uD83C\uDDEE\uD83C\uDDF1", Collections.singletonList(":flag_il:"), Collections.singletonList(":flag-il:"), Collections.singletonList(":israel:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Israel", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇮🇲
     */
    Emoji FLAG_ISLE_OF_MAN = new Emoji("🇮🇲", "\uD83C\uDDEE\uD83C\uDDF2", Collections.singletonList(":flag_im:"), Collections.singletonList(":flag-im:"), Collections.singletonList(":isle_of_man:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Isle of Man", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇮🇳
     */
    Emoji FLAG_INDIA = new Emoji("🇮🇳", "\uD83C\uDDEE\uD83C\uDDF3", Collections.singletonList(":flag_in:"), Collections.singletonList(":flag-in:"), Collections.singletonList(":india:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: India", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇮🇴
     */
    Emoji FLAG_BRITISH_INDIAN_OCEAN_TERRITORY = new Emoji("🇮🇴", "\uD83C\uDDEE\uD83C\uDDF4", Collections.singletonList(":flag_io:"), Collections.singletonList(":flag-io:"), Collections.singletonList(":british_indian_ocean_territory:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: British Indian Ocean Territory", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇮🇶
     */
    Emoji FLAG_IRAQ = new Emoji("🇮🇶", "\uD83C\uDDEE\uD83C\uDDF6", Collections.singletonList(":flag_iq:"), Collections.singletonList(":flag-iq:"), Collections.singletonList(":iraq:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Iraq", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇮🇷
     */
    Emoji FLAG_IRAN = new Emoji("🇮🇷", "\uD83C\uDDEE\uD83C\uDDF7", Collections.singletonList(":flag_ir:"), Collections.singletonList(":flag-ir:"), Collections.singletonList(":iran:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Iran", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇮🇸
     */
    Emoji FLAG_ICELAND = new Emoji("🇮🇸", "\uD83C\uDDEE\uD83C\uDDF8", Collections.singletonList(":flag_is:"), Collections.singletonList(":flag-is:"), Collections.singletonList(":iceland:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Iceland", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇮🇹
     */
    Emoji FLAG_ITALY = new Emoji("🇮🇹", "\uD83C\uDDEE\uD83C\uDDF9", Collections.singletonList(":flag_it:"), Collections.singletonList(":it:"), Collections.singletonList(":it:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "flag: Italy", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇯🇪
     */
    Emoji FLAG_JERSEY = new Emoji("🇯🇪", "\uD83C\uDDEF\uD83C\uDDEA", Collections.singletonList(":flag_je:"), Collections.singletonList(":flag-je:"), Collections.singletonList(":jersey:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Jersey", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇯🇲
     */
    Emoji FLAG_JAMAICA = new Emoji("🇯🇲", "\uD83C\uDDEF\uD83C\uDDF2", Collections.singletonList(":flag_jm:"), Collections.singletonList(":flag-jm:"), Collections.singletonList(":jamaica:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Jamaica", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇯🇴
     */
    Emoji FLAG_JORDAN = new Emoji("🇯🇴", "\uD83C\uDDEF\uD83C\uDDF4", Collections.singletonList(":flag_jo:"), Collections.singletonList(":flag-jo:"), Collections.singletonList(":jordan:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Jordan", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇯🇵
     */
    Emoji FLAG_JAPAN = new Emoji("🇯🇵", "\uD83C\uDDEF\uD83C\uDDF5", Collections.singletonList(":flag_jp:"), Collections.singletonList(":jp:"), Collections.singletonList(":jp:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "flag: Japan", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇰🇪
     */
    Emoji FLAG_KENYA = new Emoji("🇰🇪", "\uD83C\uDDF0\uD83C\uDDEA", Collections.singletonList(":flag_ke:"), Collections.singletonList(":flag-ke:"), Collections.singletonList(":kenya:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Kenya", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇰🇬
     */
    Emoji FLAG_KYRGYZSTAN = new Emoji("🇰🇬", "\uD83C\uDDF0\uD83C\uDDEC", Collections.singletonList(":flag_kg:"), Collections.singletonList(":flag-kg:"), Collections.singletonList(":kyrgyzstan:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Kyrgyzstan", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇰🇭
     */
    Emoji FLAG_CAMBODIA = new Emoji("🇰🇭", "\uD83C\uDDF0\uD83C\uDDED", Collections.singletonList(":flag_kh:"), Collections.singletonList(":flag-kh:"), Collections.singletonList(":cambodia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Cambodia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇰🇮
     */
    Emoji FLAG_KIRIBATI = new Emoji("🇰🇮", "\uD83C\uDDF0\uD83C\uDDEE", Collections.singletonList(":flag_ki:"), Collections.singletonList(":flag-ki:"), Collections.singletonList(":kiribati:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Kiribati", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇰🇲
     */
    Emoji FLAG_COMOROS = new Emoji("🇰🇲", "\uD83C\uDDF0\uD83C\uDDF2", Collections.singletonList(":flag_km:"), Collections.singletonList(":flag-km:"), Collections.singletonList(":comoros:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Comoros", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇰🇳
     */
    Emoji FLAG_ST_KITTS_NEVIS = new Emoji("🇰🇳", "\uD83C\uDDF0\uD83C\uDDF3", Collections.singletonList(":flag_kn:"), Collections.singletonList(":flag-kn:"), Collections.singletonList(":st_kitts_nevis:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: St. Kitts & Nevis", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇰🇵
     */
    Emoji FLAG_NORTH_KOREA = new Emoji("🇰🇵", "\uD83C\uDDF0\uD83C\uDDF5", Collections.singletonList(":flag_kp:"), Collections.singletonList(":flag-kp:"), Collections.singletonList(":north_korea:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: North Korea", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇰🇷
     */
    Emoji FLAG_SOUTH_KOREA = new Emoji("🇰🇷", "\uD83C\uDDF0\uD83C\uDDF7", Collections.singletonList(":flag_kr:"), Collections.singletonList(":kr:"), Collections.singletonList(":kr:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "flag: South Korea", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇰🇼
     */
    Emoji FLAG_KUWAIT = new Emoji("🇰🇼", "\uD83C\uDDF0\uD83C\uDDFC", Collections.singletonList(":flag_kw:"), Collections.singletonList(":flag-kw:"), Collections.singletonList(":kuwait:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Kuwait", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇰🇾
     */
    Emoji FLAG_CAYMAN_ISLANDS = new Emoji("🇰🇾", "\uD83C\uDDF0\uD83C\uDDFE", Collections.singletonList(":flag_ky:"), Collections.singletonList(":flag-ky:"), Collections.singletonList(":cayman_islands:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Cayman Islands", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇰🇿
     */
    Emoji FLAG_KAZAKHSTAN = new Emoji("🇰🇿", "\uD83C\uDDF0\uD83C\uDDFF", Collections.singletonList(":flag_kz:"), Collections.singletonList(":flag-kz:"), Collections.singletonList(":kazakhstan:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Kazakhstan", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇱🇦
     */
    Emoji FLAG_LAOS = new Emoji("🇱🇦", "\uD83C\uDDF1\uD83C\uDDE6", Collections.singletonList(":flag_la:"), Collections.singletonList(":flag-la:"), Collections.singletonList(":laos:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Laos", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇱🇧
     */
    Emoji FLAG_LEBANON = new Emoji("🇱🇧", "\uD83C\uDDF1\uD83C\uDDE7", Collections.singletonList(":flag_lb:"), Collections.singletonList(":flag-lb:"), Collections.singletonList(":lebanon:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Lebanon", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇱🇨
     */
    Emoji FLAG_ST_LUCIA = new Emoji("🇱🇨", "\uD83C\uDDF1\uD83C\uDDE8", Collections.singletonList(":flag_lc:"), Collections.singletonList(":flag-lc:"), Collections.singletonList(":st_lucia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: St. Lucia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇱🇮
     */
    Emoji FLAG_LIECHTENSTEIN = new Emoji("🇱🇮", "\uD83C\uDDF1\uD83C\uDDEE", Collections.singletonList(":flag_li:"), Collections.singletonList(":flag-li:"), Collections.singletonList(":liechtenstein:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Liechtenstein", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇱🇰
     */
    Emoji FLAG_SRI_LANKA = new Emoji("🇱🇰", "\uD83C\uDDF1\uD83C\uDDF0", Collections.singletonList(":flag_lk:"), Collections.singletonList(":flag-lk:"), Collections.singletonList(":sri_lanka:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Sri Lanka", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇱🇷
     */
    Emoji FLAG_LIBERIA = new Emoji("🇱🇷", "\uD83C\uDDF1\uD83C\uDDF7", Collections.singletonList(":flag_lr:"), Collections.singletonList(":flag-lr:"), Collections.singletonList(":liberia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Liberia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇱🇸
     */
    Emoji FLAG_LESOTHO = new Emoji("🇱🇸", "\uD83C\uDDF1\uD83C\uDDF8", Collections.singletonList(":flag_ls:"), Collections.singletonList(":flag-ls:"), Collections.singletonList(":lesotho:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Lesotho", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇱🇹
     */
    Emoji FLAG_LITHUANIA = new Emoji("🇱🇹", "\uD83C\uDDF1\uD83C\uDDF9", Collections.singletonList(":flag_lt:"), Collections.singletonList(":flag-lt:"), Collections.singletonList(":lithuania:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Lithuania", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇱🇺
     */
    Emoji FLAG_LUXEMBOURG = new Emoji("🇱🇺", "\uD83C\uDDF1\uD83C\uDDFA", Collections.singletonList(":flag_lu:"), Collections.singletonList(":flag-lu:"), Collections.singletonList(":luxembourg:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Luxembourg", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇱🇻
     */
    Emoji FLAG_LATVIA = new Emoji("🇱🇻", "\uD83C\uDDF1\uD83C\uDDFB", Collections.singletonList(":flag_lv:"), Collections.singletonList(":flag-lv:"), Collections.singletonList(":latvia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Latvia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇱🇾
     */
    Emoji FLAG_LIBYA = new Emoji("🇱🇾", "\uD83C\uDDF1\uD83C\uDDFE", Collections.singletonList(":flag_ly:"), Collections.singletonList(":flag-ly:"), Collections.singletonList(":libya:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Libya", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇦
     */
    Emoji FLAG_MOROCCO = new Emoji("🇲🇦", "\uD83C\uDDF2\uD83C\uDDE6", Collections.singletonList(":flag_ma:"), Collections.singletonList(":flag-ma:"), Collections.singletonList(":morocco:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Morocco", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇨
     */
    Emoji FLAG_MONACO = new Emoji("🇲🇨", "\uD83C\uDDF2\uD83C\uDDE8", Collections.singletonList(":flag_mc:"), Collections.singletonList(":flag-mc:"), Collections.singletonList(":monaco:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Monaco", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇩
     */
    Emoji FLAG_MOLDOVA = new Emoji("🇲🇩", "\uD83C\uDDF2\uD83C\uDDE9", Collections.singletonList(":flag_md:"), Collections.singletonList(":flag-md:"), Collections.singletonList(":moldova:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Moldova", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇪
     */
    Emoji FLAG_MONTENEGRO = new Emoji("🇲🇪", "\uD83C\uDDF2\uD83C\uDDEA", Collections.singletonList(":flag_me:"), Collections.singletonList(":flag-me:"), Collections.singletonList(":montenegro:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Montenegro", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇫
     */
    Emoji FLAG_ST_MARTIN = new Emoji("🇲🇫", "\uD83C\uDDF2\uD83C\uDDEB", Collections.singletonList(":flag_mf:"), Collections.singletonList(":flag-mf:"), Collections.singletonList(":st_martin:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: St. Martin", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇬
     */
    Emoji FLAG_MADAGASCAR = new Emoji("🇲🇬", "\uD83C\uDDF2\uD83C\uDDEC", Collections.singletonList(":flag_mg:"), Collections.singletonList(":flag-mg:"), Collections.singletonList(":madagascar:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Madagascar", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇭
     */
    Emoji FLAG_MARSHALL_ISLANDS = new Emoji("🇲🇭", "\uD83C\uDDF2\uD83C\uDDED", Collections.singletonList(":flag_mh:"), Collections.singletonList(":flag-mh:"), Collections.singletonList(":marshall_islands:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Marshall Islands", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇰
     */
    Emoji FLAG_NORTH_MACEDONIA = new Emoji("🇲🇰", "\uD83C\uDDF2\uD83C\uDDF0", Collections.singletonList(":flag_mk:"), Collections.singletonList(":flag-mk:"), Collections.singletonList(":macedonia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: North Macedonia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇱
     */
    Emoji FLAG_MALI = new Emoji("🇲🇱", "\uD83C\uDDF2\uD83C\uDDF1", Collections.singletonList(":flag_ml:"), Collections.singletonList(":flag-ml:"), Collections.singletonList(":mali:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Mali", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇲
     */
    Emoji FLAG_MYANMAR_BURMA = new Emoji("🇲🇲", "\uD83C\uDDF2\uD83C\uDDF2", Collections.singletonList(":flag_mm:"), Collections.singletonList(":flag-mm:"), Collections.singletonList(":myanmar:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Myanmar (Burma)", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇳
     */
    Emoji FLAG_MONGOLIA = new Emoji("🇲🇳", "\uD83C\uDDF2\uD83C\uDDF3", Collections.singletonList(":flag_mn:"), Collections.singletonList(":flag-mn:"), Collections.singletonList(":mongolia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Mongolia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇴
     */
    Emoji FLAG_MACAO_SAR_CHINA = new Emoji("🇲🇴", "\uD83C\uDDF2\uD83C\uDDF4", Collections.singletonList(":flag_mo:"), Collections.singletonList(":flag-mo:"), Collections.singletonList(":macau:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Macao SAR China", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇵
     */
    Emoji FLAG_NORTHERN_MARIANA_ISLANDS = new Emoji("🇲🇵", "\uD83C\uDDF2\uD83C\uDDF5", Collections.singletonList(":flag_mp:"), Collections.singletonList(":flag-mp:"), Collections.singletonList(":northern_mariana_islands:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Northern Mariana Islands", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇶
     */
    Emoji FLAG_MARTINIQUE = new Emoji("🇲🇶", "\uD83C\uDDF2\uD83C\uDDF6", Collections.singletonList(":flag_mq:"), Collections.singletonList(":flag-mq:"), Collections.singletonList(":martinique:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Martinique", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇷
     */
    Emoji FLAG_MAURITANIA = new Emoji("🇲🇷", "\uD83C\uDDF2\uD83C\uDDF7", Collections.singletonList(":flag_mr:"), Collections.singletonList(":flag-mr:"), Collections.singletonList(":mauritania:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Mauritania", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇸
     */
    Emoji FLAG_MONTSERRAT = new Emoji("🇲🇸", "\uD83C\uDDF2\uD83C\uDDF8", Collections.singletonList(":flag_ms:"), Collections.singletonList(":flag-ms:"), Collections.singletonList(":montserrat:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Montserrat", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇹
     */
    Emoji FLAG_MALTA = new Emoji("🇲🇹", "\uD83C\uDDF2\uD83C\uDDF9", Collections.singletonList(":flag_mt:"), Collections.singletonList(":flag-mt:"), Collections.singletonList(":malta:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Malta", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇺
     */
    Emoji FLAG_MAURITIUS = new Emoji("🇲🇺", "\uD83C\uDDF2\uD83C\uDDFA", Collections.singletonList(":flag_mu:"), Collections.singletonList(":flag-mu:"), Collections.singletonList(":mauritius:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Mauritius", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇻
     */
    Emoji FLAG_MALDIVES = new Emoji("🇲🇻", "\uD83C\uDDF2\uD83C\uDDFB", Collections.singletonList(":flag_mv:"), Collections.singletonList(":flag-mv:"), Collections.singletonList(":maldives:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Maldives", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇼
     */
    Emoji FLAG_MALAWI = new Emoji("🇲🇼", "\uD83C\uDDF2\uD83C\uDDFC", Collections.singletonList(":flag_mw:"), Collections.singletonList(":flag-mw:"), Collections.singletonList(":malawi:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Malawi", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇽
     */
    Emoji FLAG_MEXICO = new Emoji("🇲🇽", "\uD83C\uDDF2\uD83C\uDDFD", Collections.singletonList(":flag_mx:"), Collections.singletonList(":flag-mx:"), Collections.singletonList(":mexico:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Mexico", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇾
     */
    Emoji FLAG_MALAYSIA = new Emoji("🇲🇾", "\uD83C\uDDF2\uD83C\uDDFE", Collections.singletonList(":flag_my:"), Collections.singletonList(":flag-my:"), Collections.singletonList(":malaysia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Malaysia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇲🇿
     */
    Emoji FLAG_MOZAMBIQUE = new Emoji("🇲🇿", "\uD83C\uDDF2\uD83C\uDDFF", Collections.singletonList(":flag_mz:"), Collections.singletonList(":flag-mz:"), Collections.singletonList(":mozambique:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Mozambique", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇳🇦
     */
    Emoji FLAG_NAMIBIA = new Emoji("🇳🇦", "\uD83C\uDDF3\uD83C\uDDE6", Collections.singletonList(":flag_na:"), Collections.singletonList(":flag-na:"), Collections.singletonList(":namibia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Namibia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇳🇨
     */
    Emoji FLAG_NEW_CALEDONIA = new Emoji("🇳🇨", "\uD83C\uDDF3\uD83C\uDDE8", Collections.singletonList(":flag_nc:"), Collections.singletonList(":flag-nc:"), Collections.singletonList(":new_caledonia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: New Caledonia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇳🇪
     */
    Emoji FLAG_NIGER = new Emoji("🇳🇪", "\uD83C\uDDF3\uD83C\uDDEA", Collections.singletonList(":flag_ne:"), Collections.singletonList(":flag-ne:"), Collections.singletonList(":niger:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Niger", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇳🇫
     */
    Emoji FLAG_NORFOLK_ISLAND = new Emoji("🇳🇫", "\uD83C\uDDF3\uD83C\uDDEB", Collections.singletonList(":flag_nf:"), Collections.singletonList(":flag-nf:"), Collections.singletonList(":norfolk_island:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Norfolk Island", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇳🇬
     */
    Emoji FLAG_NIGERIA = new Emoji("🇳🇬", "\uD83C\uDDF3\uD83C\uDDEC", Collections.singletonList(":flag_ng:"), Collections.singletonList(":flag-ng:"), Collections.singletonList(":nigeria:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Nigeria", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇳🇮
     */
    Emoji FLAG_NICARAGUA = new Emoji("🇳🇮", "\uD83C\uDDF3\uD83C\uDDEE", Collections.singletonList(":flag_ni:"), Collections.singletonList(":flag-ni:"), Collections.singletonList(":nicaragua:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Nicaragua", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇳🇱
     */
    Emoji FLAG_NETHERLANDS = new Emoji("🇳🇱", "\uD83C\uDDF3\uD83C\uDDF1", Collections.singletonList(":flag_nl:"), Collections.singletonList(":flag-nl:"), Collections.singletonList(":netherlands:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Netherlands", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇳🇴
     */
    Emoji FLAG_NORWAY = new Emoji("🇳🇴", "\uD83C\uDDF3\uD83C\uDDF4", Collections.singletonList(":flag_no:"), Collections.singletonList(":flag-no:"), Collections.singletonList(":norway:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Norway", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇳🇵
     */
    Emoji FLAG_NEPAL = new Emoji("🇳🇵", "\uD83C\uDDF3\uD83C\uDDF5", Collections.singletonList(":flag_np:"), Collections.singletonList(":flag-np:"), Collections.singletonList(":nepal:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Nepal", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇳🇷
     */
    Emoji FLAG_NAURU = new Emoji("🇳🇷", "\uD83C\uDDF3\uD83C\uDDF7", Collections.singletonList(":flag_nr:"), Collections.singletonList(":flag-nr:"), Collections.singletonList(":nauru:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Nauru", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇳🇺
     */
    Emoji FLAG_NIUE = new Emoji("🇳🇺", "\uD83C\uDDF3\uD83C\uDDFA", Collections.singletonList(":flag_nu:"), Collections.singletonList(":flag-nu:"), Collections.singletonList(":niue:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Niue", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇳🇿
     */
    Emoji FLAG_NEW_ZEALAND = new Emoji("🇳🇿", "\uD83C\uDDF3\uD83C\uDDFF", Collections.singletonList(":flag_nz:"), Collections.singletonList(":flag-nz:"), Collections.singletonList(":new_zealand:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: New Zealand", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇴🇲
     */
    Emoji FLAG_OMAN = new Emoji("🇴🇲", "\uD83C\uDDF4\uD83C\uDDF2", Collections.singletonList(":flag_om:"), Collections.singletonList(":flag-om:"), Collections.singletonList(":oman:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Oman", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇵🇦
     */
    Emoji FLAG_PANAMA = new Emoji("🇵🇦", "\uD83C\uDDF5\uD83C\uDDE6", Collections.singletonList(":flag_pa:"), Collections.singletonList(":flag-pa:"), Collections.singletonList(":panama:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Panama", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇵🇪
     */
    Emoji FLAG_PERU = new Emoji("🇵🇪", "\uD83C\uDDF5\uD83C\uDDEA", Collections.singletonList(":flag_pe:"), Collections.singletonList(":flag-pe:"), Collections.singletonList(":peru:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Peru", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇵🇫
     */
    Emoji FLAG_FRENCH_POLYNESIA = new Emoji("🇵🇫", "\uD83C\uDDF5\uD83C\uDDEB", Collections.singletonList(":flag_pf:"), Collections.singletonList(":flag-pf:"), Collections.singletonList(":french_polynesia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: French Polynesia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇵🇬
     */
    Emoji FLAG_PAPUA_NEW_GUINEA = new Emoji("🇵🇬", "\uD83C\uDDF5\uD83C\uDDEC", Collections.singletonList(":flag_pg:"), Collections.singletonList(":flag-pg:"), Collections.singletonList(":papua_new_guinea:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Papua New Guinea", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇵🇭
     */
    Emoji FLAG_PHILIPPINES = new Emoji("🇵🇭", "\uD83C\uDDF5\uD83C\uDDED", Collections.singletonList(":flag_ph:"), Collections.singletonList(":flag-ph:"), Collections.singletonList(":philippines:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Philippines", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇵🇰
     */
    Emoji FLAG_PAKISTAN = new Emoji("🇵🇰", "\uD83C\uDDF5\uD83C\uDDF0", Collections.singletonList(":flag_pk:"), Collections.singletonList(":flag-pk:"), Collections.singletonList(":pakistan:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Pakistan", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇵🇱
     */
    Emoji FLAG_POLAND = new Emoji("🇵🇱", "\uD83C\uDDF5\uD83C\uDDF1", Collections.singletonList(":flag_pl:"), Collections.singletonList(":flag-pl:"), Collections.singletonList(":poland:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Poland", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇵🇲
     */
    Emoji FLAG_ST_PIERRE_MIQUELON = new Emoji("🇵🇲", "\uD83C\uDDF5\uD83C\uDDF2", Collections.singletonList(":flag_pm:"), Collections.singletonList(":flag-pm:"), Collections.singletonList(":st_pierre_miquelon:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: St. Pierre & Miquelon", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇵🇳
     */
    Emoji FLAG_PITCAIRN_ISLANDS = new Emoji("🇵🇳", "\uD83C\uDDF5\uD83C\uDDF3", Collections.singletonList(":flag_pn:"), Collections.singletonList(":flag-pn:"), Collections.singletonList(":pitcairn_islands:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Pitcairn Islands", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇵🇷
     */
    Emoji FLAG_PUERTO_RICO = new Emoji("🇵🇷", "\uD83C\uDDF5\uD83C\uDDF7", Collections.singletonList(":flag_pr:"), Collections.singletonList(":flag-pr:"), Collections.singletonList(":puerto_rico:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Puerto Rico", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇵🇸
     */
    Emoji FLAG_PALESTINIAN_TERRITORIES = new Emoji("🇵🇸", "\uD83C\uDDF5\uD83C\uDDF8", Collections.singletonList(":flag_ps:"), Collections.singletonList(":flag-ps:"), Collections.singletonList(":palestinian_territories:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Palestinian Territories", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇵🇹
     */
    Emoji FLAG_PORTUGAL = new Emoji("🇵🇹", "\uD83C\uDDF5\uD83C\uDDF9", Collections.singletonList(":flag_pt:"), Collections.singletonList(":flag-pt:"), Collections.singletonList(":portugal:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Portugal", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇵🇼
     */
    Emoji FLAG_PALAU = new Emoji("🇵🇼", "\uD83C\uDDF5\uD83C\uDDFC", Collections.singletonList(":flag_pw:"), Collections.singletonList(":flag-pw:"), Collections.singletonList(":palau:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Palau", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇵🇾
     */
    Emoji FLAG_PARAGUAY = new Emoji("🇵🇾", "\uD83C\uDDF5\uD83C\uDDFE", Collections.singletonList(":flag_py:"), Collections.singletonList(":flag-py:"), Collections.singletonList(":paraguay:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Paraguay", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇶🇦
     */
    Emoji FLAG_QATAR = new Emoji("🇶🇦", "\uD83C\uDDF6\uD83C\uDDE6", Collections.singletonList(":flag_qa:"), Collections.singletonList(":flag-qa:"), Collections.singletonList(":qatar:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Qatar", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇷🇪
     */
    Emoji FLAG_R_UNION = new Emoji("🇷🇪", "\uD83C\uDDF7\uD83C\uDDEA", Collections.singletonList(":flag_re:"), Collections.singletonList(":flag-re:"), Collections.singletonList(":reunion:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Réunion", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇷🇴
     */
    Emoji FLAG_ROMANIA = new Emoji("🇷🇴", "\uD83C\uDDF7\uD83C\uDDF4", Collections.singletonList(":flag_ro:"), Collections.singletonList(":flag-ro:"), Collections.singletonList(":romania:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Romania", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇷🇸
     */
    Emoji FLAG_SERBIA = new Emoji("🇷🇸", "\uD83C\uDDF7\uD83C\uDDF8", Collections.singletonList(":flag_rs:"), Collections.singletonList(":flag-rs:"), Collections.singletonList(":serbia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Serbia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇷🇺
     */
    Emoji FLAG_RUSSIA = new Emoji("🇷🇺", "\uD83C\uDDF7\uD83C\uDDFA", Collections.singletonList(":flag_ru:"), Collections.singletonList(":ru:"), Collections.singletonList(":ru:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "flag: Russia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇷🇼
     */
    Emoji FLAG_RWANDA = new Emoji("🇷🇼", "\uD83C\uDDF7\uD83C\uDDFC", Collections.singletonList(":flag_rw:"), Collections.singletonList(":flag-rw:"), Collections.singletonList(":rwanda:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Rwanda", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇦
     */
    Emoji FLAG_SAUDI_ARABIA = new Emoji("🇸🇦", "\uD83C\uDDF8\uD83C\uDDE6", Collections.singletonList(":flag_sa:"), Collections.singletonList(":flag-sa:"), Collections.singletonList(":saudi_arabia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Saudi Arabia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇧
     */
    Emoji FLAG_SOLOMON_ISLANDS = new Emoji("🇸🇧", "\uD83C\uDDF8\uD83C\uDDE7", Collections.singletonList(":flag_sb:"), Collections.singletonList(":flag-sb:"), Collections.singletonList(":solomon_islands:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Solomon Islands", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇨
     */
    Emoji FLAG_SEYCHELLES = new Emoji("🇸🇨", "\uD83C\uDDF8\uD83C\uDDE8", Collections.singletonList(":flag_sc:"), Collections.singletonList(":flag-sc:"), Collections.singletonList(":seychelles:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Seychelles", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇩
     */
    Emoji FLAG_SUDAN = new Emoji("🇸🇩", "\uD83C\uDDF8\uD83C\uDDE9", Collections.singletonList(":flag_sd:"), Collections.singletonList(":flag-sd:"), Collections.singletonList(":sudan:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Sudan", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇪
     */
    Emoji FLAG_SWEDEN = new Emoji("🇸🇪", "\uD83C\uDDF8\uD83C\uDDEA", Collections.singletonList(":flag_se:"), Collections.singletonList(":flag-se:"), Collections.singletonList(":sweden:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Sweden", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇬
     */
    Emoji FLAG_SINGAPORE = new Emoji("🇸🇬", "\uD83C\uDDF8\uD83C\uDDEC", Collections.singletonList(":flag_sg:"), Collections.singletonList(":flag-sg:"), Collections.singletonList(":singapore:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Singapore", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇭
     */
    Emoji FLAG_ST_HELENA = new Emoji("🇸🇭", "\uD83C\uDDF8\uD83C\uDDED", Collections.singletonList(":flag_sh:"), Collections.singletonList(":flag-sh:"), Collections.singletonList(":st_helena:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: St. Helena", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇮
     */
    Emoji FLAG_SLOVENIA = new Emoji("🇸🇮", "\uD83C\uDDF8\uD83C\uDDEE", Collections.singletonList(":flag_si:"), Collections.singletonList(":flag-si:"), Collections.singletonList(":slovenia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Slovenia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇯
     */
    Emoji FLAG_SVALBARD_JAN_MAYEN = new Emoji("🇸🇯", "\uD83C\uDDF8\uD83C\uDDEF", Collections.singletonList(":flag_sj:"), Collections.singletonList(":flag-sj:"), Collections.singletonList(":svalbard_jan_mayen:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Svalbard & Jan Mayen", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇰
     */
    Emoji FLAG_SLOVAKIA = new Emoji("🇸🇰", "\uD83C\uDDF8\uD83C\uDDF0", Collections.singletonList(":flag_sk:"), Collections.singletonList(":flag-sk:"), Collections.singletonList(":slovakia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Slovakia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇱
     */
    Emoji FLAG_SIERRA_LEONE = new Emoji("🇸🇱", "\uD83C\uDDF8\uD83C\uDDF1", Collections.singletonList(":flag_sl:"), Collections.singletonList(":flag-sl:"), Collections.singletonList(":sierra_leone:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Sierra Leone", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇲
     */
    Emoji FLAG_SAN_MARINO = new Emoji("🇸🇲", "\uD83C\uDDF8\uD83C\uDDF2", Collections.singletonList(":flag_sm:"), Collections.singletonList(":flag-sm:"), Collections.singletonList(":san_marino:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: San Marino", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇳
     */
    Emoji FLAG_SENEGAL = new Emoji("🇸🇳", "\uD83C\uDDF8\uD83C\uDDF3", Collections.singletonList(":flag_sn:"), Collections.singletonList(":flag-sn:"), Collections.singletonList(":senegal:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Senegal", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇴
     */
    Emoji FLAG_SOMALIA = new Emoji("🇸🇴", "\uD83C\uDDF8\uD83C\uDDF4", Collections.singletonList(":flag_so:"), Collections.singletonList(":flag-so:"), Collections.singletonList(":somalia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Somalia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇷
     */
    Emoji FLAG_SURINAME = new Emoji("🇸🇷", "\uD83C\uDDF8\uD83C\uDDF7", Collections.singletonList(":flag_sr:"), Collections.singletonList(":flag-sr:"), Collections.singletonList(":suriname:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Suriname", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇸
     */
    Emoji FLAG_SOUTH_SUDAN = new Emoji("🇸🇸", "\uD83C\uDDF8\uD83C\uDDF8", Collections.singletonList(":flag_ss:"), Collections.singletonList(":flag-ss:"), Collections.singletonList(":south_sudan:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: South Sudan", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇹
     */
    Emoji FLAG_S_O_TOM_PR_NCIPE = new Emoji("🇸🇹", "\uD83C\uDDF8\uD83C\uDDF9", Collections.singletonList(":flag_st:"), Collections.singletonList(":flag-st:"), Collections.singletonList(":sao_tome_principe:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: São Tomé & Príncipe", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇻
     */
    Emoji FLAG_EL_SALVADOR = new Emoji("🇸🇻", "\uD83C\uDDF8\uD83C\uDDFB", Collections.singletonList(":flag_sv:"), Collections.singletonList(":flag-sv:"), Collections.singletonList(":el_salvador:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: El Salvador", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇽
     */
    Emoji FLAG_SINT_MAARTEN = new Emoji("🇸🇽", "\uD83C\uDDF8\uD83C\uDDFD", Collections.singletonList(":flag_sx:"), Collections.singletonList(":flag-sx:"), Collections.singletonList(":sint_maarten:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Sint Maarten", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇾
     */
    Emoji FLAG_SYRIA = new Emoji("🇸🇾", "\uD83C\uDDF8\uD83C\uDDFE", Collections.singletonList(":flag_sy:"), Collections.singletonList(":flag-sy:"), Collections.singletonList(":syria:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Syria", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇸🇿
     */
    Emoji FLAG_ESWATINI = new Emoji("🇸🇿", "\uD83C\uDDF8\uD83C\uDDFF", Collections.singletonList(":flag_sz:"), Collections.singletonList(":flag-sz:"), Collections.singletonList(":swaziland:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Eswatini", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇹🇦
     */
    Emoji FLAG_TRISTAN_DA_CUNHA = new Emoji("🇹🇦", "\uD83C\uDDF9\uD83C\uDDE6", Collections.singletonList(":flag_ta:"), Collections.singletonList(":flag-ta:"), Collections.singletonList(":tristan_da_cunha:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Tristan da Cunha", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇹🇨
     */
    Emoji FLAG_TURKS_CAICOS_ISLANDS = new Emoji("🇹🇨", "\uD83C\uDDF9\uD83C\uDDE8", Collections.singletonList(":flag_tc:"), Collections.singletonList(":flag-tc:"), Collections.singletonList(":turks_caicos_islands:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Turks & Caicos Islands", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇹🇩
     */
    Emoji FLAG_CHAD = new Emoji("🇹🇩", "\uD83C\uDDF9\uD83C\uDDE9", Collections.singletonList(":flag_td:"), Collections.singletonList(":flag-td:"), Collections.singletonList(":chad:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Chad", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇹🇫
     */
    Emoji FLAG_FRENCH_SOUTHERN_TERRITORIES = new Emoji("🇹🇫", "\uD83C\uDDF9\uD83C\uDDEB", Collections.singletonList(":flag_tf:"), Collections.singletonList(":flag-tf:"), Collections.singletonList(":french_southern_territories:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: French Southern Territories", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇹🇬
     */
    Emoji FLAG_TOGO = new Emoji("🇹🇬", "\uD83C\uDDF9\uD83C\uDDEC", Collections.singletonList(":flag_tg:"), Collections.singletonList(":flag-tg:"), Collections.singletonList(":togo:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Togo", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇹🇭
     */
    Emoji FLAG_THAILAND = new Emoji("🇹🇭", "\uD83C\uDDF9\uD83C\uDDED", Collections.singletonList(":flag_th:"), Collections.singletonList(":flag-th:"), Collections.singletonList(":thailand:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Thailand", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇹🇯
     */
    Emoji FLAG_TAJIKISTAN = new Emoji("🇹🇯", "\uD83C\uDDF9\uD83C\uDDEF", Collections.singletonList(":flag_tj:"), Collections.singletonList(":flag-tj:"), Collections.singletonList(":tajikistan:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Tajikistan", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇹🇰
     */
    Emoji FLAG_TOKELAU = new Emoji("🇹🇰", "\uD83C\uDDF9\uD83C\uDDF0", Collections.singletonList(":flag_tk:"), Collections.singletonList(":flag-tk:"), Collections.singletonList(":tokelau:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Tokelau", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇹🇱
     */
    Emoji FLAG_TIMOR_LESTE = new Emoji("🇹🇱", "\uD83C\uDDF9\uD83C\uDDF1", Collections.singletonList(":flag_tl:"), Collections.singletonList(":flag-tl:"), Collections.singletonList(":timor_leste:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Timor-Leste", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇹🇲
     */
    Emoji FLAG_TURKMENISTAN = new Emoji("🇹🇲", "\uD83C\uDDF9\uD83C\uDDF2", Collections.singletonList(":flag_tm:"), Collections.singletonList(":flag-tm:"), Collections.singletonList(":turkmenistan:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Turkmenistan", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇹🇳
     */
    Emoji FLAG_TUNISIA = new Emoji("🇹🇳", "\uD83C\uDDF9\uD83C\uDDF3", Collections.singletonList(":flag_tn:"), Collections.singletonList(":flag-tn:"), Collections.singletonList(":tunisia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Tunisia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇹🇴
     */
    Emoji FLAG_TONGA = new Emoji("🇹🇴", "\uD83C\uDDF9\uD83C\uDDF4", Collections.singletonList(":flag_to:"), Collections.singletonList(":flag-to:"), Collections.singletonList(":tonga:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Tonga", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇹🇷
     */
    Emoji FLAG_T_RKIYE = new Emoji("🇹🇷", "\uD83C\uDDF9\uD83C\uDDF7", Collections.singletonList(":flag_tr:"), Collections.singletonList(":flag-tr:"), Collections.singletonList(":tr:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Türkiye", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇹🇹
     */
    Emoji FLAG_TRINIDAD_TOBAGO = new Emoji("🇹🇹", "\uD83C\uDDF9\uD83C\uDDF9", Collections.singletonList(":flag_tt:"), Collections.singletonList(":flag-tt:"), Collections.singletonList(":trinidad_tobago:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Trinidad & Tobago", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇹🇻
     */
    Emoji FLAG_TUVALU = new Emoji("🇹🇻", "\uD83C\uDDF9\uD83C\uDDFB", Collections.singletonList(":flag_tv:"), Collections.singletonList(":flag-tv:"), Collections.singletonList(":tuvalu:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Tuvalu", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇹🇼
     */
    Emoji FLAG_TAIWAN = new Emoji("🇹🇼", "\uD83C\uDDF9\uD83C\uDDFC", Collections.singletonList(":flag_tw:"), Collections.singletonList(":flag-tw:"), Collections.singletonList(":taiwan:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Taiwan", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇹🇿
     */
    Emoji FLAG_TANZANIA = new Emoji("🇹🇿", "\uD83C\uDDF9\uD83C\uDDFF", Collections.singletonList(":flag_tz:"), Collections.singletonList(":flag-tz:"), Collections.singletonList(":tanzania:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Tanzania", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇺🇦
     */
    Emoji FLAG_UKRAINE = new Emoji("🇺🇦", "\uD83C\uDDFA\uD83C\uDDE6", Collections.singletonList(":flag_ua:"), Collections.singletonList(":flag-ua:"), Collections.singletonList(":ukraine:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Ukraine", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇺🇬
     */
    Emoji FLAG_UGANDA = new Emoji("🇺🇬", "\uD83C\uDDFA\uD83C\uDDEC", Collections.singletonList(":flag_ug:"), Collections.singletonList(":flag-ug:"), Collections.singletonList(":uganda:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Uganda", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇺🇲
     */
    Emoji FLAG_U_S_OUTLYING_ISLANDS = new Emoji("🇺🇲", "\uD83C\uDDFA\uD83C\uDDF2", Collections.singletonList(":flag_um:"), Collections.singletonList(":flag-um:"), Collections.singletonList(":us_outlying_islands:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: U.S. Outlying Islands", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇺🇳
     */
    Emoji FLAG_UNITED_NATIONS = new Emoji("🇺🇳", "\uD83C\uDDFA\uD83C\uDDF3", Collections.singletonList(":united_nations:"), Collections.singletonList(":flag-un:"), Collections.singletonList(":united_nations:"), false, false, 4.0, Qualification.fromString("fully-qualified"), "flag: United Nations", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇺🇸
     */
    Emoji FLAG_UNITED_STATES = new Emoji("🇺🇸", "\uD83C\uDDFA\uD83C\uDDF8", Collections.singletonList(":flag_us:"), Collections.singletonList(":us:"), Collections.singletonList(":us:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "flag: United States", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇺🇾
     */
    Emoji FLAG_URUGUAY = new Emoji("🇺🇾", "\uD83C\uDDFA\uD83C\uDDFE", Collections.singletonList(":flag_uy:"), Collections.singletonList(":flag-uy:"), Collections.singletonList(":uruguay:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Uruguay", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇺🇿
     */
    Emoji FLAG_UZBEKISTAN = new Emoji("🇺🇿", "\uD83C\uDDFA\uD83C\uDDFF", Collections.singletonList(":flag_uz:"), Collections.singletonList(":flag-uz:"), Collections.singletonList(":uzbekistan:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Uzbekistan", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇻🇦
     */
    Emoji FLAG_VATICAN_CITY = new Emoji("🇻🇦", "\uD83C\uDDFB\uD83C\uDDE6", Collections.singletonList(":flag_va:"), Collections.singletonList(":flag-va:"), Collections.singletonList(":vatican_city:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Vatican City", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇻🇨
     */
    Emoji FLAG_ST_VINCENT_GRENADINES = new Emoji("🇻🇨", "\uD83C\uDDFB\uD83C\uDDE8", Collections.singletonList(":flag_vc:"), Collections.singletonList(":flag-vc:"), Collections.singletonList(":st_vincent_grenadines:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: St. Vincent & Grenadines", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇻🇪
     */
    Emoji FLAG_VENEZUELA = new Emoji("🇻🇪", "\uD83C\uDDFB\uD83C\uDDEA", Collections.singletonList(":flag_ve:"), Collections.singletonList(":flag-ve:"), Collections.singletonList(":venezuela:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Venezuela", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇻🇬
     */
    Emoji FLAG_BRITISH_VIRGIN_ISLANDS = new Emoji("🇻🇬", "\uD83C\uDDFB\uD83C\uDDEC", Collections.singletonList(":flag_vg:"), Collections.singletonList(":flag-vg:"), Collections.singletonList(":british_virgin_islands:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: British Virgin Islands", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇻🇮
     */
    Emoji FLAG_U_S_VIRGIN_ISLANDS = new Emoji("🇻🇮", "\uD83C\uDDFB\uD83C\uDDEE", Collections.singletonList(":flag_vi:"), Collections.singletonList(":flag-vi:"), Collections.singletonList(":us_virgin_islands:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: U.S. Virgin Islands", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇻🇳
     */
    Emoji FLAG_VIETNAM = new Emoji("🇻🇳", "\uD83C\uDDFB\uD83C\uDDF3", Collections.singletonList(":flag_vn:"), Collections.singletonList(":flag-vn:"), Collections.singletonList(":vietnam:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Vietnam", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇻🇺
     */
    Emoji FLAG_VANUATU = new Emoji("🇻🇺", "\uD83C\uDDFB\uD83C\uDDFA", Collections.singletonList(":flag_vu:"), Collections.singletonList(":flag-vu:"), Collections.singletonList(":vanuatu:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Vanuatu", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇼🇫
     */
    Emoji FLAG_WALLIS_FUTUNA = new Emoji("🇼🇫", "\uD83C\uDDFC\uD83C\uDDEB", Collections.singletonList(":flag_wf:"), Collections.singletonList(":flag-wf:"), Collections.singletonList(":wallis_futuna:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Wallis & Futuna", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇼🇸
     */
    Emoji FLAG_SAMOA = new Emoji("🇼🇸", "\uD83C\uDDFC\uD83C\uDDF8", Collections.singletonList(":flag_ws:"), Collections.singletonList(":flag-ws:"), Collections.singletonList(":samoa:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Samoa", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇽🇰
     */
    Emoji FLAG_KOSOVO = new Emoji("🇽🇰", "\uD83C\uDDFD\uD83C\uDDF0", Collections.singletonList(":flag_xk:"), Collections.singletonList(":flag-xk:"), Collections.singletonList(":kosovo:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Kosovo", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇾🇪
     */
    Emoji FLAG_YEMEN = new Emoji("🇾🇪", "\uD83C\uDDFE\uD83C\uDDEA", Collections.singletonList(":flag_ye:"), Collections.singletonList(":flag-ye:"), Collections.singletonList(":yemen:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Yemen", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇾🇹
     */
    Emoji FLAG_MAYOTTE = new Emoji("🇾🇹", "\uD83C\uDDFE\uD83C\uDDF9", Collections.singletonList(":flag_yt:"), Collections.singletonList(":flag-yt:"), Collections.singletonList(":mayotte:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Mayotte", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇿🇦
     */
    Emoji FLAG_SOUTH_AFRICA = new Emoji("🇿🇦", "\uD83C\uDDFF\uD83C\uDDE6", Collections.singletonList(":flag_za:"), Collections.singletonList(":flag-za:"), Collections.singletonList(":south_africa:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: South Africa", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇿🇲
     */
    Emoji FLAG_ZAMBIA = new Emoji("🇿🇲", "\uD83C\uDDFF\uD83C\uDDF2", Collections.singletonList(":flag_zm:"), Collections.singletonList(":flag-zm:"), Collections.singletonList(":zambia:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Zambia", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);

    /**
     * 🇿🇼
     */
    Emoji FLAG_ZIMBABWE = new Emoji("🇿🇼", "\uD83C\uDDFF\uD83C\uDDFC", Collections.singletonList(":flag_zw:"), Collections.singletonList(":flag-zw:"), Collections.singletonList(":zimbabwe:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "flag: Zimbabwe", EmojiGroup.FLAGS, EmojiSubGroup.COUNTRY_FLAG, false);
}
