package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiEvent {

    /**
     * 🎃
     */
    Emoji JACK_O_LANTERN = new Emoji("🎃", "\uD83C\uDF83", Collections.singletonList(":jack_o_lantern:"), Collections.singletonList(":jack_o_lantern:"), Collections.singletonList(":jack_o_lantern:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "jack-o-lantern", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, false);

    /**
     * 🎄
     */
    Emoji CHRISTMAS_TREE = new Emoji("🎄", "\uD83C\uDF84", Collections.singletonList(":christmas_tree:"), Collections.singletonList(":christmas_tree:"), Collections.singletonList(":christmas_tree:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Christmas tree", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, false);

    /**
     * 🎆
     */
    Emoji FIREWORKS = new Emoji("🎆", "\uD83C\uDF86", Collections.singletonList(":fireworks:"), Collections.singletonList(":fireworks:"), Collections.singletonList(":fireworks:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "fireworks", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, false);

    /**
     * 🎇
     */
    Emoji SPARKLER = new Emoji("🎇", "\uD83C\uDF87", Collections.singletonList(":sparkler:"), Collections.singletonList(":sparkler:"), Collections.singletonList(":sparkler:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "sparkler", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, false);

    /**
     * 🧨
     */
    Emoji FIRECRACKER = new Emoji("🧨", "\uD83E\uDDE8", Collections.singletonList(":firecracker:"), Collections.singletonList(":firecracker:"), Collections.singletonList(":firecracker:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "firecracker", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, false);

    /**
     * ✨
     */
    Emoji SPARKLES = new Emoji("✨", "\u2728", Collections.singletonList(":sparkles:"), Collections.singletonList(":sparkles:"), Collections.singletonList(":sparkles:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "sparkles", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, true);

    /**
     * 🎈
     */
    Emoji BALLOON = new Emoji("🎈", "\uD83C\uDF88", Collections.singletonList(":balloon:"), Collections.singletonList(":balloon:"), Collections.singletonList(":balloon:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "balloon", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, false);

    /**
     * 🎉
     */
    Emoji PARTY_POPPER = new Emoji("🎉", "\uD83C\uDF89", Collections.unmodifiableList(Arrays.asList(":tada:", ":party_popper:")), Collections.singletonList(":tada:"), Collections.singletonList(":tada:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "party popper", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, false);

    /**
     * 🎊
     */
    Emoji CONFETTI_BALL = new Emoji("🎊", "\uD83C\uDF8A", Collections.singletonList(":confetti_ball:"), Collections.singletonList(":confetti_ball:"), Collections.singletonList(":confetti_ball:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "confetti ball", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, false);

    /**
     * 🎋
     */
    Emoji TANABATA_TREE = new Emoji("🎋", "\uD83C\uDF8B", Collections.singletonList(":tanabata_tree:"), Collections.singletonList(":tanabata_tree:"), Collections.singletonList(":tanabata_tree:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "tanabata tree", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, false);

    /**
     * 🎍
     */
    Emoji PINE_DECORATION = new Emoji("🎍", "\uD83C\uDF8D", Collections.singletonList(":bamboo:"), Collections.singletonList(":bamboo:"), Collections.singletonList(":bamboo:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "pine decoration", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, false);

    /**
     * 🎎
     */
    Emoji JAPANESE_DOLLS = new Emoji("🎎", "\uD83C\uDF8E", Collections.singletonList(":dolls:"), Collections.singletonList(":dolls:"), Collections.singletonList(":dolls:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese dolls", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, false);

    /**
     * 🎏
     */
    Emoji CARP_STREAMER = new Emoji("🎏", "\uD83C\uDF8F", Collections.unmodifiableList(Arrays.asList(":flags:", ":carp_streamer:")), Collections.singletonList(":flags:"), Collections.singletonList(":flags:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "carp streamer", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, false);

    /**
     * 🎐
     */
    Emoji WIND_CHIME = new Emoji("🎐", "\uD83C\uDF90", Collections.singletonList(":wind_chime:"), Collections.singletonList(":wind_chime:"), Collections.singletonList(":wind_chime:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "wind chime", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, false);

    /**
     * 🎑
     */
    Emoji MOON_VIEWING_CEREMONY = new Emoji("🎑", "\uD83C\uDF91", Collections.singletonList(":rice_scene:"), Collections.singletonList(":rice_scene:"), Collections.singletonList(":rice_scene:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "moon viewing ceremony", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, false);

    /**
     * 🧧
     */
    Emoji RED_ENVELOPE = new Emoji("🧧", "\uD83E\uDDE7", Collections.singletonList(":red_envelope:"), Collections.singletonList(":red_envelope:"), Collections.singletonList(":red_envelope:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "red envelope", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, false);

    /**
     * 🎀
     */
    Emoji RIBBON = new Emoji("🎀", "\uD83C\uDF80", Collections.singletonList(":ribbon:"), Collections.singletonList(":ribbon:"), Collections.singletonList(":ribbon:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "ribbon", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, false);

    /**
     * 🎁
     */
    Emoji WRAPPED_GIFT = new Emoji("🎁", "\uD83C\uDF81", Collections.unmodifiableList(Arrays.asList(":gift:", ":wrapped_gift:")), Collections.singletonList(":gift:"), Collections.singletonList(":gift:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "wrapped gift", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, false);

    /**
     * 🎗️
     */
    Emoji REMINDER_RIBBON = new Emoji("🎗️", "\uD83C\uDF97\uFE0F", Collections.singletonList(":reminder_ribbon:"), Collections.singletonList(":reminder_ribbon:"), Collections.singletonList(":reminder_ribbon:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "reminder ribbon", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, false);

    /**
     * 🎗
     */
    Emoji REMINDER_RIBBON_UNQUALIFIED = new Emoji("🎗", "\uD83C\uDF97", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":reminder_ribbon:"), false, false, 0.7, Qualification.fromString("unqualified"), "reminder ribbon", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, true);

    /**
     * 🎟️
     */
    Emoji ADMISSION_TICKETS = new Emoji("🎟️", "\uD83C\uDF9F\uFE0F", Collections.unmodifiableList(Arrays.asList(":tickets:", ":admission_tickets:")), Collections.singletonList(":admission_tickets:"), Collections.singletonList(":tickets:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "admission tickets", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, false);

    /**
     * 🎟
     */
    Emoji ADMISSION_TICKETS_UNQUALIFIED = new Emoji("🎟", "\uD83C\uDF9F", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":tickets:"), false, false, 0.7, Qualification.fromString("unqualified"), "admission tickets", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, true);

    /**
     * 🎫
     */
    Emoji TICKET = new Emoji("🎫", "\uD83C\uDFAB", Collections.singletonList(":ticket:"), Collections.singletonList(":ticket:"), Collections.singletonList(":ticket:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "ticket", EmojiGroup.ACTIVITIES, EmojiSubGroup.EVENT, false);
}
