package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiFaceHand {

    /**
     * 🤗
     */
    Emoji SMILING_FACE_WITH_OPEN_HANDS = new Emoji("🤗", "\uD83E\uDD17", Collections.unmodifiableList(Arrays.asList(":hugging:", ":hugging_face:")), Collections.singletonList(":hugging_face:"), Collections.singletonList(":hugs:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "smiling face with open hands", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_HAND, false);

    /**
     * 🤭
     */
    Emoji FACE_WITH_HAND_OVER_MOUTH = new Emoji("🤭", "\uD83E\uDD2D", Collections.singletonList(":face_with_hand_over_mouth:"), Collections.singletonList(":face_with_hand_over_mouth:"), Collections.singletonList(":hand_over_mouth:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "face with hand over mouth", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_HAND, false);

    /**
     * 🫢
     */
    Emoji FACE_WITH_OPEN_EYES_AND_HAND_OVER_MOUTH = new Emoji("🫢", "\uD83E\uDEE2", Collections.singletonList(":face_with_open_eyes_and_hand_over_mouth:"), Collections.emptyList(), Collections.singletonList(":face_with_open_eyes_and_hand_over_mouth:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "face with open eyes and hand over mouth", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_HAND, false);

    /**
     * 🫣
     */
    Emoji FACE_WITH_PEEKING_EYE = new Emoji("🫣", "\uD83E\uDEE3", Collections.singletonList(":face_with_peeking_eye:"), Collections.emptyList(), Collections.singletonList(":face_with_peeking_eye:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "face with peeking eye", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_HAND, false);

    /**
     * 🤫
     */
    Emoji SHUSHING_FACE = new Emoji("🤫", "\uD83E\uDD2B", Collections.singletonList(":shushing_face:"), Collections.singletonList(":shushing_face:"), Collections.singletonList(":shushing_face:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "shushing face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_HAND, false);

    /**
     * 🤔
     */
    Emoji THINKING_FACE = new Emoji("🤔", "\uD83E\uDD14", Collections.unmodifiableList(Arrays.asList(":thinking:", ":thinking_face:")), Collections.singletonList(":thinking_face:"), Collections.singletonList(":thinking:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "thinking face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_HAND, false);

    /**
     * 🫡
     */
    Emoji SALUTING_FACE = new Emoji("🫡", "\uD83E\uDEE1", Collections.singletonList(":saluting_face:"), Collections.emptyList(), Collections.singletonList(":saluting_face:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "saluting face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_HAND, false);
}
