package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiFaceNegative {

    /**
     * 😤
     */
    Emoji FACE_WITH_STEAM_FROM_NOSE = new Emoji("😤", "\uD83D\uDE24", Collections.singletonList(":triumph:"), Collections.singletonList(":triumph:"), Collections.singletonList(":triumph:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "face with steam from nose", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEGATIVE, false);

    /**
     * 😡
     */
    Emoji ENRAGED_FACE = new Emoji("😡", "\uD83D\uDE21", Collections.unmodifiableList(Arrays.asList(":rage:", ":pouting_face:", ":@", ":-@", "=@", "=-@")), Collections.singletonList(":rage:"), Collections.unmodifiableList(Arrays.asList(":pout:", ":rage:")), false, false, 0.6, Qualification.fromString("fully-qualified"), "enraged face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEGATIVE, false);

    /**
     * 😠
     */
    Emoji ANGRY_FACE = new Emoji("😠", "\uD83D\uDE20", Collections.unmodifiableList(Arrays.asList(":angry:", ":angry_face:", ">:(", ">:-(", ">=(", ">=-(")), Collections.singletonList(":angry:"), Collections.singletonList(":angry:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "angry face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEGATIVE, false);

    /**
     * 🤬
     */
    Emoji FACE_WITH_SYMBOLS_ON_MOUTH = new Emoji("🤬", "\uD83E\uDD2C", Collections.singletonList(":face_with_symbols_over_mouth:"), Collections.singletonList(":face_with_symbols_on_mouth:"), Collections.singletonList(":cursing_face:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "face with symbols on mouth", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEGATIVE, false);

    /**
     * 😈
     */
    Emoji SMILING_FACE_WITH_HORNS = new Emoji("😈", "\uD83D\uDE08", Collections.unmodifiableList(Arrays.asList(":smiling_imp:", "]:)", "]:-)", "]=)", "]=-)")), Collections.singletonList(":smiling_imp:"), Collections.singletonList(":smiling_imp:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "smiling face with horns", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEGATIVE, false);

    /**
     * 👿
     */
    Emoji ANGRY_FACE_WITH_HORNS = new Emoji("👿", "\uD83D\uDC7F", Collections.unmodifiableList(Arrays.asList(":imp:", "]:(", "]:-(", "]=(", "]=-(")), Collections.singletonList(":imp:"), Collections.singletonList(":imp:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "angry face with horns", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEGATIVE, false);

    /**
     * 💀
     */
    Emoji SKULL = new Emoji("💀", "\uD83D\uDC80", Collections.unmodifiableList(Arrays.asList(":skull:", ":skeleton:")), Collections.singletonList(":skull:"), Collections.singletonList(":skull:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "skull", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEGATIVE, false);

    /**
     * ☠️
     */
    Emoji SKULL_AND_CROSSBONES = new Emoji("☠️", "\u2620\uFE0F", Collections.unmodifiableList(Arrays.asList(":skull_crossbones:", ":skull_and_crossbones:")), Collections.singletonList(":skull_and_crossbones:"), Collections.singletonList(":skull_and_crossbones:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "skull and crossbones", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEGATIVE, false);

    /**
     * ☠
     */
    Emoji SKULL_AND_CROSSBONES_UNQUALIFIED = new Emoji("☠", "\u2620", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":skull_and_crossbones:"), false, false, 1.0, Qualification.fromString("unqualified"), "skull and crossbones", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEGATIVE, true);
}
