package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiFaceNeutralSkeptical {

    /**
     * 🤐
     */
    Emoji ZIPPER_MOUTH_FACE = new Emoji("🤐", "\uD83E\uDD10", Collections.unmodifiableList(Arrays.asList(":zipper_mouth:", ":zipper_mouth_face:")), Collections.singletonList(":zipper_mouth_face:"), Collections.singletonList(":zipper_mouth_face:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "zipper-mouth face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEUTRAL_SKEPTICAL, false);

    /**
     * 🤨
     */
    Emoji FACE_WITH_RAISED_EYEBROW = new Emoji("🤨", "\uD83E\uDD28", Collections.singletonList(":face_with_raised_eyebrow:"), Collections.singletonList(":face_with_raised_eyebrow:"), Collections.singletonList(":raised_eyebrow:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "face with raised eyebrow", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEUTRAL_SKEPTICAL, false);

    /**
     * 😐
     */
    Emoji NEUTRAL_FACE = new Emoji("😐", "\uD83D\uDE10", Collections.unmodifiableList(Arrays.asList(":neutral_face:", ":|", ":-|", "=|", "=-|")), Collections.singletonList(":neutral_face:"), Collections.singletonList(":neutral_face:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "neutral face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEUTRAL_SKEPTICAL, true);

    /**
     * 😑
     */
    Emoji EXPRESSIONLESS_FACE = new Emoji("😑", "\uD83D\uDE11", Collections.singletonList(":expressionless:"), Collections.singletonList(":expressionless:"), Collections.singletonList(":expressionless:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "expressionless face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEUTRAL_SKEPTICAL, false);

    /**
     * 😶
     */
    Emoji FACE_WITHOUT_MOUTH = new Emoji("😶", "\uD83D\uDE36", Collections.singletonList(":no_mouth:"), Collections.singletonList(":no_mouth:"), Collections.singletonList(":no_mouth:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "face without mouth", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEUTRAL_SKEPTICAL, false);

    /**
     * 🫥
     */
    Emoji DOTTED_LINE_FACE = new Emoji("🫥", "\uD83E\uDEE5", Collections.singletonList(":dotted_line_face:"), Collections.emptyList(), Collections.singletonList(":dotted_line_face:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "dotted line face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEUTRAL_SKEPTICAL, false);

    /**
     * 😶‍🌫️
     */
    Emoji FACE_IN_CLOUDS = new Emoji("😶‍🌫️", "\uD83D\uDE36\u200D\uD83C\uDF2B\uFE0F", Collections.singletonList(":face_in_clouds:"), Collections.emptyList(), Collections.singletonList(":face_in_clouds:"), false, false, 13.1, Qualification.fromString("fully-qualified"), "face in clouds", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEUTRAL_SKEPTICAL, false);

    /**
     * 😶‍🌫
     */
    Emoji FACE_IN_CLOUDS_MINIMALLY_QUALIFIED = new Emoji("😶‍🌫", "\uD83D\uDE36\u200D\uD83C\uDF2B", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 13.1, Qualification.fromString("minimally-qualified"), "face in clouds", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEUTRAL_SKEPTICAL, false);

    /**
     * 😏
     */
    Emoji SMIRKING_FACE = new Emoji("😏", "\uD83D\uDE0F", Collections.unmodifiableList(Arrays.asList(":smirk:", ":smirking_face:")), Collections.singletonList(":smirk:"), Collections.singletonList(":smirk:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "smirking face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEUTRAL_SKEPTICAL, false);

    /**
     * 😒
     */
    Emoji UNAMUSED_FACE = new Emoji("😒", "\uD83D\uDE12", Collections.unmodifiableList(Arrays.asList(":unamused:", ":unamused_face:", ":s", ":-S", ":z", ":-Z", ":$", ":-$", "=s", "=-S", "=z", "=-Z", "=$", "=-$")), Collections.singletonList(":unamused:"), Collections.singletonList(":unamused:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "unamused face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEUTRAL_SKEPTICAL, false);

    /**
     * 🙄
     */
    Emoji FACE_WITH_ROLLING_EYES = new Emoji("🙄", "\uD83D\uDE44", Collections.unmodifiableList(Arrays.asList(":rolling_eyes:", ":face_with_rolling_eyes:")), Collections.singletonList(":face_with_rolling_eyes:"), Collections.singletonList(":roll_eyes:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "face with rolling eyes", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEUTRAL_SKEPTICAL, false);

    /**
     * 😬
     */
    Emoji GRIMACING_FACE = new Emoji("😬", "\uD83D\uDE2C", Collections.singletonList(":grimacing:"), Collections.singletonList(":grimacing:"), Collections.singletonList(":grimacing:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "grimacing face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEUTRAL_SKEPTICAL, false);

    /**
     * 😮‍💨
     */
    Emoji FACE_EXHALING = new Emoji("😮‍💨", "\uD83D\uDE2E\u200D\uD83D\uDCA8", Collections.singletonList(":face_exhaling:"), Collections.emptyList(), Collections.singletonList(":face_exhaling:"), false, false, 13.1, Qualification.fromString("fully-qualified"), "face exhaling", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEUTRAL_SKEPTICAL, false);

    /**
     * 🤥
     */
    Emoji LYING_FACE = new Emoji("🤥", "\uD83E\uDD25", Collections.unmodifiableList(Arrays.asList(":lying_face:", ":liar:")), Collections.singletonList(":lying_face:"), Collections.singletonList(":lying_face:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "lying face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEUTRAL_SKEPTICAL, false);

    /**
     * 🫨
     */
    Emoji SHAKING_FACE = new Emoji("🫨", "\uD83E\uDEE8", Collections.singletonList(":shaking_face:"), Collections.emptyList(), Collections.singletonList(":shaking_face:"), false, false, 15.0, Qualification.fromString("fully-qualified"), "shaking face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEUTRAL_SKEPTICAL, false);

    /**
     * 🙂‍↔️
     */
    Emoji HEAD_SHAKING_HORIZONTALLY = new Emoji("🙂‍↔️", "\uD83D\uDE42\u200D\u2194\uFE0F", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 15.1, Qualification.fromString("fully-qualified"), "head shaking horizontally", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEUTRAL_SKEPTICAL, false);

    /**
     * 🙂‍↔
     */
    Emoji HEAD_SHAKING_HORIZONTALLY_MINIMALLY_QUALIFIED = new Emoji("🙂‍↔", "\uD83D\uDE42\u200D\u2194", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 15.1, Qualification.fromString("minimally-qualified"), "head shaking horizontally", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEUTRAL_SKEPTICAL, false);

    /**
     * 🙂‍↕️
     */
    Emoji HEAD_SHAKING_VERTICALLY = new Emoji("🙂‍↕️", "\uD83D\uDE42\u200D\u2195\uFE0F", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 15.1, Qualification.fromString("fully-qualified"), "head shaking vertically", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEUTRAL_SKEPTICAL, false);

    /**
     * 🙂‍↕
     */
    Emoji HEAD_SHAKING_VERTICALLY_MINIMALLY_QUALIFIED = new Emoji("🙂‍↕", "\uD83D\uDE42\u200D\u2195", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 15.1, Qualification.fromString("minimally-qualified"), "head shaking vertically", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_NEUTRAL_SKEPTICAL, false);
}
