package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiGame {

    /**
     * 🎯
     */
    Emoji BULLSEYE = new Emoji("🎯", "\uD83C\uDFAF", Collections.unmodifiableList(Arrays.asList(":dart:", ":direct_hit:")), Collections.singletonList(":dart:"), Collections.singletonList(":dart:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "bullseye", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * 🪀
     */
    Emoji YO_YO = new Emoji("🪀", "\uD83E\uDE80", Collections.singletonList(":yo_yo:"), Collections.singletonList(":yo-yo:"), Collections.singletonList(":yo_yo:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "yo-yo", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * 🪁
     */
    Emoji KITE = new Emoji("🪁", "\uD83E\uDE81", Collections.singletonList(":kite:"), Collections.singletonList(":kite:"), Collections.singletonList(":kite:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "kite", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * 🔫
     */
    Emoji WATER_PISTOL = new Emoji("🔫", "\uD83D\uDD2B", Collections.unmodifiableList(Arrays.asList(":gun:", ":pistol:")), Collections.singletonList(":gun:"), Collections.singletonList(":gun:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "water pistol", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * 🎱
     */
    Emoji POOL_8_BALL = new Emoji("🎱", "\uD83C\uDFB1", Collections.singletonList(":8ball:"), Collections.singletonList(":8ball:"), Collections.singletonList(":8ball:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "pool 8 ball", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * 🔮
     */
    Emoji CRYSTAL_BALL = new Emoji("🔮", "\uD83D\uDD2E", Collections.singletonList(":crystal_ball:"), Collections.singletonList(":crystal_ball:"), Collections.singletonList(":crystal_ball:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "crystal ball", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * 🪄
     */
    Emoji MAGIC_WAND = new Emoji("🪄", "\uD83E\uDE84", Collections.singletonList(":magic_wand:"), Collections.singletonList(":magic_wand:"), Collections.singletonList(":magic_wand:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "magic wand", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * 🎮
     */
    Emoji VIDEO_GAME = new Emoji("🎮", "\uD83C\uDFAE", Collections.singletonList(":video_game:"), Collections.singletonList(":video_game:"), Collections.singletonList(":video_game:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "video game", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, true);

    /**
     * 🕹️
     */
    Emoji JOYSTICK = new Emoji("🕹️", "\uD83D\uDD79\uFE0F", Collections.singletonList(":joystick:"), Collections.singletonList(":joystick:"), Collections.singletonList(":joystick:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "joystick", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * 🕹
     */
    Emoji JOYSTICK_UNQUALIFIED = new Emoji("🕹", "\uD83D\uDD79", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":joystick:"), false, false, 0.7, Qualification.fromString("unqualified"), "joystick", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, true);

    /**
     * 🎰
     */
    Emoji SLOT_MACHINE = new Emoji("🎰", "\uD83C\uDFB0", Collections.singletonList(":slot_machine:"), Collections.singletonList(":slot_machine:"), Collections.singletonList(":slot_machine:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "slot machine", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * 🎲
     */
    Emoji GAME_DIE = new Emoji("🎲", "\uD83C\uDFB2", Collections.singletonList(":game_die:"), Collections.singletonList(":game_die:"), Collections.singletonList(":game_die:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "game die", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * 🧩
     */
    Emoji PUZZLE_PIECE = new Emoji("🧩", "\uD83E\uDDE9", Collections.unmodifiableList(Arrays.asList(":jigsaw:", ":puzzle_piece:")), Collections.singletonList(":jigsaw:"), Collections.singletonList(":jigsaw:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "puzzle piece", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * 🧸
     */
    Emoji TEDDY_BEAR = new Emoji("🧸", "\uD83E\uDDF8", Collections.singletonList(":teddy_bear:"), Collections.singletonList(":teddy_bear:"), Collections.singletonList(":teddy_bear:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "teddy bear", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * 🪅
     */
    Emoji PI_ATA = new Emoji("🪅", "\uD83E\uDE85", Collections.singletonList(":piñata:"), Collections.singletonList(":pinata:"), Collections.singletonList(":pinata:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "piñata", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * 🪩
     */
    Emoji MIRROR_BALL = new Emoji("🪩", "\uD83E\uDEA9", Collections.singletonList(":mirror_ball:"), Collections.emptyList(), Collections.singletonList(":mirror_ball:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "mirror ball", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * 🪆
     */
    Emoji NESTING_DOLLS = new Emoji("🪆", "\uD83E\uDE86", Collections.singletonList(":nesting_dolls:"), Collections.singletonList(":nesting_dolls:"), Collections.singletonList(":nesting_dolls:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "nesting dolls", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * ♠️
     */
    Emoji SPADE_SUIT = new Emoji("♠️", "\u2660\uFE0F", Collections.unmodifiableList(Arrays.asList(":spades:", ":spade_suit:")), Collections.singletonList(":spades:"), Collections.singletonList(":spades:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "spade suit", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * ♠
     */
    Emoji SPADE_SUIT_UNQUALIFIED = new Emoji("♠", "\u2660", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":spades:"), false, false, 0.6, Qualification.fromString("unqualified"), "spade suit", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, true);

    /**
     * ♥️
     */
    Emoji HEART_SUIT = new Emoji("♥️", "\u2665\uFE0F", Collections.unmodifiableList(Arrays.asList(":hearts:", ":heart_suit:")), Collections.singletonList(":hearts:"), Collections.singletonList(":hearts:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "heart suit", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * ♥
     */
    Emoji HEART_SUIT_UNQUALIFIED = new Emoji("♥", "\u2665", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":hearts:"), false, false, 0.6, Qualification.fromString("unqualified"), "heart suit", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, true);

    /**
     * ♦️
     */
    Emoji DIAMOND_SUIT = new Emoji("♦️", "\u2666\uFE0F", Collections.unmodifiableList(Arrays.asList(":diamonds:", ":diamond_suit:")), Collections.singletonList(":diamonds:"), Collections.singletonList(":diamonds:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "diamond suit", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * ♦
     */
    Emoji DIAMOND_SUIT_UNQUALIFIED = new Emoji("♦", "\u2666", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":diamonds:"), false, false, 0.6, Qualification.fromString("unqualified"), "diamond suit", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, true);

    /**
     * ♣️
     */
    Emoji CLUB_SUIT = new Emoji("♣️", "\u2663\uFE0F", Collections.unmodifiableList(Arrays.asList(":clubs:", ":club_suit:")), Collections.singletonList(":clubs:"), Collections.singletonList(":clubs:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "club suit", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * ♣
     */
    Emoji CLUB_SUIT_UNQUALIFIED = new Emoji("♣", "\u2663", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":clubs:"), false, false, 0.6, Qualification.fromString("unqualified"), "club suit", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, true);

    /**
     * ♟️
     */
    Emoji CHESS_PAWN = new Emoji("♟️", "\u265F\uFE0F", Collections.singletonList(":chess_pawn:"), Collections.singletonList(":chess_pawn:"), Collections.singletonList(":chess_pawn:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "chess pawn", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * ♟
     */
    Emoji CHESS_PAWN_UNQUALIFIED = new Emoji("♟", "\u265F", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":chess_pawn:"), false, false, 11.0, Qualification.fromString("unqualified"), "chess pawn", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, true);

    /**
     * 🃏
     */
    Emoji JOKER = new Emoji("🃏", "\uD83C\uDCCF", Collections.unmodifiableList(Arrays.asList(":black_joker:", ":joker:")), Collections.singletonList(":black_joker:"), Collections.singletonList(":black_joker:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "joker", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);

    /**
     * 🀄
     */
    Emoji MAHJONG_RED_DRAGON = new Emoji("🀄", "\uD83C\uDC04", Collections.singletonList(":mahjong:"), Collections.singletonList(":mahjong:"), Collections.singletonList(":mahjong:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "mahjong red dragon", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, true);

    /**
     * 🎴
     */
    Emoji FLOWER_PLAYING_CARDS = new Emoji("🎴", "\uD83C\uDFB4", Collections.singletonList(":flower_playing_cards:"), Collections.singletonList(":flower_playing_cards:"), Collections.singletonList(":flower_playing_cards:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "flower playing cards", EmojiGroup.ACTIVITIES, EmojiSubGroup.GAME, false);
}
