package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiHands {

    /**
     * 👏
     */
    Emoji CLAPPING_HANDS = new Emoji("👏", "\uD83D\uDC4F", Collections.singletonList(":clap:"), Collections.singletonList(":clap:"), Collections.singletonList(":clap:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "clapping hands", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 👏🏻
     */
    Emoji CLAPPING_HANDS_LIGHT_SKIN_TONE = new Emoji("👏🏻", "\uD83D\uDC4F\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":clap_tone1:", ":clap::skin-tone-1:")), Collections.singletonList(":clap::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "clapping hands: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 👏🏼
     */
    Emoji CLAPPING_HANDS_MEDIUM_LIGHT_SKIN_TONE = new Emoji("👏🏼", "\uD83D\uDC4F\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":clap_tone2:", ":clap::skin-tone-2:")), Collections.singletonList(":clap::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "clapping hands: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 👏🏽
     */
    Emoji CLAPPING_HANDS_MEDIUM_SKIN_TONE = new Emoji("👏🏽", "\uD83D\uDC4F\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":clap_tone3:", ":clap::skin-tone-3:")), Collections.singletonList(":clap::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "clapping hands: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 👏🏾
     */
    Emoji CLAPPING_HANDS_MEDIUM_DARK_SKIN_TONE = new Emoji("👏🏾", "\uD83D\uDC4F\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":clap_tone4:", ":clap::skin-tone-4:")), Collections.singletonList(":clap::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "clapping hands: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 👏🏿
     */
    Emoji CLAPPING_HANDS_DARK_SKIN_TONE = new Emoji("👏🏿", "\uD83D\uDC4F\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":clap_tone5:", ":clap::skin-tone-5:")), Collections.singletonList(":clap::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "clapping hands: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🙌
     */
    Emoji RAISING_HANDS = new Emoji("🙌", "\uD83D\uDE4C", Collections.unmodifiableList(Arrays.asList(":raised_hands:", ":raising_hands:")), Collections.singletonList(":raised_hands:"), Collections.singletonList(":raised_hands:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "raising hands", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🙌🏻
     */
    Emoji RAISING_HANDS_LIGHT_SKIN_TONE = new Emoji("🙌🏻", "\uD83D\uDE4C\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":raised_hands_tone1:", ":raised_hands::skin-tone-1:", ":raising_hands::skin-tone-1:")), Collections.singletonList(":raised_hands::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "raising hands: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🙌🏼
     */
    Emoji RAISING_HANDS_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🙌🏼", "\uD83D\uDE4C\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":raised_hands_tone2:", ":raised_hands::skin-tone-2:", ":raising_hands::skin-tone-2:")), Collections.singletonList(":raised_hands::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "raising hands: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🙌🏽
     */
    Emoji RAISING_HANDS_MEDIUM_SKIN_TONE = new Emoji("🙌🏽", "\uD83D\uDE4C\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":raised_hands_tone3:", ":raised_hands::skin-tone-3:", ":raising_hands::skin-tone-3:")), Collections.singletonList(":raised_hands::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "raising hands: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🙌🏾
     */
    Emoji RAISING_HANDS_MEDIUM_DARK_SKIN_TONE = new Emoji("🙌🏾", "\uD83D\uDE4C\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":raised_hands_tone4:", ":raised_hands::skin-tone-4:", ":raising_hands::skin-tone-4:")), Collections.singletonList(":raised_hands::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "raising hands: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🙌🏿
     */
    Emoji RAISING_HANDS_DARK_SKIN_TONE = new Emoji("🙌🏿", "\uD83D\uDE4C\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":raised_hands_tone5:", ":raised_hands::skin-tone-5:", ":raising_hands::skin-tone-5:")), Collections.singletonList(":raised_hands::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "raising hands: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫶
     */
    Emoji HEART_HANDS = new Emoji("🫶", "\uD83E\uDEF6", Collections.singletonList(":heart_hands:"), Collections.emptyList(), Collections.singletonList(":heart_hands:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "heart hands", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫶🏻
     */
    Emoji HEART_HANDS_LIGHT_SKIN_TONE = new Emoji("🫶🏻", "\uD83E\uDEF6\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":heart_hands_tone1:", ":heart_hands_light_skin_tone:", ":heart_hands::skin-tone-1:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "heart hands: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫶🏼
     */
    Emoji HEART_HANDS_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🫶🏼", "\uD83E\uDEF6\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":heart_hands_tone2:", ":heart_hands_medium_light_skin_tone:", ":heart_hands::skin-tone-2:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "heart hands: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫶🏽
     */
    Emoji HEART_HANDS_MEDIUM_SKIN_TONE = new Emoji("🫶🏽", "\uD83E\uDEF6\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":heart_hands_tone3:", ":heart_hands_medium_skin_tone:", ":heart_hands::skin-tone-3:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "heart hands: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫶🏾
     */
    Emoji HEART_HANDS_MEDIUM_DARK_SKIN_TONE = new Emoji("🫶🏾", "\uD83E\uDEF6\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":heart_hands_tone4:", ":heart_hands_medium_dark_skin_tone:", ":heart_hands::skin-tone-4:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "heart hands: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫶🏿
     */
    Emoji HEART_HANDS_DARK_SKIN_TONE = new Emoji("🫶🏿", "\uD83E\uDEF6\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":heart_hands_tone5:", ":heart_hands_dark_skin_tone:", ":heart_hands::skin-tone-5:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "heart hands: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 👐
     */
    Emoji OPEN_HANDS = new Emoji("👐", "\uD83D\uDC50", Collections.singletonList(":open_hands:"), Collections.singletonList(":open_hands:"), Collections.singletonList(":open_hands:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "open hands", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 👐🏻
     */
    Emoji OPEN_HANDS_LIGHT_SKIN_TONE = new Emoji("👐🏻", "\uD83D\uDC50\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":open_hands_tone1:", ":open_hands::skin-tone-1:")), Collections.singletonList(":open_hands::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "open hands: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 👐🏼
     */
    Emoji OPEN_HANDS_MEDIUM_LIGHT_SKIN_TONE = new Emoji("👐🏼", "\uD83D\uDC50\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":open_hands_tone2:", ":open_hands::skin-tone-2:")), Collections.singletonList(":open_hands::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "open hands: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 👐🏽
     */
    Emoji OPEN_HANDS_MEDIUM_SKIN_TONE = new Emoji("👐🏽", "\uD83D\uDC50\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":open_hands_tone3:", ":open_hands::skin-tone-3:")), Collections.singletonList(":open_hands::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "open hands: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 👐🏾
     */
    Emoji OPEN_HANDS_MEDIUM_DARK_SKIN_TONE = new Emoji("👐🏾", "\uD83D\uDC50\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":open_hands_tone4:", ":open_hands::skin-tone-4:")), Collections.singletonList(":open_hands::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "open hands: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 👐🏿
     */
    Emoji OPEN_HANDS_DARK_SKIN_TONE = new Emoji("👐🏿", "\uD83D\uDC50\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":open_hands_tone5:", ":open_hands::skin-tone-5:")), Collections.singletonList(":open_hands::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "open hands: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🤲
     */
    Emoji PALMS_UP_TOGETHER = new Emoji("🤲", "\uD83E\uDD32", Collections.singletonList(":palms_up_together:"), Collections.singletonList(":palms_up_together:"), Collections.singletonList(":palms_up_together:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "palms up together", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🤲🏻
     */
    Emoji PALMS_UP_TOGETHER_LIGHT_SKIN_TONE = new Emoji("🤲🏻", "\uD83E\uDD32\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":palms_up_together_tone1:", ":palms_up_together_light_skin_tone:", ":palms_up_together::skin-tone-1:")), Collections.singletonList(":palms_up_together::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "palms up together: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🤲🏼
     */
    Emoji PALMS_UP_TOGETHER_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🤲🏼", "\uD83E\uDD32\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":palms_up_together_tone2:", ":palms_up_together_medium_light_skin_tone:", ":palms_up_together::skin-tone-2:")), Collections.singletonList(":palms_up_together::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "palms up together: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🤲🏽
     */
    Emoji PALMS_UP_TOGETHER_MEDIUM_SKIN_TONE = new Emoji("🤲🏽", "\uD83E\uDD32\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":palms_up_together_tone3:", ":palms_up_together_medium_skin_tone:", ":palms_up_together::skin-tone-3:")), Collections.singletonList(":palms_up_together::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "palms up together: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🤲🏾
     */
    Emoji PALMS_UP_TOGETHER_MEDIUM_DARK_SKIN_TONE = new Emoji("🤲🏾", "\uD83E\uDD32\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":palms_up_together_tone4:", ":palms_up_together_medium_dark_skin_tone:", ":palms_up_together::skin-tone-4:")), Collections.singletonList(":palms_up_together::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "palms up together: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🤲🏿
     */
    Emoji PALMS_UP_TOGETHER_DARK_SKIN_TONE = new Emoji("🤲🏿", "\uD83E\uDD32\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":palms_up_together_tone5:", ":palms_up_together_dark_skin_tone:", ":palms_up_together::skin-tone-5:")), Collections.singletonList(":palms_up_together::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "palms up together: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🤝
     */
    Emoji HANDSHAKE = new Emoji("🤝", "\uD83E\uDD1D", Collections.unmodifiableList(Arrays.asList(":handshake:", ":shaking_hands:")), Collections.singletonList(":handshake:"), Collections.singletonList(":handshake:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "handshake", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🤝🏻
     */
    Emoji HANDSHAKE_LIGHT_SKIN_TONE = new Emoji("🤝🏻", "\uD83E\uDD1D\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":handshake_tone1:", ":handshake_light_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🤝🏼
     */
    Emoji HANDSHAKE_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🤝🏼", "\uD83E\uDD1D\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":handshake_tone2:", ":handshake_medium_light_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🤝🏽
     */
    Emoji HANDSHAKE_MEDIUM_SKIN_TONE = new Emoji("🤝🏽", "\uD83E\uDD1D\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":handshake_tone3:", ":handshake_medium_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🤝🏾
     */
    Emoji HANDSHAKE_MEDIUM_DARK_SKIN_TONE = new Emoji("🤝🏾", "\uD83E\uDD1D\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":handshake_tone4:", ":handshake_medium_dark_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🤝🏿
     */
    Emoji HANDSHAKE_DARK_SKIN_TONE = new Emoji("🤝🏿", "\uD83E\uDD1D\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":handshake_tone5:", ":handshake_dark_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫱🏻‍🫲🏼
     */
    Emoji HANDSHAKE_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🫱🏻‍🫲🏼", "\uD83E\uDEF1\uD83C\uDFFB\u200D\uD83E\uDEF2\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":handshake_tone1_tone2:", ":handshake_light_skin_tone_medium_light_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: light skin tone, medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫱🏻‍🫲🏽
     */
    Emoji HANDSHAKE_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE = new Emoji("🫱🏻‍🫲🏽", "\uD83E\uDEF1\uD83C\uDFFB\u200D\uD83E\uDEF2\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":handshake_tone1_tone3:", ":handshake_light_skin_tone_medium_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: light skin tone, medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫱🏻‍🫲🏾
     */
    Emoji HANDSHAKE_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE = new Emoji("🫱🏻‍🫲🏾", "\uD83E\uDEF1\uD83C\uDFFB\u200D\uD83E\uDEF2\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":handshake_tone1_tone4:", ":handshake_light_skin_tone_medium_dark_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: light skin tone, medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫱🏻‍🫲🏿
     */
    Emoji HANDSHAKE_LIGHT_SKIN_TONE_DARK_SKIN_TONE = new Emoji("🫱🏻‍🫲🏿", "\uD83E\uDEF1\uD83C\uDFFB\u200D\uD83E\uDEF2\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":handshake_tone1_tone5:", ":handshake_light_skin_tone_dark_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: light skin tone, dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫱🏼‍🫲🏻
     */
    Emoji HANDSHAKE_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE = new Emoji("🫱🏼‍🫲🏻", "\uD83E\uDEF1\uD83C\uDFFC\u200D\uD83E\uDEF2\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":handshake_tone2_tone1:", ":handshake_medium_light_skin_tone_light_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: medium-light skin tone, light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫱🏼‍🫲🏽
     */
    Emoji HANDSHAKE_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE = new Emoji("🫱🏼‍🫲🏽", "\uD83E\uDEF1\uD83C\uDFFC\u200D\uD83E\uDEF2\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":handshake_tone2_tone3:", ":handshake_medium_light_skin_tone_medium_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: medium-light skin tone, medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫱🏼‍🫲🏾
     */
    Emoji HANDSHAKE_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE = new Emoji("🫱🏼‍🫲🏾", "\uD83E\uDEF1\uD83C\uDFFC\u200D\uD83E\uDEF2\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":handshake_tone2_tone4:", ":handshake_medium_light_skin_tone_medium_dark_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: medium-light skin tone, medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫱🏼‍🫲🏿
     */
    Emoji HANDSHAKE_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE = new Emoji("🫱🏼‍🫲🏿", "\uD83E\uDEF1\uD83C\uDFFC\u200D\uD83E\uDEF2\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":handshake_tone2_tone5:", ":handshake_medium_light_skin_tone_dark_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: medium-light skin tone, dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫱🏽‍🫲🏻
     */
    Emoji HANDSHAKE_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE = new Emoji("🫱🏽‍🫲🏻", "\uD83E\uDEF1\uD83C\uDFFD\u200D\uD83E\uDEF2\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":handshake_tone3_tone1:", ":handshake_medium_skin_tone_light_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: medium skin tone, light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫱🏽‍🫲🏼
     */
    Emoji HANDSHAKE_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🫱🏽‍🫲🏼", "\uD83E\uDEF1\uD83C\uDFFD\u200D\uD83E\uDEF2\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":handshake_tone3_tone2:", ":handshake_medium_skin_tone_medium_light_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: medium skin tone, medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫱🏽‍🫲🏾
     */
    Emoji HANDSHAKE_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE = new Emoji("🫱🏽‍🫲🏾", "\uD83E\uDEF1\uD83C\uDFFD\u200D\uD83E\uDEF2\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":handshake_tone3_tone4:", ":handshake_medium_skin_tone_medium_dark_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: medium skin tone, medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫱🏽‍🫲🏿
     */
    Emoji HANDSHAKE_MEDIUM_SKIN_TONE_DARK_SKIN_TONE = new Emoji("🫱🏽‍🫲🏿", "\uD83E\uDEF1\uD83C\uDFFD\u200D\uD83E\uDEF2\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":handshake_tone3_tone5:", ":handshake_medium_skin_tone_dark_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: medium skin tone, dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫱🏾‍🫲🏻
     */
    Emoji HANDSHAKE_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE = new Emoji("🫱🏾‍🫲🏻", "\uD83E\uDEF1\uD83C\uDFFE\u200D\uD83E\uDEF2\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":handshake_tone4_tone1:", ":handshake_medium_dark_skin_tone_light_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: medium-dark skin tone, light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫱🏾‍🫲🏼
     */
    Emoji HANDSHAKE_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🫱🏾‍🫲🏼", "\uD83E\uDEF1\uD83C\uDFFE\u200D\uD83E\uDEF2\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":handshake_tone4_tone2:", ":handshake_medium_dark_skin_tone_medium_light_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: medium-dark skin tone, medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫱🏾‍🫲🏽
     */
    Emoji HANDSHAKE_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE = new Emoji("🫱🏾‍🫲🏽", "\uD83E\uDEF1\uD83C\uDFFE\u200D\uD83E\uDEF2\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":handshake_tone4_tone3:", ":handshake_medium_dark_skin_tone_medium_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: medium-dark skin tone, medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫱🏾‍🫲🏿
     */
    Emoji HANDSHAKE_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE = new Emoji("🫱🏾‍🫲🏿", "\uD83E\uDEF1\uD83C\uDFFE\u200D\uD83E\uDEF2\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":handshake_tone4_tone5:", ":handshake_medium_dark_skin_tone_dark_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: medium-dark skin tone, dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫱🏿‍🫲🏻
     */
    Emoji HANDSHAKE_DARK_SKIN_TONE_LIGHT_SKIN_TONE = new Emoji("🫱🏿‍🫲🏻", "\uD83E\uDEF1\uD83C\uDFFF\u200D\uD83E\uDEF2\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":handshake_tone5_tone1:", ":handshake_dark_skin_tone_light_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: dark skin tone, light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫱🏿‍🫲🏼
     */
    Emoji HANDSHAKE_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🫱🏿‍🫲🏼", "\uD83E\uDEF1\uD83C\uDFFF\u200D\uD83E\uDEF2\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":handshake_tone5_tone2:", ":handshake_dark_skin_tone_medium_light_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: dark skin tone, medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫱🏿‍🫲🏽
     */
    Emoji HANDSHAKE_DARK_SKIN_TONE_MEDIUM_SKIN_TONE = new Emoji("🫱🏿‍🫲🏽", "\uD83E\uDEF1\uD83C\uDFFF\u200D\uD83E\uDEF2\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":handshake_tone5_tone3:", ":handshake_dark_skin_tone_medium_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: dark skin tone, medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🫱🏿‍🫲🏾
     */
    Emoji HANDSHAKE_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE = new Emoji("🫱🏿‍🫲🏾", "\uD83E\uDEF1\uD83C\uDFFF\u200D\uD83E\uDEF2\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":handshake_tone5_tone4:", ":handshake_dark_skin_tone_medium_dark_skin_tone:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "handshake: dark skin tone, medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🙏
     */
    Emoji FOLDED_HANDS = new Emoji("🙏", "\uD83D\uDE4F", Collections.unmodifiableList(Arrays.asList(":pray:", ":folded_hands:")), Collections.singletonList(":pray:"), Collections.singletonList(":pray:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "folded hands", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🙏🏻
     */
    Emoji FOLDED_HANDS_LIGHT_SKIN_TONE = new Emoji("🙏🏻", "\uD83D\uDE4F\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":pray_tone1:", ":pray::skin-tone-1:", ":folded_hands::skin-tone-1:")), Collections.singletonList(":pray::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "folded hands: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🙏🏼
     */
    Emoji FOLDED_HANDS_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🙏🏼", "\uD83D\uDE4F\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":pray_tone2:", ":pray::skin-tone-2:", ":folded_hands::skin-tone-2:")), Collections.singletonList(":pray::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "folded hands: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🙏🏽
     */
    Emoji FOLDED_HANDS_MEDIUM_SKIN_TONE = new Emoji("🙏🏽", "\uD83D\uDE4F\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":pray_tone3:", ":pray::skin-tone-3:", ":folded_hands::skin-tone-3:")), Collections.singletonList(":pray::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "folded hands: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🙏🏾
     */
    Emoji FOLDED_HANDS_MEDIUM_DARK_SKIN_TONE = new Emoji("🙏🏾", "\uD83D\uDE4F\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":pray_tone4:", ":pray::skin-tone-4:", ":folded_hands::skin-tone-4:")), Collections.singletonList(":pray::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "folded hands: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);

    /**
     * 🙏🏿
     */
    Emoji FOLDED_HANDS_DARK_SKIN_TONE = new Emoji("🙏🏿", "\uD83D\uDE4F\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":pray_tone5:", ":pray::skin-tone-5:", ":folded_hands::skin-tone-5:")), Collections.singletonList(":pray::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "folded hands: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HANDS, false);
}
