package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiHousehold {

    /**
     * 🚪
     */
    Emoji DOOR = new Emoji("🚪", "\uD83D\uDEAA", Collections.singletonList(":door:"), Collections.singletonList(":door:"), Collections.singletonList(":door:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "door", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🛗
     */
    Emoji ELEVATOR = new Emoji("🛗", "\uD83D\uDED7", Collections.singletonList(":elevator:"), Collections.singletonList(":elevator:"), Collections.singletonList(":elevator:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "elevator", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🪞
     */
    Emoji MIRROR = new Emoji("🪞", "\uD83E\uDE9E", Collections.singletonList(":mirror:"), Collections.singletonList(":mirror:"), Collections.singletonList(":mirror:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "mirror", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🪟
     */
    Emoji WINDOW = new Emoji("🪟", "\uD83E\uDE9F", Collections.singletonList(":window:"), Collections.singletonList(":window:"), Collections.singletonList(":window:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "window", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🛏️
     */
    Emoji BED = new Emoji("🛏️", "\uD83D\uDECF\uFE0F", Collections.singletonList(":bed:"), Collections.singletonList(":bed:"), Collections.singletonList(":bed:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "bed", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🛏
     */
    Emoji BED_UNQUALIFIED = new Emoji("🛏", "\uD83D\uDECF", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":bed:"), false, false, 0.7, Qualification.fromString("unqualified"), "bed", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, true);

    /**
     * 🛋️
     */
    Emoji COUCH_AND_LAMP = new Emoji("🛋️", "\uD83D\uDECB\uFE0F", Collections.unmodifiableList(Arrays.asList(":couch:", ":couch_and_lamp:")), Collections.singletonList(":couch_and_lamp:"), Collections.singletonList(":couch_and_lamp:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "couch and lamp", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🛋
     */
    Emoji COUCH_AND_LAMP_UNQUALIFIED = new Emoji("🛋", "\uD83D\uDECB", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":couch_and_lamp:"), false, false, 0.7, Qualification.fromString("unqualified"), "couch and lamp", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, true);

    /**
     * 🪑
     */
    Emoji CHAIR = new Emoji("🪑", "\uD83E\uDE91", Collections.singletonList(":chair:"), Collections.singletonList(":chair:"), Collections.singletonList(":chair:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "chair", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🚽
     */
    Emoji TOILET = new Emoji("🚽", "\uD83D\uDEBD", Collections.singletonList(":toilet:"), Collections.singletonList(":toilet:"), Collections.singletonList(":toilet:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "toilet", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🪠
     */
    Emoji PLUNGER = new Emoji("🪠", "\uD83E\uDEA0", Collections.singletonList(":plunger:"), Collections.singletonList(":plunger:"), Collections.singletonList(":plunger:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "plunger", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🚿
     */
    Emoji SHOWER = new Emoji("🚿", "\uD83D\uDEBF", Collections.singletonList(":shower:"), Collections.singletonList(":shower:"), Collections.singletonList(":shower:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "shower", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🛁
     */
    Emoji BATHTUB = new Emoji("🛁", "\uD83D\uDEC1", Collections.singletonList(":bathtub:"), Collections.singletonList(":bathtub:"), Collections.singletonList(":bathtub:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "bathtub", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🪤
     */
    Emoji MOUSE_TRAP = new Emoji("🪤", "\uD83E\uDEA4", Collections.singletonList(":mouse_trap:"), Collections.singletonList(":mouse_trap:"), Collections.singletonList(":mouse_trap:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "mouse trap", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🪒
     */
    Emoji RAZOR = new Emoji("🪒", "\uD83E\uDE92", Collections.singletonList(":razor:"), Collections.singletonList(":razor:"), Collections.singletonList(":razor:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "razor", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🧴
     */
    Emoji LOTION_BOTTLE = new Emoji("🧴", "\uD83E\uDDF4", Collections.unmodifiableList(Arrays.asList(":squeeze_bottle:", ":lotion_bottle:")), Collections.singletonList(":lotion_bottle:"), Collections.singletonList(":lotion_bottle:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "lotion bottle", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🧷
     */
    Emoji SAFETY_PIN = new Emoji("🧷", "\uD83E\uDDF7", Collections.singletonList(":safety_pin:"), Collections.singletonList(":safety_pin:"), Collections.singletonList(":safety_pin:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "safety pin", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🧹
     */
    Emoji BROOM = new Emoji("🧹", "\uD83E\uDDF9", Collections.singletonList(":broom:"), Collections.singletonList(":broom:"), Collections.singletonList(":broom:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "broom", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🧺
     */
    Emoji BASKET = new Emoji("🧺", "\uD83E\uDDFA", Collections.singletonList(":basket:"), Collections.singletonList(":basket:"), Collections.singletonList(":basket:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "basket", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🧻
     */
    Emoji ROLL_OF_PAPER = new Emoji("🧻", "\uD83E\uDDFB", Collections.singletonList(":roll_of_paper:"), Collections.singletonList(":roll_of_paper:"), Collections.singletonList(":roll_of_paper:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "roll of paper", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🪣
     */
    Emoji BUCKET = new Emoji("🪣", "\uD83E\uDEA3", Collections.singletonList(":bucket:"), Collections.singletonList(":bucket:"), Collections.singletonList(":bucket:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "bucket", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🧼
     */
    Emoji SOAP = new Emoji("🧼", "\uD83E\uDDFC", Collections.singletonList(":soap:"), Collections.singletonList(":soap:"), Collections.singletonList(":soap:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "soap", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🫧
     */
    Emoji BUBBLES = new Emoji("🫧", "\uD83E\uDEE7", Collections.singletonList(":bubbles:"), Collections.emptyList(), Collections.singletonList(":bubbles:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "bubbles", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🪥
     */
    Emoji TOOTHBRUSH = new Emoji("🪥", "\uD83E\uDEA5", Collections.singletonList(":toothbrush:"), Collections.singletonList(":toothbrush:"), Collections.singletonList(":toothbrush:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "toothbrush", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🧽
     */
    Emoji SPONGE = new Emoji("🧽", "\uD83E\uDDFD", Collections.singletonList(":sponge:"), Collections.singletonList(":sponge:"), Collections.singletonList(":sponge:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "sponge", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🧯
     */
    Emoji FIRE_EXTINGUISHER = new Emoji("🧯", "\uD83E\uDDEF", Collections.singletonList(":fire_extinguisher:"), Collections.singletonList(":fire_extinguisher:"), Collections.singletonList(":fire_extinguisher:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "fire extinguisher", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);

    /**
     * 🛒
     */
    Emoji SHOPPING_CART = new Emoji("🛒", "\uD83D\uDED2", Collections.unmodifiableList(Arrays.asList(":shopping_cart:", ":shopping_trolley:")), Collections.singletonList(":shopping_trolley:"), Collections.singletonList(":shopping_cart:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "shopping cart", EmojiGroup.OBJECTS, EmojiSubGroup.HOUSEHOLD, false);
}
