package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiKeycap {

    /**
     * #️⃣
     */
    Emoji KEYCAP_HASH = new Emoji("#️⃣", "\u0023\uFE0F\u20E3", Collections.singletonList(":hash:"), Collections.singletonList(":hash:"), Collections.singletonList(":hash:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "keycap: #", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * #⃣
     */
    Emoji KEYCAP_HASH_UNQUALIFIED = new Emoji("#⃣", "\u0023\u20E3", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":hash:"), false, false, 0.6, Qualification.fromString("unqualified"), "keycap: #", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * ️⃣
     */
    Emoji KEYCAP_STAR = new Emoji("*️⃣", "\u002A\uFE0F\u20E3", Collections.unmodifiableList(Arrays.asList(":asterisk:", ":keycap_asterisk:")), Collections.singletonList(":keycap_star:"), Collections.singletonList(":asterisk:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "keycap: *", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * ⃣
     */
    Emoji KEYCAP_STAR_UNQUALIFIED = new Emoji("*⃣", "\u002A\u20E3", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":asterisk:"), false, false, 2.0, Qualification.fromString("unqualified"), "keycap: *", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 0️⃣
     */
    Emoji KEYCAP_0 = new Emoji("0️⃣", "\u0030\uFE0F\u20E3", Collections.singletonList(":zero:"), Collections.singletonList(":zero:"), Collections.singletonList(":zero:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "keycap: 0", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 0⃣
     */
    Emoji KEYCAP_0_UNQUALIFIED = new Emoji("0⃣", "\u0030\u20E3", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":zero:"), false, false, 0.6, Qualification.fromString("unqualified"), "keycap: 0", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 1️⃣
     */
    Emoji KEYCAP_1 = new Emoji("1️⃣", "\u0031\uFE0F\u20E3", Collections.singletonList(":one:"), Collections.singletonList(":one:"), Collections.singletonList(":one:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "keycap: 1", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 1⃣
     */
    Emoji KEYCAP_1_UNQUALIFIED = new Emoji("1⃣", "\u0031\u20E3", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":one:"), false, false, 0.6, Qualification.fromString("unqualified"), "keycap: 1", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 2️⃣
     */
    Emoji KEYCAP_2 = new Emoji("2️⃣", "\u0032\uFE0F\u20E3", Collections.singletonList(":two:"), Collections.singletonList(":two:"), Collections.singletonList(":two:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "keycap: 2", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 2⃣
     */
    Emoji KEYCAP_2_UNQUALIFIED = new Emoji("2⃣", "\u0032\u20E3", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":two:"), false, false, 0.6, Qualification.fromString("unqualified"), "keycap: 2", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 3️⃣
     */
    Emoji KEYCAP_3 = new Emoji("3️⃣", "\u0033\uFE0F\u20E3", Collections.singletonList(":three:"), Collections.singletonList(":three:"), Collections.singletonList(":three:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "keycap: 3", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 3⃣
     */
    Emoji KEYCAP_3_UNQUALIFIED = new Emoji("3⃣", "\u0033\u20E3", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":three:"), false, false, 0.6, Qualification.fromString("unqualified"), "keycap: 3", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 4️⃣
     */
    Emoji KEYCAP_4 = new Emoji("4️⃣", "\u0034\uFE0F\u20E3", Collections.singletonList(":four:"), Collections.singletonList(":four:"), Collections.singletonList(":four:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "keycap: 4", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 4⃣
     */
    Emoji KEYCAP_4_UNQUALIFIED = new Emoji("4⃣", "\u0034\u20E3", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":four:"), false, false, 0.6, Qualification.fromString("unqualified"), "keycap: 4", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 5️⃣
     */
    Emoji KEYCAP_5 = new Emoji("5️⃣", "\u0035\uFE0F\u20E3", Collections.singletonList(":five:"), Collections.singletonList(":five:"), Collections.singletonList(":five:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "keycap: 5", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 5⃣
     */
    Emoji KEYCAP_5_UNQUALIFIED = new Emoji("5⃣", "\u0035\u20E3", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":five:"), false, false, 0.6, Qualification.fromString("unqualified"), "keycap: 5", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 6️⃣
     */
    Emoji KEYCAP_6 = new Emoji("6️⃣", "\u0036\uFE0F\u20E3", Collections.singletonList(":six:"), Collections.singletonList(":six:"), Collections.singletonList(":six:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "keycap: 6", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 6⃣
     */
    Emoji KEYCAP_6_UNQUALIFIED = new Emoji("6⃣", "\u0036\u20E3", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":six:"), false, false, 0.6, Qualification.fromString("unqualified"), "keycap: 6", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 7️⃣
     */
    Emoji KEYCAP_7 = new Emoji("7️⃣", "\u0037\uFE0F\u20E3", Collections.singletonList(":seven:"), Collections.singletonList(":seven:"), Collections.singletonList(":seven:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "keycap: 7", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 7⃣
     */
    Emoji KEYCAP_7_UNQUALIFIED = new Emoji("7⃣", "\u0037\u20E3", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":seven:"), false, false, 0.6, Qualification.fromString("unqualified"), "keycap: 7", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 8️⃣
     */
    Emoji KEYCAP_8 = new Emoji("8️⃣", "\u0038\uFE0F\u20E3", Collections.singletonList(":eight:"), Collections.singletonList(":eight:"), Collections.singletonList(":eight:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "keycap: 8", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 8⃣
     */
    Emoji KEYCAP_8_UNQUALIFIED = new Emoji("8⃣", "\u0038\u20E3", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":eight:"), false, false, 0.6, Qualification.fromString("unqualified"), "keycap: 8", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 9️⃣
     */
    Emoji KEYCAP_9 = new Emoji("9️⃣", "\u0039\uFE0F\u20E3", Collections.singletonList(":nine:"), Collections.singletonList(":nine:"), Collections.singletonList(":nine:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "keycap: 9", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 9⃣
     */
    Emoji KEYCAP_9_UNQUALIFIED = new Emoji("9⃣", "\u0039\u20E3", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":nine:"), false, false, 0.6, Qualification.fromString("unqualified"), "keycap: 9", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);

    /**
     * 🔟
     */
    Emoji KEYCAP_10 = new Emoji("🔟", "\uD83D\uDD1F", Collections.singletonList(":keycap_ten:"), Collections.singletonList(":keycap_ten:"), Collections.singletonList(":keycap_ten:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "keycap: 10", EmojiGroup.SYMBOLS, EmojiSubGroup.KEYCAP, false);
}
