package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiLightAndVideo {

    /**
     * 🎥
     */
    Emoji MOVIE_CAMERA = new Emoji("🎥", "\uD83C\uDFA5", Collections.singletonList(":movie_camera:"), Collections.singletonList(":movie_camera:"), Collections.singletonList(":movie_camera:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "movie camera", EmojiGroup.OBJECTS, EmojiSubGroup.LIGHT_AND_VIDEO, false);

    /**
     * 🎞️
     */
    Emoji FILM_FRAMES = new Emoji("🎞️", "\uD83C\uDF9E\uFE0F", Collections.singletonList(":film_frames:"), Collections.singletonList(":film_frames:"), Collections.singletonList(":film_strip:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "film frames", EmojiGroup.OBJECTS, EmojiSubGroup.LIGHT_AND_VIDEO, false);

    /**
     * 🎞
     */
    Emoji FILM_FRAMES_UNQUALIFIED = new Emoji("🎞", "\uD83C\uDF9E", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":film_strip:"), false, false, 0.7, Qualification.fromString("unqualified"), "film frames", EmojiGroup.OBJECTS, EmojiSubGroup.LIGHT_AND_VIDEO, true);

    /**
     * 📽️
     */
    Emoji FILM_PROJECTOR = new Emoji("📽️", "\uD83D\uDCFD\uFE0F", Collections.unmodifiableList(Arrays.asList(":projector:", ":film_projector:")), Collections.singletonList(":film_projector:"), Collections.singletonList(":film_projector:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "film projector", EmojiGroup.OBJECTS, EmojiSubGroup.LIGHT_AND_VIDEO, false);

    /**
     * 📽
     */
    Emoji FILM_PROJECTOR_UNQUALIFIED = new Emoji("📽", "\uD83D\uDCFD", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":film_projector:"), false, false, 0.7, Qualification.fromString("unqualified"), "film projector", EmojiGroup.OBJECTS, EmojiSubGroup.LIGHT_AND_VIDEO, true);

    /**
     * 🎬
     */
    Emoji CLAPPER_BOARD = new Emoji("🎬", "\uD83C\uDFAC", Collections.unmodifiableList(Arrays.asList(":clapper:", ":clapper_board:")), Collections.singletonList(":clapper:"), Collections.singletonList(":clapper:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "clapper board", EmojiGroup.OBJECTS, EmojiSubGroup.LIGHT_AND_VIDEO, true);

    /**
     * 📺
     */
    Emoji TELEVISION = new Emoji("📺", "\uD83D\uDCFA", Collections.unmodifiableList(Arrays.asList(":tv:", ":television:")), Collections.singletonList(":tv:"), Collections.singletonList(":tv:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "television", EmojiGroup.OBJECTS, EmojiSubGroup.LIGHT_AND_VIDEO, true);

    /**
     * 📷
     */
    Emoji CAMERA = new Emoji("📷", "\uD83D\uDCF7", Collections.singletonList(":camera:"), Collections.singletonList(":camera:"), Collections.singletonList(":camera:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "camera", EmojiGroup.OBJECTS, EmojiSubGroup.LIGHT_AND_VIDEO, true);

    /**
     * 📸
     */
    Emoji CAMERA_WITH_FLASH = new Emoji("📸", "\uD83D\uDCF8", Collections.singletonList(":camera_with_flash:"), Collections.singletonList(":camera_with_flash:"), Collections.singletonList(":camera_flash:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "camera with flash", EmojiGroup.OBJECTS, EmojiSubGroup.LIGHT_AND_VIDEO, false);

    /**
     * 📹
     */
    Emoji VIDEO_CAMERA = new Emoji("📹", "\uD83D\uDCF9", Collections.singletonList(":video_camera:"), Collections.singletonList(":video_camera:"), Collections.singletonList(":video_camera:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "video camera", EmojiGroup.OBJECTS, EmojiSubGroup.LIGHT_AND_VIDEO, true);

    /**
     * 📼
     */
    Emoji VIDEOCASSETTE = new Emoji("📼", "\uD83D\uDCFC", Collections.unmodifiableList(Arrays.asList(":vhs:", ":videocassette:")), Collections.singletonList(":vhs:"), Collections.singletonList(":vhs:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "videocassette", EmojiGroup.OBJECTS, EmojiSubGroup.LIGHT_AND_VIDEO, false);

    /**
     * 🔍
     */
    Emoji MAGNIFYING_GLASS_TILTED_LEFT = new Emoji("🔍", "\uD83D\uDD0D", Collections.singletonList(":mag:"), Collections.singletonList(":mag:"), Collections.singletonList(":mag:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "magnifying glass tilted left", EmojiGroup.OBJECTS, EmojiSubGroup.LIGHT_AND_VIDEO, true);

    /**
     * 🔎
     */
    Emoji MAGNIFYING_GLASS_TILTED_RIGHT = new Emoji("🔎", "\uD83D\uDD0E", Collections.singletonList(":mag_right:"), Collections.singletonList(":mag_right:"), Collections.singletonList(":mag_right:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "magnifying glass tilted right", EmojiGroup.OBJECTS, EmojiSubGroup.LIGHT_AND_VIDEO, false);

    /**
     * 🕯️
     */
    Emoji CANDLE = new Emoji("🕯️", "\uD83D\uDD6F\uFE0F", Collections.singletonList(":candle:"), Collections.singletonList(":candle:"), Collections.singletonList(":candle:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "candle", EmojiGroup.OBJECTS, EmojiSubGroup.LIGHT_AND_VIDEO, false);

    /**
     * 🕯
     */
    Emoji CANDLE_UNQUALIFIED = new Emoji("🕯", "\uD83D\uDD6F", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":candle:"), false, false, 0.7, Qualification.fromString("unqualified"), "candle", EmojiGroup.OBJECTS, EmojiSubGroup.LIGHT_AND_VIDEO, true);

    /**
     * 💡
     */
    Emoji LIGHT_BULB = new Emoji("💡", "\uD83D\uDCA1", Collections.unmodifiableList(Arrays.asList(":bulb:", ":light_bulb:")), Collections.singletonList(":bulb:"), Collections.singletonList(":bulb:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "light bulb", EmojiGroup.OBJECTS, EmojiSubGroup.LIGHT_AND_VIDEO, false);

    /**
     * 🔦
     */
    Emoji FLASHLIGHT = new Emoji("🔦", "\uD83D\uDD26", Collections.singletonList(":flashlight:"), Collections.singletonList(":flashlight:"), Collections.singletonList(":flashlight:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "flashlight", EmojiGroup.OBJECTS, EmojiSubGroup.LIGHT_AND_VIDEO, false);

    /**
     * 🏮
     */
    Emoji RED_PAPER_LANTERN = new Emoji("🏮", "\uD83C\uDFEE", Collections.singletonList(":izakaya_lantern:"), Collections.singletonList(":izakaya_lantern:"), Collections.unmodifiableList(Arrays.asList(":izakaya_lantern:", ":lantern:")), false, false, 0.6, Qualification.fromString("fully-qualified"), "red paper lantern", EmojiGroup.OBJECTS, EmojiSubGroup.LIGHT_AND_VIDEO, false);

    /**
     * 🪔
     */
    Emoji DIYA_LAMP = new Emoji("🪔", "\uD83E\uDE94", Collections.singletonList(":diya_lamp:"), Collections.singletonList(":diya_lamp:"), Collections.singletonList(":diya_lamp:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "diya lamp", EmojiGroup.OBJECTS, EmojiSubGroup.LIGHT_AND_VIDEO, false);
}
