package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiLock {

    /**
     * 🔒
     */
    Emoji LOCKED = new Emoji("🔒", "\uD83D\uDD12", Collections.unmodifiableList(Arrays.asList(":lock:", ":locked:")), Collections.singletonList(":lock:"), Collections.singletonList(":lock:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "locked", EmojiGroup.OBJECTS, EmojiSubGroup.LOCK, true);

    /**
     * 🔓
     */
    Emoji UNLOCKED = new Emoji("🔓", "\uD83D\uDD13", Collections.unmodifiableList(Arrays.asList(":unlock:", ":unlocked:")), Collections.singletonList(":unlock:"), Collections.singletonList(":unlock:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "unlocked", EmojiGroup.OBJECTS, EmojiSubGroup.LOCK, true);

    /**
     * 🔏
     */
    Emoji LOCKED_WITH_PEN = new Emoji("🔏", "\uD83D\uDD0F", Collections.singletonList(":lock_with_ink_pen:"), Collections.singletonList(":lock_with_ink_pen:"), Collections.singletonList(":lock_with_ink_pen:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "locked with pen", EmojiGroup.OBJECTS, EmojiSubGroup.LOCK, false);

    /**
     * 🔐
     */
    Emoji LOCKED_WITH_KEY = new Emoji("🔐", "\uD83D\uDD10", Collections.singletonList(":closed_lock_with_key:"), Collections.singletonList(":closed_lock_with_key:"), Collections.singletonList(":closed_lock_with_key:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "locked with key", EmojiGroup.OBJECTS, EmojiSubGroup.LOCK, false);

    /**
     * 🔑
     */
    Emoji KEY = new Emoji("🔑", "\uD83D\uDD11", Collections.singletonList(":key:"), Collections.singletonList(":key:"), Collections.singletonList(":key:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "key", EmojiGroup.OBJECTS, EmojiSubGroup.LOCK, false);

    /**
     * 🗝️
     */
    Emoji OLD_KEY = new Emoji("🗝️", "\uD83D\uDDDD\uFE0F", Collections.unmodifiableList(Arrays.asList(":key2:", ":old_key:")), Collections.singletonList(":old_key:"), Collections.singletonList(":old_key:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "old key", EmojiGroup.OBJECTS, EmojiSubGroup.LOCK, false);

    /**
     * 🗝
     */
    Emoji OLD_KEY_UNQUALIFIED = new Emoji("🗝", "\uD83D\uDDDD", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":old_key:"), false, false, 0.7, Qualification.fromString("unqualified"), "old key", EmojiGroup.OBJECTS, EmojiSubGroup.LOCK, true);
}
