package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiMail {

    /**
     * ✉️
     */
    Emoji ENVELOPE = new Emoji("✉️", "\u2709\uFE0F", Collections.singletonList(":envelope:"), Collections.singletonList(":email:"), Collections.singletonList(":envelope:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "envelope", EmojiGroup.OBJECTS, EmojiSubGroup.MAIL, false);

    /**
     * ✉
     */
    Emoji ENVELOPE_UNQUALIFIED = new Emoji("✉", "\u2709", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":envelope:"), false, false, 0.6, Qualification.fromString("unqualified"), "envelope", EmojiGroup.OBJECTS, EmojiSubGroup.MAIL, true);

    /**
     * 📧
     */
    Emoji E_MAIL = new Emoji("📧", "\uD83D\uDCE7", Collections.unmodifiableList(Arrays.asList(":e_mail:", ":email:")), Collections.singletonList(":e-mail:"), Collections.unmodifiableList(Arrays.asList(":e-mail:", ":email:")), false, false, 0.6, Qualification.fromString("fully-qualified"), "e-mail", EmojiGroup.OBJECTS, EmojiSubGroup.MAIL, false);

    /**
     * 📨
     */
    Emoji INCOMING_ENVELOPE = new Emoji("📨", "\uD83D\uDCE8", Collections.singletonList(":incoming_envelope:"), Collections.singletonList(":incoming_envelope:"), Collections.singletonList(":incoming_envelope:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "incoming envelope", EmojiGroup.OBJECTS, EmojiSubGroup.MAIL, false);

    /**
     * 📩
     */
    Emoji ENVELOPE_WITH_ARROW = new Emoji("📩", "\uD83D\uDCE9", Collections.singletonList(":envelope_with_arrow:"), Collections.singletonList(":envelope_with_arrow:"), Collections.singletonList(":envelope_with_arrow:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "envelope with arrow", EmojiGroup.OBJECTS, EmojiSubGroup.MAIL, false);

    /**
     * 📤
     */
    Emoji OUTBOX_TRAY = new Emoji("📤", "\uD83D\uDCE4", Collections.singletonList(":outbox_tray:"), Collections.singletonList(":outbox_tray:"), Collections.singletonList(":outbox_tray:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "outbox tray", EmojiGroup.OBJECTS, EmojiSubGroup.MAIL, true);

    /**
     * 📥
     */
    Emoji INBOX_TRAY = new Emoji("📥", "\uD83D\uDCE5", Collections.singletonList(":inbox_tray:"), Collections.singletonList(":inbox_tray:"), Collections.singletonList(":inbox_tray:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "inbox tray", EmojiGroup.OBJECTS, EmojiSubGroup.MAIL, true);

    /**
     * 📦
     */
    Emoji PACKAGE = new Emoji("📦", "\uD83D\uDCE6", Collections.singletonList(":package:"), Collections.singletonList(":package:"), Collections.singletonList(":package:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "package", EmojiGroup.OBJECTS, EmojiSubGroup.MAIL, true);

    /**
     * 📫
     */
    Emoji CLOSED_MAILBOX_WITH_RAISED_FLAG = new Emoji("📫", "\uD83D\uDCEB", Collections.singletonList(":mailbox:"), Collections.singletonList(":mailbox:"), Collections.singletonList(":mailbox:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "closed mailbox with raised flag", EmojiGroup.OBJECTS, EmojiSubGroup.MAIL, true);

    /**
     * 📪
     */
    Emoji CLOSED_MAILBOX_WITH_LOWERED_FLAG = new Emoji("📪", "\uD83D\uDCEA", Collections.singletonList(":mailbox_closed:"), Collections.singletonList(":mailbox_closed:"), Collections.singletonList(":mailbox_closed:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "closed mailbox with lowered flag", EmojiGroup.OBJECTS, EmojiSubGroup.MAIL, true);

    /**
     * 📬
     */
    Emoji OPEN_MAILBOX_WITH_RAISED_FLAG = new Emoji("📬", "\uD83D\uDCEC", Collections.singletonList(":mailbox_with_mail:"), Collections.singletonList(":mailbox_with_mail:"), Collections.singletonList(":mailbox_with_mail:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "open mailbox with raised flag", EmojiGroup.OBJECTS, EmojiSubGroup.MAIL, true);

    /**
     * 📭
     */
    Emoji OPEN_MAILBOX_WITH_LOWERED_FLAG = new Emoji("📭", "\uD83D\uDCED", Collections.singletonList(":mailbox_with_no_mail:"), Collections.singletonList(":mailbox_with_no_mail:"), Collections.singletonList(":mailbox_with_no_mail:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "open mailbox with lowered flag", EmojiGroup.OBJECTS, EmojiSubGroup.MAIL, true);

    /**
     * 📮
     */
    Emoji POSTBOX = new Emoji("📮", "\uD83D\uDCEE", Collections.singletonList(":postbox:"), Collections.singletonList(":postbox:"), Collections.singletonList(":postbox:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "postbox", EmojiGroup.OBJECTS, EmojiSubGroup.MAIL, false);

    /**
     * 🗳️
     */
    Emoji BALLOT_BOX_WITH_BALLOT = new Emoji("🗳️", "\uD83D\uDDF3\uFE0F", Collections.unmodifiableList(Arrays.asList(":ballot_box:", ":ballot_box_with_ballot:")), Collections.singletonList(":ballot_box_with_ballot:"), Collections.singletonList(":ballot_box:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "ballot box with ballot", EmojiGroup.OBJECTS, EmojiSubGroup.MAIL, false);

    /**
     * 🗳
     */
    Emoji BALLOT_BOX_WITH_BALLOT_UNQUALIFIED = new Emoji("🗳", "\uD83D\uDDF3", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":ballot_box:"), false, false, 0.7, Qualification.fromString("unqualified"), "ballot box with ballot", EmojiGroup.OBJECTS, EmojiSubGroup.MAIL, true);
}
