package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiOtherSymbol {

    /**
     * ⚕️
     */
    Emoji MEDICAL_SYMBOL = new Emoji("⚕️", "\u2695\uFE0F", Collections.singletonList(":medical_symbol:"), Collections.singletonList(":medical_symbol:"), Collections.singletonList(":medical_symbol:"), false, false, 4.0, Qualification.fromString("fully-qualified"), "medical symbol", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, false);

    /**
     * ⚕
     */
    Emoji MEDICAL_SYMBOL_UNQUALIFIED = new Emoji("⚕", "\u2695", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":medical_symbol:"), false, false, 4.0, Qualification.fromString("unqualified"), "medical symbol", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, true);

    /**
     * ♻️
     */
    Emoji RECYCLING_SYMBOL = new Emoji("♻️", "\u267B\uFE0F", Collections.singletonList(":recycle:"), Collections.singletonList(":recycle:"), Collections.singletonList(":recycle:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "recycling symbol", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, false);

    /**
     * ♻
     */
    Emoji RECYCLING_SYMBOL_UNQUALIFIED = new Emoji("♻", "\u267B", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":recycle:"), false, false, 0.6, Qualification.fromString("unqualified"), "recycling symbol", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, true);

    /**
     * ⚜️
     */
    Emoji FLEUR_DE_LIS = new Emoji("⚜️", "\u269C\uFE0F", Collections.singletonList(":fleur_de_lis:"), Collections.singletonList(":fleur_de_lis:"), Collections.singletonList(":fleur_de_lis:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "fleur-de-lis", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, false);

    /**
     * ⚜
     */
    Emoji FLEUR_DE_LIS_UNQUALIFIED = new Emoji("⚜", "\u269C", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":fleur_de_lis:"), false, false, 1.0, Qualification.fromString("unqualified"), "fleur-de-lis", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, true);

    /**
     * 🔱
     */
    Emoji TRIDENT_EMBLEM = new Emoji("🔱", "\uD83D\uDD31", Collections.singletonList(":trident:"), Collections.singletonList(":trident:"), Collections.singletonList(":trident:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "trident emblem", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, false);

    /**
     * 📛
     */
    Emoji NAME_BADGE = new Emoji("📛", "\uD83D\uDCDB", Collections.singletonList(":name_badge:"), Collections.singletonList(":name_badge:"), Collections.singletonList(":name_badge:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "name badge", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, false);

    /**
     * 🔰
     */
    Emoji JAPANESE_SYMBOL_FOR_BEGINNER = new Emoji("🔰", "\uD83D\uDD30", Collections.singletonList(":beginner:"), Collections.singletonList(":beginner:"), Collections.singletonList(":beginner:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese symbol for beginner", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, false);

    /**
     * ⭕
     */
    Emoji HOLLOW_RED_CIRCLE = new Emoji("⭕", "\u2B55", Collections.singletonList(":o:"), Collections.singletonList(":o:"), Collections.singletonList(":o:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "hollow red circle", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, true);

    /**
     * ✅
     */
    Emoji CHECK_MARK_BUTTON = new Emoji("✅", "\u2705", Collections.singletonList(":white_check_mark:"), Collections.singletonList(":white_check_mark:"), Collections.singletonList(":white_check_mark:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "check mark button", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, true);

    /**
     * ☑️
     */
    Emoji CHECK_BOX_WITH_CHECK = new Emoji("☑️", "\u2611\uFE0F", Collections.singletonList(":ballot_box_with_check:"), Collections.singletonList(":ballot_box_with_check:"), Collections.singletonList(":ballot_box_with_check:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "check box with check", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, false);

    /**
     * ☑
     */
    Emoji CHECK_BOX_WITH_CHECK_UNQUALIFIED = new Emoji("☑", "\u2611", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":ballot_box_with_check:"), false, false, 0.6, Qualification.fromString("unqualified"), "check box with check", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, true);

    /**
     * ✔️
     */
    Emoji CHECK_MARK = new Emoji("✔️", "\u2714\uFE0F", Collections.unmodifiableList(Arrays.asList(":heavy_check_mark:", ":check_mark:")), Collections.singletonList(":heavy_check_mark:"), Collections.singletonList(":heavy_check_mark:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "check mark", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, false);

    /**
     * ✔
     */
    Emoji CHECK_MARK_UNQUALIFIED = new Emoji("✔", "\u2714", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":heavy_check_mark:"), false, false, 0.6, Qualification.fromString("unqualified"), "check mark", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, true);

    /**
     * ❌
     */
    Emoji CROSS_MARK = new Emoji("❌", "\u274C", Collections.unmodifiableList(Arrays.asList(":x:", ":cross_mark:")), Collections.singletonList(":x:"), Collections.singletonList(":x:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "cross mark", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, true);

    /**
     * ❎
     */
    Emoji CROSS_MARK_BUTTON = new Emoji("❎", "\u274E", Collections.singletonList(":negative_squared_cross_mark:"), Collections.singletonList(":negative_squared_cross_mark:"), Collections.singletonList(":negative_squared_cross_mark:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "cross mark button", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, true);

    /**
     * ➰
     */
    Emoji CURLY_LOOP = new Emoji("➰", "\u27B0", Collections.singletonList(":curly_loop:"), Collections.singletonList(":curly_loop:"), Collections.singletonList(":curly_loop:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "curly loop", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, true);

    /**
     * ➿
     */
    Emoji DOUBLE_CURLY_LOOP = new Emoji("➿", "\u27BF", Collections.singletonList(":loop:"), Collections.singletonList(":loop:"), Collections.singletonList(":loop:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "double curly loop", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, true);

    /**
     * 〽️
     */
    Emoji PART_ALTERNATION_MARK = new Emoji("〽️", "\u303D\uFE0F", Collections.singletonList(":part_alternation_mark:"), Collections.singletonList(":part_alternation_mark:"), Collections.singletonList(":part_alternation_mark:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "part alternation mark", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, false);

    /**
     * 〽
     */
    Emoji PART_ALTERNATION_MARK_UNQUALIFIED = new Emoji("〽", "\u303D", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":part_alternation_mark:"), false, false, 0.6, Qualification.fromString("unqualified"), "part alternation mark", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, true);

    /**
     * ✳️
     */
    Emoji EIGHT_SPOKED_ASTERISK = new Emoji("✳️", "\u2733\uFE0F", Collections.singletonList(":eight_spoked_asterisk:"), Collections.singletonList(":eight_spoked_asterisk:"), Collections.singletonList(":eight_spoked_asterisk:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "eight-spoked asterisk", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, false);

    /**
     * ✳
     */
    Emoji EIGHT_SPOKED_ASTERISK_UNQUALIFIED = new Emoji("✳", "\u2733", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":eight_spoked_asterisk:"), false, false, 0.6, Qualification.fromString("unqualified"), "eight-spoked asterisk", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, true);

    /**
     * ✴️
     */
    Emoji EIGHT_POINTED_STAR = new Emoji("✴️", "\u2734\uFE0F", Collections.singletonList(":eight_pointed_black_star:"), Collections.singletonList(":eight_pointed_black_star:"), Collections.singletonList(":eight_pointed_black_star:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "eight-pointed star", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, false);

    /**
     * ✴
     */
    Emoji EIGHT_POINTED_STAR_UNQUALIFIED = new Emoji("✴", "\u2734", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":eight_pointed_black_star:"), false, false, 0.6, Qualification.fromString("unqualified"), "eight-pointed star", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, true);

    /**
     * ❇️
     */
    Emoji SPARKLE = new Emoji("❇️", "\u2747\uFE0F", Collections.singletonList(":sparkle:"), Collections.singletonList(":sparkle:"), Collections.singletonList(":sparkle:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "sparkle", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, false);

    /**
     * ❇
     */
    Emoji SPARKLE_UNQUALIFIED = new Emoji("❇", "\u2747", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":sparkle:"), false, false, 0.6, Qualification.fromString("unqualified"), "sparkle", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, true);

    /**
     * ©️
     */
    Emoji COPYRIGHT = new Emoji("©️", "\u00A9\uFE0F", Collections.singletonList(":copyright:"), Collections.singletonList(":copyright:"), Collections.singletonList(":copyright:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "copyright", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, false);

    /**
     * ©
     */
    Emoji COPYRIGHT_UNQUALIFIED = new Emoji("©", "\u00A9", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":copyright:"), false, false, 0.6, Qualification.fromString("unqualified"), "copyright", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, true);

    /**
     * ®️
     */
    Emoji REGISTERED = new Emoji("®️", "\u00AE\uFE0F", Collections.singletonList(":registered:"), Collections.singletonList(":registered:"), Collections.singletonList(":registered:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "registered", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, false);

    /**
     * ®
     */
    Emoji REGISTERED_UNQUALIFIED = new Emoji("®", "\u00AE", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":registered:"), false, false, 0.6, Qualification.fromString("unqualified"), "registered", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, true);

    /**
     * ™️
     */
    Emoji TRADE_MARK = new Emoji("™️", "\u2122\uFE0F", Collections.unmodifiableList(Arrays.asList(":tm:", ":trade_mark:")), Collections.singletonList(":tm:"), Collections.singletonList(":tm:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "trade mark", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, false);

    /**
     * ™
     */
    Emoji TRADE_MARK_UNQUALIFIED = new Emoji("™", "\u2122", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":tm:"), false, false, 0.6, Qualification.fromString("unqualified"), "trade mark", EmojiGroup.SYMBOLS, EmojiSubGroup.OTHER_SYMBOL, true);
}
