package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiPersonFantasy {

    /**
     * 👼
     */
    Emoji BABY_ANGEL = new Emoji("👼", "\uD83D\uDC7C", Collections.unmodifiableList(Arrays.asList(":angel:", ":baby_angel:")), Collections.singletonList(":angel:"), Collections.singletonList(":angel:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "baby angel", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 👼🏻
     */
    Emoji BABY_ANGEL_LIGHT_SKIN_TONE = new Emoji("👼🏻", "\uD83D\uDC7C\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":angel_tone1:", ":angel::skin-tone-1:", ":baby_angel::skin-tone-1:")), Collections.singletonList(":angel::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "baby angel: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 👼🏼
     */
    Emoji BABY_ANGEL_MEDIUM_LIGHT_SKIN_TONE = new Emoji("👼🏼", "\uD83D\uDC7C\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":angel_tone2:", ":angel::skin-tone-2:", ":baby_angel::skin-tone-2:")), Collections.singletonList(":angel::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "baby angel: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 👼🏽
     */
    Emoji BABY_ANGEL_MEDIUM_SKIN_TONE = new Emoji("👼🏽", "\uD83D\uDC7C\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":angel_tone3:", ":angel::skin-tone-3:", ":baby_angel::skin-tone-3:")), Collections.singletonList(":angel::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "baby angel: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 👼🏾
     */
    Emoji BABY_ANGEL_MEDIUM_DARK_SKIN_TONE = new Emoji("👼🏾", "\uD83D\uDC7C\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":angel_tone4:", ":angel::skin-tone-4:", ":baby_angel::skin-tone-4:")), Collections.singletonList(":angel::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "baby angel: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 👼🏿
     */
    Emoji BABY_ANGEL_DARK_SKIN_TONE = new Emoji("👼🏿", "\uD83D\uDC7C\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":angel_tone5:", ":angel::skin-tone-5:", ":baby_angel::skin-tone-5:")), Collections.singletonList(":angel::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "baby angel: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🎅
     */
    Emoji SANTA_CLAUS = new Emoji("🎅", "\uD83C\uDF85", Collections.unmodifiableList(Arrays.asList(":santa:", ":santa_claus:")), Collections.singletonList(":santa:"), Collections.singletonList(":santa:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Santa Claus", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🎅🏻
     */
    Emoji SANTA_CLAUS_LIGHT_SKIN_TONE = new Emoji("🎅🏻", "\uD83C\uDF85\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":santa_tone1:", ":santa::skin-tone-1:", ":santa_claus::skin-tone-1:")), Collections.singletonList(":santa::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "Santa Claus: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🎅🏼
     */
    Emoji SANTA_CLAUS_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🎅🏼", "\uD83C\uDF85\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":santa_tone2:", ":santa::skin-tone-2:", ":santa_claus::skin-tone-2:")), Collections.singletonList(":santa::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "Santa Claus: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🎅🏽
     */
    Emoji SANTA_CLAUS_MEDIUM_SKIN_TONE = new Emoji("🎅🏽", "\uD83C\uDF85\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":santa_tone3:", ":santa::skin-tone-3:", ":santa_claus::skin-tone-3:")), Collections.singletonList(":santa::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "Santa Claus: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🎅🏾
     */
    Emoji SANTA_CLAUS_MEDIUM_DARK_SKIN_TONE = new Emoji("🎅🏾", "\uD83C\uDF85\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":santa_tone4:", ":santa::skin-tone-4:", ":santa_claus::skin-tone-4:")), Collections.singletonList(":santa::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "Santa Claus: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🎅🏿
     */
    Emoji SANTA_CLAUS_DARK_SKIN_TONE = new Emoji("🎅🏿", "\uD83C\uDF85\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":santa_tone5:", ":santa::skin-tone-5:", ":santa_claus::skin-tone-5:")), Collections.singletonList(":santa::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "Santa Claus: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🤶
     */
    Emoji MRS_CLAUS = new Emoji("🤶", "\uD83E\uDD36", Collections.unmodifiableList(Arrays.asList(":mrs_claus:", ":mother_christmas:")), Collections.singletonList(":mrs_claus:"), Collections.singletonList(":mrs_claus:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "Mrs. Claus", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🤶🏻
     */
    Emoji MRS_CLAUS_LIGHT_SKIN_TONE = new Emoji("🤶🏻", "\uD83E\uDD36\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":mrs_claus_tone1:", ":mother_christmas_tone1:", ":mrs_claus::skin-tone-1:", ":mother_christmas::skin-tone-1:")), Collections.singletonList(":mrs_claus::skin-tone-2:"), Collections.emptyList(), true, false, 3.0, Qualification.fromString("fully-qualified"), "Mrs. Claus: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🤶🏼
     */
    Emoji MRS_CLAUS_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🤶🏼", "\uD83E\uDD36\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":mrs_claus_tone2:", ":mother_christmas_tone2:", ":mrs_claus::skin-tone-2:", ":mother_christmas::skin-tone-2:")), Collections.singletonList(":mrs_claus::skin-tone-3:"), Collections.emptyList(), true, false, 3.0, Qualification.fromString("fully-qualified"), "Mrs. Claus: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🤶🏽
     */
    Emoji MRS_CLAUS_MEDIUM_SKIN_TONE = new Emoji("🤶🏽", "\uD83E\uDD36\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":mrs_claus_tone3:", ":mother_christmas_tone3:", ":mrs_claus::skin-tone-3:", ":mother_christmas::skin-tone-3:")), Collections.singletonList(":mrs_claus::skin-tone-4:"), Collections.emptyList(), true, false, 3.0, Qualification.fromString("fully-qualified"), "Mrs. Claus: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🤶🏾
     */
    Emoji MRS_CLAUS_MEDIUM_DARK_SKIN_TONE = new Emoji("🤶🏾", "\uD83E\uDD36\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":mrs_claus_tone4:", ":mother_christmas_tone4:", ":mrs_claus::skin-tone-4:", ":mother_christmas::skin-tone-4:")), Collections.singletonList(":mrs_claus::skin-tone-5:"), Collections.emptyList(), true, false, 3.0, Qualification.fromString("fully-qualified"), "Mrs. Claus: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🤶🏿
     */
    Emoji MRS_CLAUS_DARK_SKIN_TONE = new Emoji("🤶🏿", "\uD83E\uDD36\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":mrs_claus_tone5:", ":mother_christmas_tone5:", ":mrs_claus::skin-tone-5:", ":mother_christmas::skin-tone-5:")), Collections.singletonList(":mrs_claus::skin-tone-6:"), Collections.emptyList(), true, false, 3.0, Qualification.fromString("fully-qualified"), "Mrs. Claus: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧑‍🎄
     */
    Emoji MX_CLAUS = new Emoji("🧑‍🎄", "\uD83E\uDDD1\u200D\uD83C\uDF84", Collections.singletonList(":mx_claus:"), Collections.singletonList(":mx_claus:"), Collections.singletonList(":mx_claus:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "mx claus", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧑🏻‍🎄
     */
    Emoji MX_CLAUS_LIGHT_SKIN_TONE = new Emoji("🧑🏻‍🎄", "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDF84", Collections.unmodifiableList(Arrays.asList(":mx_claus_tone1:", ":mx_claus_light_skin_tone:", ":mx_claus::skin-tone-1:")), Collections.singletonList(":mx_claus::skin-tone-2:"), Collections.emptyList(), true, false, 13.0, Qualification.fromString("fully-qualified"), "mx claus: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧑🏼‍🎄
     */
    Emoji MX_CLAUS_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🧑🏼‍🎄", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDF84", Collections.unmodifiableList(Arrays.asList(":mx_claus_tone2:", ":mx_claus_medium_light_skin_tone:", ":mx_claus::skin-tone-2:")), Collections.singletonList(":mx_claus::skin-tone-3:"), Collections.emptyList(), true, false, 13.0, Qualification.fromString("fully-qualified"), "mx claus: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧑🏽‍🎄
     */
    Emoji MX_CLAUS_MEDIUM_SKIN_TONE = new Emoji("🧑🏽‍🎄", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDF84", Collections.unmodifiableList(Arrays.asList(":mx_claus_tone3:", ":mx_claus_medium_skin_tone:", ":mx_claus::skin-tone-3:")), Collections.singletonList(":mx_claus::skin-tone-4:"), Collections.emptyList(), true, false, 13.0, Qualification.fromString("fully-qualified"), "mx claus: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧑🏾‍🎄
     */
    Emoji MX_CLAUS_MEDIUM_DARK_SKIN_TONE = new Emoji("🧑🏾‍🎄", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDF84", Collections.unmodifiableList(Arrays.asList(":mx_claus_tone4:", ":mx_claus_medium_dark_skin_tone:", ":mx_claus::skin-tone-4:")), Collections.singletonList(":mx_claus::skin-tone-5:"), Collections.emptyList(), true, false, 13.0, Qualification.fromString("fully-qualified"), "mx claus: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧑🏿‍🎄
     */
    Emoji MX_CLAUS_DARK_SKIN_TONE = new Emoji("🧑🏿‍🎄", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDF84", Collections.unmodifiableList(Arrays.asList(":mx_claus_tone5:", ":mx_claus_dark_skin_tone:", ":mx_claus::skin-tone-5:")), Collections.singletonList(":mx_claus::skin-tone-6:"), Collections.emptyList(), true, false, 13.0, Qualification.fromString("fully-qualified"), "mx claus: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸
     */
    Emoji SUPERHERO = new Emoji("🦸", "\uD83E\uDDB8", Collections.singletonList(":superhero:"), Collections.singletonList(":superhero:"), Collections.singletonList(":superhero:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "superhero", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏻
     */
    Emoji SUPERHERO_LIGHT_SKIN_TONE = new Emoji("🦸🏻", "\uD83E\uDDB8\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":superhero_tone1:", ":superhero_light_skin_tone:", ":superhero::skin-tone-1:")), Collections.singletonList(":superhero::skin-tone-2:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "superhero: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏼
     */
    Emoji SUPERHERO_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🦸🏼", "\uD83E\uDDB8\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":superhero_tone2:", ":superhero_medium_light_skin_tone:", ":superhero::skin-tone-2:")), Collections.singletonList(":superhero::skin-tone-3:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "superhero: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏽
     */
    Emoji SUPERHERO_MEDIUM_SKIN_TONE = new Emoji("🦸🏽", "\uD83E\uDDB8\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":superhero_tone3:", ":superhero_medium_skin_tone:", ":superhero::skin-tone-3:")), Collections.singletonList(":superhero::skin-tone-4:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "superhero: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏾
     */
    Emoji SUPERHERO_MEDIUM_DARK_SKIN_TONE = new Emoji("🦸🏾", "\uD83E\uDDB8\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":superhero_tone4:", ":superhero_medium_dark_skin_tone:", ":superhero::skin-tone-4:")), Collections.singletonList(":superhero::skin-tone-5:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "superhero: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏿
     */
    Emoji SUPERHERO_DARK_SKIN_TONE = new Emoji("🦸🏿", "\uD83E\uDDB8\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":superhero_tone5:", ":superhero_dark_skin_tone:", ":superhero::skin-tone-5:")), Collections.singletonList(":superhero::skin-tone-6:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "superhero: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸‍♂️
     */
    Emoji MAN_SUPERHERO = new Emoji("🦸‍♂️", "\uD83E\uDDB8\u200D\u2642\uFE0F", Collections.singletonList(":man_superhero:"), Collections.singletonList(":male_superhero:"), Collections.singletonList(":superhero_man:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "man superhero", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸‍♂
     */
    Emoji MAN_SUPERHERO_MINIMALLY_QUALIFIED = new Emoji("🦸‍♂", "\uD83E\uDDB8\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 11.0, Qualification.fromString("minimally-qualified"), "man superhero", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏻‍♂️
     */
    Emoji MAN_SUPERHERO_LIGHT_SKIN_TONE = new Emoji("🦸🏻‍♂️", "\uD83E\uDDB8\uD83C\uDFFB\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_superhero_tone1:", ":man_superhero_light_skin_tone:", ":man_superhero::skin-tone-1:")), Collections.singletonList(":male_superhero::skin-tone-2:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "man superhero: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏻‍♂
     */
    Emoji MAN_SUPERHERO_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🦸🏻‍♂", "\uD83E\uDDB8\uD83C\uDFFB\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 11.0, Qualification.fromString("minimally-qualified"), "man superhero: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏼‍♂️
     */
    Emoji MAN_SUPERHERO_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🦸🏼‍♂️", "\uD83E\uDDB8\uD83C\uDFFC\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_superhero_tone2:", ":man_superhero_medium_light_skin_tone:", ":man_superhero::skin-tone-2:")), Collections.singletonList(":male_superhero::skin-tone-3:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "man superhero: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏼‍♂
     */
    Emoji MAN_SUPERHERO_MEDIUM_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🦸🏼‍♂", "\uD83E\uDDB8\uD83C\uDFFC\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 11.0, Qualification.fromString("minimally-qualified"), "man superhero: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏽‍♂️
     */
    Emoji MAN_SUPERHERO_MEDIUM_SKIN_TONE = new Emoji("🦸🏽‍♂️", "\uD83E\uDDB8\uD83C\uDFFD\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_superhero_tone3:", ":man_superhero_medium_skin_tone:", ":man_superhero::skin-tone-3:")), Collections.singletonList(":male_superhero::skin-tone-4:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "man superhero: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏽‍♂
     */
    Emoji MAN_SUPERHERO_MEDIUM_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🦸🏽‍♂", "\uD83E\uDDB8\uD83C\uDFFD\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 11.0, Qualification.fromString("minimally-qualified"), "man superhero: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏾‍♂️
     */
    Emoji MAN_SUPERHERO_MEDIUM_DARK_SKIN_TONE = new Emoji("🦸🏾‍♂️", "\uD83E\uDDB8\uD83C\uDFFE\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_superhero_tone4:", ":man_superhero_medium_dark_skin_tone:", ":man_superhero::skin-tone-4:")), Collections.singletonList(":male_superhero::skin-tone-5:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "man superhero: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏾‍♂
     */
    Emoji MAN_SUPERHERO_MEDIUM_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🦸🏾‍♂", "\uD83E\uDDB8\uD83C\uDFFE\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 11.0, Qualification.fromString("minimally-qualified"), "man superhero: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏿‍♂️
     */
    Emoji MAN_SUPERHERO_DARK_SKIN_TONE = new Emoji("🦸🏿‍♂️", "\uD83E\uDDB8\uD83C\uDFFF\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_superhero_tone5:", ":man_superhero_dark_skin_tone:", ":man_superhero::skin-tone-5:")), Collections.singletonList(":male_superhero::skin-tone-6:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "man superhero: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏿‍♂
     */
    Emoji MAN_SUPERHERO_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🦸🏿‍♂", "\uD83E\uDDB8\uD83C\uDFFF\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 11.0, Qualification.fromString("minimally-qualified"), "man superhero: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸‍♀️
     */
    Emoji WOMAN_SUPERHERO = new Emoji("🦸‍♀️", "\uD83E\uDDB8\u200D\u2640\uFE0F", Collections.singletonList(":woman_superhero:"), Collections.singletonList(":female_superhero:"), Collections.singletonList(":superhero_woman:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "woman superhero", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸‍♀
     */
    Emoji WOMAN_SUPERHERO_MINIMALLY_QUALIFIED = new Emoji("🦸‍♀", "\uD83E\uDDB8\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 11.0, Qualification.fromString("minimally-qualified"), "woman superhero", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏻‍♀️
     */
    Emoji WOMAN_SUPERHERO_LIGHT_SKIN_TONE = new Emoji("🦸🏻‍♀️", "\uD83E\uDDB8\uD83C\uDFFB\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_superhero_tone1:", ":woman_superhero_light_skin_tone:", ":woman_superhero::skin-tone-1:")), Collections.singletonList(":female_superhero::skin-tone-2:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "woman superhero: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏻‍♀
     */
    Emoji WOMAN_SUPERHERO_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🦸🏻‍♀", "\uD83E\uDDB8\uD83C\uDFFB\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 11.0, Qualification.fromString("minimally-qualified"), "woman superhero: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏼‍♀️
     */
    Emoji WOMAN_SUPERHERO_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🦸🏼‍♀️", "\uD83E\uDDB8\uD83C\uDFFC\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_superhero_tone2:", ":woman_superhero_medium_light_skin_tone:", ":woman_superhero::skin-tone-2:")), Collections.singletonList(":female_superhero::skin-tone-3:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "woman superhero: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏼‍♀
     */
    Emoji WOMAN_SUPERHERO_MEDIUM_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🦸🏼‍♀", "\uD83E\uDDB8\uD83C\uDFFC\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 11.0, Qualification.fromString("minimally-qualified"), "woman superhero: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏽‍♀️
     */
    Emoji WOMAN_SUPERHERO_MEDIUM_SKIN_TONE = new Emoji("🦸🏽‍♀️", "\uD83E\uDDB8\uD83C\uDFFD\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_superhero_tone3:", ":woman_superhero_medium_skin_tone:", ":woman_superhero::skin-tone-3:")), Collections.singletonList(":female_superhero::skin-tone-4:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "woman superhero: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏽‍♀
     */
    Emoji WOMAN_SUPERHERO_MEDIUM_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🦸🏽‍♀", "\uD83E\uDDB8\uD83C\uDFFD\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 11.0, Qualification.fromString("minimally-qualified"), "woman superhero: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏾‍♀️
     */
    Emoji WOMAN_SUPERHERO_MEDIUM_DARK_SKIN_TONE = new Emoji("🦸🏾‍♀️", "\uD83E\uDDB8\uD83C\uDFFE\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_superhero_tone4:", ":woman_superhero_medium_dark_skin_tone:", ":woman_superhero::skin-tone-4:")), Collections.singletonList(":female_superhero::skin-tone-5:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "woman superhero: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏾‍♀
     */
    Emoji WOMAN_SUPERHERO_MEDIUM_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🦸🏾‍♀", "\uD83E\uDDB8\uD83C\uDFFE\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 11.0, Qualification.fromString("minimally-qualified"), "woman superhero: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏿‍♀️
     */
    Emoji WOMAN_SUPERHERO_DARK_SKIN_TONE = new Emoji("🦸🏿‍♀️", "\uD83E\uDDB8\uD83C\uDFFF\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_superhero_tone5:", ":woman_superhero_dark_skin_tone:", ":woman_superhero::skin-tone-5:")), Collections.singletonList(":female_superhero::skin-tone-6:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "woman superhero: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦸🏿‍♀
     */
    Emoji WOMAN_SUPERHERO_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🦸🏿‍♀", "\uD83E\uDDB8\uD83C\uDFFF\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 11.0, Qualification.fromString("minimally-qualified"), "woman superhero: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹
     */
    Emoji SUPERVILLAIN = new Emoji("🦹", "\uD83E\uDDB9", Collections.singletonList(":supervillain:"), Collections.singletonList(":supervillain:"), Collections.singletonList(":supervillain:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "supervillain", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏻
     */
    Emoji SUPERVILLAIN_LIGHT_SKIN_TONE = new Emoji("🦹🏻", "\uD83E\uDDB9\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":supervillain_tone1:", ":supervillain_light_skin_tone:", ":supervillain::skin-tone-1:")), Collections.singletonList(":supervillain::skin-tone-2:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "supervillain: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏼
     */
    Emoji SUPERVILLAIN_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🦹🏼", "\uD83E\uDDB9\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":supervillain_tone2:", ":supervillain_medium_light_skin_tone:", ":supervillain::skin-tone-2:")), Collections.singletonList(":supervillain::skin-tone-3:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "supervillain: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏽
     */
    Emoji SUPERVILLAIN_MEDIUM_SKIN_TONE = new Emoji("🦹🏽", "\uD83E\uDDB9\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":supervillain_tone3:", ":supervillain_medium_skin_tone:", ":supervillain::skin-tone-3:")), Collections.singletonList(":supervillain::skin-tone-4:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "supervillain: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏾
     */
    Emoji SUPERVILLAIN_MEDIUM_DARK_SKIN_TONE = new Emoji("🦹🏾", "\uD83E\uDDB9\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":supervillain_tone4:", ":supervillain_medium_dark_skin_tone:", ":supervillain::skin-tone-4:")), Collections.singletonList(":supervillain::skin-tone-5:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "supervillain: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏿
     */
    Emoji SUPERVILLAIN_DARK_SKIN_TONE = new Emoji("🦹🏿", "\uD83E\uDDB9\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":supervillain_tone5:", ":supervillain_dark_skin_tone:", ":supervillain::skin-tone-5:")), Collections.singletonList(":supervillain::skin-tone-6:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "supervillain: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹‍♂️
     */
    Emoji MAN_SUPERVILLAIN = new Emoji("🦹‍♂️", "\uD83E\uDDB9\u200D\u2642\uFE0F", Collections.singletonList(":man_supervillain:"), Collections.singletonList(":male_supervillain:"), Collections.singletonList(":supervillain_man:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "man supervillain", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹‍♂
     */
    Emoji MAN_SUPERVILLAIN_MINIMALLY_QUALIFIED = new Emoji("🦹‍♂", "\uD83E\uDDB9\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 11.0, Qualification.fromString("minimally-qualified"), "man supervillain", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏻‍♂️
     */
    Emoji MAN_SUPERVILLAIN_LIGHT_SKIN_TONE = new Emoji("🦹🏻‍♂️", "\uD83E\uDDB9\uD83C\uDFFB\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_supervillain_tone1:", ":man_supervillain_light_skin_tone:", ":man_supervillain::skin-tone-1:")), Collections.singletonList(":male_supervillain::skin-tone-2:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "man supervillain: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏻‍♂
     */
    Emoji MAN_SUPERVILLAIN_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🦹🏻‍♂", "\uD83E\uDDB9\uD83C\uDFFB\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 11.0, Qualification.fromString("minimally-qualified"), "man supervillain: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏼‍♂️
     */
    Emoji MAN_SUPERVILLAIN_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🦹🏼‍♂️", "\uD83E\uDDB9\uD83C\uDFFC\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_supervillain_tone2:", ":man_supervillain_medium_light_skin_tone:", ":man_supervillain::skin-tone-2:")), Collections.singletonList(":male_supervillain::skin-tone-3:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "man supervillain: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏼‍♂
     */
    Emoji MAN_SUPERVILLAIN_MEDIUM_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🦹🏼‍♂", "\uD83E\uDDB9\uD83C\uDFFC\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 11.0, Qualification.fromString("minimally-qualified"), "man supervillain: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏽‍♂️
     */
    Emoji MAN_SUPERVILLAIN_MEDIUM_SKIN_TONE = new Emoji("🦹🏽‍♂️", "\uD83E\uDDB9\uD83C\uDFFD\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_supervillain_tone3:", ":man_supervillain_medium_skin_tone:", ":man_supervillain::skin-tone-3:")), Collections.singletonList(":male_supervillain::skin-tone-4:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "man supervillain: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏽‍♂
     */
    Emoji MAN_SUPERVILLAIN_MEDIUM_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🦹🏽‍♂", "\uD83E\uDDB9\uD83C\uDFFD\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 11.0, Qualification.fromString("minimally-qualified"), "man supervillain: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏾‍♂️
     */
    Emoji MAN_SUPERVILLAIN_MEDIUM_DARK_SKIN_TONE = new Emoji("🦹🏾‍♂️", "\uD83E\uDDB9\uD83C\uDFFE\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_supervillain_tone4:", ":man_supervillain_medium_dark_skin_tone:", ":man_supervillain::skin-tone-4:")), Collections.singletonList(":male_supervillain::skin-tone-5:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "man supervillain: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏾‍♂
     */
    Emoji MAN_SUPERVILLAIN_MEDIUM_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🦹🏾‍♂", "\uD83E\uDDB9\uD83C\uDFFE\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 11.0, Qualification.fromString("minimally-qualified"), "man supervillain: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏿‍♂️
     */
    Emoji MAN_SUPERVILLAIN_DARK_SKIN_TONE = new Emoji("🦹🏿‍♂️", "\uD83E\uDDB9\uD83C\uDFFF\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_supervillain_tone5:", ":man_supervillain_dark_skin_tone:", ":man_supervillain::skin-tone-5:")), Collections.singletonList(":male_supervillain::skin-tone-6:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "man supervillain: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏿‍♂
     */
    Emoji MAN_SUPERVILLAIN_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🦹🏿‍♂", "\uD83E\uDDB9\uD83C\uDFFF\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 11.0, Qualification.fromString("minimally-qualified"), "man supervillain: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹‍♀️
     */
    Emoji WOMAN_SUPERVILLAIN = new Emoji("🦹‍♀️", "\uD83E\uDDB9\u200D\u2640\uFE0F", Collections.singletonList(":woman_supervillain:"), Collections.singletonList(":female_supervillain:"), Collections.singletonList(":supervillain_woman:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "woman supervillain", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹‍♀
     */
    Emoji WOMAN_SUPERVILLAIN_MINIMALLY_QUALIFIED = new Emoji("🦹‍♀", "\uD83E\uDDB9\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 11.0, Qualification.fromString("minimally-qualified"), "woman supervillain", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏻‍♀️
     */
    Emoji WOMAN_SUPERVILLAIN_LIGHT_SKIN_TONE = new Emoji("🦹🏻‍♀️", "\uD83E\uDDB9\uD83C\uDFFB\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_supervillain_tone1:", ":woman_supervillain_light_skin_tone:", ":woman_supervillain::skin-tone-1:")), Collections.singletonList(":female_supervillain::skin-tone-2:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "woman supervillain: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏻‍♀
     */
    Emoji WOMAN_SUPERVILLAIN_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🦹🏻‍♀", "\uD83E\uDDB9\uD83C\uDFFB\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 11.0, Qualification.fromString("minimally-qualified"), "woman supervillain: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏼‍♀️
     */
    Emoji WOMAN_SUPERVILLAIN_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🦹🏼‍♀️", "\uD83E\uDDB9\uD83C\uDFFC\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_supervillain_tone2:", ":woman_supervillain_medium_light_skin_tone:", ":woman_supervillain::skin-tone-2:")), Collections.singletonList(":female_supervillain::skin-tone-3:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "woman supervillain: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏼‍♀
     */
    Emoji WOMAN_SUPERVILLAIN_MEDIUM_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🦹🏼‍♀", "\uD83E\uDDB9\uD83C\uDFFC\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 11.0, Qualification.fromString("minimally-qualified"), "woman supervillain: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏽‍♀️
     */
    Emoji WOMAN_SUPERVILLAIN_MEDIUM_SKIN_TONE = new Emoji("🦹🏽‍♀️", "\uD83E\uDDB9\uD83C\uDFFD\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_supervillain_tone3:", ":woman_supervillain_medium_skin_tone:", ":woman_supervillain::skin-tone-3:")), Collections.singletonList(":female_supervillain::skin-tone-4:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "woman supervillain: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏽‍♀
     */
    Emoji WOMAN_SUPERVILLAIN_MEDIUM_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🦹🏽‍♀", "\uD83E\uDDB9\uD83C\uDFFD\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 11.0, Qualification.fromString("minimally-qualified"), "woman supervillain: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏾‍♀️
     */
    Emoji WOMAN_SUPERVILLAIN_MEDIUM_DARK_SKIN_TONE = new Emoji("🦹🏾‍♀️", "\uD83E\uDDB9\uD83C\uDFFE\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_supervillain_tone4:", ":woman_supervillain_medium_dark_skin_tone:", ":woman_supervillain::skin-tone-4:")), Collections.singletonList(":female_supervillain::skin-tone-5:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "woman supervillain: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏾‍♀
     */
    Emoji WOMAN_SUPERVILLAIN_MEDIUM_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🦹🏾‍♀", "\uD83E\uDDB9\uD83C\uDFFE\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 11.0, Qualification.fromString("minimally-qualified"), "woman supervillain: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏿‍♀️
     */
    Emoji WOMAN_SUPERVILLAIN_DARK_SKIN_TONE = new Emoji("🦹🏿‍♀️", "\uD83E\uDDB9\uD83C\uDFFF\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_supervillain_tone5:", ":woman_supervillain_dark_skin_tone:", ":woman_supervillain::skin-tone-5:")), Collections.singletonList(":female_supervillain::skin-tone-6:"), Collections.emptyList(), true, false, 11.0, Qualification.fromString("fully-qualified"), "woman supervillain: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🦹🏿‍♀
     */
    Emoji WOMAN_SUPERVILLAIN_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🦹🏿‍♀", "\uD83E\uDDB9\uD83C\uDFFF\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 11.0, Qualification.fromString("minimally-qualified"), "woman supervillain: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙
     */
    Emoji MAGE = new Emoji("🧙", "\uD83E\uDDD9", Collections.singletonList(":mage:"), Collections.singletonList(":mage:"), Collections.singletonList(":mage:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "mage", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏻
     */
    Emoji MAGE_LIGHT_SKIN_TONE = new Emoji("🧙🏻", "\uD83E\uDDD9\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":mage_tone1:", ":mage_light_skin_tone:", ":mage::skin-tone-1:")), Collections.singletonList(":mage::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "mage: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏼
     */
    Emoji MAGE_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🧙🏼", "\uD83E\uDDD9\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":mage_tone2:", ":mage_medium_light_skin_tone:", ":mage::skin-tone-2:")), Collections.singletonList(":mage::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "mage: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏽
     */
    Emoji MAGE_MEDIUM_SKIN_TONE = new Emoji("🧙🏽", "\uD83E\uDDD9\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":mage_tone3:", ":mage_medium_skin_tone:", ":mage::skin-tone-3:")), Collections.singletonList(":mage::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "mage: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏾
     */
    Emoji MAGE_MEDIUM_DARK_SKIN_TONE = new Emoji("🧙🏾", "\uD83E\uDDD9\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":mage_tone4:", ":mage_medium_dark_skin_tone:", ":mage::skin-tone-4:")), Collections.singletonList(":mage::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "mage: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏿
     */
    Emoji MAGE_DARK_SKIN_TONE = new Emoji("🧙🏿", "\uD83E\uDDD9\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":mage_tone5:", ":mage_dark_skin_tone:", ":mage::skin-tone-5:")), Collections.singletonList(":mage::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "mage: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙‍♂️
     */
    Emoji MAN_MAGE = new Emoji("🧙‍♂️", "\uD83E\uDDD9\u200D\u2642\uFE0F", Collections.singletonList(":man_mage:"), Collections.singletonList(":male_mage:"), Collections.singletonList(":mage_man:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "man mage", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙‍♂
     */
    Emoji MAN_MAGE_MINIMALLY_QUALIFIED = new Emoji("🧙‍♂", "\uD83E\uDDD9\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 5.0, Qualification.fromString("minimally-qualified"), "man mage", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏻‍♂️
     */
    Emoji MAN_MAGE_LIGHT_SKIN_TONE = new Emoji("🧙🏻‍♂️", "\uD83E\uDDD9\uD83C\uDFFB\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_mage_tone1:", ":man_mage_light_skin_tone:", ":man_mage::skin-tone-1:")), Collections.singletonList(":male_mage::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "man mage: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏻‍♂
     */
    Emoji MAN_MAGE_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧙🏻‍♂", "\uD83E\uDDD9\uD83C\uDFFB\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "man mage: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏼‍♂️
     */
    Emoji MAN_MAGE_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🧙🏼‍♂️", "\uD83E\uDDD9\uD83C\uDFFC\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_mage_tone2:", ":man_mage_medium_light_skin_tone:", ":man_mage::skin-tone-2:")), Collections.singletonList(":male_mage::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "man mage: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏼‍♂
     */
    Emoji MAN_MAGE_MEDIUM_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧙🏼‍♂", "\uD83E\uDDD9\uD83C\uDFFC\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "man mage: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏽‍♂️
     */
    Emoji MAN_MAGE_MEDIUM_SKIN_TONE = new Emoji("🧙🏽‍♂️", "\uD83E\uDDD9\uD83C\uDFFD\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_mage_tone3:", ":man_mage_medium_skin_tone:", ":man_mage::skin-tone-3:")), Collections.singletonList(":male_mage::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "man mage: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏽‍♂
     */
    Emoji MAN_MAGE_MEDIUM_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧙🏽‍♂", "\uD83E\uDDD9\uD83C\uDFFD\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "man mage: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏾‍♂️
     */
    Emoji MAN_MAGE_MEDIUM_DARK_SKIN_TONE = new Emoji("🧙🏾‍♂️", "\uD83E\uDDD9\uD83C\uDFFE\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_mage_tone4:", ":man_mage_medium_dark_skin_tone:", ":man_mage::skin-tone-4:")), Collections.singletonList(":male_mage::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "man mage: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏾‍♂
     */
    Emoji MAN_MAGE_MEDIUM_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧙🏾‍♂", "\uD83E\uDDD9\uD83C\uDFFE\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "man mage: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏿‍♂️
     */
    Emoji MAN_MAGE_DARK_SKIN_TONE = new Emoji("🧙🏿‍♂️", "\uD83E\uDDD9\uD83C\uDFFF\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_mage_tone5:", ":man_mage_dark_skin_tone:", ":man_mage::skin-tone-5:")), Collections.singletonList(":male_mage::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "man mage: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏿‍♂
     */
    Emoji MAN_MAGE_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧙🏿‍♂", "\uD83E\uDDD9\uD83C\uDFFF\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "man mage: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙‍♀️
     */
    Emoji WOMAN_MAGE = new Emoji("🧙‍♀️", "\uD83E\uDDD9\u200D\u2640\uFE0F", Collections.singletonList(":woman_mage:"), Collections.singletonList(":female_mage:"), Collections.singletonList(":mage_woman:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "woman mage", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙‍♀
     */
    Emoji WOMAN_MAGE_MINIMALLY_QUALIFIED = new Emoji("🧙‍♀", "\uD83E\uDDD9\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 5.0, Qualification.fromString("minimally-qualified"), "woman mage", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏻‍♀️
     */
    Emoji WOMAN_MAGE_LIGHT_SKIN_TONE = new Emoji("🧙🏻‍♀️", "\uD83E\uDDD9\uD83C\uDFFB\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_mage_tone1:", ":woman_mage_light_skin_tone:", ":woman_mage::skin-tone-1:")), Collections.singletonList(":female_mage::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "woman mage: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏻‍♀
     */
    Emoji WOMAN_MAGE_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧙🏻‍♀", "\uD83E\uDDD9\uD83C\uDFFB\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "woman mage: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏼‍♀️
     */
    Emoji WOMAN_MAGE_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🧙🏼‍♀️", "\uD83E\uDDD9\uD83C\uDFFC\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_mage_tone2:", ":woman_mage_medium_light_skin_tone:", ":woman_mage::skin-tone-2:")), Collections.singletonList(":female_mage::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "woman mage: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏼‍♀
     */
    Emoji WOMAN_MAGE_MEDIUM_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧙🏼‍♀", "\uD83E\uDDD9\uD83C\uDFFC\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "woman mage: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏽‍♀️
     */
    Emoji WOMAN_MAGE_MEDIUM_SKIN_TONE = new Emoji("🧙🏽‍♀️", "\uD83E\uDDD9\uD83C\uDFFD\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_mage_tone3:", ":woman_mage_medium_skin_tone:", ":woman_mage::skin-tone-3:")), Collections.singletonList(":female_mage::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "woman mage: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏽‍♀
     */
    Emoji WOMAN_MAGE_MEDIUM_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧙🏽‍♀", "\uD83E\uDDD9\uD83C\uDFFD\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "woman mage: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏾‍♀️
     */
    Emoji WOMAN_MAGE_MEDIUM_DARK_SKIN_TONE = new Emoji("🧙🏾‍♀️", "\uD83E\uDDD9\uD83C\uDFFE\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_mage_tone4:", ":woman_mage_medium_dark_skin_tone:", ":woman_mage::skin-tone-4:")), Collections.singletonList(":female_mage::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "woman mage: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏾‍♀
     */
    Emoji WOMAN_MAGE_MEDIUM_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧙🏾‍♀", "\uD83E\uDDD9\uD83C\uDFFE\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "woman mage: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏿‍♀️
     */
    Emoji WOMAN_MAGE_DARK_SKIN_TONE = new Emoji("🧙🏿‍♀️", "\uD83E\uDDD9\uD83C\uDFFF\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_mage_tone5:", ":woman_mage_dark_skin_tone:", ":woman_mage::skin-tone-5:")), Collections.singletonList(":female_mage::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "woman mage: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧙🏿‍♀
     */
    Emoji WOMAN_MAGE_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧙🏿‍♀", "\uD83E\uDDD9\uD83C\uDFFF\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "woman mage: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚
     */
    Emoji FAIRY = new Emoji("🧚", "\uD83E\uDDDA", Collections.singletonList(":fairy:"), Collections.singletonList(":fairy:"), Collections.singletonList(":fairy:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "fairy", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏻
     */
    Emoji FAIRY_LIGHT_SKIN_TONE = new Emoji("🧚🏻", "\uD83E\uDDDA\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":fairy_tone1:", ":fairy_light_skin_tone:", ":fairy::skin-tone-1:")), Collections.singletonList(":fairy::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "fairy: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏼
     */
    Emoji FAIRY_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🧚🏼", "\uD83E\uDDDA\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":fairy_tone2:", ":fairy_medium_light_skin_tone:", ":fairy::skin-tone-2:")), Collections.singletonList(":fairy::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "fairy: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏽
     */
    Emoji FAIRY_MEDIUM_SKIN_TONE = new Emoji("🧚🏽", "\uD83E\uDDDA\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":fairy_tone3:", ":fairy_medium_skin_tone:", ":fairy::skin-tone-3:")), Collections.singletonList(":fairy::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "fairy: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏾
     */
    Emoji FAIRY_MEDIUM_DARK_SKIN_TONE = new Emoji("🧚🏾", "\uD83E\uDDDA\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":fairy_tone4:", ":fairy_medium_dark_skin_tone:", ":fairy::skin-tone-4:")), Collections.singletonList(":fairy::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "fairy: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏿
     */
    Emoji FAIRY_DARK_SKIN_TONE = new Emoji("🧚🏿", "\uD83E\uDDDA\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":fairy_tone5:", ":fairy_dark_skin_tone:", ":fairy::skin-tone-5:")), Collections.singletonList(":fairy::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "fairy: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚‍♂️
     */
    Emoji MAN_FAIRY = new Emoji("🧚‍♂️", "\uD83E\uDDDA\u200D\u2642\uFE0F", Collections.singletonList(":man_fairy:"), Collections.singletonList(":male_fairy:"), Collections.singletonList(":fairy_man:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "man fairy", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚‍♂
     */
    Emoji MAN_FAIRY_MINIMALLY_QUALIFIED = new Emoji("🧚‍♂", "\uD83E\uDDDA\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 5.0, Qualification.fromString("minimally-qualified"), "man fairy", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏻‍♂️
     */
    Emoji MAN_FAIRY_LIGHT_SKIN_TONE = new Emoji("🧚🏻‍♂️", "\uD83E\uDDDA\uD83C\uDFFB\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_fairy_tone1:", ":man_fairy_light_skin_tone:", ":man_fairy::skin-tone-1:")), Collections.singletonList(":male_fairy::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "man fairy: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏻‍♂
     */
    Emoji MAN_FAIRY_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧚🏻‍♂", "\uD83E\uDDDA\uD83C\uDFFB\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "man fairy: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏼‍♂️
     */
    Emoji MAN_FAIRY_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🧚🏼‍♂️", "\uD83E\uDDDA\uD83C\uDFFC\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_fairy_tone2:", ":man_fairy_medium_light_skin_tone:", ":man_fairy::skin-tone-2:")), Collections.singletonList(":male_fairy::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "man fairy: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏼‍♂
     */
    Emoji MAN_FAIRY_MEDIUM_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧚🏼‍♂", "\uD83E\uDDDA\uD83C\uDFFC\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "man fairy: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏽‍♂️
     */
    Emoji MAN_FAIRY_MEDIUM_SKIN_TONE = new Emoji("🧚🏽‍♂️", "\uD83E\uDDDA\uD83C\uDFFD\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_fairy_tone3:", ":man_fairy_medium_skin_tone:", ":man_fairy::skin-tone-3:")), Collections.singletonList(":male_fairy::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "man fairy: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏽‍♂
     */
    Emoji MAN_FAIRY_MEDIUM_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧚🏽‍♂", "\uD83E\uDDDA\uD83C\uDFFD\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "man fairy: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏾‍♂️
     */
    Emoji MAN_FAIRY_MEDIUM_DARK_SKIN_TONE = new Emoji("🧚🏾‍♂️", "\uD83E\uDDDA\uD83C\uDFFE\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_fairy_tone4:", ":man_fairy_medium_dark_skin_tone:", ":man_fairy::skin-tone-4:")), Collections.singletonList(":male_fairy::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "man fairy: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏾‍♂
     */
    Emoji MAN_FAIRY_MEDIUM_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧚🏾‍♂", "\uD83E\uDDDA\uD83C\uDFFE\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "man fairy: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏿‍♂️
     */
    Emoji MAN_FAIRY_DARK_SKIN_TONE = new Emoji("🧚🏿‍♂️", "\uD83E\uDDDA\uD83C\uDFFF\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_fairy_tone5:", ":man_fairy_dark_skin_tone:", ":man_fairy::skin-tone-5:")), Collections.singletonList(":male_fairy::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "man fairy: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏿‍♂
     */
    Emoji MAN_FAIRY_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧚🏿‍♂", "\uD83E\uDDDA\uD83C\uDFFF\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "man fairy: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚‍♀️
     */
    Emoji WOMAN_FAIRY = new Emoji("🧚‍♀️", "\uD83E\uDDDA\u200D\u2640\uFE0F", Collections.singletonList(":woman_fairy:"), Collections.singletonList(":female_fairy:"), Collections.singletonList(":fairy_woman:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "woman fairy", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚‍♀
     */
    Emoji WOMAN_FAIRY_MINIMALLY_QUALIFIED = new Emoji("🧚‍♀", "\uD83E\uDDDA\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 5.0, Qualification.fromString("minimally-qualified"), "woman fairy", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏻‍♀️
     */
    Emoji WOMAN_FAIRY_LIGHT_SKIN_TONE = new Emoji("🧚🏻‍♀️", "\uD83E\uDDDA\uD83C\uDFFB\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_fairy_tone1:", ":woman_fairy_light_skin_tone:", ":woman_fairy::skin-tone-1:")), Collections.singletonList(":female_fairy::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "woman fairy: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏻‍♀
     */
    Emoji WOMAN_FAIRY_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧚🏻‍♀", "\uD83E\uDDDA\uD83C\uDFFB\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "woman fairy: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏼‍♀️
     */
    Emoji WOMAN_FAIRY_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🧚🏼‍♀️", "\uD83E\uDDDA\uD83C\uDFFC\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_fairy_tone2:", ":woman_fairy_medium_light_skin_tone:", ":woman_fairy::skin-tone-2:")), Collections.singletonList(":female_fairy::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "woman fairy: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏼‍♀
     */
    Emoji WOMAN_FAIRY_MEDIUM_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧚🏼‍♀", "\uD83E\uDDDA\uD83C\uDFFC\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "woman fairy: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏽‍♀️
     */
    Emoji WOMAN_FAIRY_MEDIUM_SKIN_TONE = new Emoji("🧚🏽‍♀️", "\uD83E\uDDDA\uD83C\uDFFD\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_fairy_tone3:", ":woman_fairy_medium_skin_tone:", ":woman_fairy::skin-tone-3:")), Collections.singletonList(":female_fairy::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "woman fairy: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏽‍♀
     */
    Emoji WOMAN_FAIRY_MEDIUM_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧚🏽‍♀", "\uD83E\uDDDA\uD83C\uDFFD\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "woman fairy: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏾‍♀️
     */
    Emoji WOMAN_FAIRY_MEDIUM_DARK_SKIN_TONE = new Emoji("🧚🏾‍♀️", "\uD83E\uDDDA\uD83C\uDFFE\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_fairy_tone4:", ":woman_fairy_medium_dark_skin_tone:", ":woman_fairy::skin-tone-4:")), Collections.singletonList(":female_fairy::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "woman fairy: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏾‍♀
     */
    Emoji WOMAN_FAIRY_MEDIUM_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧚🏾‍♀", "\uD83E\uDDDA\uD83C\uDFFE\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "woman fairy: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏿‍♀️
     */
    Emoji WOMAN_FAIRY_DARK_SKIN_TONE = new Emoji("🧚🏿‍♀️", "\uD83E\uDDDA\uD83C\uDFFF\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_fairy_tone5:", ":woman_fairy_dark_skin_tone:", ":woman_fairy::skin-tone-5:")), Collections.singletonList(":female_fairy::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "woman fairy: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧚🏿‍♀
     */
    Emoji WOMAN_FAIRY_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧚🏿‍♀", "\uD83E\uDDDA\uD83C\uDFFF\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "woman fairy: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛
     */
    Emoji VAMPIRE = new Emoji("🧛", "\uD83E\uDDDB", Collections.singletonList(":vampire:"), Collections.singletonList(":vampire:"), Collections.singletonList(":vampire:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "vampire", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏻
     */
    Emoji VAMPIRE_LIGHT_SKIN_TONE = new Emoji("🧛🏻", "\uD83E\uDDDB\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":vampire_tone1:", ":vampire_light_skin_tone:", ":vampire::skin-tone-1:")), Collections.singletonList(":vampire::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "vampire: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏼
     */
    Emoji VAMPIRE_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🧛🏼", "\uD83E\uDDDB\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":vampire_tone2:", ":vampire_medium_light_skin_tone:", ":vampire::skin-tone-2:")), Collections.singletonList(":vampire::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "vampire: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏽
     */
    Emoji VAMPIRE_MEDIUM_SKIN_TONE = new Emoji("🧛🏽", "\uD83E\uDDDB\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":vampire_tone3:", ":vampire_medium_skin_tone:", ":vampire::skin-tone-3:")), Collections.singletonList(":vampire::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "vampire: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏾
     */
    Emoji VAMPIRE_MEDIUM_DARK_SKIN_TONE = new Emoji("🧛🏾", "\uD83E\uDDDB\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":vampire_tone4:", ":vampire_medium_dark_skin_tone:", ":vampire::skin-tone-4:")), Collections.singletonList(":vampire::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "vampire: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏿
     */
    Emoji VAMPIRE_DARK_SKIN_TONE = new Emoji("🧛🏿", "\uD83E\uDDDB\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":vampire_tone5:", ":vampire_dark_skin_tone:", ":vampire::skin-tone-5:")), Collections.singletonList(":vampire::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "vampire: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛‍♂️
     */
    Emoji MAN_VAMPIRE = new Emoji("🧛‍♂️", "\uD83E\uDDDB\u200D\u2642\uFE0F", Collections.singletonList(":man_vampire:"), Collections.singletonList(":male_vampire:"), Collections.singletonList(":vampire_man:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "man vampire", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛‍♂
     */
    Emoji MAN_VAMPIRE_MINIMALLY_QUALIFIED = new Emoji("🧛‍♂", "\uD83E\uDDDB\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 5.0, Qualification.fromString("minimally-qualified"), "man vampire", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏻‍♂️
     */
    Emoji MAN_VAMPIRE_LIGHT_SKIN_TONE = new Emoji("🧛🏻‍♂️", "\uD83E\uDDDB\uD83C\uDFFB\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_vampire_tone1:", ":man_vampire_light_skin_tone:", ":man_vampire::skin-tone-1:")), Collections.singletonList(":male_vampire::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "man vampire: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏻‍♂
     */
    Emoji MAN_VAMPIRE_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧛🏻‍♂", "\uD83E\uDDDB\uD83C\uDFFB\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "man vampire: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏼‍♂️
     */
    Emoji MAN_VAMPIRE_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🧛🏼‍♂️", "\uD83E\uDDDB\uD83C\uDFFC\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_vampire_tone2:", ":man_vampire_medium_light_skin_tone:", ":man_vampire::skin-tone-2:")), Collections.singletonList(":male_vampire::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "man vampire: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏼‍♂
     */
    Emoji MAN_VAMPIRE_MEDIUM_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧛🏼‍♂", "\uD83E\uDDDB\uD83C\uDFFC\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "man vampire: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏽‍♂️
     */
    Emoji MAN_VAMPIRE_MEDIUM_SKIN_TONE = new Emoji("🧛🏽‍♂️", "\uD83E\uDDDB\uD83C\uDFFD\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_vampire_tone3:", ":man_vampire_medium_skin_tone:", ":man_vampire::skin-tone-3:")), Collections.singletonList(":male_vampire::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "man vampire: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏽‍♂
     */
    Emoji MAN_VAMPIRE_MEDIUM_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧛🏽‍♂", "\uD83E\uDDDB\uD83C\uDFFD\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "man vampire: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏾‍♂️
     */
    Emoji MAN_VAMPIRE_MEDIUM_DARK_SKIN_TONE = new Emoji("🧛🏾‍♂️", "\uD83E\uDDDB\uD83C\uDFFE\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_vampire_tone4:", ":man_vampire_medium_dark_skin_tone:", ":man_vampire::skin-tone-4:")), Collections.singletonList(":male_vampire::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "man vampire: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏾‍♂
     */
    Emoji MAN_VAMPIRE_MEDIUM_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧛🏾‍♂", "\uD83E\uDDDB\uD83C\uDFFE\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "man vampire: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏿‍♂️
     */
    Emoji MAN_VAMPIRE_DARK_SKIN_TONE = new Emoji("🧛🏿‍♂️", "\uD83E\uDDDB\uD83C\uDFFF\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_vampire_tone5:", ":man_vampire_dark_skin_tone:", ":man_vampire::skin-tone-5:")), Collections.singletonList(":male_vampire::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "man vampire: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏿‍♂
     */
    Emoji MAN_VAMPIRE_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧛🏿‍♂", "\uD83E\uDDDB\uD83C\uDFFF\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "man vampire: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛‍♀️
     */
    Emoji WOMAN_VAMPIRE = new Emoji("🧛‍♀️", "\uD83E\uDDDB\u200D\u2640\uFE0F", Collections.singletonList(":woman_vampire:"), Collections.singletonList(":female_vampire:"), Collections.singletonList(":vampire_woman:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "woman vampire", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛‍♀
     */
    Emoji WOMAN_VAMPIRE_MINIMALLY_QUALIFIED = new Emoji("🧛‍♀", "\uD83E\uDDDB\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 5.0, Qualification.fromString("minimally-qualified"), "woman vampire", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏻‍♀️
     */
    Emoji WOMAN_VAMPIRE_LIGHT_SKIN_TONE = new Emoji("🧛🏻‍♀️", "\uD83E\uDDDB\uD83C\uDFFB\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_vampire_tone1:", ":woman_vampire_light_skin_tone:", ":woman_vampire::skin-tone-1:")), Collections.singletonList(":female_vampire::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "woman vampire: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏻‍♀
     */
    Emoji WOMAN_VAMPIRE_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧛🏻‍♀", "\uD83E\uDDDB\uD83C\uDFFB\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "woman vampire: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏼‍♀️
     */
    Emoji WOMAN_VAMPIRE_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🧛🏼‍♀️", "\uD83E\uDDDB\uD83C\uDFFC\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_vampire_tone2:", ":woman_vampire_medium_light_skin_tone:", ":woman_vampire::skin-tone-2:")), Collections.singletonList(":female_vampire::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "woman vampire: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏼‍♀
     */
    Emoji WOMAN_VAMPIRE_MEDIUM_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧛🏼‍♀", "\uD83E\uDDDB\uD83C\uDFFC\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "woman vampire: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏽‍♀️
     */
    Emoji WOMAN_VAMPIRE_MEDIUM_SKIN_TONE = new Emoji("🧛🏽‍♀️", "\uD83E\uDDDB\uD83C\uDFFD\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_vampire_tone3:", ":woman_vampire_medium_skin_tone:", ":woman_vampire::skin-tone-3:")), Collections.singletonList(":female_vampire::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "woman vampire: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏽‍♀
     */
    Emoji WOMAN_VAMPIRE_MEDIUM_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧛🏽‍♀", "\uD83E\uDDDB\uD83C\uDFFD\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "woman vampire: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏾‍♀️
     */
    Emoji WOMAN_VAMPIRE_MEDIUM_DARK_SKIN_TONE = new Emoji("🧛🏾‍♀️", "\uD83E\uDDDB\uD83C\uDFFE\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_vampire_tone4:", ":woman_vampire_medium_dark_skin_tone:", ":woman_vampire::skin-tone-4:")), Collections.singletonList(":female_vampire::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "woman vampire: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏾‍♀
     */
    Emoji WOMAN_VAMPIRE_MEDIUM_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧛🏾‍♀", "\uD83E\uDDDB\uD83C\uDFFE\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "woman vampire: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏿‍♀️
     */
    Emoji WOMAN_VAMPIRE_DARK_SKIN_TONE = new Emoji("🧛🏿‍♀️", "\uD83E\uDDDB\uD83C\uDFFF\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_vampire_tone5:", ":woman_vampire_dark_skin_tone:", ":woman_vampire::skin-tone-5:")), Collections.singletonList(":female_vampire::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "woman vampire: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧛🏿‍♀
     */
    Emoji WOMAN_VAMPIRE_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧛🏿‍♀", "\uD83E\uDDDB\uD83C\uDFFF\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "woman vampire: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜
     */
    Emoji MERPERSON = new Emoji("🧜", "\uD83E\uDDDC", Collections.singletonList(":merperson:"), Collections.singletonList(":merperson:"), Collections.singletonList(":merperson:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "merperson", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏻
     */
    Emoji MERPERSON_LIGHT_SKIN_TONE = new Emoji("🧜🏻", "\uD83E\uDDDC\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":merperson_tone1:", ":merperson_light_skin_tone:", ":merperson::skin-tone-1:")), Collections.singletonList(":merperson::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "merperson: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏼
     */
    Emoji MERPERSON_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🧜🏼", "\uD83E\uDDDC\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":merperson_tone2:", ":merperson_medium_light_skin_tone:", ":merperson::skin-tone-2:")), Collections.singletonList(":merperson::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "merperson: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏽
     */
    Emoji MERPERSON_MEDIUM_SKIN_TONE = new Emoji("🧜🏽", "\uD83E\uDDDC\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":merperson_tone3:", ":merperson_medium_skin_tone:", ":merperson::skin-tone-3:")), Collections.singletonList(":merperson::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "merperson: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏾
     */
    Emoji MERPERSON_MEDIUM_DARK_SKIN_TONE = new Emoji("🧜🏾", "\uD83E\uDDDC\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":merperson_tone4:", ":merperson_medium_dark_skin_tone:", ":merperson::skin-tone-4:")), Collections.singletonList(":merperson::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "merperson: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏿
     */
    Emoji MERPERSON_DARK_SKIN_TONE = new Emoji("🧜🏿", "\uD83E\uDDDC\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":merperson_tone5:", ":merperson_dark_skin_tone:", ":merperson::skin-tone-5:")), Collections.singletonList(":merperson::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "merperson: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜‍♂️
     */
    Emoji MERMAN = new Emoji("🧜‍♂️", "\uD83E\uDDDC\u200D\u2642\uFE0F", Collections.singletonList(":merman:"), Collections.singletonList(":merman:"), Collections.singletonList(":merman:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "merman", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜‍♂
     */
    Emoji MERMAN_MINIMALLY_QUALIFIED = new Emoji("🧜‍♂", "\uD83E\uDDDC\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 5.0, Qualification.fromString("minimally-qualified"), "merman", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏻‍♂️
     */
    Emoji MERMAN_LIGHT_SKIN_TONE = new Emoji("🧜🏻‍♂️", "\uD83E\uDDDC\uD83C\uDFFB\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":merman_tone1:", ":merman_light_skin_tone:", ":merman::skin-tone-1:")), Collections.singletonList(":merman::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "merman: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏻‍♂
     */
    Emoji MERMAN_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧜🏻‍♂", "\uD83E\uDDDC\uD83C\uDFFB\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "merman: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏼‍♂️
     */
    Emoji MERMAN_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🧜🏼‍♂️", "\uD83E\uDDDC\uD83C\uDFFC\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":merman_tone2:", ":merman_medium_light_skin_tone:", ":merman::skin-tone-2:")), Collections.singletonList(":merman::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "merman: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏼‍♂
     */
    Emoji MERMAN_MEDIUM_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧜🏼‍♂", "\uD83E\uDDDC\uD83C\uDFFC\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "merman: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏽‍♂️
     */
    Emoji MERMAN_MEDIUM_SKIN_TONE = new Emoji("🧜🏽‍♂️", "\uD83E\uDDDC\uD83C\uDFFD\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":merman_tone3:", ":merman_medium_skin_tone:", ":merman::skin-tone-3:")), Collections.singletonList(":merman::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "merman: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏽‍♂
     */
    Emoji MERMAN_MEDIUM_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧜🏽‍♂", "\uD83E\uDDDC\uD83C\uDFFD\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "merman: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏾‍♂️
     */
    Emoji MERMAN_MEDIUM_DARK_SKIN_TONE = new Emoji("🧜🏾‍♂️", "\uD83E\uDDDC\uD83C\uDFFE\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":merman_tone4:", ":merman_medium_dark_skin_tone:", ":merman::skin-tone-4:")), Collections.singletonList(":merman::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "merman: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏾‍♂
     */
    Emoji MERMAN_MEDIUM_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧜🏾‍♂", "\uD83E\uDDDC\uD83C\uDFFE\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "merman: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏿‍♂️
     */
    Emoji MERMAN_DARK_SKIN_TONE = new Emoji("🧜🏿‍♂️", "\uD83E\uDDDC\uD83C\uDFFF\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":merman_tone5:", ":merman_dark_skin_tone:", ":merman::skin-tone-5:")), Collections.singletonList(":merman::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "merman: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏿‍♂
     */
    Emoji MERMAN_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧜🏿‍♂", "\uD83E\uDDDC\uD83C\uDFFF\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "merman: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜‍♀️
     */
    Emoji MERMAID = new Emoji("🧜‍♀️", "\uD83E\uDDDC\u200D\u2640\uFE0F", Collections.singletonList(":mermaid:"), Collections.singletonList(":mermaid:"), Collections.singletonList(":mermaid:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "mermaid", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜‍♀
     */
    Emoji MERMAID_MINIMALLY_QUALIFIED = new Emoji("🧜‍♀", "\uD83E\uDDDC\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 5.0, Qualification.fromString("minimally-qualified"), "mermaid", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏻‍♀️
     */
    Emoji MERMAID_LIGHT_SKIN_TONE = new Emoji("🧜🏻‍♀️", "\uD83E\uDDDC\uD83C\uDFFB\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":mermaid_tone1:", ":mermaid_light_skin_tone:", ":mermaid::skin-tone-1:")), Collections.singletonList(":mermaid::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "mermaid: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏻‍♀
     */
    Emoji MERMAID_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧜🏻‍♀", "\uD83E\uDDDC\uD83C\uDFFB\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "mermaid: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏼‍♀️
     */
    Emoji MERMAID_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🧜🏼‍♀️", "\uD83E\uDDDC\uD83C\uDFFC\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":mermaid_tone2:", ":mermaid_medium_light_skin_tone:", ":mermaid::skin-tone-2:")), Collections.singletonList(":mermaid::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "mermaid: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏼‍♀
     */
    Emoji MERMAID_MEDIUM_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧜🏼‍♀", "\uD83E\uDDDC\uD83C\uDFFC\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "mermaid: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏽‍♀️
     */
    Emoji MERMAID_MEDIUM_SKIN_TONE = new Emoji("🧜🏽‍♀️", "\uD83E\uDDDC\uD83C\uDFFD\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":mermaid_tone3:", ":mermaid_medium_skin_tone:", ":mermaid::skin-tone-3:")), Collections.singletonList(":mermaid::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "mermaid: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏽‍♀
     */
    Emoji MERMAID_MEDIUM_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧜🏽‍♀", "\uD83E\uDDDC\uD83C\uDFFD\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "mermaid: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏾‍♀️
     */
    Emoji MERMAID_MEDIUM_DARK_SKIN_TONE = new Emoji("🧜🏾‍♀️", "\uD83E\uDDDC\uD83C\uDFFE\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":mermaid_tone4:", ":mermaid_medium_dark_skin_tone:", ":mermaid::skin-tone-4:")), Collections.singletonList(":mermaid::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "mermaid: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏾‍♀
     */
    Emoji MERMAID_MEDIUM_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧜🏾‍♀", "\uD83E\uDDDC\uD83C\uDFFE\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "mermaid: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏿‍♀️
     */
    Emoji MERMAID_DARK_SKIN_TONE = new Emoji("🧜🏿‍♀️", "\uD83E\uDDDC\uD83C\uDFFF\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":mermaid_tone5:", ":mermaid_dark_skin_tone:", ":mermaid::skin-tone-5:")), Collections.singletonList(":mermaid::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "mermaid: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧜🏿‍♀
     */
    Emoji MERMAID_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧜🏿‍♀", "\uD83E\uDDDC\uD83C\uDFFF\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "mermaid: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝
     */
    Emoji ELF = new Emoji("🧝", "\uD83E\uDDDD", Collections.singletonList(":elf:"), Collections.singletonList(":elf:"), Collections.singletonList(":elf:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "elf", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏻
     */
    Emoji ELF_LIGHT_SKIN_TONE = new Emoji("🧝🏻", "\uD83E\uDDDD\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":elf_tone1:", ":elf_light_skin_tone:", ":elf::skin-tone-1:")), Collections.singletonList(":elf::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "elf: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏼
     */
    Emoji ELF_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🧝🏼", "\uD83E\uDDDD\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":elf_tone2:", ":elf_medium_light_skin_tone:", ":elf::skin-tone-2:")), Collections.singletonList(":elf::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "elf: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏽
     */
    Emoji ELF_MEDIUM_SKIN_TONE = new Emoji("🧝🏽", "\uD83E\uDDDD\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":elf_tone3:", ":elf_medium_skin_tone:", ":elf::skin-tone-3:")), Collections.singletonList(":elf::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "elf: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏾
     */
    Emoji ELF_MEDIUM_DARK_SKIN_TONE = new Emoji("🧝🏾", "\uD83E\uDDDD\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":elf_tone4:", ":elf_medium_dark_skin_tone:", ":elf::skin-tone-4:")), Collections.singletonList(":elf::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "elf: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏿
     */
    Emoji ELF_DARK_SKIN_TONE = new Emoji("🧝🏿", "\uD83E\uDDDD\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":elf_tone5:", ":elf_dark_skin_tone:", ":elf::skin-tone-5:")), Collections.singletonList(":elf::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "elf: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝‍♂️
     */
    Emoji MAN_ELF = new Emoji("🧝‍♂️", "\uD83E\uDDDD\u200D\u2642\uFE0F", Collections.singletonList(":man_elf:"), Collections.singletonList(":male_elf:"), Collections.singletonList(":elf_man:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "man elf", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝‍♂
     */
    Emoji MAN_ELF_MINIMALLY_QUALIFIED = new Emoji("🧝‍♂", "\uD83E\uDDDD\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 5.0, Qualification.fromString("minimally-qualified"), "man elf", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏻‍♂️
     */
    Emoji MAN_ELF_LIGHT_SKIN_TONE = new Emoji("🧝🏻‍♂️", "\uD83E\uDDDD\uD83C\uDFFB\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_elf_tone1:", ":man_elf_light_skin_tone:", ":man_elf::skin-tone-1:")), Collections.singletonList(":male_elf::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "man elf: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏻‍♂
     */
    Emoji MAN_ELF_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧝🏻‍♂", "\uD83E\uDDDD\uD83C\uDFFB\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "man elf: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏼‍♂️
     */
    Emoji MAN_ELF_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🧝🏼‍♂️", "\uD83E\uDDDD\uD83C\uDFFC\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_elf_tone2:", ":man_elf_medium_light_skin_tone:", ":man_elf::skin-tone-2:")), Collections.singletonList(":male_elf::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "man elf: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏼‍♂
     */
    Emoji MAN_ELF_MEDIUM_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧝🏼‍♂", "\uD83E\uDDDD\uD83C\uDFFC\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "man elf: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏽‍♂️
     */
    Emoji MAN_ELF_MEDIUM_SKIN_TONE = new Emoji("🧝🏽‍♂️", "\uD83E\uDDDD\uD83C\uDFFD\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_elf_tone3:", ":man_elf_medium_skin_tone:", ":man_elf::skin-tone-3:")), Collections.singletonList(":male_elf::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "man elf: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏽‍♂
     */
    Emoji MAN_ELF_MEDIUM_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧝🏽‍♂", "\uD83E\uDDDD\uD83C\uDFFD\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "man elf: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏾‍♂️
     */
    Emoji MAN_ELF_MEDIUM_DARK_SKIN_TONE = new Emoji("🧝🏾‍♂️", "\uD83E\uDDDD\uD83C\uDFFE\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_elf_tone4:", ":man_elf_medium_dark_skin_tone:", ":man_elf::skin-tone-4:")), Collections.singletonList(":male_elf::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "man elf: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏾‍♂
     */
    Emoji MAN_ELF_MEDIUM_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧝🏾‍♂", "\uD83E\uDDDD\uD83C\uDFFE\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "man elf: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏿‍♂️
     */
    Emoji MAN_ELF_DARK_SKIN_TONE = new Emoji("🧝🏿‍♂️", "\uD83E\uDDDD\uD83C\uDFFF\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_elf_tone5:", ":man_elf_dark_skin_tone:", ":man_elf::skin-tone-5:")), Collections.singletonList(":male_elf::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "man elf: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏿‍♂
     */
    Emoji MAN_ELF_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧝🏿‍♂", "\uD83E\uDDDD\uD83C\uDFFF\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "man elf: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝‍♀️
     */
    Emoji WOMAN_ELF = new Emoji("🧝‍♀️", "\uD83E\uDDDD\u200D\u2640\uFE0F", Collections.singletonList(":woman_elf:"), Collections.singletonList(":female_elf:"), Collections.singletonList(":elf_woman:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "woman elf", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝‍♀
     */
    Emoji WOMAN_ELF_MINIMALLY_QUALIFIED = new Emoji("🧝‍♀", "\uD83E\uDDDD\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 5.0, Qualification.fromString("minimally-qualified"), "woman elf", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏻‍♀️
     */
    Emoji WOMAN_ELF_LIGHT_SKIN_TONE = new Emoji("🧝🏻‍♀️", "\uD83E\uDDDD\uD83C\uDFFB\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_elf_tone1:", ":woman_elf_light_skin_tone:", ":woman_elf::skin-tone-1:")), Collections.singletonList(":female_elf::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "woman elf: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏻‍♀
     */
    Emoji WOMAN_ELF_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧝🏻‍♀", "\uD83E\uDDDD\uD83C\uDFFB\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "woman elf: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏼‍♀️
     */
    Emoji WOMAN_ELF_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🧝🏼‍♀️", "\uD83E\uDDDD\uD83C\uDFFC\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_elf_tone2:", ":woman_elf_medium_light_skin_tone:", ":woman_elf::skin-tone-2:")), Collections.singletonList(":female_elf::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "woman elf: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏼‍♀
     */
    Emoji WOMAN_ELF_MEDIUM_LIGHT_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧝🏼‍♀", "\uD83E\uDDDD\uD83C\uDFFC\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "woman elf: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏽‍♀️
     */
    Emoji WOMAN_ELF_MEDIUM_SKIN_TONE = new Emoji("🧝🏽‍♀️", "\uD83E\uDDDD\uD83C\uDFFD\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_elf_tone3:", ":woman_elf_medium_skin_tone:", ":woman_elf::skin-tone-3:")), Collections.singletonList(":female_elf::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "woman elf: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏽‍♀
     */
    Emoji WOMAN_ELF_MEDIUM_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧝🏽‍♀", "\uD83E\uDDDD\uD83C\uDFFD\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "woman elf: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏾‍♀️
     */
    Emoji WOMAN_ELF_MEDIUM_DARK_SKIN_TONE = new Emoji("🧝🏾‍♀️", "\uD83E\uDDDD\uD83C\uDFFE\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_elf_tone4:", ":woman_elf_medium_dark_skin_tone:", ":woman_elf::skin-tone-4:")), Collections.singletonList(":female_elf::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "woman elf: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏾‍♀
     */
    Emoji WOMAN_ELF_MEDIUM_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧝🏾‍♀", "\uD83E\uDDDD\uD83C\uDFFE\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "woman elf: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏿‍♀️
     */
    Emoji WOMAN_ELF_DARK_SKIN_TONE = new Emoji("🧝🏿‍♀️", "\uD83E\uDDDD\uD83C\uDFFF\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_elf_tone5:", ":woman_elf_dark_skin_tone:", ":woman_elf::skin-tone-5:")), Collections.singletonList(":female_elf::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "woman elf: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧝🏿‍♀
     */
    Emoji WOMAN_ELF_DARK_SKIN_TONE_MINIMALLY_QUALIFIED = new Emoji("🧝🏿‍♀", "\uD83E\uDDDD\uD83C\uDFFF\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 5.0, Qualification.fromString("minimally-qualified"), "woman elf: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧞
     */
    Emoji GENIE = new Emoji("🧞", "\uD83E\uDDDE", Collections.singletonList(":genie:"), Collections.singletonList(":genie:"), Collections.singletonList(":genie:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "genie", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧞‍♂️
     */
    Emoji MAN_GENIE = new Emoji("🧞‍♂️", "\uD83E\uDDDE\u200D\u2642\uFE0F", Collections.singletonList(":man_genie:"), Collections.singletonList(":male_genie:"), Collections.singletonList(":genie_man:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "man genie", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧞‍♂
     */
    Emoji MAN_GENIE_MINIMALLY_QUALIFIED = new Emoji("🧞‍♂", "\uD83E\uDDDE\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 5.0, Qualification.fromString("minimally-qualified"), "man genie", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧞‍♀️
     */
    Emoji WOMAN_GENIE = new Emoji("🧞‍♀️", "\uD83E\uDDDE\u200D\u2640\uFE0F", Collections.singletonList(":woman_genie:"), Collections.singletonList(":female_genie:"), Collections.singletonList(":genie_woman:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "woman genie", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧞‍♀
     */
    Emoji WOMAN_GENIE_MINIMALLY_QUALIFIED = new Emoji("🧞‍♀", "\uD83E\uDDDE\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 5.0, Qualification.fromString("minimally-qualified"), "woman genie", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧟
     */
    Emoji ZOMBIE = new Emoji("🧟", "\uD83E\uDDDF", Collections.singletonList(":zombie:"), Collections.singletonList(":zombie:"), Collections.singletonList(":zombie:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "zombie", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧟‍♂️
     */
    Emoji MAN_ZOMBIE = new Emoji("🧟‍♂️", "\uD83E\uDDDF\u200D\u2642\uFE0F", Collections.singletonList(":man_zombie:"), Collections.singletonList(":male_zombie:"), Collections.singletonList(":zombie_man:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "man zombie", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧟‍♂
     */
    Emoji MAN_ZOMBIE_MINIMALLY_QUALIFIED = new Emoji("🧟‍♂", "\uD83E\uDDDF\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 5.0, Qualification.fromString("minimally-qualified"), "man zombie", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧟‍♀️
     */
    Emoji WOMAN_ZOMBIE = new Emoji("🧟‍♀️", "\uD83E\uDDDF\u200D\u2640\uFE0F", Collections.singletonList(":woman_zombie:"), Collections.singletonList(":female_zombie:"), Collections.singletonList(":zombie_woman:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "woman zombie", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧟‍♀
     */
    Emoji WOMAN_ZOMBIE_MINIMALLY_QUALIFIED = new Emoji("🧟‍♀", "\uD83E\uDDDF\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 5.0, Qualification.fromString("minimally-qualified"), "woman zombie", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);

    /**
     * 🧌
     */
    Emoji TROLL = new Emoji("🧌", "\uD83E\uDDCC", Collections.singletonList(":troll:"), Collections.emptyList(), Collections.singletonList(":troll:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "troll", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_FANTASY, false);
}
