package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiPlaceBuilding {

    /**
     * 🏟️
     */
    Emoji STADIUM = new Emoji("🏟️", "\uD83C\uDFDF\uFE0F", Collections.singletonList(":stadium:"), Collections.singletonList(":stadium:"), Collections.singletonList(":stadium:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "stadium", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🏟
     */
    Emoji STADIUM_UNQUALIFIED = new Emoji("🏟", "\uD83C\uDFDF", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":stadium:"), false, false, 0.7, Qualification.fromString("unqualified"), "stadium", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, true);

    /**
     * 🏛️
     */
    Emoji CLASSICAL_BUILDING = new Emoji("🏛️", "\uD83C\uDFDB\uFE0F", Collections.singletonList(":classical_building:"), Collections.singletonList(":classical_building:"), Collections.singletonList(":classical_building:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "classical building", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🏛
     */
    Emoji CLASSICAL_BUILDING_UNQUALIFIED = new Emoji("🏛", "\uD83C\uDFDB", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":classical_building:"), false, false, 0.7, Qualification.fromString("unqualified"), "classical building", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, true);

    /**
     * 🏗️
     */
    Emoji BUILDING_CONSTRUCTION = new Emoji("🏗️", "\uD83C\uDFD7\uFE0F", Collections.unmodifiableList(Arrays.asList(":construction_site:", ":building_construction:")), Collections.singletonList(":building_construction:"), Collections.singletonList(":building_construction:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "building construction", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🏗
     */
    Emoji BUILDING_CONSTRUCTION_UNQUALIFIED = new Emoji("🏗", "\uD83C\uDFD7", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":building_construction:"), false, false, 0.7, Qualification.fromString("unqualified"), "building construction", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, true);

    /**
     * 🧱
     */
    Emoji BRICK = new Emoji("🧱", "\uD83E\uDDF1", Collections.unmodifiableList(Arrays.asList(":bricks:", ":brick:")), Collections.singletonList(":bricks:"), Collections.singletonList(":bricks:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "brick", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🪨
     */
    Emoji ROCK = new Emoji("🪨", "\uD83E\uDEA8", Collections.singletonList(":rock:"), Collections.singletonList(":rock:"), Collections.singletonList(":rock:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "rock", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🪵
     */
    Emoji WOOD = new Emoji("🪵", "\uD83E\uDEB5", Collections.singletonList(":wood:"), Collections.singletonList(":wood:"), Collections.singletonList(":wood:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "wood", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🛖
     */
    Emoji HUT = new Emoji("🛖", "\uD83D\uDED6", Collections.singletonList(":hut:"), Collections.singletonList(":hut:"), Collections.singletonList(":hut:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "hut", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🏘️
     */
    Emoji HOUSES = new Emoji("🏘️", "\uD83C\uDFD8\uFE0F", Collections.unmodifiableList(Arrays.asList(":homes:", ":house_buildings:", ":houses:")), Collections.singletonList(":house_buildings:"), Collections.singletonList(":houses:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "houses", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🏘
     */
    Emoji HOUSES_UNQUALIFIED = new Emoji("🏘", "\uD83C\uDFD8", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":houses:"), false, false, 0.7, Qualification.fromString("unqualified"), "houses", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, true);

    /**
     * 🏚️
     */
    Emoji DERELICT_HOUSE = new Emoji("🏚️", "\uD83C\uDFDA\uFE0F", Collections.unmodifiableList(Arrays.asList(":house_abandoned:", ":derelict_house_building:")), Collections.singletonList(":derelict_house_building:"), Collections.singletonList(":derelict_house:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "derelict house", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🏚
     */
    Emoji DERELICT_HOUSE_UNQUALIFIED = new Emoji("🏚", "\uD83C\uDFDA", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":derelict_house:"), false, false, 0.7, Qualification.fromString("unqualified"), "derelict house", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, true);

    /**
     * 🏠
     */
    Emoji HOUSE = new Emoji("🏠", "\uD83C\uDFE0", Collections.singletonList(":house:"), Collections.singletonList(":house:"), Collections.singletonList(":house:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "house", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, true);

    /**
     * 🏡
     */
    Emoji HOUSE_WITH_GARDEN = new Emoji("🏡", "\uD83C\uDFE1", Collections.singletonList(":house_with_garden:"), Collections.singletonList(":house_with_garden:"), Collections.singletonList(":house_with_garden:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "house with garden", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🏢
     */
    Emoji OFFICE_BUILDING = new Emoji("🏢", "\uD83C\uDFE2", Collections.singletonList(":office:"), Collections.singletonList(":office:"), Collections.singletonList(":office:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "office building", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🏣
     */
    Emoji JAPANESE_POST_OFFICE = new Emoji("🏣", "\uD83C\uDFE3", Collections.singletonList(":post_office:"), Collections.singletonList(":post_office:"), Collections.singletonList(":post_office:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese post office", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🏤
     */
    Emoji POST_OFFICE = new Emoji("🏤", "\uD83C\uDFE4", Collections.singletonList(":european_post_office:"), Collections.singletonList(":european_post_office:"), Collections.singletonList(":european_post_office:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "post office", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🏥
     */
    Emoji HOSPITAL = new Emoji("🏥", "\uD83C\uDFE5", Collections.singletonList(":hospital:"), Collections.singletonList(":hospital:"), Collections.singletonList(":hospital:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "hospital", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🏦
     */
    Emoji BANK = new Emoji("🏦", "\uD83C\uDFE6", Collections.singletonList(":bank:"), Collections.singletonList(":bank:"), Collections.singletonList(":bank:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "bank", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🏨
     */
    Emoji HOTEL = new Emoji("🏨", "\uD83C\uDFE8", Collections.singletonList(":hotel:"), Collections.singletonList(":hotel:"), Collections.singletonList(":hotel:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "hotel", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🏩
     */
    Emoji LOVE_HOTEL = new Emoji("🏩", "\uD83C\uDFE9", Collections.singletonList(":love_hotel:"), Collections.singletonList(":love_hotel:"), Collections.singletonList(":love_hotel:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "love hotel", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🏪
     */
    Emoji CONVENIENCE_STORE = new Emoji("🏪", "\uD83C\uDFEA", Collections.singletonList(":convenience_store:"), Collections.singletonList(":convenience_store:"), Collections.singletonList(":convenience_store:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "convenience store", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🏫
     */
    Emoji SCHOOL = new Emoji("🏫", "\uD83C\uDFEB", Collections.singletonList(":school:"), Collections.singletonList(":school:"), Collections.singletonList(":school:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "school", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🏬
     */
    Emoji DEPARTMENT_STORE = new Emoji("🏬", "\uD83C\uDFEC", Collections.singletonList(":department_store:"), Collections.singletonList(":department_store:"), Collections.singletonList(":department_store:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "department store", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🏭
     */
    Emoji FACTORY = new Emoji("🏭", "\uD83C\uDFED", Collections.singletonList(":factory:"), Collections.singletonList(":factory:"), Collections.singletonList(":factory:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "factory", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, true);

    /**
     * 🏯
     */
    Emoji JAPANESE_CASTLE = new Emoji("🏯", "\uD83C\uDFEF", Collections.singletonList(":japanese_castle:"), Collections.singletonList(":japanese_castle:"), Collections.singletonList(":japanese_castle:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Japanese castle", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🏰
     */
    Emoji CASTLE = new Emoji("🏰", "\uD83C\uDFF0", Collections.unmodifiableList(Arrays.asList(":european_castle:", ":castle:")), Collections.singletonList(":european_castle:"), Collections.singletonList(":european_castle:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "castle", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 💒
     */
    Emoji WEDDING = new Emoji("💒", "\uD83D\uDC92", Collections.singletonList(":wedding:"), Collections.singletonList(":wedding:"), Collections.singletonList(":wedding:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "wedding", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🗼
     */
    Emoji TOKYO_TOWER = new Emoji("🗼", "\uD83D\uDDFC", Collections.singletonList(":tokyo_tower:"), Collections.singletonList(":tokyo_tower:"), Collections.singletonList(":tokyo_tower:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Tokyo tower", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);

    /**
     * 🗽
     */
    Emoji STATUE_OF_LIBERTY = new Emoji("🗽", "\uD83D\uDDFD", Collections.singletonList(":statue_of_liberty:"), Collections.singletonList(":statue_of_liberty:"), Collections.singletonList(":statue_of_liberty:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Statue of Liberty", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_BUILDING, false);
}
