package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiPlaceMap {

    /**
     * 🌍
     */
    Emoji GLOBE_SHOWING_EUROPE_AFRICA = new Emoji("🌍", "\uD83C\uDF0D", Collections.singletonList(":earth_africa:"), Collections.singletonList(":earth_africa:"), Collections.singletonList(":earth_africa:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "globe showing Europe-Africa", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_MAP, true);

    /**
     * 🌎
     */
    Emoji GLOBE_SHOWING_AMERICAS = new Emoji("🌎", "\uD83C\uDF0E", Collections.singletonList(":earth_americas:"), Collections.singletonList(":earth_americas:"), Collections.singletonList(":earth_americas:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "globe showing Americas", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_MAP, true);

    /**
     * 🌏
     */
    Emoji GLOBE_SHOWING_ASIA_AUSTRALIA = new Emoji("🌏", "\uD83C\uDF0F", Collections.singletonList(":earth_asia:"), Collections.singletonList(":earth_asia:"), Collections.singletonList(":earth_asia:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "globe showing Asia-Australia", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_MAP, true);

    /**
     * 🌐
     */
    Emoji GLOBE_WITH_MERIDIANS = new Emoji("🌐", "\uD83C\uDF10", Collections.singletonList(":globe_with_meridians:"), Collections.singletonList(":globe_with_meridians:"), Collections.singletonList(":globe_with_meridians:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "globe with meridians", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_MAP, false);

    /**
     * 🗺️
     */
    Emoji WORLD_MAP = new Emoji("🗺️", "\uD83D\uDDFA\uFE0F", Collections.unmodifiableList(Arrays.asList(":map:", ":world_map:")), Collections.singletonList(":world_map:"), Collections.singletonList(":world_map:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "world map", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_MAP, false);

    /**
     * 🗺
     */
    Emoji WORLD_MAP_UNQUALIFIED = new Emoji("🗺", "\uD83D\uDDFA", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":world_map:"), false, false, 0.7, Qualification.fromString("unqualified"), "world map", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_MAP, true);

    /**
     * 🗾
     */
    Emoji MAP_OF_JAPAN = new Emoji("🗾", "\uD83D\uDDFE", Collections.unmodifiableList(Arrays.asList(":japan:", ":map_of_japan:")), Collections.singletonList(":japan:"), Collections.singletonList(":japan:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "map of Japan", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_MAP, false);

    /**
     * 🧭
     */
    Emoji COMPASS = new Emoji("🧭", "\uD83E\uDDED", Collections.singletonList(":compass:"), Collections.singletonList(":compass:"), Collections.singletonList(":compass:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "compass", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_MAP, false);
}
