package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiPlaceOther {

    /**
     * ⛲
     */
    Emoji FOUNTAIN = new Emoji("⛲", "\u26F2", Collections.singletonList(":fountain:"), Collections.singletonList(":fountain:"), Collections.singletonList(":fountain:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "fountain", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_OTHER, true);

    /**
     * ⛺
     */
    Emoji TENT = new Emoji("⛺", "\u26FA", Collections.singletonList(":tent:"), Collections.singletonList(":tent:"), Collections.singletonList(":tent:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "tent", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_OTHER, true);

    /**
     * 🌁
     */
    Emoji FOGGY = new Emoji("🌁", "\uD83C\uDF01", Collections.singletonList(":foggy:"), Collections.singletonList(":foggy:"), Collections.singletonList(":foggy:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "foggy", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_OTHER, false);

    /**
     * 🌃
     */
    Emoji NIGHT_WITH_STARS = new Emoji("🌃", "\uD83C\uDF03", Collections.singletonList(":night_with_stars:"), Collections.singletonList(":night_with_stars:"), Collections.singletonList(":night_with_stars:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "night with stars", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_OTHER, false);

    /**
     * 🏙️
     */
    Emoji CITYSCAPE = new Emoji("🏙️", "\uD83C\uDFD9\uFE0F", Collections.singletonList(":cityscape:"), Collections.singletonList(":cityscape:"), Collections.singletonList(":cityscape:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "cityscape", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_OTHER, false);

    /**
     * 🏙
     */
    Emoji CITYSCAPE_UNQUALIFIED = new Emoji("🏙", "\uD83C\uDFD9", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":cityscape:"), false, false, 0.7, Qualification.fromString("unqualified"), "cityscape", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_OTHER, true);

    /**
     * 🌄
     */
    Emoji SUNRISE_OVER_MOUNTAINS = new Emoji("🌄", "\uD83C\uDF04", Collections.singletonList(":sunrise_over_mountains:"), Collections.singletonList(":sunrise_over_mountains:"), Collections.singletonList(":sunrise_over_mountains:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "sunrise over mountains", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_OTHER, false);

    /**
     * 🌅
     */
    Emoji SUNRISE = new Emoji("🌅", "\uD83C\uDF05", Collections.singletonList(":sunrise:"), Collections.singletonList(":sunrise:"), Collections.singletonList(":sunrise:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "sunrise", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_OTHER, false);

    /**
     * 🌆
     */
    Emoji CITYSCAPE_AT_DUSK = new Emoji("🌆", "\uD83C\uDF06", Collections.singletonList(":city_dusk:"), Collections.singletonList(":city_sunset:"), Collections.singletonList(":city_sunset:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "cityscape at dusk", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_OTHER, false);

    /**
     * 🌇
     */
    Emoji SUNSET = new Emoji("🌇", "\uD83C\uDF07", Collections.unmodifiableList(Arrays.asList(":city_sunset:", ":city_sunrise:", ":sunset:")), Collections.singletonList(":city_sunrise:"), Collections.singletonList(":city_sunrise:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "sunset", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_OTHER, false);

    /**
     * 🌉
     */
    Emoji BRIDGE_AT_NIGHT = new Emoji("🌉", "\uD83C\uDF09", Collections.singletonList(":bridge_at_night:"), Collections.singletonList(":bridge_at_night:"), Collections.singletonList(":bridge_at_night:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "bridge at night", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_OTHER, false);

    /**
     * ♨️
     */
    Emoji HOT_SPRINGS = new Emoji("♨️", "\u2668\uFE0F", Collections.unmodifiableList(Arrays.asList(":hotsprings:", ":hot_springs:")), Collections.singletonList(":hotsprings:"), Collections.singletonList(":hotsprings:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "hot springs", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_OTHER, false);

    /**
     * ♨
     */
    Emoji HOT_SPRINGS_UNQUALIFIED = new Emoji("♨", "\u2668", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":hotsprings:"), false, false, 0.6, Qualification.fromString("unqualified"), "hot springs", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_OTHER, true);

    /**
     * 🎠
     */
    Emoji CAROUSEL_HORSE = new Emoji("🎠", "\uD83C\uDFA0", Collections.singletonList(":carousel_horse:"), Collections.singletonList(":carousel_horse:"), Collections.singletonList(":carousel_horse:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "carousel horse", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_OTHER, false);

    /**
     * 🛝
     */
    Emoji PLAYGROUND_SLIDE = new Emoji("🛝", "\uD83D\uDEDD", Collections.singletonList(":playground_slide:"), Collections.emptyList(), Collections.singletonList(":playground_slide:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "playground slide", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_OTHER, false);

    /**
     * 🎡
     */
    Emoji FERRIS_WHEEL = new Emoji("🎡", "\uD83C\uDFA1", Collections.singletonList(":ferris_wheel:"), Collections.singletonList(":ferris_wheel:"), Collections.singletonList(":ferris_wheel:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "ferris wheel", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_OTHER, false);

    /**
     * 🎢
     */
    Emoji ROLLER_COASTER = new Emoji("🎢", "\uD83C\uDFA2", Collections.singletonList(":roller_coaster:"), Collections.singletonList(":roller_coaster:"), Collections.singletonList(":roller_coaster:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "roller coaster", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_OTHER, false);

    /**
     * 💈
     */
    Emoji BARBER_POLE = new Emoji("💈", "\uD83D\uDC88", Collections.unmodifiableList(Arrays.asList(":barber:", ":barber_pole:")), Collections.singletonList(":barber:"), Collections.singletonList(":barber:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "barber pole", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_OTHER, false);

    /**
     * 🎪
     */
    Emoji CIRCUS_TENT = new Emoji("🎪", "\uD83C\uDFAA", Collections.singletonList(":circus_tent:"), Collections.singletonList(":circus_tent:"), Collections.singletonList(":circus_tent:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "circus tent", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.PLACE_OTHER, false);
}
