package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiReligion {

    /**
     * 🛐
     */
    Emoji PLACE_OF_WORSHIP = new Emoji("🛐", "\uD83D\uDED0", Collections.unmodifiableList(Arrays.asList(":place_of_worship:", ":worship_symbol:")), Collections.singletonList(":place_of_worship:"), Collections.singletonList(":place_of_worship:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "place of worship", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, false);

    /**
     * ⚛️
     */
    Emoji ATOM_SYMBOL = new Emoji("⚛️", "\u269B\uFE0F", Collections.unmodifiableList(Arrays.asList(":atom:", ":atom_symbol:")), Collections.singletonList(":atom_symbol:"), Collections.singletonList(":atom_symbol:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "atom symbol", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, false);

    /**
     * ⚛
     */
    Emoji ATOM_SYMBOL_UNQUALIFIED = new Emoji("⚛", "\u269B", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":atom_symbol:"), false, false, 1.0, Qualification.fromString("unqualified"), "atom symbol", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, true);

    /**
     * 🕉️
     */
    Emoji OM = new Emoji("🕉️", "\uD83D\uDD49\uFE0F", Collections.singletonList(":om_symbol:"), Collections.singletonList(":om_symbol:"), Collections.singletonList(":om:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "om", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, false);

    /**
     * 🕉
     */
    Emoji OM_UNQUALIFIED = new Emoji("🕉", "\uD83D\uDD49", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":om:"), false, false, 0.7, Qualification.fromString("unqualified"), "om", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, true);

    /**
     * ✡️
     */
    Emoji STAR_OF_DAVID = new Emoji("✡️", "\u2721\uFE0F", Collections.singletonList(":star_of_david:"), Collections.singletonList(":star_of_david:"), Collections.singletonList(":star_of_david:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "star of David", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, false);

    /**
     * ✡
     */
    Emoji STAR_OF_DAVID_UNQUALIFIED = new Emoji("✡", "\u2721", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":star_of_david:"), false, false, 0.7, Qualification.fromString("unqualified"), "star of David", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, true);

    /**
     * ☸️
     */
    Emoji WHEEL_OF_DHARMA = new Emoji("☸️", "\u2638\uFE0F", Collections.singletonList(":wheel_of_dharma:"), Collections.singletonList(":wheel_of_dharma:"), Collections.singletonList(":wheel_of_dharma:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "wheel of dharma", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, false);

    /**
     * ☸
     */
    Emoji WHEEL_OF_DHARMA_UNQUALIFIED = new Emoji("☸", "\u2638", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":wheel_of_dharma:"), false, false, 0.7, Qualification.fromString("unqualified"), "wheel of dharma", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, true);

    /**
     * ☯️
     */
    Emoji YIN_YANG = new Emoji("☯️", "\u262F\uFE0F", Collections.singletonList(":yin_yang:"), Collections.singletonList(":yin_yang:"), Collections.singletonList(":yin_yang:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "yin yang", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, false);

    /**
     * ☯
     */
    Emoji YIN_YANG_UNQUALIFIED = new Emoji("☯", "\u262F", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":yin_yang:"), false, false, 0.7, Qualification.fromString("unqualified"), "yin yang", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, true);

    /**
     * ✝️
     */
    Emoji LATIN_CROSS = new Emoji("✝️", "\u271D\uFE0F", Collections.unmodifiableList(Arrays.asList(":cross:", ":latin_cross:")), Collections.singletonList(":latin_cross:"), Collections.singletonList(":latin_cross:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "latin cross", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, false);

    /**
     * ✝
     */
    Emoji LATIN_CROSS_UNQUALIFIED = new Emoji("✝", "\u271D", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":latin_cross:"), false, false, 0.7, Qualification.fromString("unqualified"), "latin cross", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, true);

    /**
     * ☦️
     */
    Emoji ORTHODOX_CROSS = new Emoji("☦️", "\u2626\uFE0F", Collections.singletonList(":orthodox_cross:"), Collections.singletonList(":orthodox_cross:"), Collections.singletonList(":orthodox_cross:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "orthodox cross", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, false);

    /**
     * ☦
     */
    Emoji ORTHODOX_CROSS_UNQUALIFIED = new Emoji("☦", "\u2626", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":orthodox_cross:"), false, false, 1.0, Qualification.fromString("unqualified"), "orthodox cross", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, true);

    /**
     * ☪️
     */
    Emoji STAR_AND_CRESCENT = new Emoji("☪️", "\u262A\uFE0F", Collections.singletonList(":star_and_crescent:"), Collections.singletonList(":star_and_crescent:"), Collections.singletonList(":star_and_crescent:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "star and crescent", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, false);

    /**
     * ☪
     */
    Emoji STAR_AND_CRESCENT_UNQUALIFIED = new Emoji("☪", "\u262A", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":star_and_crescent:"), false, false, 0.7, Qualification.fromString("unqualified"), "star and crescent", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, true);

    /**
     * ☮️
     */
    Emoji PEACE_SYMBOL = new Emoji("☮️", "\u262E\uFE0F", Collections.unmodifiableList(Arrays.asList(":peace:", ":peace_symbol:")), Collections.singletonList(":peace_symbol:"), Collections.singletonList(":peace_symbol:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "peace symbol", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, false);

    /**
     * ☮
     */
    Emoji PEACE_SYMBOL_UNQUALIFIED = new Emoji("☮", "\u262E", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":peace_symbol:"), false, false, 1.0, Qualification.fromString("unqualified"), "peace symbol", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, true);

    /**
     * 🕎
     */
    Emoji MENORAH = new Emoji("🕎", "\uD83D\uDD4E", Collections.singletonList(":menorah:"), Collections.singletonList(":menorah_with_nine_branches:"), Collections.singletonList(":menorah:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "menorah", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, false);

    /**
     * 🔯
     */
    Emoji DOTTED_SIX_POINTED_STAR = new Emoji("🔯", "\uD83D\uDD2F", Collections.singletonList(":six_pointed_star:"), Collections.singletonList(":six_pointed_star:"), Collections.singletonList(":six_pointed_star:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "dotted six-pointed star", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, false);

    /**
     * 🪯
     */
    Emoji KHANDA = new Emoji("🪯", "\uD83E\uDEAF", Collections.singletonList(":khanda:"), Collections.emptyList(), Collections.singletonList(":khanda:"), false, false, 15.0, Qualification.fromString("fully-qualified"), "khanda", EmojiGroup.SYMBOLS, EmojiSubGroup.RELIGION, false);
}
