package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiSound {

    /**
     * 🔇
     */
    Emoji MUTED_SPEAKER = new Emoji("🔇", "\uD83D\uDD07", Collections.unmodifiableList(Arrays.asList(":mute:", ":muted_speaker:")), Collections.singletonList(":mute:"), Collections.singletonList(":mute:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "muted speaker", EmojiGroup.OBJECTS, EmojiSubGroup.SOUND, false);

    /**
     * 🔈
     */
    Emoji SPEAKER_LOW_VOLUME = new Emoji("🔈", "\uD83D\uDD08", Collections.singletonList(":speaker:"), Collections.singletonList(":speaker:"), Collections.singletonList(":speaker:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "speaker low volume", EmojiGroup.OBJECTS, EmojiSubGroup.SOUND, true);

    /**
     * 🔉
     */
    Emoji SPEAKER_MEDIUM_VOLUME = new Emoji("🔉", "\uD83D\uDD09", Collections.singletonList(":sound:"), Collections.singletonList(":sound:"), Collections.singletonList(":sound:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "speaker medium volume", EmojiGroup.OBJECTS, EmojiSubGroup.SOUND, false);

    /**
     * 🔊
     */
    Emoji SPEAKER_HIGH_VOLUME = new Emoji("🔊", "\uD83D\uDD0A", Collections.singletonList(":loud_sound:"), Collections.singletonList(":loud_sound:"), Collections.singletonList(":loud_sound:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "speaker high volume", EmojiGroup.OBJECTS, EmojiSubGroup.SOUND, false);

    /**
     * 📢
     */
    Emoji LOUDSPEAKER = new Emoji("📢", "\uD83D\uDCE2", Collections.singletonList(":loudspeaker:"), Collections.singletonList(":loudspeaker:"), Collections.singletonList(":loudspeaker:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "loudspeaker", EmojiGroup.OBJECTS, EmojiSubGroup.SOUND, false);

    /**
     * 📣
     */
    Emoji MEGAPHONE = new Emoji("📣", "\uD83D\uDCE3", Collections.unmodifiableList(Arrays.asList(":mega:", ":megaphone:")), Collections.singletonList(":mega:"), Collections.singletonList(":mega:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "megaphone", EmojiGroup.OBJECTS, EmojiSubGroup.SOUND, false);

    /**
     * 📯
     */
    Emoji POSTAL_HORN = new Emoji("📯", "\uD83D\uDCEF", Collections.singletonList(":postal_horn:"), Collections.singletonList(":postal_horn:"), Collections.singletonList(":postal_horn:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "postal horn", EmojiGroup.OBJECTS, EmojiSubGroup.SOUND, false);

    /**
     * 🔔
     */
    Emoji BELL = new Emoji("🔔", "\uD83D\uDD14", Collections.singletonList(":bell:"), Collections.singletonList(":bell:"), Collections.singletonList(":bell:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "bell", EmojiGroup.OBJECTS, EmojiSubGroup.SOUND, false);

    /**
     * 🔕
     */
    Emoji BELL_WITH_SLASH = new Emoji("🔕", "\uD83D\uDD15", Collections.singletonList(":no_bell:"), Collections.singletonList(":no_bell:"), Collections.singletonList(":no_bell:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "bell with slash", EmojiGroup.OBJECTS, EmojiSubGroup.SOUND, false);
}
