package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiTime {

    /**
     * ⌛
     */
    Emoji HOURGLASS_DONE = new Emoji("⌛", "\u231B", Collections.singletonList(":hourglass:"), Collections.singletonList(":hourglass:"), Collections.singletonList(":hourglass:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "hourglass done", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * ⏳
     */
    Emoji HOURGLASS_NOT_DONE = new Emoji("⏳", "\u23F3", Collections.singletonList(":hourglass_flowing_sand:"), Collections.singletonList(":hourglass_flowing_sand:"), Collections.singletonList(":hourglass_flowing_sand:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "hourglass not done", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * ⌚
     */
    Emoji WATCH = new Emoji("⌚", "\u231A", Collections.singletonList(":watch:"), Collections.singletonList(":watch:"), Collections.singletonList(":watch:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "watch", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * ⏰
     */
    Emoji ALARM_CLOCK = new Emoji("⏰", "\u23F0", Collections.singletonList(":alarm_clock:"), Collections.singletonList(":alarm_clock:"), Collections.singletonList(":alarm_clock:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "alarm clock", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * ⏱️
     */
    Emoji STOPWATCH = new Emoji("⏱️", "\u23F1\uFE0F", Collections.singletonList(":stopwatch:"), Collections.singletonList(":stopwatch:"), Collections.singletonList(":stopwatch:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "stopwatch", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, false);

    /**
     * ⏱
     */
    Emoji STOPWATCH_UNQUALIFIED = new Emoji("⏱", "\u23F1", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":stopwatch:"), false, false, 1.0, Qualification.fromString("unqualified"), "stopwatch", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * ⏲️
     */
    Emoji TIMER_CLOCK = new Emoji("⏲️", "\u23F2\uFE0F", Collections.unmodifiableList(Arrays.asList(":timer:", ":timer_clock:")), Collections.singletonList(":timer_clock:"), Collections.singletonList(":timer_clock:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "timer clock", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, false);

    /**
     * ⏲
     */
    Emoji TIMER_CLOCK_UNQUALIFIED = new Emoji("⏲", "\u23F2", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":timer_clock:"), false, false, 1.0, Qualification.fromString("unqualified"), "timer clock", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕰️
     */
    Emoji MANTELPIECE_CLOCK = new Emoji("🕰️", "\uD83D\uDD70\uFE0F", Collections.unmodifiableList(Arrays.asList(":clock:", ":mantlepiece_clock:")), Collections.singletonList(":mantelpiece_clock:"), Collections.singletonList(":mantelpiece_clock:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "mantelpiece clock", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, false);

    /**
     * 🕰
     */
    Emoji MANTELPIECE_CLOCK_UNQUALIFIED = new Emoji("🕰", "\uD83D\uDD70", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":mantelpiece_clock:"), false, false, 0.7, Qualification.fromString("unqualified"), "mantelpiece clock", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕛
     */
    Emoji TWELVE_O_CLOCK = new Emoji("🕛", "\uD83D\uDD5B", Collections.unmodifiableList(Arrays.asList(":clock12:", ":twelve_oclock:")), Collections.singletonList(":clock12:"), Collections.singletonList(":clock12:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "twelve o’clock", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕧
     */
    Emoji TWELVE_THIRTY = new Emoji("🕧", "\uD83D\uDD67", Collections.unmodifiableList(Arrays.asList(":clock1230:", ":twelve_thirty:")), Collections.singletonList(":clock1230:"), Collections.singletonList(":clock1230:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "twelve-thirty", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕐
     */
    Emoji ONE_O_CLOCK = new Emoji("🕐", "\uD83D\uDD50", Collections.unmodifiableList(Arrays.asList(":clock1:", ":one_oclock:")), Collections.singletonList(":clock1:"), Collections.singletonList(":clock1:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "one o’clock", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕜
     */
    Emoji ONE_THIRTY = new Emoji("🕜", "\uD83D\uDD5C", Collections.unmodifiableList(Arrays.asList(":clock130:", ":one_thirty:")), Collections.singletonList(":clock130:"), Collections.singletonList(":clock130:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "one-thirty", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕑
     */
    Emoji TWO_O_CLOCK = new Emoji("🕑", "\uD83D\uDD51", Collections.unmodifiableList(Arrays.asList(":clock2:", ":two_oclock:")), Collections.singletonList(":clock2:"), Collections.singletonList(":clock2:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "two o’clock", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕝
     */
    Emoji TWO_THIRTY = new Emoji("🕝", "\uD83D\uDD5D", Collections.unmodifiableList(Arrays.asList(":clock230:", ":two_thirty:")), Collections.singletonList(":clock230:"), Collections.singletonList(":clock230:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "two-thirty", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕒
     */
    Emoji THREE_O_CLOCK = new Emoji("🕒", "\uD83D\uDD52", Collections.unmodifiableList(Arrays.asList(":clock3:", ":three_oclock:")), Collections.singletonList(":clock3:"), Collections.singletonList(":clock3:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "three o’clock", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕞
     */
    Emoji THREE_THIRTY = new Emoji("🕞", "\uD83D\uDD5E", Collections.unmodifiableList(Arrays.asList(":clock330:", ":three_thirty:")), Collections.singletonList(":clock330:"), Collections.singletonList(":clock330:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "three-thirty", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕓
     */
    Emoji FOUR_O_CLOCK = new Emoji("🕓", "\uD83D\uDD53", Collections.unmodifiableList(Arrays.asList(":clock4:", ":four_oclock:")), Collections.singletonList(":clock4:"), Collections.singletonList(":clock4:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "four o’clock", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕟
     */
    Emoji FOUR_THIRTY = new Emoji("🕟", "\uD83D\uDD5F", Collections.unmodifiableList(Arrays.asList(":clock430:", ":four_thirty:")), Collections.singletonList(":clock430:"), Collections.singletonList(":clock430:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "four-thirty", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕔
     */
    Emoji FIVE_O_CLOCK = new Emoji("🕔", "\uD83D\uDD54", Collections.unmodifiableList(Arrays.asList(":clock5:", ":five_oclock:")), Collections.singletonList(":clock5:"), Collections.singletonList(":clock5:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "five o’clock", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕠
     */
    Emoji FIVE_THIRTY = new Emoji("🕠", "\uD83D\uDD60", Collections.unmodifiableList(Arrays.asList(":clock530:", ":five_thirty:")), Collections.singletonList(":clock530:"), Collections.singletonList(":clock530:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "five-thirty", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕕
     */
    Emoji SIX_O_CLOCK = new Emoji("🕕", "\uD83D\uDD55", Collections.unmodifiableList(Arrays.asList(":clock6:", ":six_oclock:")), Collections.singletonList(":clock6:"), Collections.singletonList(":clock6:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "six o’clock", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕡
     */
    Emoji SIX_THIRTY = new Emoji("🕡", "\uD83D\uDD61", Collections.unmodifiableList(Arrays.asList(":clock630:", ":six_thirty:")), Collections.singletonList(":clock630:"), Collections.singletonList(":clock630:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "six-thirty", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕖
     */
    Emoji SEVEN_O_CLOCK = new Emoji("🕖", "\uD83D\uDD56", Collections.unmodifiableList(Arrays.asList(":clock7:", ":seven_oclock:")), Collections.singletonList(":clock7:"), Collections.singletonList(":clock7:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "seven o’clock", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕢
     */
    Emoji SEVEN_THIRTY = new Emoji("🕢", "\uD83D\uDD62", Collections.unmodifiableList(Arrays.asList(":clock730:", ":seven_thirty:")), Collections.singletonList(":clock730:"), Collections.singletonList(":clock730:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "seven-thirty", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕗
     */
    Emoji EIGHT_O_CLOCK = new Emoji("🕗", "\uD83D\uDD57", Collections.unmodifiableList(Arrays.asList(":clock8:", ":eight_oclock:")), Collections.singletonList(":clock8:"), Collections.singletonList(":clock8:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "eight o’clock", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕣
     */
    Emoji EIGHT_THIRTY = new Emoji("🕣", "\uD83D\uDD63", Collections.unmodifiableList(Arrays.asList(":clock830:", ":eight_thirty:")), Collections.singletonList(":clock830:"), Collections.singletonList(":clock830:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "eight-thirty", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕘
     */
    Emoji NINE_O_CLOCK = new Emoji("🕘", "\uD83D\uDD58", Collections.unmodifiableList(Arrays.asList(":clock9:", ":nine_oclock:")), Collections.singletonList(":clock9:"), Collections.singletonList(":clock9:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "nine o’clock", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕤
     */
    Emoji NINE_THIRTY = new Emoji("🕤", "\uD83D\uDD64", Collections.unmodifiableList(Arrays.asList(":clock930:", ":nine_thirty:")), Collections.singletonList(":clock930:"), Collections.singletonList(":clock930:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "nine-thirty", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕙
     */
    Emoji TEN_O_CLOCK = new Emoji("🕙", "\uD83D\uDD59", Collections.unmodifiableList(Arrays.asList(":clock10:", ":ten_oclock:")), Collections.singletonList(":clock10:"), Collections.singletonList(":clock10:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "ten o’clock", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕥
     */
    Emoji TEN_THIRTY = new Emoji("🕥", "\uD83D\uDD65", Collections.unmodifiableList(Arrays.asList(":clock1030:", ":ten_thirty:")), Collections.singletonList(":clock1030:"), Collections.singletonList(":clock1030:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "ten-thirty", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕚
     */
    Emoji ELEVEN_O_CLOCK = new Emoji("🕚", "\uD83D\uDD5A", Collections.unmodifiableList(Arrays.asList(":clock11:", ":eleven_oclock:")), Collections.singletonList(":clock11:"), Collections.singletonList(":clock11:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "eleven o’clock", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);

    /**
     * 🕦
     */
    Emoji ELEVEN_THIRTY = new Emoji("🕦", "\uD83D\uDD66", Collections.unmodifiableList(Arrays.asList(":clock1130:", ":eleven_thirty:")), Collections.singletonList(":clock1130:"), Collections.singletonList(":clock1130:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "eleven-thirty", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TIME, true);
}
