package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiTool {

    /**
     * 🔨
     */
    Emoji HAMMER = new Emoji("🔨", "\uD83D\uDD28", Collections.singletonList(":hammer:"), Collections.singletonList(":hammer:"), Collections.singletonList(":hammer:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "hammer", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * 🪓
     */
    Emoji AXE = new Emoji("🪓", "\uD83E\uDE93", Collections.singletonList(":axe:"), Collections.singletonList(":axe:"), Collections.singletonList(":axe:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "axe", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * ⛏️
     */
    Emoji PICK = new Emoji("⛏️", "\u26CF\uFE0F", Collections.singletonList(":pick:"), Collections.singletonList(":pick:"), Collections.singletonList(":pick:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "pick", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * ⛏
     */
    Emoji PICK_UNQUALIFIED = new Emoji("⛏", "\u26CF", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":pick:"), false, false, 0.7, Qualification.fromString("unqualified"), "pick", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, true);

    /**
     * ⚒️
     */
    Emoji HAMMER_AND_PICK = new Emoji("⚒️", "\u2692\uFE0F", Collections.unmodifiableList(Arrays.asList(":hammer_pick:", ":hammer_and_pick:")), Collections.singletonList(":hammer_and_pick:"), Collections.singletonList(":hammer_and_pick:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "hammer and pick", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * ⚒
     */
    Emoji HAMMER_AND_PICK_UNQUALIFIED = new Emoji("⚒", "\u2692", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":hammer_and_pick:"), false, false, 1.0, Qualification.fromString("unqualified"), "hammer and pick", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, true);

    /**
     * 🛠️
     */
    Emoji HAMMER_AND_WRENCH = new Emoji("🛠️", "\uD83D\uDEE0\uFE0F", Collections.unmodifiableList(Arrays.asList(":tools:", ":hammer_and_wrench:")), Collections.singletonList(":hammer_and_wrench:"), Collections.singletonList(":hammer_and_wrench:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "hammer and wrench", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * 🛠
     */
    Emoji HAMMER_AND_WRENCH_UNQUALIFIED = new Emoji("🛠", "\uD83D\uDEE0", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":hammer_and_wrench:"), false, false, 0.7, Qualification.fromString("unqualified"), "hammer and wrench", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, true);

    /**
     * 🗡️
     */
    Emoji DAGGER = new Emoji("🗡️", "\uD83D\uDDE1\uFE0F", Collections.unmodifiableList(Arrays.asList(":dagger:", ":dagger_knife:")), Collections.singletonList(":dagger_knife:"), Collections.singletonList(":dagger:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "dagger", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * 🗡
     */
    Emoji DAGGER_UNQUALIFIED = new Emoji("🗡", "\uD83D\uDDE1", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":dagger:"), false, false, 0.7, Qualification.fromString("unqualified"), "dagger", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, true);

    /**
     * ⚔️
     */
    Emoji CROSSED_SWORDS = new Emoji("⚔️", "\u2694\uFE0F", Collections.singletonList(":crossed_swords:"), Collections.singletonList(":crossed_swords:"), Collections.singletonList(":crossed_swords:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "crossed swords", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * ⚔
     */
    Emoji CROSSED_SWORDS_UNQUALIFIED = new Emoji("⚔", "\u2694", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":crossed_swords:"), false, false, 1.0, Qualification.fromString("unqualified"), "crossed swords", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, true);

    /**
     * 💣
     */
    Emoji BOMB = new Emoji("💣", "\uD83D\uDCA3", Collections.singletonList(":bomb:"), Collections.singletonList(":bomb:"), Collections.singletonList(":bomb:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "bomb", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, true);

    /**
     * 🪃
     */
    Emoji BOOMERANG = new Emoji("🪃", "\uD83E\uDE83", Collections.singletonList(":boomerang:"), Collections.singletonList(":boomerang:"), Collections.singletonList(":boomerang:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "boomerang", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * 🏹
     */
    Emoji BOW_AND_ARROW = new Emoji("🏹", "\uD83C\uDFF9", Collections.unmodifiableList(Arrays.asList(":bow_and_arrow:", ":archery:")), Collections.singletonList(":bow_and_arrow:"), Collections.singletonList(":bow_and_arrow:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "bow and arrow", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * 🛡️
     */
    Emoji SHIELD = new Emoji("🛡️", "\uD83D\uDEE1\uFE0F", Collections.singletonList(":shield:"), Collections.singletonList(":shield:"), Collections.singletonList(":shield:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "shield", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * 🛡
     */
    Emoji SHIELD_UNQUALIFIED = new Emoji("🛡", "\uD83D\uDEE1", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":shield:"), false, false, 0.7, Qualification.fromString("unqualified"), "shield", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, true);

    /**
     * 🪚
     */
    Emoji CARPENTRY_SAW = new Emoji("🪚", "\uD83E\uDE9A", Collections.singletonList(":carpentry_saw:"), Collections.singletonList(":carpentry_saw:"), Collections.singletonList(":carpentry_saw:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "carpentry saw", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * 🔧
     */
    Emoji WRENCH = new Emoji("🔧", "\uD83D\uDD27", Collections.singletonList(":wrench:"), Collections.singletonList(":wrench:"), Collections.singletonList(":wrench:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "wrench", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * 🪛
     */
    Emoji SCREWDRIVER = new Emoji("🪛", "\uD83E\uDE9B", Collections.singletonList(":screwdriver:"), Collections.singletonList(":screwdriver:"), Collections.singletonList(":screwdriver:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "screwdriver", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * 🔩
     */
    Emoji NUT_AND_BOLT = new Emoji("🔩", "\uD83D\uDD29", Collections.singletonList(":nut_and_bolt:"), Collections.singletonList(":nut_and_bolt:"), Collections.singletonList(":nut_and_bolt:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "nut and bolt", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * ⚙️
     */
    Emoji GEAR = new Emoji("⚙️", "\u2699\uFE0F", Collections.singletonList(":gear:"), Collections.singletonList(":gear:"), Collections.singletonList(":gear:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "gear", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * ⚙
     */
    Emoji GEAR_UNQUALIFIED = new Emoji("⚙", "\u2699", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":gear:"), false, false, 1.0, Qualification.fromString("unqualified"), "gear", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, true);

    /**
     * 🗜️
     */
    Emoji CLAMP = new Emoji("🗜️", "\uD83D\uDDDC\uFE0F", Collections.unmodifiableList(Arrays.asList(":compression:", ":clamp:")), Collections.singletonList(":compression:"), Collections.singletonList(":clamp:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "clamp", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * 🗜
     */
    Emoji CLAMP_UNQUALIFIED = new Emoji("🗜", "\uD83D\uDDDC", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":clamp:"), false, false, 0.7, Qualification.fromString("unqualified"), "clamp", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, true);

    /**
     * ⚖️
     */
    Emoji BALANCE_SCALE = new Emoji("⚖️", "\u2696\uFE0F", Collections.unmodifiableList(Arrays.asList(":scales:", ":balance_scale:")), Collections.singletonList(":scales:"), Collections.singletonList(":balance_scale:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "balance scale", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * ⚖
     */
    Emoji BALANCE_SCALE_UNQUALIFIED = new Emoji("⚖", "\u2696", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":balance_scale:"), false, false, 1.0, Qualification.fromString("unqualified"), "balance scale", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, true);

    /**
     * 🦯
     */
    Emoji WHITE_CANE = new Emoji("🦯", "\uD83E\uDDAF", Collections.singletonList(":probing_cane:"), Collections.singletonList(":probing_cane:"), Collections.singletonList(":probing_cane:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "white cane", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * 🔗
     */
    Emoji LINK = new Emoji("🔗", "\uD83D\uDD17", Collections.singletonList(":link:"), Collections.singletonList(":link:"), Collections.singletonList(":link:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "link", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * ⛓️‍💥
     */
    Emoji BROKEN_CHAIN = new Emoji("⛓️‍💥", "\u26D3\uFE0F\u200D\uD83D\uDCA5", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 15.1, Qualification.fromString("fully-qualified"), "broken chain", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * ⛓‍💥
     */
    Emoji BROKEN_CHAIN_UNQUALIFIED = new Emoji("⛓‍💥", "\u26D3\u200D\uD83D\uDCA5", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 15.1, Qualification.fromString("unqualified"), "broken chain", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * ⛓️
     */
    Emoji CHAINS = new Emoji("⛓️", "\u26D3\uFE0F", Collections.singletonList(":chains:"), Collections.singletonList(":chains:"), Collections.singletonList(":chains:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "chains", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * ⛓
     */
    Emoji CHAINS_UNQUALIFIED = new Emoji("⛓", "\u26D3", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":chains:"), false, false, 0.7, Qualification.fromString("unqualified"), "chains", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, true);

    /**
     * 🪝
     */
    Emoji HOOK = new Emoji("🪝", "\uD83E\uDE9D", Collections.singletonList(":hook:"), Collections.singletonList(":hook:"), Collections.singletonList(":hook:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "hook", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * 🧰
     */
    Emoji TOOLBOX = new Emoji("🧰", "\uD83E\uDDF0", Collections.singletonList(":toolbox:"), Collections.singletonList(":toolbox:"), Collections.singletonList(":toolbox:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "toolbox", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * 🧲
     */
    Emoji MAGNET = new Emoji("🧲", "\uD83E\uDDF2", Collections.singletonList(":magnet:"), Collections.singletonList(":magnet:"), Collections.singletonList(":magnet:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "magnet", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);

    /**
     * 🪜
     */
    Emoji LADDER = new Emoji("🪜", "\uD83E\uDE9C", Collections.singletonList(":ladder:"), Collections.singletonList(":ladder:"), Collections.singletonList(":ladder:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "ladder", EmojiGroup.OBJECTS, EmojiSubGroup.TOOL, false);
}
