package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiTransportGround {

    /**
     * 🚂
     */
    Emoji LOCOMOTIVE = new Emoji("🚂", "\uD83D\uDE82", Collections.unmodifiableList(Arrays.asList(":steam_locomotive:", ":locomotive:")), Collections.singletonList(":steam_locomotive:"), Collections.singletonList(":steam_locomotive:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "locomotive", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚃
     */
    Emoji RAILWAY_CAR = new Emoji("🚃", "\uD83D\uDE83", Collections.singletonList(":railway_car:"), Collections.singletonList(":railway_car:"), Collections.singletonList(":railway_car:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "railway car", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚄
     */
    Emoji HIGH_SPEED_TRAIN = new Emoji("🚄", "\uD83D\uDE84", Collections.singletonList(":bullettrain_side:"), Collections.singletonList(":bullettrain_side:"), Collections.singletonList(":bullettrain_side:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "high-speed train", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚅
     */
    Emoji BULLET_TRAIN = new Emoji("🚅", "\uD83D\uDE85", Collections.unmodifiableList(Arrays.asList(":bullettrain_front:", ":bullet_train:")), Collections.singletonList(":bullettrain_front:"), Collections.singletonList(":bullettrain_front:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "bullet train", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚆
     */
    Emoji TRAIN = new Emoji("🚆", "\uD83D\uDE86", Collections.singletonList(":train2:"), Collections.singletonList(":train2:"), Collections.singletonList(":train2:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "train", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚇
     */
    Emoji METRO = new Emoji("🚇", "\uD83D\uDE87", Collections.singletonList(":metro:"), Collections.singletonList(":metro:"), Collections.singletonList(":metro:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "metro", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, true);

    /**
     * 🚈
     */
    Emoji LIGHT_RAIL = new Emoji("🚈", "\uD83D\uDE88", Collections.singletonList(":light_rail:"), Collections.singletonList(":light_rail:"), Collections.singletonList(":light_rail:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "light rail", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚉
     */
    Emoji STATION = new Emoji("🚉", "\uD83D\uDE89", Collections.singletonList(":station:"), Collections.singletonList(":station:"), Collections.singletonList(":station:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "station", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚊
     */
    Emoji TRAM = new Emoji("🚊", "\uD83D\uDE8A", Collections.singletonList(":tram:"), Collections.singletonList(":tram:"), Collections.singletonList(":tram:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "tram", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚝
     */
    Emoji MONORAIL = new Emoji("🚝", "\uD83D\uDE9D", Collections.singletonList(":monorail:"), Collections.singletonList(":monorail:"), Collections.singletonList(":monorail:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "monorail", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚞
     */
    Emoji MOUNTAIN_RAILWAY = new Emoji("🚞", "\uD83D\uDE9E", Collections.singletonList(":mountain_railway:"), Collections.singletonList(":mountain_railway:"), Collections.singletonList(":mountain_railway:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "mountain railway", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚋
     */
    Emoji TRAM_CAR = new Emoji("🚋", "\uD83D\uDE8B", Collections.unmodifiableList(Arrays.asList(":train:", ":tram_car:")), Collections.singletonList(":train:"), Collections.singletonList(":train:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "tram car", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚌
     */
    Emoji BUS = new Emoji("🚌", "\uD83D\uDE8C", Collections.singletonList(":bus:"), Collections.singletonList(":bus:"), Collections.singletonList(":bus:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "bus", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚍
     */
    Emoji ONCOMING_BUS = new Emoji("🚍", "\uD83D\uDE8D", Collections.singletonList(":oncoming_bus:"), Collections.singletonList(":oncoming_bus:"), Collections.singletonList(":oncoming_bus:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "oncoming bus", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, true);

    /**
     * 🚎
     */
    Emoji TROLLEYBUS = new Emoji("🚎", "\uD83D\uDE8E", Collections.singletonList(":trolleybus:"), Collections.singletonList(":trolleybus:"), Collections.singletonList(":trolleybus:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "trolleybus", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚐
     */
    Emoji MINIBUS = new Emoji("🚐", "\uD83D\uDE90", Collections.singletonList(":minibus:"), Collections.singletonList(":minibus:"), Collections.singletonList(":minibus:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "minibus", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚑
     */
    Emoji AMBULANCE = new Emoji("🚑", "\uD83D\uDE91", Collections.singletonList(":ambulance:"), Collections.singletonList(":ambulance:"), Collections.singletonList(":ambulance:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "ambulance", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, true);

    /**
     * 🚒
     */
    Emoji FIRE_ENGINE = new Emoji("🚒", "\uD83D\uDE92", Collections.singletonList(":fire_engine:"), Collections.singletonList(":fire_engine:"), Collections.singletonList(":fire_engine:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "fire engine", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚓
     */
    Emoji POLICE_CAR = new Emoji("🚓", "\uD83D\uDE93", Collections.singletonList(":police_car:"), Collections.singletonList(":police_car:"), Collections.singletonList(":police_car:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "police car", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚔
     */
    Emoji ONCOMING_POLICE_CAR = new Emoji("🚔", "\uD83D\uDE94", Collections.singletonList(":oncoming_police_car:"), Collections.singletonList(":oncoming_police_car:"), Collections.singletonList(":oncoming_police_car:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "oncoming police car", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, true);

    /**
     * 🚕
     */
    Emoji TAXI = new Emoji("🚕", "\uD83D\uDE95", Collections.singletonList(":taxi:"), Collections.singletonList(":taxi:"), Collections.singletonList(":taxi:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "taxi", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚖
     */
    Emoji ONCOMING_TAXI = new Emoji("🚖", "\uD83D\uDE96", Collections.singletonList(":oncoming_taxi:"), Collections.singletonList(":oncoming_taxi:"), Collections.singletonList(":oncoming_taxi:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "oncoming taxi", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚗
     */
    Emoji AUTOMOBILE = new Emoji("🚗", "\uD83D\uDE97", Collections.unmodifiableList(Arrays.asList(":red_car:", ":automobile:")), Collections.singletonList(":car:"), Collections.unmodifiableList(Arrays.asList(":car:", ":red_car:")), false, false, 0.6, Qualification.fromString("fully-qualified"), "automobile", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚘
     */
    Emoji ONCOMING_AUTOMOBILE = new Emoji("🚘", "\uD83D\uDE98", Collections.singletonList(":oncoming_automobile:"), Collections.singletonList(":oncoming_automobile:"), Collections.singletonList(":oncoming_automobile:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "oncoming automobile", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, true);

    /**
     * 🚙
     */
    Emoji SPORT_UTILITY_VEHICLE = new Emoji("🚙", "\uD83D\uDE99", Collections.singletonList(":blue_car:"), Collections.singletonList(":blue_car:"), Collections.singletonList(":blue_car:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "sport utility vehicle", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🛻
     */
    Emoji PICKUP_TRUCK = new Emoji("🛻", "\uD83D\uDEFB", Collections.singletonList(":pickup_truck:"), Collections.singletonList(":pickup_truck:"), Collections.singletonList(":pickup_truck:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "pickup truck", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚚
     */
    Emoji DELIVERY_TRUCK = new Emoji("🚚", "\uD83D\uDE9A", Collections.singletonList(":truck:"), Collections.singletonList(":truck:"), Collections.singletonList(":truck:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "delivery truck", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚛
     */
    Emoji ARTICULATED_LORRY = new Emoji("🚛", "\uD83D\uDE9B", Collections.singletonList(":articulated_lorry:"), Collections.singletonList(":articulated_lorry:"), Collections.singletonList(":articulated_lorry:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "articulated lorry", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚜
     */
    Emoji TRACTOR = new Emoji("🚜", "\uD83D\uDE9C", Collections.singletonList(":tractor:"), Collections.singletonList(":tractor:"), Collections.singletonList(":tractor:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "tractor", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🏎️
     */
    Emoji RACING_CAR = new Emoji("🏎️", "\uD83C\uDFCE\uFE0F", Collections.unmodifiableList(Arrays.asList(":race_car:", ":racing_car:")), Collections.singletonList(":racing_car:"), Collections.singletonList(":racing_car:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "racing car", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🏎
     */
    Emoji RACING_CAR_UNQUALIFIED = new Emoji("🏎", "\uD83C\uDFCE", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":racing_car:"), false, false, 0.7, Qualification.fromString("unqualified"), "racing car", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, true);

    /**
     * 🏍️
     */
    Emoji MOTORCYCLE = new Emoji("🏍️", "\uD83C\uDFCD\uFE0F", Collections.unmodifiableList(Arrays.asList(":motorcycle:", ":racing_motorcycle:")), Collections.singletonList(":racing_motorcycle:"), Collections.singletonList(":motorcycle:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "motorcycle", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🏍
     */
    Emoji MOTORCYCLE_UNQUALIFIED = new Emoji("🏍", "\uD83C\uDFCD", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":motorcycle:"), false, false, 0.7, Qualification.fromString("unqualified"), "motorcycle", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, true);

    /**
     * 🛵
     */
    Emoji MOTOR_SCOOTER = new Emoji("🛵", "\uD83D\uDEF5", Collections.unmodifiableList(Arrays.asList(":motor_scooter:", ":motorbike:")), Collections.singletonList(":motor_scooter:"), Collections.singletonList(":motor_scooter:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "motor scooter", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🦽
     */
    Emoji MANUAL_WHEELCHAIR = new Emoji("🦽", "\uD83E\uDDBD", Collections.singletonList(":manual_wheelchair:"), Collections.singletonList(":manual_wheelchair:"), Collections.singletonList(":manual_wheelchair:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "manual wheelchair", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🦼
     */
    Emoji MOTORIZED_WHEELCHAIR = new Emoji("🦼", "\uD83E\uDDBC", Collections.singletonList(":motorized_wheelchair:"), Collections.singletonList(":motorized_wheelchair:"), Collections.singletonList(":motorized_wheelchair:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "motorized wheelchair", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🛺
     */
    Emoji AUTO_RICKSHAW = new Emoji("🛺", "\uD83D\uDEFA", Collections.singletonList(":auto_rickshaw:"), Collections.singletonList(":auto_rickshaw:"), Collections.singletonList(":auto_rickshaw:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "auto rickshaw", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚲
     */
    Emoji BICYCLE = new Emoji("🚲", "\uD83D\uDEB2", Collections.unmodifiableList(Arrays.asList(":bike:", ":bicycle:")), Collections.singletonList(":bike:"), Collections.singletonList(":bike:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "bicycle", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, true);

    /**
     * 🛴
     */
    Emoji KICK_SCOOTER = new Emoji("🛴", "\uD83D\uDEF4", Collections.unmodifiableList(Arrays.asList(":scooter:", ":kick_scooter:")), Collections.singletonList(":scooter:"), Collections.singletonList(":kick_scooter:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "kick scooter", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🛹
     */
    Emoji SKATEBOARD = new Emoji("🛹", "\uD83D\uDEF9", Collections.singletonList(":skateboard:"), Collections.singletonList(":skateboard:"), Collections.singletonList(":skateboard:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "skateboard", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🛼
     */
    Emoji ROLLER_SKATE = new Emoji("🛼", "\uD83D\uDEFC", Collections.singletonList(":roller_skate:"), Collections.singletonList(":roller_skate:"), Collections.singletonList(":roller_skate:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "roller skate", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚏
     */
    Emoji BUS_STOP = new Emoji("🚏", "\uD83D\uDE8F", Collections.unmodifiableList(Arrays.asList(":busstop:", ":bus_stop:")), Collections.singletonList(":busstop:"), Collections.singletonList(":busstop:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "bus stop", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🛣️
     */
    Emoji MOTORWAY = new Emoji("🛣️", "\uD83D\uDEE3\uFE0F", Collections.singletonList(":motorway:"), Collections.singletonList(":motorway:"), Collections.singletonList(":motorway:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "motorway", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🛣
     */
    Emoji MOTORWAY_UNQUALIFIED = new Emoji("🛣", "\uD83D\uDEE3", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":motorway:"), false, false, 0.7, Qualification.fromString("unqualified"), "motorway", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, true);

    /**
     * 🛤️
     */
    Emoji RAILWAY_TRACK = new Emoji("🛤️", "\uD83D\uDEE4\uFE0F", Collections.unmodifiableList(Arrays.asList(":railway_track:", ":railroad_track:")), Collections.singletonList(":railway_track:"), Collections.singletonList(":railway_track:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "railway track", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🛤
     */
    Emoji RAILWAY_TRACK_UNQUALIFIED = new Emoji("🛤", "\uD83D\uDEE4", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":railway_track:"), false, false, 0.7, Qualification.fromString("unqualified"), "railway track", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, true);

    /**
     * 🛢️
     */
    Emoji OIL_DRUM = new Emoji("🛢️", "\uD83D\uDEE2\uFE0F", Collections.unmodifiableList(Arrays.asList(":oil:", ":oil_drum:")), Collections.singletonList(":oil_drum:"), Collections.singletonList(":oil_drum:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "oil drum", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🛢
     */
    Emoji OIL_DRUM_UNQUALIFIED = new Emoji("🛢", "\uD83D\uDEE2", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":oil_drum:"), false, false, 0.7, Qualification.fromString("unqualified"), "oil drum", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, true);

    /**
     * ⛽
     */
    Emoji FUEL_PUMP = new Emoji("⛽", "\u26FD", Collections.unmodifiableList(Arrays.asList(":fuelpump:", ":fuel_pump:")), Collections.singletonList(":fuelpump:"), Collections.singletonList(":fuelpump:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "fuel pump", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, true);

    /**
     * 🛞
     */
    Emoji WHEEL = new Emoji("🛞", "\uD83D\uDEDE", Collections.singletonList(":wheel:"), Collections.emptyList(), Collections.singletonList(":wheel:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "wheel", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚨
     */
    Emoji POLICE_CAR_LIGHT = new Emoji("🚨", "\uD83D\uDEA8", Collections.singletonList(":rotating_light:"), Collections.singletonList(":rotating_light:"), Collections.singletonList(":rotating_light:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "police car light", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚥
     */
    Emoji HORIZONTAL_TRAFFIC_LIGHT = new Emoji("🚥", "\uD83D\uDEA5", Collections.singletonList(":traffic_light:"), Collections.singletonList(":traffic_light:"), Collections.singletonList(":traffic_light:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "horizontal traffic light", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚦
     */
    Emoji VERTICAL_TRAFFIC_LIGHT = new Emoji("🚦", "\uD83D\uDEA6", Collections.singletonList(":vertical_traffic_light:"), Collections.singletonList(":vertical_traffic_light:"), Collections.singletonList(":vertical_traffic_light:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "vertical traffic light", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🛑
     */
    Emoji STOP_SIGN = new Emoji("🛑", "\uD83D\uDED1", Collections.unmodifiableList(Arrays.asList(":octagonal_sign:", ":stop_sign:")), Collections.singletonList(":octagonal_sign:"), Collections.singletonList(":stop_sign:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "stop sign", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);

    /**
     * 🚧
     */
    Emoji CONSTRUCTION = new Emoji("🚧", "\uD83D\uDEA7", Collections.singletonList(":construction:"), Collections.singletonList(":construction:"), Collections.singletonList(":construction:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "construction", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_GROUND, false);
}
