package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiTransportWater {

    /**
     * ⚓
     */
    Emoji ANCHOR = new Emoji("⚓", "\u2693", Collections.singletonList(":anchor:"), Collections.singletonList(":anchor:"), Collections.singletonList(":anchor:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "anchor", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_WATER, true);

    /**
     * 🛟
     */
    Emoji RING_BUOY = new Emoji("🛟", "\uD83D\uDEDF", Collections.singletonList(":ring_buoy:"), Collections.emptyList(), Collections.singletonList(":ring_buoy:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "ring buoy", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_WATER, false);

    /**
     * ⛵
     */
    Emoji SAILBOAT = new Emoji("⛵", "\u26F5", Collections.singletonList(":sailboat:"), Collections.singletonList(":boat:"), Collections.unmodifiableList(Arrays.asList(":boat:", ":sailboat:")), false, false, 0.6, Qualification.fromString("fully-qualified"), "sailboat", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_WATER, true);

    /**
     * 🛶
     */
    Emoji CANOE = new Emoji("🛶", "\uD83D\uDEF6", Collections.unmodifiableList(Arrays.asList(":canoe:", ":kayak:")), Collections.singletonList(":canoe:"), Collections.singletonList(":canoe:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "canoe", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_WATER, false);

    /**
     * 🚤
     */
    Emoji SPEEDBOAT = new Emoji("🚤", "\uD83D\uDEA4", Collections.singletonList(":speedboat:"), Collections.singletonList(":speedboat:"), Collections.singletonList(":speedboat:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "speedboat", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_WATER, false);

    /**
     * 🛳️
     */
    Emoji PASSENGER_SHIP = new Emoji("🛳️", "\uD83D\uDEF3\uFE0F", Collections.unmodifiableList(Arrays.asList(":cruise_ship:", ":passenger_ship:")), Collections.singletonList(":passenger_ship:"), Collections.singletonList(":passenger_ship:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "passenger ship", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_WATER, false);

    /**
     * 🛳
     */
    Emoji PASSENGER_SHIP_UNQUALIFIED = new Emoji("🛳", "\uD83D\uDEF3", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":passenger_ship:"), false, false, 0.7, Qualification.fromString("unqualified"), "passenger ship", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_WATER, true);

    /**
     * ⛴️
     */
    Emoji FERRY = new Emoji("⛴️", "\u26F4\uFE0F", Collections.singletonList(":ferry:"), Collections.singletonList(":ferry:"), Collections.singletonList(":ferry:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "ferry", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_WATER, false);

    /**
     * ⛴
     */
    Emoji FERRY_UNQUALIFIED = new Emoji("⛴", "\u26F4", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":ferry:"), false, false, 0.7, Qualification.fromString("unqualified"), "ferry", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_WATER, true);

    /**
     * 🛥️
     */
    Emoji MOTOR_BOAT = new Emoji("🛥️", "\uD83D\uDEE5\uFE0F", Collections.unmodifiableList(Arrays.asList(":motorboat:", ":motor_boat:")), Collections.singletonList(":motor_boat:"), Collections.singletonList(":motor_boat:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "motor boat", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_WATER, false);

    /**
     * 🛥
     */
    Emoji MOTOR_BOAT_UNQUALIFIED = new Emoji("🛥", "\uD83D\uDEE5", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":motor_boat:"), false, false, 0.7, Qualification.fromString("unqualified"), "motor boat", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_WATER, true);

    /**
     * 🚢
     */
    Emoji SHIP = new Emoji("🚢", "\uD83D\uDEA2", Collections.singletonList(":ship:"), Collections.singletonList(":ship:"), Collections.singletonList(":ship:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "ship", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_WATER, false);
}
