/*
 * Decompiled with CFR 0.152.
 */
package net.fellbaum.jemoji;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fellbaum.jemoji.Emoji;
import net.fellbaum.jemoji.EmojiGroup;
import net.fellbaum.jemoji.EmojiLanguage;
import net.fellbaum.jemoji.EmojiLoader;
import net.fellbaum.jemoji.EmojiLoaderA;
import net.fellbaum.jemoji.EmojiLoaderB;
import net.fellbaum.jemoji.EmojiSubGroup;
import net.fellbaum.jemoji.EmojiType;
import net.fellbaum.jemoji.IndexedAlias;
import net.fellbaum.jemoji.IndexedEmoji;
import net.fellbaum.jemoji.InternalCodepointSequence;
import net.fellbaum.jemoji.InternalEmojiUtils;
import net.fellbaum.jemoji.NonUniqueEmojiFoundResult;
import net.fellbaum.jemoji.UniqueEmojiFoundResult;
import org.jspecify.annotations.Nullable;

public final class EmojiManager {
    private static final Map<String, Emoji> EMOJI_UNICODE_TO_EMOJI;
    static final Map<Integer, List<Emoji>> EMOJI_FIRST_CODEPOINT_TO_EMOJIS_ORDER_CODEPOINT_LENGTH_DESCENDING;
    static final Map<InternalCodepointSequence, List<Emoji>> ALIAS_EMOJI_TO_EMOJIS_ORDER_CODEPOINT_LENGTH_DESCENDING;
    static final Set<Integer> POSSIBLE_EMOJI_ALIAS_STARTER_CODEPOINTS;
    static final int ALIAS_EMOJI_MAX_LENGTH;
    static final Set<Integer> POSSIBLE_EMOJI_URL_ENCODED_STARTER_CODEPOINTS;
    static final int MINIMUM_EMOJI_URL_ENCODED_LENGTH;
    static final int MAXIMUM_EMOJI_URL_ENCODED_LENGTH;
    static final Set<String> ALLOWED_EMOJI_URL_ENCODED_SEQUENCES;
    static final Map<String, Emoji> EMOJI_HTML_DECIMAL_REPRESENTATION_TO_EMOJI;
    static final Map<String, Emoji> EMOJI_HTML_HEXADECIMAL_REPRESENTATION_TO_EMOJI;
    static final Map<String, Emoji> EMOJI_URL_ENCODED_REPRESENTATION_TO_EMOJI;
    static final Map<String, List<Emoji>> EMOJI_ALIAS_TO_EMOJIS;
    static final int MIN_HTML_DECIMAL_CODEPOINT_LENGTH;
    static final int MAX_HTML_DECIMAL_SINGLE_EMOJIS_CONCATENATED_LENGTH;
    private static final List<Emoji> EMOJIS_LENGTH_DESCENDING;
    private static @Nullable Pattern EMOJI_PATTERN;
    private static final Pattern NOT_WANTED_EMOJI_CHARACTERS;
    private static final Map<EmojiLanguage, Map<String, String>> EMOJI_DESCRIPTION_LANGUAGE_MAP;
    private static final Map<EmojiLanguage, Map<String, List<String>>> EMOJI_KEYWORD_LANGUAGE_MAP;

    private static Map<InternalCodepointSequence, List<Emoji>> mapAliasesToEmojis(List<Emoji> emojis) {
        return emojis.stream().flatMap(emoji -> emoji.getAllAliases().stream().map(alias -> new AbstractMap.SimpleEntry<InternalCodepointSequence, Emoji>(new InternalCodepointSequence(InternalEmojiUtils.stringToCodePoints(alias)), (Emoji)emoji))).collect(Collectors.groupingBy(AbstractMap.SimpleEntry::getKey, HashMap::new, Collectors.mapping(AbstractMap.SimpleEntry::getValue, Collectors.toList())));
    }

    private static Collector<AbstractMap.SimpleEntry<String, Emoji>, ?, LinkedHashMap<Integer, List<Emoji>>> getEmojiLinkedHashMapCollector() {
        return Collectors.groupingBy(entry -> ((Emoji)entry.getValue()).getEmoji().codePointAt(0), LinkedHashMap::new, Collectors.collectingAndThen(Collectors.mapping(Map.Entry::getValue, Collectors.toList()), list -> {
            list.sort((e1, e2) -> Integer.compare(e2.getEmoji().length(), e1.getEmoji().length()));
            return list;
        }));
    }

    private static Stream<AbstractMap.SimpleEntry<String, Emoji>> prepareEmojisStreamForInitialization(Set<Emoji> emojis) {
        return emojis.stream().flatMap(emoji -> {
            Stream.Builder<AbstractMap.SimpleEntry<String, Emoji>> streamBuilder = Stream.builder();
            streamBuilder.add(new AbstractMap.SimpleEntry<String, Emoji>(emoji.getEmoji(), (Emoji)emoji));
            if (emoji.hasVariationSelectors()) {
                emoji.getTextVariation().ifPresent(variation -> streamBuilder.add(new AbstractMap.SimpleEntry<String, Emoji>((String)variation, (Emoji)emoji)));
                emoji.getEmojiVariation().ifPresent(variation -> streamBuilder.add(new AbstractMap.SimpleEntry<String, Emoji>((String)variation, (Emoji)emoji)));
            }
            return streamBuilder.build();
        });
    }

    static Optional<String> getEmojiDescriptionForLanguageAndEmoji(EmojiLanguage language, String emoji) {
        return Optional.ofNullable(EMOJI_DESCRIPTION_LANGUAGE_MAP.computeIfAbsent(language, emojiLanguage -> (Map)EmojiLoader.readFromAllLanguageResourceFiles("/emoji_sources/description/", emojiLanguage)).get(emoji));
    }

    static Optional<List<String>> getEmojiKeywordsForLanguageAndEmoji(EmojiLanguage language, String emoji) {
        return Optional.ofNullable(EMOJI_KEYWORD_LANGUAGE_MAP.computeIfAbsent(language, emojiLanguage -> (Map)EmojiLoader.readFromAllLanguageResourceFiles("/emoji_sources/keyword/", emojiLanguage)).get(emoji));
    }

    private EmojiManager() {
    }

    public static Optional<Emoji> getEmoji(String emoji) {
        if (InternalEmojiUtils.isStringNullOrEmpty(emoji)) {
            return Optional.empty();
        }
        return Optional.ofNullable(EMOJI_UNICODE_TO_EMOJI.get(emoji));
    }

    public static boolean isEmoji(String emoji) {
        if (InternalEmojiUtils.isStringNullOrEmpty(emoji)) {
            return false;
        }
        return EMOJI_UNICODE_TO_EMOJI.containsKey(emoji);
    }

    public static Set<Emoji> getAllEmojis() {
        return new HashSet<Emoji>(EMOJIS_LENGTH_DESCENDING);
    }

    public static Map<EmojiGroup, Set<Emoji>> getAllEmojisGrouped() {
        return EMOJIS_LENGTH_DESCENDING.stream().collect(Collectors.groupingBy(Emoji::getGroup, Collectors.toSet()));
    }

    public static Map<EmojiSubGroup, Set<Emoji>> getAllEmojisSubGrouped() {
        return EMOJIS_LENGTH_DESCENDING.stream().collect(Collectors.groupingBy(Emoji::getSubgroup, Collectors.toSet()));
    }

    public static Set<Emoji> getAllEmojisByGroup(EmojiGroup group) {
        return EMOJIS_LENGTH_DESCENDING.stream().filter(emoji -> emoji.getGroup() == group).collect(Collectors.toSet());
    }

    public static Set<Emoji> getAllEmojisBySubGroup(EmojiSubGroup subgroup) {
        return EMOJIS_LENGTH_DESCENDING.stream().filter(emoji -> emoji.getSubgroup() == subgroup).collect(Collectors.toSet());
    }

    public static List<Emoji> getAllEmojisLengthDescending() {
        return EMOJIS_LENGTH_DESCENDING;
    }

    public static Optional<List<Emoji>> getByAlias(String alias) {
        if (InternalEmojiUtils.isStringNullOrEmpty(alias)) {
            return Optional.empty();
        }
        return InternalEmojiUtils.findEmojiByEitherAlias(EMOJI_ALIAS_TO_EMOJIS, alias);
    }

    public static Optional<Emoji> getByDiscordAlias(String alias) {
        if (InternalEmojiUtils.isStringNullOrEmpty(alias)) {
            return Optional.empty();
        }
        return InternalEmojiUtils.findEmojiByEitherAlias(EMOJI_ALIAS_TO_EMOJIS, alias).flatMap(emojis -> {
            for (Emoji emoji : emojis) {
                if (emoji.getDiscordAliases().isEmpty()) continue;
                return Optional.of(emoji);
            }
            return Optional.empty();
        });
    }

    public static Optional<Emoji> getByGithubAlias(String alias) {
        if (InternalEmojiUtils.isStringNullOrEmpty(alias)) {
            return Optional.empty();
        }
        return InternalEmojiUtils.findEmojiByEitherAlias(EMOJI_ALIAS_TO_EMOJIS, alias).flatMap(emojis -> {
            for (Emoji emoji : emojis) {
                if (emoji.getGithubAliases().isEmpty()) continue;
                return Optional.of(emoji);
            }
            return Optional.empty();
        });
    }

    public static Optional<Emoji> getBySlackAlias(String alias) {
        if (InternalEmojiUtils.isStringNullOrEmpty(alias)) {
            return Optional.empty();
        }
        return InternalEmojiUtils.findEmojiByEitherAlias(EMOJI_ALIAS_TO_EMOJIS, alias).flatMap(emojis -> {
            for (Emoji emoji : emojis) {
                if (emoji.getSlackAliases().isEmpty()) continue;
                return Optional.of(emoji);
            }
            return Optional.empty();
        });
    }

    public static Pattern getEmojiPattern() {
        if (EMOJI_PATTERN == null) {
            EMOJI_PATTERN = Pattern.compile(EMOJIS_LENGTH_DESCENDING.stream().map(s -> "(" + Pattern.quote(s.getEmoji()) + ")").collect(Collectors.joining("|")));
        }
        return EMOJI_PATTERN;
    }

    public static boolean containsAnyEmoji(String text) {
        return EmojiManager.containsAnyEmoji(text, EnumSet.of(EmojiType.UNICODE));
    }

    public static boolean containsAnyEmoji(String text, EnumSet<EmojiType> emojiType) {
        if (InternalEmojiUtils.isStringNullOrEmpty(text)) {
            return false;
        }
        int[] textCodePointsArray = InternalEmojiUtils.stringToCodePoints(text);
        long textCodePointsLength = textCodePointsArray.length;
        int textIndex = 0;
        while ((long)textIndex < textCodePointsLength) {
            if (!InternalEmojiUtils.checkIfCodepointIsInvalidEmojiStarter(textCodePointsArray[textIndex])) {
                for (EmojiType type : emojiType) {
                    UniqueEmojiFoundResult uniqueEmojiFoundResult = InternalEmojiUtils.findUniqueEmoji(textCodePointsArray, textIndex, textCodePointsLength, type);
                    if (uniqueEmojiFoundResult == null) continue;
                    return true;
                }
            }
            ++textIndex;
        }
        return false;
    }

    public static Set<Emoji> extractEmojis(String text) {
        return Collections.unmodifiableSet(new HashSet<Emoji>(EmojiManager.extractEmojisInOrder(text)));
    }

    public static Set<Emoji> extractEmojis(String text, EnumSet<EmojiType> emojiType) {
        return Collections.unmodifiableSet(new HashSet<Emoji>(EmojiManager.extractEmojisInOrder(text, emojiType)));
    }

    public static List<Emoji> extractEmojisInOrder(String text) {
        return EmojiManager.extractEmojisInOrderWithIndex(text).stream().map(IndexedEmoji::getEmoji).collect(Collectors.toList());
    }

    public static List<Emoji> extractEmojisInOrder(String text, EnumSet<EmojiType> emojiType) {
        return EmojiManager.extractEmojisInOrderWithIndex(text, emojiType).stream().map(IndexedEmoji::getEmoji).collect(Collectors.toList());
    }

    public static List<IndexedEmoji> extractEmojisInOrderWithIndex(String text) {
        return EmojiManager.extractEmojisInOrderWithIndex(text, EnumSet.of(EmojiType.UNICODE));
    }

    public static List<IndexedEmoji> extractEmojisInOrderWithIndex(String text, EnumSet<EmojiType> emojiType) {
        if (InternalEmojiUtils.isStringNullOrEmpty(text)) {
            return Collections.emptyList();
        }
        ArrayList<IndexedEmoji> emojis = new ArrayList<IndexedEmoji>();
        int[] textCodePointsArray = InternalEmojiUtils.stringToCodePoints(text);
        long textCodePointsLength = textCodePointsArray.length;
        int charIndex = 0;
        int textIndex = 0;
        while ((long)textIndex < textCodePointsLength) {
            block6: {
                int currentCodepoint = textCodePointsArray[textIndex];
                if (InternalEmojiUtils.checkIfCodepointIsInvalidEmojiStarter(currentCodepoint)) {
                    charIndex += Character.charCount(currentCodepoint);
                } else {
                    for (EmojiType type : emojiType) {
                        UniqueEmojiFoundResult uniqueEmojiFoundResult = InternalEmojiUtils.findUniqueEmoji(textCodePointsArray, textIndex, textCodePointsLength, type);
                        if (uniqueEmojiFoundResult == null) continue;
                        int startCharIndex = charIndex;
                        int startTextIndex = textIndex;
                        for (int i = textIndex; i < uniqueEmojiFoundResult.getEndIndex(); ++i) {
                            charIndex += Character.charCount(textCodePointsArray[i]);
                        }
                        emojis.add(new IndexedEmoji(uniqueEmojiFoundResult.getEmoji(), startCharIndex, startTextIndex, charIndex, textIndex));
                        textIndex = uniqueEmojiFoundResult.getEndIndex() - 1;
                        break block6;
                    }
                    charIndex += Character.charCount(currentCodepoint);
                }
            }
            ++textIndex;
        }
        return Collections.unmodifiableList(emojis);
    }

    public static String removeAllEmojis(String text) {
        return EmojiManager.removeAllEmojisExcept(text, Collections.emptyList(), EnumSet.of(EmojiType.UNICODE));
    }

    public static String removeAllEmojis(String text, EnumSet<EmojiType> emojiType) {
        return EmojiManager.removeAllEmojisExcept(text, Collections.emptyList(), emojiType);
    }

    public static String removeEmojis(String text, Emoji ... emojisToRemove) {
        return EmojiManager.removeEmojis(text, Arrays.asList(emojisToRemove));
    }

    public static String removeEmojis(String text, Collection<Emoji> emojisToRemove) {
        return EmojiManager.removeEmojis(text, emojisToRemove, EnumSet.of(EmojiType.UNICODE));
    }

    public static String removeEmojis(String text, Collection<Emoji> emojisToRemove, EnumSet<EmojiType> emojiType) {
        HashSet<Emoji> emojis = new HashSet<Emoji>(EMOJIS_LENGTH_DESCENDING);
        emojis.removeAll(emojisToRemove);
        return EmojiManager.removeAllEmojisExcept(text, emojis, emojiType);
    }

    public static String removeAllEmojisExcept(String text, Emoji ... emojisToKeep) {
        return EmojiManager.removeAllEmojisExcept(text, Arrays.asList(emojisToKeep));
    }

    public static String removeAllEmojisExcept(String text, Collection<Emoji> emojisToKeep) {
        return EmojiManager.removeAllEmojisExcept(text, emojisToKeep, EnumSet.of(EmojiType.UNICODE));
    }

    public static String removeAllEmojisExcept(String text, Collection<Emoji> emojisToKeep, EnumSet<EmojiType> emojiType) {
        if (InternalEmojiUtils.isStringNullOrEmpty(text)) {
            return "";
        }
        int[] textCodePointsArray = InternalEmojiUtils.stringToCodePoints(text);
        long textCodePointsLength = textCodePointsArray.length;
        StringBuilder sb = new StringBuilder();
        int textIndex = 0;
        while ((long)textIndex < textCodePointsLength) {
            int currentCodepoint = textCodePointsArray[textIndex];
            sb.appendCodePoint(currentCodepoint);
            if (!InternalEmojiUtils.checkIfCodepointIsInvalidEmojiStarter(currentCodepoint)) {
                for (EmojiType type : emojiType) {
                    UniqueEmojiFoundResult uniqueEmojiFoundResult = InternalEmojiUtils.findUniqueEmoji(textCodePointsArray, textIndex, textCodePointsLength, type);
                    if (uniqueEmojiFoundResult == null) continue;
                    if (emojisToKeep.contains(uniqueEmojiFoundResult.getEmoji())) {
                        for (int i = textIndex + 1; i < uniqueEmojiFoundResult.getEndIndex(); ++i) {
                            sb.appendCodePoint(textCodePointsArray[i]);
                        }
                    } else {
                        sb.delete(sb.length() - Character.charCount(currentCodepoint), sb.length());
                    }
                    textIndex = uniqueEmojiFoundResult.getEndIndex() - 1;
                    break;
                }
            }
            ++textIndex;
        }
        return sb.toString();
    }

    public static String replaceAllEmojis(String text, String replacementString) {
        return EmojiManager.replaceEmojis(text, replacementString, EMOJIS_LENGTH_DESCENDING);
    }

    public static String replaceAllEmojis(String text, String replacementString, EnumSet<EmojiType> emojiType) {
        return EmojiManager.replaceEmojis(text, replacementString, EMOJIS_LENGTH_DESCENDING, emojiType);
    }

    public static String replaceAllEmojis(String text, Function<Emoji, String> replacementFunction) {
        return EmojiManager.replaceEmojis(text, replacementFunction, EMOJIS_LENGTH_DESCENDING);
    }

    public static String replaceAllEmojis(String text, Function<Emoji, String> replacementFunction, EnumSet<EmojiType> emojiType) {
        return EmojiManager.replaceEmojis(text, replacementFunction, EMOJIS_LENGTH_DESCENDING, emojiType);
    }

    public static String replaceEmojis(String text, String replacementString, Collection<Emoji> emojisToReplace) {
        return EmojiManager.replaceEmojis(text, (Emoji emoji) -> replacementString, emojisToReplace);
    }

    public static String replaceEmojis(String text, String replacementString, Collection<Emoji> emojisToReplace, EnumSet<EmojiType> emojiType) {
        return EmojiManager.replaceEmojis(text, (Emoji emoji) -> replacementString, emojisToReplace, emojiType);
    }

    public static String replaceEmojis(String text, String replacementString, Emoji ... emojisToReplace) {
        return EmojiManager.replaceEmojis(text, (Emoji emoji) -> replacementString, Arrays.asList(emojisToReplace));
    }

    public static String replaceEmojis(String text, Function<Emoji, String> replacementFunction, Collection<Emoji> emojisToReplace) {
        return EmojiManager.replaceEmojis(text, replacementFunction, emojisToReplace, EnumSet.of(EmojiType.UNICODE));
    }

    public static String replaceEmojis(String text, Function<Emoji, String> replacementFunction, Collection<Emoji> emojisToReplace, EnumSet<EmojiType> emojiType) {
        if (InternalEmojiUtils.isStringNullOrEmpty(text)) {
            return "";
        }
        int[] textCodePointsArray = InternalEmojiUtils.stringToCodePoints(text);
        long textCodePointsLength = textCodePointsArray.length;
        StringBuilder sb = new StringBuilder();
        int textIndex = 0;
        while ((long)textIndex < textCodePointsLength) {
            int currentCodepoint = textCodePointsArray[textIndex];
            sb.appendCodePoint(currentCodepoint);
            if (!InternalEmojiUtils.checkIfCodepointIsInvalidEmojiStarter(currentCodepoint)) {
                for (EmojiType type : emojiType) {
                    UniqueEmojiFoundResult uniqueEmojiFoundResult = InternalEmojiUtils.findUniqueEmoji(textCodePointsArray, textIndex, textCodePointsLength, type);
                    if (uniqueEmojiFoundResult == null) continue;
                    textIndex = uniqueEmojiFoundResult.getEndIndex() - 1;
                    sb.delete(sb.length() - Character.charCount(currentCodepoint), sb.length());
                    if (emojisToReplace.contains(uniqueEmojiFoundResult.getEmoji())) {
                        sb.append(replacementFunction.apply(uniqueEmojiFoundResult.getEmoji()));
                        break;
                    }
                    sb.append(uniqueEmojiFoundResult.getEmoji().getEmoji());
                    break;
                }
            }
            ++textIndex;
        }
        return sb.toString();
    }

    public static String replaceAliases(String text, BiFunction<String, List<Emoji>, String> replacementFunction) {
        if (InternalEmojiUtils.isStringNullOrEmpty(text)) {
            return "";
        }
        int[] textCodePointsArray = InternalEmojiUtils.stringToCodePoints(text);
        long textCodePointsLength = textCodePointsArray.length;
        StringBuilder sb = new StringBuilder();
        int textIndex = 0;
        while ((long)textIndex < textCodePointsLength) {
            NonUniqueEmojiFoundResult nonUniqueEmojiFoundResult;
            int currentCodepoint = textCodePointsArray[textIndex];
            sb.appendCodePoint(currentCodepoint);
            if (POSSIBLE_EMOJI_ALIAS_STARTER_CODEPOINTS.contains(currentCodepoint) && (nonUniqueEmojiFoundResult = InternalEmojiUtils.findNonUniqueEmoji(textCodePointsArray, textIndex, textCodePointsLength)) != null) {
                textIndex = nonUniqueEmojiFoundResult.getEndIndex() - 1;
                sb.delete(sb.length() - Character.charCount(currentCodepoint), sb.length());
                sb.append(replacementFunction.apply(new String(nonUniqueEmojiFoundResult.getCodepointSequence().getCodepoints(), 0, nonUniqueEmojiFoundResult.getCodepointSequence().getCodepoints().length), nonUniqueEmojiFoundResult.getEmojis()));
            }
            ++textIndex;
        }
        return sb.toString();
    }

    public static Set<String> extractAliases(String text) {
        return Collections.unmodifiableSet(new HashSet<String>(EmojiManager.extractAliasesInOrder(text)));
    }

    public static List<String> extractAliasesInOrder(String text) {
        return EmojiManager.extractAliasesInOrderWithIndex(text).stream().map(IndexedAlias::getAlias).collect(Collectors.toList());
    }

    public static List<IndexedAlias> extractAliasesInOrderWithIndex(String text) {
        if (InternalEmojiUtils.isStringNullOrEmpty(text)) {
            return Collections.emptyList();
        }
        int[] textCodePointsArray = InternalEmojiUtils.stringToCodePoints(text);
        long textCodePointsLength = textCodePointsArray.length;
        ArrayList<IndexedAlias> indexedAliases = new ArrayList<IndexedAlias>();
        int charIndex = 0;
        int textIndex = 0;
        while ((long)textIndex < textCodePointsLength) {
            int currentCodepoint = textCodePointsArray[textIndex];
            if (!POSSIBLE_EMOJI_ALIAS_STARTER_CODEPOINTS.contains(currentCodepoint)) {
                charIndex += Character.charCount(currentCodepoint);
            } else {
                NonUniqueEmojiFoundResult nonUniqueEmojiFoundResult = InternalEmojiUtils.findNonUniqueEmoji(textCodePointsArray, textIndex, textCodePointsLength);
                if (nonUniqueEmojiFoundResult != null) {
                    int startCharIndex = charIndex;
                    int startTextIndex = textIndex;
                    for (int i = textIndex; i < nonUniqueEmojiFoundResult.getEndIndex(); ++i) {
                        charIndex += Character.charCount(textCodePointsArray[i]);
                    }
                    indexedAliases.add(new IndexedAlias(new String(nonUniqueEmojiFoundResult.getCodepointSequence().getCodepoints(), 0, nonUniqueEmojiFoundResult.getCodepointSequence().getCodepoints().length), nonUniqueEmojiFoundResult.getEmojis(), startCharIndex, startTextIndex, charIndex, textIndex));
                    textIndex = nonUniqueEmojiFoundResult.getEndIndex() - 1;
                }
            }
            ++textIndex;
        }
        return indexedAliases;
    }

    static {
        NOT_WANTED_EMOJI_CHARACTERS = Pattern.compile("[\\p{Alpha}\\p{Z}]");
        EMOJI_DESCRIPTION_LANGUAGE_MAP = new HashMap<EmojiLanguage, Map<String, String>>();
        EMOJI_KEYWORD_LANGUAGE_MAP = new HashMap<EmojiLanguage, Map<String, List<String>>>();
        HashSet<Emoji> emojis = new HashSet<Emoji>();
        emojis.addAll(EmojiLoaderA.EMOJI_LIST);
        emojis.addAll(EmojiLoaderB.EMOJI_LIST);
        EMOJI_UNICODE_TO_EMOJI = Collections.unmodifiableMap(EmojiManager.prepareEmojisStreamForInitialization(emojis).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue, (existing, replacement) -> existing)));
        EMOJIS_LENGTH_DESCENDING = Collections.unmodifiableList(emojis.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList()));
        EMOJI_FIRST_CODEPOINT_TO_EMOJIS_ORDER_CODEPOINT_LENGTH_DESCENDING = Collections.unmodifiableMap((Map)EmojiManager.prepareEmojisStreamForInitialization(emojis).collect(EmojiManager.getEmojiLinkedHashMapCollector()));
        EMOJI_HTML_DECIMAL_REPRESENTATION_TO_EMOJI = Collections.unmodifiableMap(emojis.stream().collect(Collectors.toMap(o -> o.getHtmlDecimalCode().toUpperCase(), emoji -> emoji, (existing, replacement) -> existing)));
        EMOJI_HTML_HEXADECIMAL_REPRESENTATION_TO_EMOJI = Collections.unmodifiableMap(emojis.stream().collect(Collectors.toMap(o -> o.getHtmlHexadecimalCode().toUpperCase(), emoji -> emoji, (existing, replacement) -> existing)));
        EMOJI_URL_ENCODED_REPRESENTATION_TO_EMOJI = Collections.unmodifiableMap(emojis.stream().collect(Collectors.toMap(o -> o.getURLEncoded().toUpperCase(), emoji -> emoji, (existing, replacement) -> existing)));
        MAX_HTML_DECIMAL_SINGLE_EMOJIS_CONCATENATED_LENGTH = (int)EMOJI_HTML_DECIMAL_REPRESENTATION_TO_EMOJI.keySet().stream().mapToLong(value -> value.chars().filter(ch -> ch == 59).count()).max().orElseThrow(IllegalStateException::new);
        MIN_HTML_DECIMAL_CODEPOINT_LENGTH = EMOJI_HTML_DECIMAL_REPRESENTATION_TO_EMOJI.keySet().stream().map(InternalEmojiUtils::stringToCodePoints).map(ints -> ((int[])ints).length).min(Comparator.comparingInt(Integer::intValue)).orElseThrow(IllegalStateException::new);
        EMOJI_ALIAS_TO_EMOJIS = EmojiManager.getAllEmojis().stream().flatMap(emoji -> emoji.getAllAliases().stream().map(alias -> new AbstractMap.SimpleEntry<String, Emoji>((String)alias, (Emoji)emoji))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        POSSIBLE_EMOJI_ALIAS_STARTER_CODEPOINTS = emojis.stream().flatMap(emoji -> emoji.getAllAliases().stream()).distinct().map(s -> s.codePointAt(0)).collect(Collectors.toSet());
        ALIAS_EMOJI_TO_EMOJIS_ORDER_CODEPOINT_LENGTH_DESCENDING = EmojiManager.mapAliasesToEmojis(EMOJIS_LENGTH_DESCENDING);
        ALIAS_EMOJI_MAX_LENGTH = EMOJIS_LENGTH_DESCENDING.stream().flatMap(emoji -> emoji.getAllAliases().stream()).distinct().map(InternalEmojiUtils::getCodePointCount).max(Comparator.naturalOrder()).orElse(0);
        POSSIBLE_EMOJI_URL_ENCODED_STARTER_CODEPOINTS = emojis.stream().map(Emoji::getURLEncoded).distinct().map(s -> s.codePointAt(0)).collect(Collectors.toSet());
        MINIMUM_EMOJI_URL_ENCODED_LENGTH = emojis.stream().map(Emoji::getURLEncoded).distinct().map(InternalEmojiUtils::getCodePointCount).min(Comparator.naturalOrder()).orElse(0);
        MAXIMUM_EMOJI_URL_ENCODED_LENGTH = emojis.stream().map(Emoji::getURLEncoded).distinct().map(InternalEmojiUtils::getCodePointCount).max(Comparator.naturalOrder()).orElse(0);
        ALLOWED_EMOJI_URL_ENCODED_SEQUENCES = emojis.stream().map(Emoji::getURLEncoded).distinct().flatMap(s -> Arrays.stream(s.split("%"))).collect(Collectors.toSet());
    }
}

