/*
 * Decompiled with CFR 0.152.
 */
package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fellbaum.jemoji.Emoji;
import net.fellbaum.jemoji.EmojiManager;
import net.fellbaum.jemoji.EmojiType;
import net.fellbaum.jemoji.InternalCodepointSequence;
import net.fellbaum.jemoji.NonUniqueEmojiFoundResult;
import net.fellbaum.jemoji.UniqueEmojiFoundResult;
import org.jspecify.annotations.Nullable;

final class InternalEmojiUtils {
    public static final char TEXT_VARIATION_CHARACTER = '\ufe0e';
    public static final char EMOJI_VARIATION_CHARACTER = '\ufe0f';
    private static final int MAX_LENGTH_HTML_DECIMAL_NUMBER_COUNT = 6;

    private InternalEmojiUtils() {
    }

    public static int getCodePointCount(String string) {
        return string.codePointCount(0, string.length());
    }

    public static boolean isStringNullOrEmpty(@Nullable String string) {
        return null == string || string.isEmpty();
    }

    public static String removeColonFromAlias(String alias) {
        return alias.startsWith(":") && alias.endsWith(":") ? alias.substring(1, alias.length() - 1) : alias;
    }

    public static String addColonToAlias(String alias) {
        return alias.startsWith(":") && alias.endsWith(":") ? alias : ":" + alias + ":";
    }

    public static Optional<List<Emoji>> findEmojiByEitherAlias(Map<String, List<Emoji>> map, String alias) {
        List<Emoji> firstValue = map.get(InternalEmojiUtils.addColonToAlias(alias));
        if (firstValue != null) {
            return Optional.of(firstValue);
        }
        List<Emoji> secondValue = map.get(InternalEmojiUtils.removeColonFromAlias(alias));
        if (secondValue != null) {
            return Optional.of(secondValue);
        }
        return Optional.empty();
    }

    public static int[] stringToCodePoints(String text) {
        int codePoint;
        int[] codePoints = new int[InternalEmojiUtils.getCodePointCount(text)];
        int j = 0;
        for (int i = 0; i < text.length(); i += Character.charCount(codePoint)) {
            codePoint = text.codePointAt(i);
            codePoints[j++] = codePoint;
        }
        return codePoints;
    }

    static @Nullable UniqueEmojiFoundResult findUnicodeEmoji(int[] textCodePointsArray, long textCodePointsLength, int textIndex) {
        List<Emoji> emojisByCodePoint = EmojiManager.EMOJI_FIRST_CODEPOINT_TO_EMOJIS_ORDER_CODEPOINT_LENGTH_DESCENDING.get(textCodePointsArray[textIndex]);
        if (emojisByCodePoint == null) {
            return null;
        }
        for (Emoji emoji : emojisByCodePoint) {
            int[] emojiCodePointsArray = InternalEmojiUtils.stringToCodePoints(emoji.getEmoji());
            int emojiCodePointsLength = emojiCodePointsArray.length;
            if ((long)(textIndex + emojiCodePointsLength) > textCodePointsLength) continue;
            for (int emojiCodePointIndex = 0; emojiCodePointIndex < emojiCodePointsLength && textCodePointsArray[textIndex + emojiCodePointIndex] == emojiCodePointsArray[emojiCodePointIndex]; ++emojiCodePointIndex) {
                if (emojiCodePointIndex != emojiCodePointsLength - 1) continue;
                return new UniqueEmojiFoundResult(emoji, textIndex + emojiCodePointsLength);
            }
        }
        return null;
    }

    static @Nullable UniqueEmojiFoundResult findHtmlDecimalEmoji(int[] textCodePointsArray, long textCodePointsLength, int textIndex, boolean isHex) {
        if (isHex ? (long)textIndex >= textCodePointsLength - 3L || InternalEmojiUtils.isInvalidHtmlHexadecimalSequence(textCodePointsArray, textIndex) : (long)textIndex >= textCodePointsLength - 2L || InternalEmojiUtils.isInvalidHtmlDecimalSequence(textCodePointsArray, textIndex)) {
            return null;
        }
        int currentIndex = textIndex;
        int lastValidSemicolonIndex = -1;
        StringBuilder sequenceBuilder = new StringBuilder();
        int leadingZeros = 0;
        for (int numberSequenceCount = 0; numberSequenceCount < EmojiManager.MAX_HTML_DECIMAL_SINGLE_EMOJIS_CONCATENATED_LENGTH && (long)currentIndex < textCodePointsLength - (long)(isHex ? 3 : 2) && !(!isHex ? InternalEmojiUtils.isInvalidHtmlDecimalSequence(textCodePointsArray, currentIndex) : InternalEmojiUtils.isInvalidHtmlHexadecimalSequence(textCodePointsArray, currentIndex)); ++numberSequenceCount) {
            currentIndex += isHex ? 3 : 2;
            int digitCount = 0;
            boolean isLeadingZero = true;
            while (digitCount < 6 + leadingZeros && (long)currentIndex < textCodePointsLength && (isHex ? InternalEmojiUtils.isValidHexadecimalCharacter(textCodePointsArray[currentIndex]) : InternalEmojiUtils.isValidDecimalCharacter(textCodePointsArray[currentIndex]))) {
                if (isLeadingZero && textCodePointsArray[currentIndex + leadingZeros] == 48) {
                    ++leadingZeros;
                    continue;
                }
                isLeadingZero = false;
                ++digitCount;
                ++currentIndex;
            }
            if (digitCount == 0 || (long)currentIndex >= textCodePointsLength || textCodePointsArray[currentIndex] != 59) break;
            lastValidSemicolonIndex = ++currentIndex;
        }
        if (lastValidSemicolonIndex == -1) {
            return null;
        }
        StringBuilder htmlEmoji = new StringBuilder(new String(textCodePointsArray, textIndex, lastValidSemicolonIndex - textIndex).toUpperCase());
        while (htmlEmoji.length() != 0) {
            Emoji emoji;
            String htmlEmojiString = htmlEmoji.toString();
            String formattedHtmlCharacterEntity = leadingZeros != 0 ? InternalEmojiUtils.removeLeadingZerosFromHtmlCharacterEntity(htmlEmojiString, isHex) : htmlEmojiString;
            Emoji emoji2 = emoji = isHex ? EmojiManager.EMOJI_HTML_HEXADECIMAL_REPRESENTATION_TO_EMOJI.get(formattedHtmlCharacterEntity) : EmojiManager.EMOJI_HTML_DECIMAL_REPRESENTATION_TO_EMOJI.get(formattedHtmlCharacterEntity);
            if (emoji != null) {
                return new UniqueEmojiFoundResult(emoji, textIndex + htmlEmojiString.length());
            }
            htmlEmoji.delete(htmlEmoji.lastIndexOf("&"), htmlEmojiString.length());
        }
        return null;
    }

    static @Nullable UniqueEmojiFoundResult findUrlEncodedEmoji(int[] textCodePointsArray, long textCodePointsLength, int textIndex) {
        if ((long)(textIndex + EmojiManager.MINIMUM_EMOJI_URL_ENCODED_LENGTH) >= textCodePointsLength || !EmojiManager.POSSIBLE_EMOJI_URL_ENCODED_STARTER_CODEPOINTS.contains(textCodePointsArray[textIndex])) {
            return null;
        }
        int currentIndex = textIndex;
        if (textCodePointsArray[textIndex] != 37) {
            ++currentIndex;
        }
        while (currentIndex - textIndex < EmojiManager.MAXIMUM_EMOJI_URL_ENCODED_LENGTH && (long)(currentIndex + 1) <= textCodePointsLength && textCodePointsArray[currentIndex] == 37) {
            if ((long)(++currentIndex + 2) <= textCodePointsLength) {
                if (EmojiManager.ALLOWED_EMOJI_URL_ENCODED_SEQUENCES.contains(new String(textCodePointsArray, currentIndex, 2))) {
                    currentIndex += 2;
                    continue;
                }
                if (!EmojiManager.ALLOWED_EMOJI_URL_ENCODED_SEQUENCES.contains(new String(textCodePointsArray, currentIndex, 1))) continue;
                ++currentIndex;
                continue;
            }
            if ((long)(currentIndex + 1) > textCodePointsLength) break;
            if (!EmojiManager.ALLOWED_EMOJI_URL_ENCODED_SEQUENCES.contains(new String(textCodePointsArray, currentIndex, 1))) continue;
            ++currentIndex;
        }
        StringBuilder urlEncodedEmoji = new StringBuilder(new String(textCodePointsArray, textIndex, currentIndex - textIndex).toUpperCase());
        while (urlEncodedEmoji.toString().contains("%")) {
            Emoji emoji = EmojiManager.EMOJI_URL_ENCODED_REPRESENTATION_TO_EMOJI.get(urlEncodedEmoji.toString());
            if (emoji != null) {
                return new UniqueEmojiFoundResult(emoji, textIndex + urlEncodedEmoji.length());
            }
            urlEncodedEmoji.delete(urlEncodedEmoji.lastIndexOf("%"), urlEncodedEmoji.length());
        }
        return null;
    }

    private static String removeLeadingZerosFromHtmlCharacterEntity(String str, boolean isHex) {
        StringBuilder sb = new StringBuilder(str);
        for (int i = 0; i < sb.length(); ++i) {
            int start;
            int end;
            if (sb.charAt(i) != '&' || i + 1 >= sb.length() || sb.charAt(i + 1) != '#') continue;
            for (end = start = i + (isHex ? 3 : 2); end < sb.length() && sb.charAt(end) == '0'; ++end) {
            }
            if (end >= sb.length() || (!isHex || !InternalEmojiUtils.isValidHexadecimalCharacter(sb.charAt(end))) && (isHex || !InternalEmojiUtils.isValidDecimalCharacter(sb.charAt(end)))) continue;
            sb.delete(start, end);
        }
        return sb.toString();
    }

    private static boolean isInvalidHtmlHexadecimalSequence(int[] textCodePointsArray, int currentIndex) {
        return InternalEmojiUtils.isInvalidHtmlDecimalSequence(textCodePointsArray, currentIndex) || textCodePointsArray[currentIndex + 2] != 120 && textCodePointsArray[currentIndex + 2] != 88;
    }

    private static boolean isInvalidHtmlDecimalSequence(int[] textCodePointsArray, int currentIndex) {
        return textCodePointsArray[currentIndex] != 38 || textCodePointsArray[currentIndex + 1] != 35;
    }

    private static boolean isValidHexadecimalCharacter(int character) {
        return Character.digit(character, 16) != -1;
    }

    private static boolean isValidDecimalCharacter(int character) {
        return Character.digit(character, 10) != -1;
    }

    public static @Nullable UniqueEmojiFoundResult findUniqueEmoji(int[] textCodePointsArray, int textIndex, long textCodePointsLength, EmojiType type) {
        switch (type) {
            case UNICODE: {
                return InternalEmojiUtils.findUnicodeEmoji(textCodePointsArray, textCodePointsLength, textIndex);
            }
            case HTML_DECIMAL: {
                return InternalEmojiUtils.findHtmlDecimalEmoji(textCodePointsArray, textCodePointsLength, textIndex, false);
            }
            case HTML_HEXADECIMAL: {
                return InternalEmojiUtils.findHtmlDecimalEmoji(textCodePointsArray, textCodePointsLength, textIndex, true);
            }
            case URL_ENCODED: {
                return InternalEmojiUtils.findUrlEncodedEmoji(textCodePointsArray, textCodePointsLength, textIndex);
            }
        }
        throw new IllegalArgumentException("Unknown EmojiType: " + (Object)((Object)type));
    }

    public static @Nullable NonUniqueEmojiFoundResult findNonUniqueEmoji(int[] textCodePointsArray, int textIndex, long textCodePointsLength) {
        return InternalEmojiUtils.findAliasEmoji(textCodePointsArray, textCodePointsLength, textIndex);
    }

    static @Nullable NonUniqueEmojiFoundResult findAliasEmoji(int[] textCodePointsArray, long textCodePointsLength, int textIndex) {
        if (!EmojiManager.POSSIBLE_EMOJI_ALIAS_STARTER_CODEPOINTS.contains(textCodePointsArray[textIndex])) {
            return null;
        }
        InternalCodepointSequence lastKnownCodepointSequence = null;
        for (int aliasCodePointIndex = 0; aliasCodePointIndex < EmojiManager.ALIAS_EMOJI_MAX_LENGTH && (long)(aliasCodePointIndex + textIndex) <= textCodePointsLength; ++aliasCodePointIndex) {
            InternalCodepointSequence tempCodepointSequence = new InternalCodepointSequence(Arrays.copyOfRange(textCodePointsArray, textIndex, textIndex + aliasCodePointIndex));
            if (!EmojiManager.ALIAS_EMOJI_TO_EMOJIS_ORDER_CODEPOINT_LENGTH_DESCENDING.containsKey(tempCodepointSequence)) continue;
            lastKnownCodepointSequence = tempCodepointSequence;
        }
        if (lastKnownCodepointSequence != null) {
            return new NonUniqueEmojiFoundResult(EmojiManager.ALIAS_EMOJI_TO_EMOJIS_ORDER_CODEPOINT_LENGTH_DESCENDING.get(lastKnownCodepointSequence), textIndex + lastKnownCodepointSequence.getCodepoints().length, lastKnownCodepointSequence);
        }
        return null;
    }

    public static boolean checkIfCodepointIsInvalidEmojiStarter(int currentCodepoint) {
        return EmojiManager.EMOJI_FIRST_CODEPOINT_TO_EMOJIS_ORDER_CODEPOINT_LENGTH_DESCENDING.get(currentCodepoint) == null && currentCodepoint != 38 && currentCodepoint != 37;
    }
}

