/*
 * Decompiled with CFR 0.152.
 */
package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.fellbaum.jemoji.EmojiSubGroup;

public enum EmojiGroup {
    SMILEYS_AND_EMOTION("Smileys & Emotion"),
    PEOPLE_AND_BODY("People & Body"),
    COMPONENT("Component"),
    ANIMALS_AND_NATURE("Animals & Nature"),
    FOOD_AND_DRINK("Food & Drink"),
    TRAVEL_AND_PLACES("Travel & Places"),
    ACTIVITIES("Activities"),
    OBJECTS("Objects"),
    SYMBOLS("Symbols"),
    FLAGS("Flags");

    private static final List<EmojiGroup> EMOJI_GROUPS;
    private final String name;

    private EmojiGroup(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static List<EmojiGroup> getGroups() {
        return EMOJI_GROUPS;
    }

    public static EmojiGroup fromString(String name) {
        for (EmojiGroup emojiGroup : EMOJI_GROUPS) {
            if (!emojiGroup.getName().equals(name)) continue;
            return emojiGroup;
        }
        throw new IllegalArgumentException("No EmojiGroup found for name: " + name);
    }

    public EnumSet<EmojiSubGroup> getSubGroups() {
        return EnumSet.copyOf(EmojiSubGroup.getSubGroups().stream().filter(subgroup -> subgroup.getGroup() == this).collect(Collectors.toList()));
    }

    static {
        EMOJI_GROUPS = Arrays.asList(EmojiGroup.values());
    }
}

