/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.montecarlo.assetderivativevaluation.products.BermudanOption;
import net.finmath.montecarlo.automaticdifferentiation.RandomVariableDifferentiableInterface;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.stochastic.ConditionalExpectationEstimatorInterface;
import net.finmath.stochastic.RandomVariableInterface;

public class DeltaHedgedPortfolioWithAAD
extends AbstractAssetMonteCarloProduct {
    private final AbstractAssetMonteCarloProduct productToReplicate;
    private int orderOfRegressionPolynomial = 4;
    private double lastOperationTimingValuation = Double.NaN;
    private double lastOperationTimingDerivative = Double.NaN;

    public DeltaHedgedPortfolioWithAAD(AbstractAssetMonteCarloProduct productToReplicate) {
        this.productToReplicate = productToReplicate;
    }

    public RandomVariableInterface getValue(double evaluationTime, AssetModelMonteCarloSimulationInterface model) throws CalculationException {
        int timeIndexEvaluationTime = model.getTimeIndex(evaluationTime);
        long timingValuationStart = System.currentTimeMillis();
        RandomVariableDifferentiableInterface value = (RandomVariableDifferentiableInterface)this.productToReplicate.getValue(model.getTime(0), model);
        RandomVariableInterface exerciseTime = null;
        if (this.productToReplicate instanceof BermudanOption) {
            exerciseTime = ((BermudanOption)this.productToReplicate).getLastValuationExerciseTime();
        }
        long timingValuationEnd = System.currentTimeMillis();
        RandomVariableInterface valueOfOption = model.getRandomVariableForConstant(value.getAverage());
        RandomVariableInterface underlyingToday = model.getAssetValue(0.0, 0);
        RandomVariableInterface numeraireToday = model.getNumeraire(0.0);
        RandomVariableInterface amountOfNumeraireAsset = valueOfOption.div(numeraireToday);
        RandomVariableInterface amountOfUderlyingAsset = model.getRandomVariableForConstant(0.0);
        long timingDerivativeStart = System.currentTimeMillis();
        Map<Long, RandomVariableInterface> gradient = value.getGradient();
        long timingDerivativeEnd = System.currentTimeMillis();
        this.lastOperationTimingValuation = (double)(timingValuationEnd - timingValuationStart) / 1000.0;
        this.lastOperationTimingDerivative = (double)(timingDerivativeEnd - timingDerivativeStart) / 1000.0;
        for (int timeIndex = 0; timeIndex < timeIndexEvaluationTime; ++timeIndex) {
            RandomVariableInterface newNumberOfNumeraireAsset;
            RandomVariableInterface underlyingAtTimeIndex = model.getAssetValue(timeIndex, 0);
            RandomVariableInterface numeraireAtTimeIndex = model.getNumeraire(timeIndex);
            RandomVariableInterface delta = gradient.get(((RandomVariableDifferentiableInterface)underlyingAtTimeIndex).getID());
            if (delta == null) {
                delta = underlyingAtTimeIndex.mult(0.0);
            }
            delta = delta.mult(numeraireAtTimeIndex);
            RandomVariable indicator = new RandomVariable(1.0);
            if (exerciseTime != null) {
                indicator = exerciseTime.barrier(exerciseTime.sub(model.getTime(timeIndex) + 0.001), (RandomVariableInterface)new RandomVariable(1.0), 0.0);
            }
            ArrayList<RandomVariableInterface> basisFunctions = this.getRegressionBasisFunctionsBinning(underlyingAtTimeIndex, (RandomVariableInterface)indicator);
            MonteCarloConditionalExpectationRegression conditionalExpectationOperator = new MonteCarloConditionalExpectationRegression(basisFunctions.toArray(new RandomVariableInterface[0]));
            RandomVariableInterface newNumberOfStocks = delta = delta.getConditionalExpectation((ConditionalExpectationEstimatorInterface)conditionalExpectationOperator);
            RandomVariableInterface stocksToBuy = newNumberOfStocks.sub(amountOfUderlyingAsset);
            RandomVariableInterface numeraireAssetsToSell = stocksToBuy.mult(underlyingAtTimeIndex).div(numeraireAtTimeIndex);
            amountOfNumeraireAsset = newNumberOfNumeraireAsset = amountOfNumeraireAsset.sub(numeraireAssetsToSell);
            amountOfUderlyingAsset = newNumberOfStocks;
        }
        RandomVariableInterface underlyingAtEvaluationTime = model.getAssetValue(evaluationTime, 0);
        RandomVariableInterface numeraireAtEvaluationTime = model.getNumeraire(evaluationTime);
        RandomVariableInterface portfolioValue = amountOfNumeraireAsset.mult(numeraireAtEvaluationTime).add(amountOfUderlyingAsset.mult(underlyingAtEvaluationTime));
        return portfolioValue;
    }

    public double getLastOperationTimingValuation() {
        return this.lastOperationTimingValuation;
    }

    public double getLastOperationTimingDerivative() {
        return this.lastOperationTimingDerivative;
    }

    private ArrayList<RandomVariableInterface> getRegressionBasisFunctions(RandomVariableInterface underlying, RandomVariableInterface indicator) {
        ArrayList<RandomVariableInterface> basisFunctions = new ArrayList<RandomVariableInterface>();
        for (int powerOfRegressionMonomial = 0; powerOfRegressionMonomial <= this.orderOfRegressionPolynomial; ++powerOfRegressionMonomial) {
            basisFunctions.add(underlying.pow((double)powerOfRegressionMonomial).mult(indicator));
        }
        return basisFunctions;
    }

    private ArrayList<RandomVariableInterface> getRegressionBasisFunctionsBinning(RandomVariableInterface underlying, RandomVariableInterface indicator) {
        ArrayList<RandomVariableInterface> basisFunctions = new ArrayList<RandomVariableInterface>();
        int numberOfBins = 20;
        double[] values = underlying.getRealizations();
        Arrays.sort(values);
        for (int i = 0; i < numberOfBins; ++i) {
            double binLeft = values[(int)((double)i / (double)numberOfBins * (double)values.length)];
            RandomVariableInterface basisFunction = underlying.barrier(underlying.sub(binLeft), (RandomVariableInterface)new RandomVariable(1.0), 0.0).mult(indicator);
            basisFunctions.add(basisFunction);
        }
        return basisFunctions;
    }
}

