/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.automaticdifferentiation.backward;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import net.finmath.functions.DoubleTernaryOperator;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.automaticdifferentiation.RandomVariableDifferentiableInterface;
import net.finmath.montecarlo.automaticdifferentiation.backward.RandomVariableDifferentiableAADFactory;
import net.finmath.stochastic.ConditionalExpectationEstimatorInterface;
import net.finmath.stochastic.RandomVariableInterface;

public class RandomVariableDifferentiableAAD
implements RandomVariableDifferentiableInterface {
    private static final long serialVersionUID = 2459373647785530657L;
    private static AtomicLong indexOfNextRandomVariable = new AtomicLong(0L);
    private RandomVariableInterface values;
    private final OperatorTreeNode operatorTreeNode;
    private final RandomVariableDifferentiableAADFactory factory;

    public static RandomVariableDifferentiableAAD of(double value) {
        return new RandomVariableDifferentiableAAD(value);
    }

    public static RandomVariableDifferentiableAAD of(RandomVariableInterface randomVariable) {
        return new RandomVariableDifferentiableAAD(randomVariable);
    }

    public RandomVariableDifferentiableAAD(double value) {
        this((RandomVariableInterface)new RandomVariable(value), null, null, null);
    }

    public RandomVariableDifferentiableAAD(RandomVariableInterface randomVariable) {
        this(randomVariable, null, null, randomVariable instanceof RandomVariableDifferentiableAAD ? ((RandomVariableDifferentiableAAD)randomVariable).getFactory() : null);
    }

    public RandomVariableDifferentiableAAD(RandomVariableInterface values, RandomVariableDifferentiableAADFactory factory) {
        this(values, null, null, factory);
    }

    private RandomVariableDifferentiableAAD(RandomVariableInterface values, List<RandomVariableInterface> arguments, OperatorType operator, RandomVariableDifferentiableAADFactory factory) {
        this(values, arguments, null, operator, factory);
    }

    public RandomVariableDifferentiableAAD(RandomVariableInterface values, List<RandomVariableInterface> arguments, ConditionalExpectationEstimatorInterface estimator, OperatorType operator, RandomVariableDifferentiableAADFactory factory) {
        this.values = values;
        this.operatorTreeNode = new OperatorTreeNode(operator, arguments, estimator, factory);
        this.factory = factory != null ? factory : new RandomVariableDifferentiableAADFactory();
    }

    public OperatorTreeNode getOperatorTreeNode() {
        return this.operatorTreeNode;
    }

    private RandomVariableInterface getValues() {
        return this.values;
    }

    public RandomVariableDifferentiableAADFactory getFactory() {
        return this.factory;
    }

    @Override
    public Long getID() {
        return this.getOperatorTreeNode().id;
    }

    @Override
    public Map<Long, RandomVariableInterface> getGradient(Set<Long> independentIDs) {
        HashMap<Long, RandomVariableInterface> derivatives = new HashMap<Long, RandomVariableInterface>();
        derivatives.put(this.getID(), this.getFactory().createRandomVariableNonDifferentiable(Double.NEGATIVE_INFINITY, 1.0));
        TreeMap<Long, OperatorTreeNode> independents = new TreeMap<Long, OperatorTreeNode>();
        independents.put(this.getID(), this.getOperatorTreeNode());
        while (independents.size() > 0) {
            Map.Entry independentEntry = independents.pollLastEntry();
            Long id = (Long)independentEntry.getKey();
            OperatorTreeNode independent = (OperatorTreeNode)independentEntry.getValue();
            List arguments = independent.arguments;
            if (arguments != null && arguments.size() > 0) {
                independent.propagateDerivativesFromResultToArgument(derivatives);
                if (this.isGradientRetainsLeafNodesOnly()) {
                    derivatives.remove(id);
                }
                for (OperatorTreeNode argument : arguments) {
                    if (argument == null) continue;
                    independents.put(argument.id, argument);
                }
            }
            if (independentIDs == null || !independentIDs.contains(id)) continue;
            derivatives.remove(id);
        }
        return derivatives;
    }

    private boolean isGradientRetainsLeafNodesOnly() {
        return this.getFactory() != null && this.getFactory().isGradientRetainsLeafNodesOnly();
    }

    @Override
    public Map<Long, RandomVariableInterface> getTangents(Set<Long> dependentIDs) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(RandomVariableInterface randomVariable) {
        return this.getValues().equals(randomVariable);
    }

    public double getFiltrationTime() {
        return this.getValues().getFiltrationTime();
    }

    public double get(int pathOrState) {
        return this.getValues().get(pathOrState);
    }

    public int size() {
        return this.getValues().size();
    }

    public boolean isDeterministic() {
        return this.getValues().isDeterministic();
    }

    public double[] getRealizations() {
        return this.getValues().getRealizations();
    }

    public Double doubleValue() {
        return this.getValues().doubleValue();
    }

    public double getMin() {
        return this.getValues().getMin();
    }

    public double getMax() {
        return this.getValues().getMax();
    }

    public double getAverage() {
        return this.getValues().getAverage();
    }

    public double getAverage(RandomVariableInterface probabilities) {
        return this.getValues().getAverage(probabilities);
    }

    public double getVariance() {
        return this.getValues().getVariance();
    }

    public double getVariance(RandomVariableInterface probabilities) {
        return this.getValues().getVariance(probabilities);
    }

    public double getSampleVariance() {
        return this.getValues().getSampleVariance();
    }

    public double getStandardDeviation() {
        return this.getValues().getStandardDeviation();
    }

    public double getStandardDeviation(RandomVariableInterface probabilities) {
        return this.getValues().getStandardDeviation(probabilities);
    }

    public double getStandardError() {
        return this.getValues().getStandardError();
    }

    public double getStandardError(RandomVariableInterface probabilities) {
        return this.getValues().getStandardError(probabilities);
    }

    public double getQuantile(double quantile) {
        return this.getValues().getQuantile(quantile);
    }

    public double getQuantile(double quantile, RandomVariableInterface probabilities) {
        return ((RandomVariableDifferentiableAAD)this.getValues()).getValues().getQuantile(quantile, probabilities);
    }

    public double getQuantileExpectation(double quantileStart, double quantileEnd) {
        return ((RandomVariableDifferentiableAAD)this.getValues()).getValues().getQuantileExpectation(quantileStart, quantileEnd);
    }

    public double[] getHistogram(double[] intervalPoints) {
        return this.getValues().getHistogram(intervalPoints);
    }

    public double[][] getHistogram(int numberOfPoints, double standardDeviations) {
        return this.getValues().getHistogram(numberOfPoints, standardDeviations);
    }

    public RandomVariableInterface cache() {
        this.values = this.values.cache();
        return this;
    }

    public RandomVariableInterface cap(double cap) {
        return new RandomVariableDifferentiableAAD(this.getValues().cap(cap), Arrays.asList(this, new RandomVariable(cap)), OperatorType.CAP, this.getFactory());
    }

    public RandomVariableInterface floor(double floor) {
        return new RandomVariableDifferentiableAAD(this.getValues().floor(floor), Arrays.asList(this, new RandomVariable(floor)), OperatorType.FLOOR, this.getFactory());
    }

    public RandomVariableInterface add(double value) {
        return new RandomVariableDifferentiableAAD(this.getValues().add(value), Arrays.asList(this, new RandomVariable(value)), OperatorType.ADD, this.getFactory());
    }

    public RandomVariableInterface sub(double value) {
        return new RandomVariableDifferentiableAAD(this.getValues().sub(value), Arrays.asList(this, new RandomVariable(value)), OperatorType.SUB, this.getFactory());
    }

    public RandomVariableInterface mult(double value) {
        return new RandomVariableDifferentiableAAD(this.getValues().mult(value), Arrays.asList(this, new RandomVariable(value)), OperatorType.MULT, this.getFactory());
    }

    public RandomVariableInterface div(double value) {
        return new RandomVariableDifferentiableAAD(this.getValues().div(value), Arrays.asList(this, new RandomVariable(value)), OperatorType.DIV, this.getFactory());
    }

    public RandomVariableInterface pow(double exponent) {
        return new RandomVariableDifferentiableAAD(this.getValues().pow(exponent), Arrays.asList(this, new RandomVariable(exponent)), OperatorType.POW, this.getFactory());
    }

    public RandomVariableInterface average() {
        return new RandomVariableDifferentiableAAD(this.getValues().average(), Arrays.asList(this), OperatorType.AVERAGE, this.getFactory());
    }

    public RandomVariableInterface getConditionalExpectation(ConditionalExpectationEstimatorInterface estimator) {
        return new RandomVariableDifferentiableAAD(this.getValues().getConditionalExpectation(estimator), Arrays.asList(this), estimator, OperatorType.CONDITIONAL_EXPECTATION, this.getFactory());
    }

    public RandomVariableInterface squared() {
        return new RandomVariableDifferentiableAAD(this.getValues().squared(), Arrays.asList(this), OperatorType.SQUARED, this.getFactory());
    }

    public RandomVariableInterface sqrt() {
        return new RandomVariableDifferentiableAAD(this.getValues().sqrt(), Arrays.asList(this), OperatorType.SQRT, this.getFactory());
    }

    public RandomVariableInterface exp() {
        return new RandomVariableDifferentiableAAD(this.getValues().exp(), Arrays.asList(this), OperatorType.EXP, this.getFactory());
    }

    public RandomVariableInterface log() {
        return new RandomVariableDifferentiableAAD(this.getValues().log(), Arrays.asList(this), OperatorType.LOG, this.getFactory());
    }

    public RandomVariableInterface sin() {
        return new RandomVariableDifferentiableAAD(this.getValues().sin(), Arrays.asList(this), OperatorType.SIN, this.getFactory());
    }

    public RandomVariableInterface cos() {
        return new RandomVariableDifferentiableAAD(this.getValues().cos(), Arrays.asList(this), OperatorType.COS, this.getFactory());
    }

    public RandomVariableInterface add(RandomVariableInterface randomVariable) {
        return new RandomVariableDifferentiableAAD(this.getValues().add(randomVariable), Arrays.asList(this, randomVariable), OperatorType.ADD, this.getFactory());
    }

    public RandomVariableInterface sub(RandomVariableInterface randomVariable) {
        return new RandomVariableDifferentiableAAD(this.getValues().sub(randomVariable), Arrays.asList(this, randomVariable), OperatorType.SUB, this.getFactory());
    }

    public RandomVariableDifferentiableInterface mult(RandomVariableInterface randomVariable) {
        return new RandomVariableDifferentiableAAD(this.getValues().mult(randomVariable), Arrays.asList(this, randomVariable), OperatorType.MULT, this.getFactory());
    }

    public RandomVariableInterface div(RandomVariableInterface randomVariable) {
        return new RandomVariableDifferentiableAAD(this.getValues().div(randomVariable), Arrays.asList(this, randomVariable), OperatorType.DIV, this.getFactory());
    }

    public RandomVariableInterface cap(RandomVariableInterface cap) {
        return new RandomVariableDifferentiableAAD(this.getValues().cap(cap), Arrays.asList(this, cap), OperatorType.CAP, this.getFactory());
    }

    public RandomVariableInterface floor(RandomVariableInterface floor) {
        return new RandomVariableDifferentiableAAD(this.getValues().cap(floor), Arrays.asList(this, floor), OperatorType.FLOOR, this.getFactory());
    }

    public RandomVariableInterface accrue(RandomVariableInterface rate, double periodLength) {
        return new RandomVariableDifferentiableAAD(this.getValues().accrue(rate, periodLength), Arrays.asList(this, rate, new RandomVariable(periodLength)), OperatorType.ACCRUE, this.getFactory());
    }

    public RandomVariableInterface discount(RandomVariableInterface rate, double periodLength) {
        return new RandomVariableDifferentiableAAD(this.getValues().discount(rate, periodLength), Arrays.asList(this, rate, new RandomVariable(periodLength)), OperatorType.DISCOUNT, this.getFactory());
    }

    public RandomVariableInterface barrier(RandomVariableInterface trigger, RandomVariableInterface valueIfTriggerNonNegative, RandomVariableInterface valueIfTriggerNegative) {
        RandomVariableInterface triggerValues = trigger instanceof RandomVariableDifferentiableAAD ? ((RandomVariableDifferentiableAAD)trigger).getValues() : trigger;
        return new RandomVariableDifferentiableAAD(this.getValues().barrier(triggerValues, valueIfTriggerNonNegative, valueIfTriggerNegative), Arrays.asList(trigger, valueIfTriggerNonNegative, valueIfTriggerNegative), OperatorType.BARRIER, this.getFactory());
    }

    public RandomVariableInterface barrier(RandomVariableInterface trigger, RandomVariableInterface valueIfTriggerNonNegative, double valueIfTriggerNegative) {
        RandomVariableInterface triggerValues = trigger instanceof RandomVariableDifferentiableAAD ? ((RandomVariableDifferentiableAAD)trigger).getValues() : trigger;
        return new RandomVariableDifferentiableAAD(this.getValues().barrier(triggerValues, valueIfTriggerNonNegative, valueIfTriggerNegative), Arrays.asList(trigger, valueIfTriggerNonNegative, new RandomVariable(valueIfTriggerNegative)), OperatorType.BARRIER, this.getFactory());
    }

    public RandomVariableInterface invert() {
        return new RandomVariableDifferentiableAAD(this.getValues().invert(), Arrays.asList(this), OperatorType.INVERT, this.getFactory());
    }

    public RandomVariableInterface abs() {
        return new RandomVariableDifferentiableAAD(this.getValues().abs(), Arrays.asList(this), OperatorType.ABS, this.getFactory());
    }

    public RandomVariableInterface addProduct(RandomVariableInterface factor1, double factor2) {
        return new RandomVariableDifferentiableAAD(this.getValues().addProduct(factor1, factor2), Arrays.asList(this, factor1, new RandomVariable(factor2)), OperatorType.ADDPRODUCT, this.getFactory());
    }

    public RandomVariableInterface addProduct(RandomVariableInterface factor1, RandomVariableInterface factor2) {
        return new RandomVariableDifferentiableAAD(this.getValues().addProduct(factor1, factor2), Arrays.asList(this, factor1, factor2), OperatorType.ADDPRODUCT, this.getFactory());
    }

    public RandomVariableInterface addRatio(RandomVariableInterface numerator, RandomVariableInterface denominator) {
        return new RandomVariableDifferentiableAAD(this.getValues().addRatio(numerator, denominator), Arrays.asList(this, numerator, denominator), OperatorType.ADDRATIO, this.getFactory());
    }

    public RandomVariableInterface subRatio(RandomVariableInterface numerator, RandomVariableInterface denominator) {
        return new RandomVariableDifferentiableAAD(this.getValues().subRatio(numerator, denominator), Arrays.asList(this, numerator, denominator), OperatorType.SUBRATIO, this.getFactory());
    }

    public RandomVariableInterface isNaN() {
        return this.getValues().isNaN();
    }

    public IntToDoubleFunction getOperator() {
        return this.getValues().getOperator();
    }

    public DoubleStream getRealizationsStream() {
        return this.getValues().getRealizationsStream();
    }

    public RandomVariableInterface apply(DoubleUnaryOperator operator) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    public RandomVariableInterface apply(DoubleBinaryOperator operator, RandomVariableInterface argument) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    public RandomVariableInterface apply(DoubleTernaryOperator operator, RandomVariableInterface argument1, RandomVariableInterface argument2) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    private RandomVariableInterface getAverageAsRandomVariableAAD(RandomVariableInterface probabilities) {
        return new RandomVariableDifferentiableAAD((RandomVariableInterface)new RandomVariable(this.getAverage(probabilities)), Arrays.asList(this, new RandomVariable(probabilities)), OperatorType.AVERAGE2, this.getFactory());
    }

    private RandomVariableInterface getVarianceAsRandomVariableAAD(RandomVariableInterface probabilities) {
        return new RandomVariableDifferentiableAAD((RandomVariableInterface)new RandomVariable(this.getVariance(probabilities)), Arrays.asList(this, new RandomVariable(probabilities)), OperatorType.VARIANCE2, this.getFactory());
    }

    private RandomVariableInterface getStandardDeviationAsRandomVariableAAD(RandomVariableInterface probabilities) {
        return new RandomVariableDifferentiableAAD((RandomVariableInterface)new RandomVariable(this.getStandardDeviation(probabilities)), Arrays.asList(this, new RandomVariable(probabilities)), OperatorType.STDEV2, this.getFactory());
    }

    private RandomVariableInterface getStandardErrorAsRandomVariableAAD(RandomVariableInterface probabilities) {
        return new RandomVariableDifferentiableAAD((RandomVariableInterface)new RandomVariable(this.getStandardError(probabilities)), Arrays.asList(this, new RandomVariable(probabilities)), OperatorType.STDERROR2, this.getFactory());
    }

    public RandomVariableInterface getVarianceAsRandomVariableAAD() {
        return new RandomVariableDifferentiableAAD((RandomVariableInterface)new RandomVariable(this.getVariance()), Arrays.asList(this), OperatorType.VARIANCE, this.getFactory());
    }

    public RandomVariableInterface getSampleVarianceAsRandomVariableAAD() {
        return new RandomVariableDifferentiableAAD((RandomVariableInterface)new RandomVariable(this.getSampleVariance()), Arrays.asList(this), OperatorType.SVARIANCE, this.getFactory());
    }

    public RandomVariableInterface getStandardDeviationAsRandomVariableAAD() {
        return new RandomVariableDifferentiableAAD((RandomVariableInterface)new RandomVariable(this.getStandardDeviation()), Arrays.asList(this), OperatorType.STDEV, this.getFactory());
    }

    public RandomVariableInterface getStandardErrorAsRandomVariableAAD() {
        return new RandomVariableDifferentiableAAD((RandomVariableInterface)new RandomVariable(this.getStandardError()), Arrays.asList(this), OperatorType.STDERROR, this.getFactory());
    }

    public RandomVariableInterface getMinAsRandomVariableAAD() {
        return new RandomVariableDifferentiableAAD((RandomVariableInterface)new RandomVariable(this.getMin()), Arrays.asList(this), OperatorType.MIN, this.getFactory());
    }

    public RandomVariableInterface getMaxAsRandomVariableAAD() {
        return new RandomVariableDifferentiableAAD((RandomVariableInterface)new RandomVariable(this.getMax()), Arrays.asList(this), OperatorType.MAX, this.getFactory());
    }

    public String toString() {
        return "RandomVariableDifferentiableAAD [values=" + this.values + ", ID=" + this.getID() + "]";
    }

    @Override
    public RandomVariableDifferentiableInterface getCloneIndependent() {
        return new RandomVariableDifferentiableAAD(this.getValues());
    }

    static /* synthetic */ AtomicLong access$000() {
        return indexOfNextRandomVariable;
    }

    private static class OperatorTreeNode {
        private final Long id = RandomVariableDifferentiableAAD.access$000().getAndIncrement();
        private final OperatorType operatorType;
        private final List<OperatorTreeNode> arguments;
        private final List<RandomVariableInterface> argumentValues;
        private final Object operator;
        private final RandomVariableDifferentiableAADFactory factory;
        private static final RandomVariableInterface zero = new RandomVariable(0.0);
        private static final RandomVariableInterface one = new RandomVariable(1.0);

        OperatorTreeNode(OperatorType operatorType, List<RandomVariableInterface> arguments, Object operator, RandomVariableDifferentiableAADFactory factory) {
            this(operatorType, OperatorTreeNode.extractOperatorTreeNodes(arguments), OperatorTreeNode.extractOperatorValues(arguments), operator, factory);
        }

        OperatorTreeNode(OperatorType operatorType, List<OperatorTreeNode> arguments, List<RandomVariableInterface> argumentValues, Object operator, RandomVariableDifferentiableAADFactory factory) {
            this.operatorType = operatorType;
            this.arguments = arguments;
            this.argumentValues = operatorType != null && operatorType.equals((Object)OperatorType.ADD) ? null : argumentValues;
            this.operator = operator;
            this.factory = factory;
            if (operatorType != null && (operatorType.equals((Object)OperatorType.ADD) || operatorType.equals((Object)OperatorType.SUB))) {
                argumentValues = null;
            } else if (operatorType != null && operatorType.equals((Object)OperatorType.AVERAGE)) {
                argumentValues = null;
            } else if (operatorType != null && operatorType.equals((Object)OperatorType.MULT)) {
                if (arguments.get(0) == null) {
                    argumentValues.set(1, null);
                }
                if (arguments.get(1) == null) {
                    argumentValues.set(0, null);
                }
            } else if (operatorType != null && operatorType.equals((Object)OperatorType.ADDPRODUCT)) {
                argumentValues.set(0, null);
                if (arguments.get(1) == null) {
                    argumentValues.set(2, null);
                }
                if (arguments.get(2) == null) {
                    argumentValues.set(1, null);
                }
            } else if (operatorType != null && operatorType.equals((Object)OperatorType.ACCRUE)) {
                if (arguments.get(1) == null && arguments.get(2) == null) {
                    argumentValues.set(0, null);
                }
                if (arguments.get(0) == null && arguments.get(1) == null) {
                    argumentValues.set(1, null);
                }
                if (arguments.get(0) == null && arguments.get(2) == null) {
                    argumentValues.set(2, null);
                }
            } else if (operatorType != null && operatorType.equals((Object)OperatorType.BARRIER) && arguments.get(0) == null) {
                argumentValues.set(1, null);
                argumentValues.set(2, null);
            }
        }

        private void propagateDerivativesFromResultToArgument(Map<Long, RandomVariableInterface> derivatives) {
            if (this.arguments == null) {
                return;
            }
            for (OperatorTreeNode argument : this.arguments) {
                if (argument == null) continue;
                Long argumentID = argument.id;
                RandomVariableInterface partialDerivative = this.getPartialDerivative(argument);
                RandomVariableInterface derivative = derivatives.get(this.id);
                RandomVariableInterface argumentDerivative = derivatives.get(argumentID);
                if (this.operatorType == OperatorType.AVERAGE) {
                    derivative = derivative.average();
                }
                if (this.operatorType == OperatorType.CONDITIONAL_EXPECTATION) {
                    ConditionalExpectationEstimatorInterface estimator = (ConditionalExpectationEstimatorInterface)this.operator;
                    derivative = estimator.getConditionalExpectation(derivative);
                }
                argumentDerivative = argumentDerivative == null ? derivative.mult(partialDerivative) : argumentDerivative.addProduct(partialDerivative, derivative);
                derivatives.put(argumentID, argumentDerivative);
            }
        }

        private RandomVariableInterface getPartialDerivative(OperatorTreeNode differential) {
            if (!this.arguments.contains(differential)) {
                return zero;
            }
            int differentialIndex = this.arguments.indexOf(differential);
            RandomVariableInterface X = this.arguments.size() > 0 && this.argumentValues != null ? this.argumentValues.get(0) : null;
            RandomVariableInterface Y = this.arguments.size() > 1 && this.argumentValues != null ? this.argumentValues.get(1) : null;
            RandomVariableInterface Z = this.arguments.size() > 2 && this.argumentValues != null ? this.argumentValues.get(2) : null;
            RandomVariableInterface derivative = null;
            switch (this.operatorType) {
                case SQUARED: {
                    derivative = X.mult(2.0);
                    break;
                }
                case SQRT: {
                    derivative = X.sqrt().invert().mult(0.5);
                    break;
                }
                case EXP: {
                    derivative = X.exp();
                    break;
                }
                case LOG: {
                    derivative = X.invert();
                    break;
                }
                case SIN: {
                    derivative = X.cos();
                    break;
                }
                case COS: {
                    derivative = X.sin().mult(-1.0);
                    break;
                }
                case AVERAGE: {
                    derivative = one;
                    break;
                }
                case CONDITIONAL_EXPECTATION: {
                    derivative = one;
                    break;
                }
                case VARIANCE: {
                    derivative = X.sub(X.getAverage() * (2.0 * (double)X.size() - 1.0) / (double)X.size()).mult(2.0 / (double)X.size());
                    break;
                }
                case STDEV: {
                    derivative = X.sub(X.getAverage() * (2.0 * (double)X.size() - 1.0) / (double)X.size()).mult(2.0 / (double)X.size()).mult(0.5).div(Math.sqrt(X.getVariance()));
                    break;
                }
                case MIN: {
                    double min = X.getMin();
                    derivative = X.apply(x -> x == min ? 1.0 : 0.0);
                    break;
                }
                case MAX: {
                    double max = X.getMax();
                    derivative = X.apply(x -> x == max ? 1.0 : 0.0);
                    break;
                }
                case ABS: {
                    derivative = X.barrier(X, one, (RandomVariableInterface)new RandomVariable(-1.0));
                    break;
                }
                case STDERROR: {
                    derivative = X.sub(X.getAverage() * (2.0 * (double)X.size() - 1.0) / (double)X.size()).mult(2.0 / (double)X.size()).mult(0.5).div(Math.sqrt(X.getVariance() * (double)X.size()));
                    break;
                }
                case SVARIANCE: {
                    derivative = X.sub(X.getAverage() * (2.0 * (double)X.size() - 1.0) / (double)X.size()).mult(2.0 / (double)(X.size() - 1));
                    break;
                }
                case ADD: {
                    derivative = one;
                    break;
                }
                case SUB: {
                    derivative = new RandomVariable(differentialIndex == 0 ? 1.0 : -1.0);
                    break;
                }
                case MULT: {
                    derivative = differentialIndex == 0 ? Y : X;
                    break;
                }
                case DIV: {
                    derivative = differentialIndex == 0 ? Y.invert() : X.div(Y.squared()).mult(-1.0);
                    break;
                }
                case CAP: {
                    if (differentialIndex == 0) {
                        derivative = X.barrier(X.sub(Y), zero, one);
                        break;
                    }
                    derivative = X.barrier(X.sub(Y), one, zero);
                    break;
                }
                case FLOOR: {
                    if (differentialIndex == 0) {
                        derivative = X.barrier(X.sub(Y), one, zero);
                        break;
                    }
                    derivative = X.barrier(X.sub(Y), zero, one);
                    break;
                }
                case AVERAGE2: {
                    derivative = differentialIndex == 0 ? Y : X;
                    break;
                }
                case VARIANCE2: {
                    derivative = differentialIndex == 0 ? Y.mult(2.0).mult(X.mult(Y.add(X.getAverage(Y) * (double)(X.size() - 1)).sub(X.getAverage(Y)))) : X.mult(2.0).mult(Y.mult(X.add(Y.getAverage(X) * (double)(X.size() - 1)).sub(Y.getAverage(X))));
                    break;
                }
                case STDEV2: {
                    derivative = differentialIndex == 0 ? Y.mult(2.0).mult(X.mult(Y.add(X.getAverage(Y) * (double)(X.size() - 1)).sub(X.getAverage(Y)))).div(Math.sqrt(X.getVariance(Y))) : X.mult(2.0).mult(Y.mult(X.add(Y.getAverage(X) * (double)(X.size() - 1)).sub(Y.getAverage(X)))).div(Math.sqrt(Y.getVariance(X)));
                    break;
                }
                case STDERROR2: {
                    derivative = differentialIndex == 0 ? Y.mult(2.0).mult(X.mult(Y.add(X.getAverage(Y) * (double)(X.size() - 1)).sub(X.getAverage(Y)))).div(Math.sqrt(X.getVariance(Y) * (double)X.size())) : X.mult(2.0).mult(Y.mult(X.add(Y.getAverage(X) * (double)(X.size() - 1)).sub(Y.getAverage(X)))).div(Math.sqrt(Y.getVariance(X) * (double)Y.size()));
                    break;
                }
                case POW: {
                    derivative = differentialIndex == 0 ? X.pow(Y.getAverage() - 1.0).mult(Y) : zero;
                    break;
                }
                case ADDPRODUCT: {
                    if (differentialIndex == 0) {
                        derivative = one;
                        break;
                    }
                    if (differentialIndex == 1) {
                        derivative = Z;
                        break;
                    }
                    derivative = Y;
                    break;
                }
                case ADDRATIO: {
                    if (differentialIndex == 0) {
                        derivative = one;
                        break;
                    }
                    if (differentialIndex == 1) {
                        derivative = Z.invert();
                        break;
                    }
                    derivative = Y.div(Z.squared()).mult(-1.0);
                    break;
                }
                case SUBRATIO: {
                    if (differentialIndex == 0) {
                        derivative = one;
                        break;
                    }
                    if (differentialIndex == 1) {
                        derivative = Z.invert().mult(-1.0);
                        break;
                    }
                    derivative = Y.div(Z.squared());
                    break;
                }
                case ACCRUE: {
                    if (differentialIndex == 0) {
                        derivative = Y.mult(Z).add(1.0);
                        break;
                    }
                    if (differentialIndex == 1) {
                        derivative = X.mult(Z);
                        break;
                    }
                    derivative = X.mult(Y);
                    break;
                }
                case DISCOUNT: {
                    if (differentialIndex == 0) {
                        derivative = Y.mult(Z).add(1.0).invert();
                        break;
                    }
                    if (differentialIndex == 1) {
                        derivative = X.mult(Z).div(Y.mult(Z).add(1.0).squared()).mult(-1.0);
                        break;
                    }
                    derivative = X.mult(Y).div(Y.mult(Z).add(1.0).squared()).mult(-1.0);
                    break;
                }
                case BARRIER: {
                    if (differentialIndex == 0) {
                        derivative = Y.sub(Z);
                        double epsilon = this.factory.getBarrierDiracWidth() * X.getStandardDeviation();
                        if (epsilon > 0.0) {
                            derivative = derivative.mult(X.barrier(X.add(epsilon / 2.0), one, zero));
                            derivative = derivative.mult(X.barrier(X.sub(epsilon / 2.0), zero, one));
                            derivative = derivative.div(epsilon);
                            break;
                        }
                        derivative = zero;
                        break;
                    }
                    derivative = differentialIndex == 1 ? X.barrier(X, one, zero) : X.barrier(X, zero, one);
                }
            }
            return derivative;
        }

        private static List<OperatorTreeNode> extractOperatorTreeNodes(List<RandomVariableInterface> arguments) {
            return arguments != null ? arguments.stream().map(x -> x != null && x instanceof RandomVariableDifferentiableAAD ? ((RandomVariableDifferentiableAAD)x).getOperatorTreeNode() : null).collect(Collectors.toList()) : null;
        }

        private static List<RandomVariableInterface> extractOperatorValues(List<RandomVariableInterface> arguments) {
            return arguments != null ? arguments.stream().map(x -> x != null && x instanceof RandomVariableDifferentiableAAD ? ((RandomVariableDifferentiableAAD)x).getValues() : x).collect(Collectors.toList()) : null;
        }
    }

    private static enum OperatorType {
        ADD,
        MULT,
        DIV,
        SUB,
        SQUARED,
        SQRT,
        LOG,
        SIN,
        COS,
        EXP,
        INVERT,
        CAP,
        FLOOR,
        ABS,
        ADDPRODUCT,
        ADDRATIO,
        SUBRATIO,
        BARRIER,
        DISCOUNT,
        ACCRUE,
        POW,
        MIN,
        MAX,
        AVERAGE,
        VARIANCE,
        STDEV,
        STDERROR,
        SVARIANCE,
        AVERAGE2,
        VARIANCE2,
        STDEV2,
        STDERROR2,
        CONDITIONAL_EXPECTATION;

    }
}

