/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.automaticdifferentiation.backward;

import java.util.Map;
import net.finmath.montecarlo.AbstractRandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.automaticdifferentiation.AbstractRandomVariableDifferentiableFactory;
import net.finmath.montecarlo.automaticdifferentiation.RandomVariableDifferentiableInterface;
import net.finmath.montecarlo.automaticdifferentiation.backward.RandomVariableDifferentiableAAD;

public class RandomVariableDifferentiableAADFactory
extends AbstractRandomVariableDifferentiableFactory {
    private final double barrierDiracWidth;
    private final boolean isGradientRetainsLeafNodesOnly;

    public RandomVariableDifferentiableAADFactory() {
        this((AbstractRandomVariableFactory)new RandomVariableFactory());
    }

    public RandomVariableDifferentiableAADFactory(AbstractRandomVariableFactory randomVariableFactoryForNonDifferentiable) {
        super(randomVariableFactoryForNonDifferentiable);
        this.barrierDiracWidth = 0.05;
        this.isGradientRetainsLeafNodesOnly = true;
    }

    public RandomVariableDifferentiableAADFactory(AbstractRandomVariableFactory randomVariableFactoryForNonDifferentiable, Map<String, Object> properties) {
        super(randomVariableFactoryForNonDifferentiable);
        this.barrierDiracWidth = (Double)properties.getOrDefault("barrierDiracWidth", new Double(0.05));
        this.isGradientRetainsLeafNodesOnly = (Boolean)properties.getOrDefault("isGradientRetainsLeafNodesOnly", new Boolean(true));
    }

    @Override
    public RandomVariableDifferentiableInterface createRandomVariable(double time, double value) {
        return new RandomVariableDifferentiableAAD(this.createRandomVariableNonDifferentiable(time, value), this);
    }

    @Override
    public RandomVariableDifferentiableInterface createRandomVariable(double time, double[] values) {
        return new RandomVariableDifferentiableAAD(this.createRandomVariableNonDifferentiable(time, values), this);
    }

    public double getBarrierDiracWidth() {
        return this.barrierDiracWidth;
    }

    public boolean isGradientRetainsLeafNodesOnly() {
        return this.isGradientRetainsLeafNodesOnly;
    }
}

