/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.automaticdifferentiation.backward.alternative;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.stream.DoubleStream;
import net.finmath.functions.DoubleTernaryOperator;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.stochastic.RandomVariableInterface;

public class RandomVariableAAD
implements RandomVariableInterface {
    private static final long serialVersionUID = 2459373647785530657L;
    private static ArrayList<RandomVariableAAD> arrayListOfAllAADRandomVariables = new ArrayList();
    private static AtomicInteger indexOfNextRandomVariable = new AtomicInteger(0);
    private final RandomVariableInterface ownRandomVariable;
    private final int ownIndexInList;
    private final int[] parentIndices;
    private final OperatorType parentOperator;
    private ArrayList<Integer> childrenIndices;
    private boolean isConstant;

    private RandomVariableAAD(int ownIndexInList, RandomVariableInterface ownRandomVariable, int[] parentIndices, OperatorType parentOperator, ArrayList<Integer> childrenIndices, boolean isConstant) {
        this.ownIndexInList = ownIndexInList;
        this.ownRandomVariable = ownRandomVariable;
        this.parentIndices = parentIndices;
        this.parentOperator = parentOperator;
        this.childrenIndices = childrenIndices;
        this.isConstant = isConstant;
    }

    public static RandomVariableAAD constructNewAADRandomVariable(RandomVariableInterface randomVariable, int[] parentIndices, OperatorType parentOperator, ArrayList<Integer> childrenIndices, boolean isConstant) {
        if (!arrayListOfAllAADRandomVariables.isEmpty() && arrayListOfAllAADRandomVariables.get(0).size() != randomVariable.size() && !randomVariable.isDeterministic()) {
            throw new IllegalArgumentException("RandomVariables with different sizes are not supported at the moment!");
        }
        int indexOfThisAADRandomVariable = indexOfNextRandomVariable.getAndIncrement();
        RandomVariableAAD newAADRandomVariable = new RandomVariableAAD(indexOfThisAADRandomVariable, randomVariable, parentIndices, parentOperator, childrenIndices, isConstant);
        arrayListOfAllAADRandomVariables.add(indexOfThisAADRandomVariable, newAADRandomVariable);
        return newAADRandomVariable;
    }

    public static RandomVariableAAD constructNewAADRandomVariable(double value) {
        return RandomVariableAAD.constructNewAADRandomVariable((RandomVariableInterface)new RandomVariable(value), null, null, null, true);
    }

    public static RandomVariableAAD constructNewAADRandomVariable(RandomVariableInterface randomVariable) {
        return RandomVariableAAD.constructNewAADRandomVariable(randomVariable, null, null, null, false);
    }

    public static RandomVariableAAD constructNewAADRandomVariable(double time, double[] realisations) {
        return RandomVariableAAD.constructNewAADRandomVariable((RandomVariableInterface)new RandomVariable(time, realisations), null, null, null, false);
    }

    private RandomVariableAAD[] getParentAADRandomVariables() {
        if (this.getParentIDs() == null) {
            return null;
        }
        int[] parentIndices = this.getParentIDs();
        RandomVariableAAD[] parentAADRandomVariables = new RandomVariableAAD[this.getNumberOfParentVariables()];
        for (int i = 0; i < parentAADRandomVariables.length; ++i) {
            parentAADRandomVariables[i] = this.getAADRandomVariableFromList(parentIndices[i]);
        }
        return parentAADRandomVariables;
    }

    private RandomVariableInterface[] getParentRandomVariableInderfaces() {
        RandomVariableAAD[] parentAADRandomVariables = this.getParentAADRandomVariables();
        RandomVariableInterface[] parentRandomVariableInderfaces = new RandomVariableInterface[parentAADRandomVariables.length];
        for (int i = 0; i < parentAADRandomVariables.length; ++i) {
            parentRandomVariableInderfaces[i] = parentAADRandomVariables[i].getRandomVariableInterface();
        }
        return parentRandomVariableInderfaces;
    }

    private RandomVariableInterface apply(OperatorType operator, RandomVariableInterface[] randomVariableInterfaces) {
        RandomVariableInterface resultrandomvariable;
        int[] futureParentIndices;
        RandomVariableAAD[] aadRandomVariables;
        block38: {
            block40: {
                RandomVariableInterface Y;
                RandomVariableInterface X;
                block39: {
                    block37: {
                        aadRandomVariables = new RandomVariableAAD[randomVariableInterfaces.length];
                        futureParentIndices = new int[aadRandomVariables.length];
                        for (int randomVariableIndex = 0; randomVariableIndex < randomVariableInterfaces.length; ++randomVariableIndex) {
                            aadRandomVariables[randomVariableIndex] = randomVariableInterfaces[randomVariableIndex] instanceof RandomVariableAAD ? (RandomVariableAAD)randomVariableInterfaces[randomVariableIndex] : RandomVariableAAD.constructNewAADRandomVariable(randomVariableInterfaces[randomVariableIndex]);
                            futureParentIndices[randomVariableIndex] = aadRandomVariables[randomVariableIndex].getFunctionIndex();
                        }
                        if (randomVariableInterfaces.length != 1) break block37;
                        X = aadRandomVariables[0].getRandomVariableInterface();
                        switch (operator) {
                            case SQUARED: {
                                resultrandomvariable = X.squared();
                                break block38;
                            }
                            case SQRT: {
                                resultrandomvariable = X.sqrt();
                                break block38;
                            }
                            case EXP: {
                                resultrandomvariable = X.exp();
                                break block38;
                            }
                            case LOG: {
                                resultrandomvariable = X.log();
                                break block38;
                            }
                            case SIN: {
                                resultrandomvariable = X.sin();
                                break block38;
                            }
                            case COS: {
                                resultrandomvariable = X.cos();
                                break block38;
                            }
                            case ABS: {
                                resultrandomvariable = X.abs();
                                break block38;
                            }
                            case INVERT: {
                                resultrandomvariable = X.invert();
                                break block38;
                            }
                            case AVERAGE: {
                                resultrandomvariable = new RandomVariable(X.getAverage());
                                break block38;
                            }
                            case STDERROR: {
                                resultrandomvariable = new RandomVariable(X.getStandardError());
                                break block38;
                            }
                            case STDEV: {
                                resultrandomvariable = new RandomVariable(X.getStandardDeviation());
                                break block38;
                            }
                            case VARIANCE: {
                                resultrandomvariable = new RandomVariable(X.getVariance());
                                break block38;
                            }
                            case SVARIANCE: {
                                resultrandomvariable = new RandomVariable(X.getSampleVariance());
                                break block38;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                    if (randomVariableInterfaces.length != 2) break block39;
                    X = aadRandomVariables[0].getRandomVariableInterface();
                    Y = aadRandomVariables[1].getRandomVariableInterface();
                    switch (operator) {
                        case ADD: {
                            resultrandomvariable = X.add(Y);
                            break block38;
                        }
                        case SUB: {
                            resultrandomvariable = X.sub(Y);
                            break block38;
                        }
                        case MULT: {
                            resultrandomvariable = X.mult(Y);
                            break block38;
                        }
                        case DIV: {
                            resultrandomvariable = X.div(Y);
                            break block38;
                        }
                        case CAP: {
                            resultrandomvariable = X.cap(Y.getAverage());
                            break block38;
                        }
                        case FLOOR: {
                            resultrandomvariable = X.floor(Y.getAverage());
                            break block38;
                        }
                        case POW: {
                            resultrandomvariable = X.pow(Y.getAverage());
                            break block38;
                        }
                        case AVERAGE: {
                            resultrandomvariable = new RandomVariable(X.getAverage(Y));
                            break block38;
                        }
                        case STDERROR: {
                            resultrandomvariable = new RandomVariable(X.getStandardError(Y));
                            break block38;
                        }
                        case STDEV: {
                            resultrandomvariable = new RandomVariable(X.getStandardDeviation(Y));
                            break block38;
                        }
                        case VARIANCE: {
                            resultrandomvariable = new RandomVariable(X.getVariance(Y));
                            break block38;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
                if (randomVariableInterfaces.length != 3) break block40;
                X = aadRandomVariables[0].getRandomVariableInterface();
                Y = aadRandomVariables[1].getRandomVariableInterface();
                RandomVariableInterface Z = aadRandomVariables[2].getRandomVariableInterface();
                switch (operator) {
                    case ADDPRODUCT: {
                        resultrandomvariable = X.addProduct(Y, Z);
                        break block38;
                    }
                    case ADDRATIO: {
                        resultrandomvariable = X.addRatio(Y, Z);
                        break block38;
                    }
                    case SUBRATIO: {
                        resultrandomvariable = X.subRatio(Y, Z);
                        break block38;
                    }
                    case ACCRUE: {
                        resultrandomvariable = X.accrue(Y, Z.getAverage());
                        break block38;
                    }
                    case DISCOUNT: {
                        resultrandomvariable = X.discount(Y, Z.getAverage());
                        break block38;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            throw new IllegalArgumentException("Operation not supported!\n");
        }
        RandomVariableAAD newRandomVariableAAD = RandomVariableAAD.constructNewAADRandomVariable(resultrandomvariable, futureParentIndices, operator, null, false);
        for (RandomVariableAAD parentRandomVariable : aadRandomVariables) {
            parentRandomVariable.addToChildrenIndices(newRandomVariableAAD.getFunctionIndex());
        }
        return newRandomVariableAAD;
    }

    public String toString() {
        return super.toString() + "\ntime: " + this.getFiltrationTime() + "\nrealizations: " + Arrays.toString(this.getRealizations()) + "\nvariableID: " + this.getFunctionIndex() + "\nparentIDs: " + Arrays.toString(this.getParentIDs()) + (this.getParentIDs() == null ? "" : " type: " + this.parentOperator.name()) + "\nisTrueVariable: " + this.isVariable() + "\n";
    }

    private RandomVariableInterface getPartialDerivative(int functionIndex, int variableIndex) {
        return this.getFunctionList().get(functionIndex).partialDerivativeWithRespectTo(variableIndex);
    }

    private RandomVariableInterface partialDerivativeWithRespectTo(int variableIndex) {
        int[] parentIDsSorted = this.getParentIDs() == null ? new int[]{} : (int[])this.getParentIDs().clone();
        Arrays.sort(parentIDsSorted);
        if (Arrays.binarySearch(parentIDsSorted, variableIndex) < 0 || this.isConstant) {
            return new RandomVariable(0.0);
        }
        RandomVariableInterface resultrandomvariable = null;
        if (this.getParentIDs().length == 1) {
            RandomVariableInterface X = this.getRandomVariableInterfaceOfIndex(this.getParentIDs()[0]);
            switch (this.parentOperator) {
                case SQUARED: {
                    resultrandomvariable = X.mult(2.0);
                    break;
                }
                case SQRT: {
                    resultrandomvariable = X.sqrt().invert().mult(0.5);
                    break;
                }
                case EXP: {
                    resultrandomvariable = X.exp();
                    break;
                }
                case LOG: {
                    resultrandomvariable = X.invert();
                    break;
                }
                case SIN: {
                    resultrandomvariable = X.cos();
                    break;
                }
                case COS: {
                    resultrandomvariable = X.sin().mult(-1.0);
                    break;
                }
                case AVERAGE: {
                    resultrandomvariable = new RandomVariable((double)X.size()).invert();
                    break;
                }
                case VARIANCE: {
                    resultrandomvariable = X.sub(X.getAverage() * (2.0 * (double)X.size() - 1.0) / (double)X.size()).mult(2.0 / (double)X.size());
                    break;
                }
                case STDEV: {
                    resultrandomvariable = X.sub(X.getAverage() * (2.0 * (double)X.size() - 1.0) / (double)X.size()).mult(2.0 / (double)X.size()).mult(0.5).div(Math.sqrt(X.getVariance()));
                    break;
                }
                case MIN: {
                    resultrandomvariable = X.apply(x -> x == X.getMin() ? 1.0 : 0.0);
                    break;
                }
                case MAX: {
                    resultrandomvariable = X.apply(x -> x == X.getMax() ? 1.0 : 0.0);
                    break;
                }
                case ABS: {
                    resultrandomvariable = X.apply(x -> x > 0.0 ? 1.0 : (x < 0.0 ? -1.0 : 0.0));
                    break;
                }
                case STDERROR: {
                    resultrandomvariable = X.sub(X.getAverage() * (2.0 * (double)X.size() - 1.0) / (double)X.size()).mult(2.0 / (double)X.size()).mult(0.5).div(Math.sqrt(X.getVariance() * (double)X.size()));
                    break;
                }
                case SVARIANCE: {
                    resultrandomvariable = X.sub(X.getAverage() * (2.0 * (double)X.size() - 1.0) / (double)X.size()).mult(2.0 / (double)(X.size() - 1));
                    break;
                }
            }
        } else if (this.getParentIDs().length == 2) {
            RandomVariableInterface X = this.getRandomVariableInterfaceOfIndex(this.getParentIDs()[0]);
            RandomVariableInterface Y = this.getRandomVariableInterfaceOfIndex(this.getParentIDs()[1]);
            switch (this.parentOperator) {
                case ADD: {
                    resultrandomvariable = new RandomVariable(1.0);
                    break;
                }
                case SUB: {
                    resultrandomvariable = new RandomVariable(variableIndex == this.getParentIDs()[0] ? 1.0 : -1.0);
                    break;
                }
                case MULT: {
                    resultrandomvariable = variableIndex == this.getParentIDs()[0] ? Y : X;
                    break;
                }
                case DIV: {
                    resultrandomvariable = variableIndex == this.getParentIDs()[0] ? Y.invert() : X.div(Y.squared()).mult(-1.0);
                    break;
                }
                case CAP: {
                    resultrandomvariable = X.apply(x -> x > Y.getAverage() ? 0.0 : 1.0);
                    break;
                }
                case FLOOR: {
                    resultrandomvariable = X.apply(x -> x > Y.getAverage() ? 1.0 : 0.0);
                    break;
                }
                case AVERAGE: {
                    resultrandomvariable = variableIndex == this.getParentIDs()[0] ? Y : X;
                    break;
                }
                case VARIANCE: {
                    resultrandomvariable = variableIndex == this.getParentIDs()[0] ? Y.mult(2.0).mult(X.mult(Y.add(X.getAverage(Y) * (double)(X.size() - 1)).sub(X.getAverage(Y)))) : X.mult(2.0).mult(Y.mult(X.add(Y.getAverage(X) * (double)(X.size() - 1)).sub(Y.getAverage(X))));
                    break;
                }
                case STDEV: {
                    resultrandomvariable = variableIndex == this.getParentIDs()[0] ? Y.mult(2.0).mult(X.mult(Y.add(X.getAverage(Y) * (double)(X.size() - 1)).sub(X.getAverage(Y)))).div(Math.sqrt(X.getVariance(Y))) : X.mult(2.0).mult(Y.mult(X.add(Y.getAverage(X) * (double)(X.size() - 1)).sub(Y.getAverage(X)))).div(Math.sqrt(Y.getVariance(X)));
                    break;
                }
                case STDERROR: {
                    resultrandomvariable = variableIndex == this.getParentIDs()[0] ? Y.mult(2.0).mult(X.mult(Y.add(X.getAverage(Y) * (double)(X.size() - 1)).sub(X.getAverage(Y)))).div(Math.sqrt(X.getVariance(Y) * (double)X.size())) : X.mult(2.0).mult(Y.mult(X.add(Y.getAverage(X) * (double)(X.size() - 1)).sub(Y.getAverage(X)))).div(Math.sqrt(Y.getVariance(X) * (double)Y.size()));
                    break;
                }
                case POW: {
                    resultrandomvariable = variableIndex == this.getParentIDs()[0] ? Y.mult(X.pow(Y.getAverage() - 1.0)) : new RandomVariable(0.0);
                    break;
                }
            }
        } else if (this.getParentIDs().length == 3) {
            RandomVariableInterface X = this.getRandomVariableInterfaceOfIndex(this.getParentIDs()[0]);
            RandomVariableInterface Y = this.getRandomVariableInterfaceOfIndex(this.getParentIDs()[1]);
            RandomVariableInterface Z = this.getRandomVariableInterfaceOfIndex(this.getParentIDs()[2]);
            switch (this.parentOperator) {
                case ADDPRODUCT: {
                    if (variableIndex == this.getParentIDs()[0]) {
                        resultrandomvariable = new RandomVariable(1.0);
                        break;
                    }
                    if (variableIndex == this.getParentIDs()[1]) {
                        resultrandomvariable = Z;
                        break;
                    }
                    resultrandomvariable = Y;
                    break;
                }
                case ADDRATIO: {
                    if (variableIndex == this.getParentIDs()[0]) {
                        resultrandomvariable = new RandomVariable(1.0);
                        break;
                    }
                    if (variableIndex == this.getParentIDs()[0]) {
                        resultrandomvariable = Z.invert();
                        break;
                    }
                    resultrandomvariable = Y.div(Z.squared());
                    break;
                }
                case SUBRATIO: {
                    if (variableIndex == this.getParentIDs()[0]) {
                        resultrandomvariable = new RandomVariable(1.0);
                        break;
                    }
                    if (variableIndex == this.getParentIDs()[1]) {
                        resultrandomvariable = Z.invert().mult(-1.0);
                        break;
                    }
                    resultrandomvariable = Y.div(Z.squared()).mult(-1.0);
                    break;
                }
                case ACCRUE: {
                    if (variableIndex == this.getParentIDs()[0]) {
                        resultrandomvariable = Y.mult(Z).add(1.0);
                        break;
                    }
                    if (variableIndex == this.getParentIDs()[1]) {
                        resultrandomvariable = X.mult(Z);
                        break;
                    }
                    resultrandomvariable = X.mult(Y);
                    break;
                }
                case DISCOUNT: {
                    if (variableIndex == this.getParentIDs()[0]) {
                        resultrandomvariable = Y.mult(Z).add(1.0).invert();
                        break;
                    }
                    if (variableIndex == this.getParentIDs()[1]) {
                        resultrandomvariable = X.mult(Z).div(Y.mult(Z).add(1.0).squared());
                        break;
                    }
                    resultrandomvariable = X.mult(Y).div(Y.mult(Z).add(1.0).squared());
                    break;
                }
                case BARRIER: {
                    if (variableIndex == this.getParentIDs()[0]) {
                        resultrandomvariable = X.apply(x -> x == 0.0 ? Double.POSITIVE_INFINITY : 0.0);
                        break;
                    }
                    if (variableIndex == this.getParentIDs()[1]) {
                        resultrandomvariable = X.barrier(X, (RandomVariableInterface)new RandomVariable(1.0), (RandomVariableInterface)new RandomVariable(0.0));
                        break;
                    }
                    resultrandomvariable = X.barrier(X, (RandomVariableInterface)new RandomVariable(0.0), (RandomVariableInterface)new RandomVariable(1.0));
                }
            }
        } else {
            throw new IllegalArgumentException("Operation not supported!\n");
        }
        return resultrandomvariable;
    }

    public Map<Integer, RandomVariableInterface> getGradient() {
        int numberOfCalculationSteps = this.getFunctionList().size();
        RandomVariableInterface[] omegaHat = new RandomVariableInterface[numberOfCalculationSteps];
        omegaHat[numberOfCalculationSteps - 1] = new RandomVariable(1.0);
        for (int variableIndex = numberOfCalculationSteps - 2; variableIndex >= 0; --variableIndex) {
            omegaHat[variableIndex] = new RandomVariable(0.0);
            ArrayList<Integer> childrenList = this.getAADRandomVariableFromList(variableIndex).getChildrenIndices();
            for (int functionIndex : childrenList) {
                RandomVariableInterface D_i_j = this.getPartialDerivative(functionIndex, variableIndex);
                omegaHat[variableIndex] = omegaHat[variableIndex].addProduct(D_i_j, omegaHat[functionIndex]);
            }
        }
        ArrayList<Integer> arrayListOfAllIndicesOfDependentRandomVariables = this.getArrayListOfAllIndicesOfDependentRandomVariables();
        HashMap<Integer, RandomVariableInterface> gradient = new HashMap<Integer, RandomVariableInterface>();
        for (Integer indexOfDependentRandomVariable : arrayListOfAllIndicesOfDependentRandomVariables) {
            gradient.put(indexOfDependentRandomVariable, omegaHat[arrayListOfAllIndicesOfDependentRandomVariables.get(indexOfDependentRandomVariable)]);
        }
        return gradient;
    }

    private ArrayList<Integer> getArrayListOfAllIndicesOfDependentRandomVariables() {
        ArrayList<Integer> arrayListOfAllIndicesOfDependentRandomVariables = new ArrayList<Integer>();
        for (int index = 0; index < this.getNumberOfParentVariables(); ++index) {
            int currentParentIndex = this.getParentIDs()[index];
            if (this.getAADRandomVariableFromList(currentParentIndex).isVariable() && !arrayListOfAllIndicesOfDependentRandomVariables.contains(currentParentIndex)) {
                arrayListOfAllIndicesOfDependentRandomVariables.add(currentParentIndex);
                continue;
            }
            arrayListOfAllIndicesOfDependentRandomVariables.addAll(this.getAADRandomVariableFromList(currentParentIndex).getArrayListOfAllIndicesOfDependentRandomVariables());
        }
        return arrayListOfAllIndicesOfDependentRandomVariables;
    }

    public RandomVariableInterface getAverageAsRandomVariableAAD(RandomVariableInterface probabilities) {
        return this.apply(OperatorType.AVERAGE, new RandomVariableInterface[]{this, probabilities});
    }

    public RandomVariableInterface getVarianceAsRandomVariableAAD(RandomVariableInterface probabilities) {
        return this.apply(OperatorType.VARIANCE, new RandomVariableInterface[]{this, probabilities});
    }

    public RandomVariableInterface getStandardDeviationAsRandomVariableAAD(RandomVariableInterface probabilities) {
        return this.apply(OperatorType.STDEV, new RandomVariableInterface[]{this, probabilities});
    }

    public RandomVariableInterface getStandardErrorAsRandomVariableAAD(RandomVariableInterface probabilities) {
        return this.apply(OperatorType.STDERROR, new RandomVariableInterface[]{this, probabilities});
    }

    public RandomVariableInterface getAverageAsRandomVariableAAD() {
        return this.apply(OperatorType.AVERAGE, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface getVarianceAsRandomVariableAAD() {
        return this.apply(OperatorType.VARIANCE, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface getSampleVarianceAsRandomVariableAAD() {
        return this.apply(OperatorType.SVARIANCE, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface getStandardDeviationAsRandomVariableAAD() {
        return this.apply(OperatorType.STDEV, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface getStandardErrorAsRandomVariableAAD() {
        return this.apply(OperatorType.STDERROR, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface getMinAsRandomVariableAAD() {
        return this.apply(OperatorType.MIN, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface getMaxAsRandomVariableAAD() {
        return this.apply(OperatorType.MAX, new RandomVariableInterface[]{this});
    }

    private OperatorType getParentOperator() {
        return this.parentOperator;
    }

    private boolean isConstant() {
        return this.isConstant;
    }

    private boolean isVariable() {
        return !this.isConstant() && this.getParentIDs() == null;
    }

    private ArrayList<RandomVariableAAD> getFunctionList() {
        return arrayListOfAllAADRandomVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetArrayListOfAllAADRandomVariables() {
        ArrayList<RandomVariableAAD> arrayList = arrayListOfAllAADRandomVariables;
        synchronized (arrayList) {
            arrayListOfAllAADRandomVariables = new ArrayList();
            indexOfNextRandomVariable = new AtomicInteger(0);
        }
    }

    public void setIsConstantTo(boolean isConstant) {
        this.isConstant = isConstant;
    }

    private RandomVariableInterface getRandomVariableInterface() {
        return this.ownRandomVariable;
    }

    private RandomVariableInterface getRandomVariableInterfaceOfIndex(int index) {
        return this.getFunctionList().get(index).getRandomVariableInterface();
    }

    private int getFunctionIndex() {
        return this.ownIndexInList;
    }

    private int[] getParentIDs() {
        return this.parentIndices;
    }

    private ArrayList<Integer> getChildrenIndices() {
        if (this.childrenIndices == null) {
            this.childrenIndices = new ArrayList();
        }
        return this.childrenIndices;
    }

    private int getNumberOfParentVariables() {
        if (this.getParentIDs() == null) {
            return 0;
        }
        return this.getParentIDs().length;
    }

    private RandomVariableAAD getAADRandomVariableFromList(int index) {
        return this.getFunctionList().get(index);
    }

    private void addToChildrenIndices(int index) {
        this.getChildrenIndices().add(index);
    }

    public boolean equals(RandomVariableInterface randomVariable) {
        return this.getRandomVariableInterface().equals(randomVariable);
    }

    public double getFiltrationTime() {
        return this.getRandomVariableInterface().getFiltrationTime();
    }

    public double get(int pathOrState) {
        return this.getRandomVariableInterface().get(pathOrState);
    }

    public int size() {
        return this.getRandomVariableInterface().size();
    }

    public boolean isDeterministic() {
        return this.getRandomVariableInterface().isDeterministic();
    }

    public double[] getRealizations() {
        return this.getRandomVariableInterface().getRealizations();
    }

    public Double doubleValue() {
        return this.getRandomVariableInterface().doubleValue();
    }

    public double getMin() {
        return ((RandomVariableAAD)this.getMinAsRandomVariableAAD()).getRandomVariableInterface().getAverage();
    }

    public double getMax() {
        return ((RandomVariableAAD)this.getMaxAsRandomVariableAAD()).getRandomVariableInterface().getAverage();
    }

    public double getAverage() {
        return ((RandomVariableAAD)this.getAverageAsRandomVariableAAD()).getRandomVariableInterface().getAverage();
    }

    public double getAverage(RandomVariableInterface probabilities) {
        return ((RandomVariableAAD)this.getAverageAsRandomVariableAAD(probabilities)).getRandomVariableInterface().getAverage();
    }

    public double getVariance() {
        return ((RandomVariableAAD)this.getVarianceAsRandomVariableAAD()).getRandomVariableInterface().getAverage();
    }

    public double getVariance(RandomVariableInterface probabilities) {
        return ((RandomVariableAAD)this.getAverageAsRandomVariableAAD(probabilities)).getRandomVariableInterface().getAverage();
    }

    public double getSampleVariance() {
        return ((RandomVariableAAD)this.getSampleVarianceAsRandomVariableAAD()).getRandomVariableInterface().getAverage();
    }

    public double getStandardDeviation() {
        return ((RandomVariableAAD)this.getStandardDeviationAsRandomVariableAAD()).getRandomVariableInterface().getAverage();
    }

    public double getStandardDeviation(RandomVariableInterface probabilities) {
        return ((RandomVariableAAD)this.getStandardDeviationAsRandomVariableAAD(probabilities)).getRandomVariableInterface().getAverage();
    }

    public double getStandardError() {
        return ((RandomVariableAAD)this.getStandardErrorAsRandomVariableAAD()).getRandomVariableInterface().getAverage();
    }

    public double getStandardError(RandomVariableInterface probabilities) {
        return ((RandomVariableAAD)this.getStandardErrorAsRandomVariableAAD(probabilities)).getRandomVariableInterface().getAverage();
    }

    public double getQuantile(double quantile) {
        return ((RandomVariableAAD)this.getRandomVariableInterface()).getRandomVariableInterface().getQuantile(quantile);
    }

    public double getQuantile(double quantile, RandomVariableInterface probabilities) {
        return ((RandomVariableAAD)this.getRandomVariableInterface()).getRandomVariableInterface().getQuantile(quantile, probabilities);
    }

    public double getQuantileExpectation(double quantileStart, double quantileEnd) {
        return ((RandomVariableAAD)this.getRandomVariableInterface()).getRandomVariableInterface().getQuantileExpectation(quantileStart, quantileEnd);
    }

    public double[] getHistogram(double[] intervalPoints) {
        return this.getRandomVariableInterface().getHistogram(intervalPoints);
    }

    public double[][] getHistogram(int numberOfPoints, double standardDeviations) {
        return this.getRandomVariableInterface().getHistogram(numberOfPoints, standardDeviations);
    }

    public RandomVariableInterface cache() {
        return this;
    }

    public RandomVariableInterface cap(double cap) {
        return this.apply(OperatorType.CAP, new RandomVariableInterface[]{this, RandomVariableAAD.constructNewAADRandomVariable(cap)});
    }

    public RandomVariableInterface floor(double floor) {
        return this.apply(OperatorType.FLOOR, new RandomVariableInterface[]{this, RandomVariableAAD.constructNewAADRandomVariable(floor)});
    }

    public RandomVariableInterface add(double value) {
        return this.apply(OperatorType.ADD, new RandomVariableInterface[]{this, RandomVariableAAD.constructNewAADRandomVariable(value)});
    }

    public RandomVariableInterface sub(double value) {
        return this.apply(OperatorType.SUB, new RandomVariableInterface[]{this, RandomVariableAAD.constructNewAADRandomVariable(value)});
    }

    public RandomVariableInterface mult(double value) {
        return this.apply(OperatorType.MULT, new RandomVariableInterface[]{this, RandomVariableAAD.constructNewAADRandomVariable(value)});
    }

    public RandomVariableInterface div(double value) {
        return this.apply(OperatorType.DIV, new RandomVariableInterface[]{this, RandomVariableAAD.constructNewAADRandomVariable(value)});
    }

    public RandomVariableInterface pow(double exponent) {
        return this.apply(OperatorType.POW, new RandomVariableInterface[]{this, RandomVariableAAD.constructNewAADRandomVariable(exponent)});
    }

    public RandomVariableInterface average() {
        return this.apply(OperatorType.AVERAGE, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface squared() {
        return this.apply(OperatorType.SQUARED, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface sqrt() {
        return this.apply(OperatorType.SQRT, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface exp() {
        return this.apply(OperatorType.EXP, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface log() {
        return this.apply(OperatorType.LOG, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface sin() {
        return this.apply(OperatorType.SIN, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface cos() {
        return this.apply(OperatorType.COS, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface add(RandomVariableInterface randomVariable) {
        return this.apply(OperatorType.ADD, new RandomVariableInterface[]{this, randomVariable});
    }

    public RandomVariableInterface sub(RandomVariableInterface randomVariable) {
        return this.apply(OperatorType.SUB, new RandomVariableInterface[]{this, randomVariable});
    }

    public RandomVariableInterface mult(RandomVariableInterface randomVariable) {
        return this.apply(OperatorType.MULT, new RandomVariableInterface[]{this, randomVariable});
    }

    public RandomVariableInterface div(RandomVariableInterface randomVariable) {
        return this.apply(OperatorType.DIV, new RandomVariableInterface[]{this, randomVariable});
    }

    public RandomVariableInterface cap(RandomVariableInterface cap) {
        return this.apply(OperatorType.CAP, new RandomVariableInterface[]{this, cap});
    }

    public RandomVariableInterface floor(RandomVariableInterface floor) {
        return this.apply(OperatorType.FLOOR, new RandomVariableInterface[]{this, floor});
    }

    public RandomVariableInterface accrue(RandomVariableInterface rate, double periodLength) {
        return this.apply(OperatorType.ACCRUE, new RandomVariableInterface[]{this, rate, RandomVariableAAD.constructNewAADRandomVariable(periodLength)});
    }

    public RandomVariableInterface discount(RandomVariableInterface rate, double periodLength) {
        return this.apply(OperatorType.DISCOUNT, new RandomVariableInterface[]{this, rate, RandomVariableAAD.constructNewAADRandomVariable(periodLength)});
    }

    public RandomVariableInterface barrier(RandomVariableInterface trigger, RandomVariableInterface valueIfTriggerNonNegative, RandomVariableInterface valueIfTriggerNegative) {
        return this.apply(OperatorType.BARRIER, new RandomVariableInterface[]{this, valueIfTriggerNonNegative, valueIfTriggerNegative});
    }

    public RandomVariableInterface barrier(RandomVariableInterface trigger, RandomVariableInterface valueIfTriggerNonNegative, double valueIfTriggerNegative) {
        return this.apply(OperatorType.BARRIER, new RandomVariableInterface[]{this, valueIfTriggerNonNegative, RandomVariableAAD.constructNewAADRandomVariable(valueIfTriggerNegative)});
    }

    public RandomVariableInterface invert() {
        return this.apply(OperatorType.INVERT, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface abs() {
        return this.apply(OperatorType.ABS, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface addProduct(RandomVariableInterface factor1, double factor2) {
        return this.apply(OperatorType.ADDPRODUCT, new RandomVariableInterface[]{this, factor1, RandomVariableAAD.constructNewAADRandomVariable(factor2)});
    }

    public RandomVariableInterface addProduct(RandomVariableInterface factor1, RandomVariableInterface factor2) {
        return this.apply(OperatorType.ADDPRODUCT, new RandomVariableInterface[]{this, factor1, factor2});
    }

    public RandomVariableInterface addRatio(RandomVariableInterface numerator, RandomVariableInterface denominator) {
        return this.apply(OperatorType.ADDRATIO, new RandomVariableInterface[]{this, numerator, denominator});
    }

    public RandomVariableInterface subRatio(RandomVariableInterface numerator, RandomVariableInterface denominator) {
        return this.apply(OperatorType.SUBRATIO, new RandomVariableInterface[]{this, numerator, denominator});
    }

    public RandomVariableInterface isNaN() {
        return this.getRandomVariableInterface().isNaN();
    }

    public IntToDoubleFunction getOperator() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public DoubleStream getRealizationsStream() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public RandomVariableInterface apply(DoubleUnaryOperator operator) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    public RandomVariableInterface apply(DoubleBinaryOperator operator, RandomVariableInterface argument) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    public RandomVariableInterface apply(DoubleTernaryOperator operator, RandomVariableInterface argument1, RandomVariableInterface argument2) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    private static enum OperatorType {
        ADD,
        MULT,
        DIV,
        SUB,
        SQUARED,
        SQRT,
        LOG,
        SIN,
        COS,
        EXP,
        INVERT,
        CAP,
        FLOOR,
        ABS,
        ADDPRODUCT,
        ADDRATIO,
        SUBRATIO,
        BARRIER,
        DISCOUNT,
        ACCRUE,
        POW,
        AVERAGE,
        VARIANCE,
        STDEV,
        MIN,
        MAX,
        STDERROR,
        SVARIANCE;

    }
}

