/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.automaticdifferentiation.backward.alternative;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.stream.DoubleStream;
import net.finmath.functions.DoubleTernaryOperator;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.automaticdifferentiation.backward.alternative.RandomVariableUniqueVariableFactory;
import net.finmath.stochastic.RandomVariableInterface;

public class RandomVariableUniqueVariable
implements RandomVariableInterface {
    private static final long serialVersionUID = -2631868286977854016L;
    private final RandomVariableUniqueVariableFactory factory = new RandomVariableUniqueVariableFactory();
    private ArrayList<RandomVariableUniqueVariable> parentsVariables;
    private OperatorType parentOperatorType;
    private int variableID;
    private boolean isConstant;

    public RandomVariableUniqueVariable(int variableID, boolean isConstant, ArrayList<RandomVariableUniqueVariable> parentVariables, OperatorType parentOperatorType) {
        this.variableID = variableID;
        this.isConstant = isConstant;
        this.parentsVariables = parentVariables;
        this.parentOperatorType = parentOperatorType;
    }

    public RandomVariableUniqueVariable(double time, double[] values, boolean isConstant, ArrayList<RandomVariableUniqueVariable> parentVariables, OperatorType parentOperatorType) {
        this.constructRandomVariableUniqueVariable((RandomVariableInterface)new RandomVariable(time, values), isConstant, parentVariables, parentOperatorType);
    }

    public RandomVariableUniqueVariable(RandomVariableInterface randomVariable, boolean isConstant, ArrayList<RandomVariableUniqueVariable> parentVariables, OperatorType parentOperatorType) {
        this.constructRandomVariableUniqueVariable(randomVariable, isConstant, parentVariables, parentOperatorType);
    }

    public RandomVariableUniqueVariable(double time, double[] values, boolean isConstant) {
        this.constructRandomVariableUniqueVariable((RandomVariableInterface)new RandomVariable(time, values), isConstant, null, null);
    }

    public RandomVariableUniqueVariable(RandomVariableInterface randomVariable, boolean isConstant) {
        this.constructRandomVariableUniqueVariable(randomVariable, isConstant, null, null);
    }

    public RandomVariableUniqueVariable(double time, double[] values) {
        this.constructRandomVariableUniqueVariable((RandomVariableInterface)new RandomVariable(time, values), false, null, null);
    }

    public RandomVariableUniqueVariable(RandomVariableInterface randomVariable) {
        this.constructRandomVariableUniqueVariable(randomVariable, false, null, null);
    }

    private void constructRandomVariableUniqueVariable(RandomVariableInterface randomVariable, boolean isConstant, ArrayList<RandomVariableUniqueVariable> parentVariables, OperatorType parentOperatorType) {
        RandomVariableInterface normalrandomvariable = this.factory.createRandomVariable(randomVariable, isConstant, parentVariables, parentOperatorType);
        RandomVariableUniqueVariable newrandomvariableuniquevariable = (RandomVariableUniqueVariable)normalrandomvariable;
        this.variableID = newrandomvariableuniquevariable.getVariableID();
        this.isConstant = newrandomvariableuniquevariable.isConstant();
        this.parentsVariables = newrandomvariableuniquevariable.getParentVariables();
        this.parentOperatorType = newrandomvariableuniquevariable.getParentOperatorType();
    }

    private int[] getParentIDs() {
        if (this.parentsVariables == null) {
            return null;
        }
        int[] parentIDs = new int[this.parentsVariables.size()];
        for (int i = 0; i < this.parentsVariables.size(); ++i) {
            parentIDs[i] = this.parentsVariables.get(i).getVariableID();
        }
        return parentIDs;
    }

    public int getVariableID() {
        return this.variableID;
    }

    private boolean isConstant() {
        return this.isConstant;
    }

    private ArrayList<RandomVariableUniqueVariable> getParentVariables() {
        return this.parentsVariables;
    }

    private OperatorType getParentOperatorType() {
        return this.parentOperatorType;
    }

    private ArrayList<RandomVariableInterface> getListOfAllVariables() {
        return this.factory.getListOfAllVariables();
    }

    private ArrayList<RandomVariableInterface> getParentRandomVariables() {
        ArrayList<RandomVariableInterface> parentrandomvariables = new ArrayList<RandomVariableInterface>();
        for (RandomVariableUniqueVariable parent : this.parentsVariables) {
            parentrandomvariables.add(parent.getRandomVariable());
        }
        return parentrandomvariables;
    }

    private RandomVariableInterface getRandomVariable() {
        return this.getListOfAllVariables().get(this.variableID);
    }

    public boolean isVariable() {
        return this.parentsVariables == null && !this.isConstant();
    }

    public boolean equals(RandomVariableInterface randomVariable) {
        return false;
    }

    public double getFiltrationTime() {
        return this.getRandomVariable().getFiltrationTime();
    }

    public double get(int pathOrState) {
        return this.getRandomVariable().get(pathOrState);
    }

    public int size() {
        return this.getRandomVariable().size();
    }

    public boolean isDeterministic() {
        return this.getRandomVariable().isDeterministic();
    }

    public double[] getRealizations() {
        return this.getRandomVariable().getRealizations();
    }

    public Double doubleValue() {
        return this.getRandomVariable().doubleValue();
    }

    public double getMin() {
        return 0.0;
    }

    public double getMax() {
        return 0.0;
    }

    public double getAverage() {
        return 0.0;
    }

    public double getAverage(RandomVariableInterface probabilities) {
        return 0.0;
    }

    public double getVariance() {
        return 0.0;
    }

    public double getVariance(RandomVariableInterface probabilities) {
        return 0.0;
    }

    public double getSampleVariance() {
        return 0.0;
    }

    public double getStandardDeviation() {
        return 0.0;
    }

    public double getStandardDeviation(RandomVariableInterface probabilities) {
        return 0.0;
    }

    public double getStandardError() {
        return 0.0;
    }

    public double getStandardError(RandomVariableInterface probabilities) {
        return 0.0;
    }

    public double getQuantile(double quantile) {
        return 0.0;
    }

    public double getQuantile(double quantile, RandomVariableInterface probabilities) {
        return 0.0;
    }

    public double getQuantileExpectation(double quantileStart, double quantileEnd) {
        return 0.0;
    }

    public double[] getHistogram(double[] intervalPoints) {
        return this.getRandomVariable().getHistogram(intervalPoints);
    }

    public double[][] getHistogram(int numberOfPoints, double standardDeviations) {
        return this.getRandomVariable().getHistogram(numberOfPoints, standardDeviations);
    }

    public RandomVariableInterface cache() {
        return this.getRandomVariable().cache();
    }

    public RandomVariableInterface floor(double floor) {
        return null;
    }

    public RandomVariableInterface add(double value) {
        return null;
    }

    public RandomVariableInterface sub(double value) {
        return null;
    }

    public RandomVariableInterface mult(double value) {
        return null;
    }

    public RandomVariableInterface div(double value) {
        return null;
    }

    public RandomVariableInterface pow(double exponent) {
        return null;
    }

    public RandomVariableInterface average() {
        return null;
    }

    public RandomVariableInterface squared() {
        return this.apply(OperatorType.SQUARED, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface sqrt() {
        return this.apply(OperatorType.SQRT, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface exp() {
        return this.apply(OperatorType.EXP, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface log() {
        return this.apply(OperatorType.LOG, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface sin() {
        return this.apply(OperatorType.SIN, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface cos() {
        return this.apply(OperatorType.COS, new RandomVariableInterface[]{this});
    }

    public RandomVariableInterface add(RandomVariableInterface randomVariable) {
        return this.apply(OperatorType.ADD, new RandomVariableInterface[]{this, randomVariable});
    }

    public RandomVariableInterface sub(RandomVariableInterface randomVariable) {
        return this.apply(OperatorType.SUB, new RandomVariableInterface[]{this, randomVariable});
    }

    public RandomVariableInterface mult(RandomVariableInterface randomVariable) {
        return this.apply(OperatorType.MULT, new RandomVariableInterface[]{this, randomVariable});
    }

    public RandomVariableInterface div(RandomVariableInterface randomVariable) {
        return this.apply(OperatorType.DIV, new RandomVariableInterface[]{this, randomVariable});
    }

    public RandomVariableInterface cap(RandomVariableInterface cap) {
        return null;
    }

    public RandomVariableInterface floor(RandomVariableInterface floor) {
        return null;
    }

    public RandomVariableInterface accrue(RandomVariableInterface rate, double periodLength) {
        return null;
    }

    public RandomVariableInterface discount(RandomVariableInterface rate, double periodLength) {
        return null;
    }

    public RandomVariableInterface barrier(RandomVariableInterface trigger, RandomVariableInterface valueIfTriggerNonNegative, RandomVariableInterface valueIfTriggerNegative) {
        return null;
    }

    public RandomVariableInterface barrier(RandomVariableInterface trigger, RandomVariableInterface valueIfTriggerNonNegative, double valueIfTriggerNegative) {
        return null;
    }

    public RandomVariableInterface invert() {
        return null;
    }

    public RandomVariableInterface abs() {
        return null;
    }

    public RandomVariableInterface addProduct(RandomVariableInterface factor1, double factor2) {
        return null;
    }

    public RandomVariableInterface addProduct(RandomVariableInterface factor1, RandomVariableInterface factor2) {
        return null;
    }

    public RandomVariableInterface addRatio(RandomVariableInterface numerator, RandomVariableInterface denominator) {
        return null;
    }

    public RandomVariableInterface subRatio(RandomVariableInterface numerator, RandomVariableInterface denominator) {
        return null;
    }

    public RandomVariableInterface isNaN() {
        return this.getRandomVariable().isNaN();
    }

    private boolean isUpcastableToRandomVariableUniqueVariable(Object obj) {
        return obj instanceof RandomVariableUniqueVariable;
    }

    private RandomVariableUniqueVariable apply(OperatorType operatortype, RandomVariableInterface[] operatorVariables) {
        RandomVariableInterface resultrandomvariable;
        ArrayList<RandomVariableUniqueVariable> parentVariables = new ArrayList<RandomVariableUniqueVariable>();
        for (int i = 0; i < operatorVariables.length; ++i) {
            if (!this.isUpcastableToRandomVariableUniqueVariable(operatorVariables[i])) {
                operatorVariables[i] = new RandomVariableUniqueVariable(operatorVariables[i], true);
            }
            parentVariables.add(i, (RandomVariableUniqueVariable)operatorVariables[i]);
            operatorVariables[i] = ((RandomVariableUniqueVariable)parentVariables.get(i)).getRandomVariable();
        }
        switch (operatortype) {
            case SQUARED: {
                resultrandomvariable = operatorVariables[0].squared();
                break;
            }
            case SQRT: {
                resultrandomvariable = operatorVariables[0].sqrt();
                break;
            }
            case EXP: {
                resultrandomvariable = operatorVariables[0].exp();
                break;
            }
            case LOG: {
                resultrandomvariable = operatorVariables[0].log();
                break;
            }
            case SIN: {
                resultrandomvariable = operatorVariables[0].sin();
                break;
            }
            case COS: {
                resultrandomvariable = operatorVariables[0].cos();
                break;
            }
            case ADD: {
                resultrandomvariable = operatorVariables[0].add(operatorVariables[1]);
                break;
            }
            case SUB: {
                resultrandomvariable = operatorVariables[0].sub(operatorVariables[1]);
                break;
            }
            case MULT: {
                resultrandomvariable = operatorVariables[0].mult(operatorVariables[1]);
                break;
            }
            case DIV: {
                resultrandomvariable = operatorVariables[0].div(operatorVariables[1]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Operation not supported!\n");
            }
        }
        return new RandomVariableUniqueVariable(resultrandomvariable, false, parentVariables, operatortype);
    }

    public RandomVariableInterface[] getGradient() {
        int numberOfVariables = this.getNumberOfVariablesInList();
        int numberOfCalculationSteps = this.factory.getNumberOfEntriesInList();
        RandomVariableInterface[] omega_hat = new RandomVariableInterface[numberOfCalculationSteps];
        omega_hat[numberOfCalculationSteps - 1] = new RandomVariable(1.0);
        for (int functionIndex = numberOfCalculationSteps - 2; functionIndex > 0; --functionIndex) {
            omega_hat[functionIndex] = new RandomVariable(0.0);
            for (RandomVariableUniqueVariable parent : this.parentsVariables) {
                int variableIndex = parent.getVariableID();
                omega_hat[functionIndex] = omega_hat[functionIndex].add(this.getPartialDerivative(functionIndex, variableIndex).mult(omega_hat[variableIndex]));
            }
        }
        RandomVariableInterface[] gradient = new RandomVariableInterface[numberOfVariables];
        int[] indicesOfVariables = this.getIDsOfVariablesInList();
        for (int i = 0; i < numberOfVariables; ++i) {
            gradient[i] = omega_hat[numberOfCalculationSteps - numberOfVariables + indicesOfVariables[i]];
        }
        return gradient;
    }

    private ArrayList<RandomVariableUniqueVariable> getListOfDependingTrueVariables() {
        ArrayList<RandomVariableUniqueVariable> listOfDependingTrueVariables = new ArrayList<RandomVariableUniqueVariable>();
        for (RandomVariableUniqueVariable parent : this.parentsVariables) {
            if (parent.isVariable() && !listOfDependingTrueVariables.contains(parent)) {
                listOfDependingTrueVariables.add(parent);
                continue;
            }
            if (parent.getParentIDs() == null) continue;
            listOfDependingTrueVariables.addAll(parent.getListOfDependingTrueVariables());
        }
        return listOfDependingTrueVariables;
    }

    private int[] getIDsOfVariablesInList() {
        int[] IDsOfVariablesInList = new int[this.getNumberOfVariablesInList()];
        ArrayList<RandomVariableUniqueVariable> listOfDependingTrueVariables = this.getListOfDependingTrueVariables();
        for (RandomVariableUniqueVariable variable : listOfDependingTrueVariables) {
            IDsOfVariablesInList[listOfDependingTrueVariables.indexOf((Object)variable)] = variable.getVariableID();
        }
        return IDsOfVariablesInList;
    }

    private int getNumberOfVariablesInList() {
        return this.getListOfDependingTrueVariables().size();
    }

    private RandomVariableInterface getPartialDerivative(int functionIndex, int variableIndex) {
        RandomVariable resultrandomvariable;
        if (!Arrays.asList(new int[][]{this.getParentIDs()}).contains(variableIndex)) {
            return new RandomVariable(0.0);
        }
        RandomVariableUniqueVariable currentRandomVariable = (RandomVariableUniqueVariable)this.getListOfAllVariables().get(functionIndex);
        ArrayList<RandomVariableInterface> currentParentRandomVaribles = currentRandomVariable.getParentRandomVariables();
        switch (currentRandomVariable.getParentOperatorType()) {
            case SQUARED: {
                resultrandomvariable = currentParentRandomVaribles.get(0).mult(2.0);
                break;
            }
            case SQRT: {
                resultrandomvariable = currentParentRandomVaribles.get(0).sqrt().invert().mult(0.5);
                break;
            }
            case EXP: {
                resultrandomvariable = currentParentRandomVaribles.get(0).exp();
                break;
            }
            case LOG: {
                resultrandomvariable = currentParentRandomVaribles.get(0).invert();
                break;
            }
            case SIN: {
                resultrandomvariable = currentParentRandomVaribles.get(0).cos();
                break;
            }
            case COS: {
                resultrandomvariable = currentParentRandomVaribles.get(0).sin().mult(-1.0);
                break;
            }
            case ADD: {
                resultrandomvariable = new RandomVariable(1.0);
                break;
            }
            case SUB: {
                resultrandomvariable = new RandomVariable(1.0);
                if (variableIndex != currentRandomVariable.getParentIDs()[1]) break;
                resultrandomvariable = resultrandomvariable.mult(-1.0);
                break;
            }
            case MULT: {
                if (variableIndex == currentRandomVariable.getParentIDs()[0]) {
                    resultrandomvariable = currentParentRandomVaribles.get(1);
                    break;
                }
                resultrandomvariable = currentParentRandomVaribles.get(0);
                break;
            }
            case DIV: {
                if (variableIndex == currentRandomVariable.getParentIDs()[0]) {
                    resultrandomvariable = currentParentRandomVaribles.get(1).invert();
                    break;
                }
                resultrandomvariable = currentParentRandomVaribles.get(0).div(currentParentRandomVaribles.get(1).squared()).mult(-1.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Operation not supported!\n");
            }
        }
        return resultrandomvariable;
    }

    public String toString() {
        return super.toString() + "\ntime: " + this.getFiltrationTime() + "\nrealizations: " + Arrays.toString(this.getRealizations()) + "\nvariableID: " + this.variableID + "\nparentIDs: " + Arrays.toString(this.getParentIDs()) + (this.getParentIDs() == null ? "" : " type: " + this.parentOperatorType.name()) + "\nisTrueVariable: " + this.isVariable() + "";
    }

    public RandomVariableInterface cap(double cap) {
        return null;
    }

    public IntToDoubleFunction getOperator() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public DoubleStream getRealizationsStream() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public RandomVariableInterface apply(DoubleUnaryOperator operator) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    public RandomVariableInterface apply(DoubleBinaryOperator operator, RandomVariableInterface argument) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    public RandomVariableInterface apply(DoubleTernaryOperator operator, RandomVariableInterface argument1, RandomVariableInterface argument2) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    public static enum OperatorType {
        ADD,
        MULT,
        DIV,
        SUB,
        SQUARED,
        SQRT,
        LOG,
        SIN,
        COS,
        EXP;

    }
}

