/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.automaticdifferentiation.forward;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import net.finmath.functions.DoubleTernaryOperator;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.automaticdifferentiation.RandomVariableDifferentiableInterface;
import net.finmath.stochastic.ConditionalExpectationEstimatorInterface;
import net.finmath.stochastic.RandomVariableInterface;

public class RandomVariableDifferentiableAD
implements RandomVariableDifferentiableInterface {
    private static final long serialVersionUID = 2459373647785530657L;
    private static AtomicLong indexOfNextRandomVariable = new AtomicLong(0L);
    private RandomVariableInterface values;
    private final OperatorTreeNode operatorTreeNode;

    public static RandomVariableDifferentiableAD of(double value) {
        return new RandomVariableDifferentiableAD(value);
    }

    public static RandomVariableDifferentiableAD of(RandomVariableInterface randomVariable) {
        return new RandomVariableDifferentiableAD(randomVariable);
    }

    public RandomVariableDifferentiableAD(double value) {
        this((RandomVariableInterface)new RandomVariable(value), null, null);
    }

    public RandomVariableDifferentiableAD(double time, double[] realisations) {
        this((RandomVariableInterface)new RandomVariable(time, realisations), null, null);
    }

    public RandomVariableDifferentiableAD(RandomVariableInterface randomVariable) {
        this(randomVariable, null, null);
    }

    private RandomVariableDifferentiableAD(RandomVariableInterface values, List<RandomVariableInterface> arguments, OperatorType operator) {
        this.values = values;
        this.operatorTreeNode = new OperatorTreeNode(operator, arguments, null);
    }

    public RandomVariableDifferentiableAD(RandomVariableInterface values, List<RandomVariableInterface> arguments, ConditionalExpectationEstimatorInterface estimator, OperatorType operator) {
        this.values = values;
        this.operatorTreeNode = new OperatorTreeNode(operator, arguments, estimator);
    }

    public RandomVariableInterface getRandomVariable() {
        return this.values;
    }

    public OperatorTreeNode getOperatorTreeNode() {
        return this.operatorTreeNode;
    }

    @Override
    public Long getID() {
        return this.getOperatorTreeNode().id;
    }

    @Override
    public Map<Long, RandomVariableInterface> getGradient(Set<Long> independentIDs) {
        HashMap<Long, RandomVariableInterface> derivatives = new HashMap<Long, RandomVariableInterface>();
        derivatives.put(this.getID(), (RandomVariableInterface)new RandomVariable(1.0));
        TreeMap<Long, OperatorTreeNode> independents = new TreeMap<Long, OperatorTreeNode>();
        independents.put(this.getID(), this.getOperatorTreeNode());
        while (independents.size() > 0) {
            Map.Entry independentEntry = independents.lastEntry();
            Long id = (Long)independentEntry.getKey();
            OperatorTreeNode independent = (OperatorTreeNode)independentEntry.getValue();
            List arguments = independent.arguments;
            if (arguments != null && arguments.size() > 0) {
                independent.propagateDerivativesFromResultToArgument(derivatives);
                for (OperatorTreeNode argument : arguments) {
                    if (argument == null) continue;
                    Long argumentId = argument.id;
                    independents.put(argumentId, argument);
                }
                derivatives.remove(id);
            }
            independents.remove(id);
        }
        return derivatives;
    }

    @Override
    public Map<Long, RandomVariableInterface> getTangents(Set<Long> dependentIDs) {
        throw new UnsupportedOperationException();
    }

    private RandomVariableInterface getValues() {
        return this.values;
    }

    public boolean equals(RandomVariableInterface randomVariable) {
        return this.getValues().equals(randomVariable);
    }

    public double getFiltrationTime() {
        return this.getValues().getFiltrationTime();
    }

    public double get(int pathOrState) {
        return this.getValues().get(pathOrState);
    }

    public int size() {
        return this.getValues().size();
    }

    public boolean isDeterministic() {
        return this.getValues().isDeterministic();
    }

    public double[] getRealizations() {
        return this.getValues().getRealizations();
    }

    public Double doubleValue() {
        return this.getValues().doubleValue();
    }

    public double getMin() {
        return this.getValues().getMin();
    }

    public double getMax() {
        return this.getValues().getMax();
    }

    public double getAverage() {
        return this.getValues().getAverage();
    }

    public double getAverage(RandomVariableInterface probabilities) {
        return this.getValues().getAverage(probabilities);
    }

    public double getVariance() {
        return this.getValues().getVariance();
    }

    public double getVariance(RandomVariableInterface probabilities) {
        return this.getValues().getVariance(probabilities);
    }

    public double getSampleVariance() {
        return this.getValues().getSampleVariance();
    }

    public double getStandardDeviation() {
        return this.getValues().getStandardDeviation();
    }

    public double getStandardDeviation(RandomVariableInterface probabilities) {
        return this.getValues().getStandardDeviation(probabilities);
    }

    public double getStandardError() {
        return this.getValues().getStandardError();
    }

    public double getStandardError(RandomVariableInterface probabilities) {
        return this.getValues().getStandardError(probabilities);
    }

    public double getQuantile(double quantile) {
        return this.getValues().getQuantile(quantile);
    }

    public double getQuantile(double quantile, RandomVariableInterface probabilities) {
        return ((RandomVariableDifferentiableAD)this.getValues()).getValues().getQuantile(quantile, probabilities);
    }

    public double getQuantileExpectation(double quantileStart, double quantileEnd) {
        return ((RandomVariableDifferentiableAD)this.getValues()).getValues().getQuantileExpectation(quantileStart, quantileEnd);
    }

    public double[] getHistogram(double[] intervalPoints) {
        return this.getValues().getHistogram(intervalPoints);
    }

    public double[][] getHistogram(int numberOfPoints, double standardDeviations) {
        return this.getValues().getHistogram(numberOfPoints, standardDeviations);
    }

    public RandomVariableInterface cache() {
        this.values = this.values.cache();
        return this;
    }

    public RandomVariableInterface cap(double cap) {
        return new RandomVariableDifferentiableAD(this.getValues().cap(cap), Arrays.asList(this, new RandomVariable(cap)), OperatorType.CAP);
    }

    public RandomVariableInterface floor(double floor) {
        return new RandomVariableDifferentiableAD(this.getValues().floor(floor), Arrays.asList(this, new RandomVariable(floor)), OperatorType.FLOOR);
    }

    public RandomVariableInterface add(double value) {
        return new RandomVariableDifferentiableAD(this.getValues().add(value), Arrays.asList(this, new RandomVariable(value)), OperatorType.ADD);
    }

    public RandomVariableInterface sub(double value) {
        return new RandomVariableDifferentiableAD(this.getValues().sub(value), Arrays.asList(this, new RandomVariable(value)), OperatorType.SUB);
    }

    public RandomVariableInterface mult(double value) {
        return new RandomVariableDifferentiableAD(this.getValues().mult(value), Arrays.asList(this, new RandomVariable(value)), OperatorType.MULT);
    }

    public RandomVariableInterface div(double value) {
        return new RandomVariableDifferentiableAD(this.getValues().div(value), Arrays.asList(this, new RandomVariable(value)), OperatorType.DIV);
    }

    public RandomVariableInterface pow(double exponent) {
        return new RandomVariableDifferentiableAD(this.getValues().pow(exponent), Arrays.asList(this, new RandomVariable(exponent)), OperatorType.POW);
    }

    public RandomVariableInterface average() {
        return new RandomVariableDifferentiableAD(this.getValues().average(), Arrays.asList(this), OperatorType.AVERAGE);
    }

    public RandomVariableInterface getConditionalExpectation(ConditionalExpectationEstimatorInterface estimator) {
        return new RandomVariableDifferentiableAD(this.getValues().average(), Arrays.asList(this), estimator, OperatorType.CONDITIONAL_EXPECTATION);
    }

    public RandomVariableInterface squared() {
        return new RandomVariableDifferentiableAD(this.getValues().squared(), Arrays.asList(this), OperatorType.SQUARED);
    }

    public RandomVariableInterface sqrt() {
        return new RandomVariableDifferentiableAD(this.getValues().sqrt(), Arrays.asList(this), OperatorType.SQRT);
    }

    public RandomVariableInterface exp() {
        return new RandomVariableDifferentiableAD(this.getValues().exp(), Arrays.asList(this), OperatorType.EXP);
    }

    public RandomVariableInterface log() {
        return new RandomVariableDifferentiableAD(this.getValues().log(), Arrays.asList(this), OperatorType.LOG);
    }

    public RandomVariableInterface sin() {
        return new RandomVariableDifferentiableAD(this.getValues().sin(), Arrays.asList(this), OperatorType.SIN);
    }

    public RandomVariableInterface cos() {
        return new RandomVariableDifferentiableAD(this.getValues().cos(), Arrays.asList(this), OperatorType.COS);
    }

    public RandomVariableInterface add(RandomVariableInterface randomVariable) {
        return new RandomVariableDifferentiableAD(this.getValues().add(randomVariable), Arrays.asList(this, randomVariable), OperatorType.ADD);
    }

    public RandomVariableInterface sub(RandomVariableInterface randomVariable) {
        return new RandomVariableDifferentiableAD(this.getValues().sub(randomVariable), Arrays.asList(this, randomVariable), OperatorType.SUB);
    }

    public RandomVariableDifferentiableInterface mult(RandomVariableInterface randomVariable) {
        return new RandomVariableDifferentiableAD(this.getValues().mult(randomVariable), Arrays.asList(this, randomVariable), OperatorType.MULT);
    }

    public RandomVariableInterface div(RandomVariableInterface randomVariable) {
        return new RandomVariableDifferentiableAD(this.getValues().div(randomVariable), Arrays.asList(this, randomVariable), OperatorType.DIV);
    }

    public RandomVariableInterface cap(RandomVariableInterface cap) {
        return new RandomVariableDifferentiableAD(this.getValues().cap(cap), Arrays.asList(this, cap), OperatorType.CAP);
    }

    public RandomVariableInterface floor(RandomVariableInterface floor) {
        return new RandomVariableDifferentiableAD(this.getValues().cap(floor), Arrays.asList(this, floor), OperatorType.FLOOR);
    }

    public RandomVariableInterface accrue(RandomVariableInterface rate, double periodLength) {
        return new RandomVariableDifferentiableAD(this.getValues().accrue(rate, periodLength), Arrays.asList(this, rate, new RandomVariable(periodLength)), OperatorType.ACCRUE);
    }

    public RandomVariableInterface discount(RandomVariableInterface rate, double periodLength) {
        return new RandomVariableDifferentiableAD(this.getValues().discount(rate, periodLength), Arrays.asList(this, rate, new RandomVariable(periodLength)), OperatorType.DISCOUNT);
    }

    public RandomVariableInterface barrier(RandomVariableInterface trigger, RandomVariableInterface valueIfTriggerNonNegative, RandomVariableInterface valueIfTriggerNegative) {
        RandomVariableInterface triggerValues = trigger instanceof RandomVariableDifferentiableAD ? ((RandomVariableDifferentiableAD)trigger).getValues() : trigger;
        return new RandomVariableDifferentiableAD(this.getValues().barrier(triggerValues, valueIfTriggerNonNegative, valueIfTriggerNegative), Arrays.asList(trigger, valueIfTriggerNonNegative, valueIfTriggerNegative), OperatorType.BARRIER);
    }

    public RandomVariableInterface barrier(RandomVariableInterface trigger, RandomVariableInterface valueIfTriggerNonNegative, double valueIfTriggerNegative) {
        RandomVariableInterface triggerValues = trigger instanceof RandomVariableDifferentiableAD ? ((RandomVariableDifferentiableAD)trigger).getValues() : trigger;
        return new RandomVariableDifferentiableAD(this.getValues().barrier(triggerValues, valueIfTriggerNonNegative, valueIfTriggerNegative), Arrays.asList(trigger, valueIfTriggerNonNegative, new RandomVariable(valueIfTriggerNegative)), OperatorType.BARRIER);
    }

    public RandomVariableInterface invert() {
        return new RandomVariableDifferentiableAD(this.getValues().invert(), Arrays.asList(this), OperatorType.INVERT);
    }

    public RandomVariableInterface abs() {
        return new RandomVariableDifferentiableAD(this.getValues().abs(), Arrays.asList(this), OperatorType.ABS);
    }

    public RandomVariableInterface addProduct(RandomVariableInterface factor1, double factor2) {
        return new RandomVariableDifferentiableAD(this.getValues().addProduct(factor1, factor2), Arrays.asList(this, factor1, new RandomVariable(factor2)), OperatorType.ADDPRODUCT);
    }

    public RandomVariableInterface addProduct(RandomVariableInterface factor1, RandomVariableInterface factor2) {
        return new RandomVariableDifferentiableAD(this.getValues().addProduct(factor1, factor2), Arrays.asList(this, factor1, factor2), OperatorType.ADDPRODUCT);
    }

    public RandomVariableInterface addRatio(RandomVariableInterface numerator, RandomVariableInterface denominator) {
        return new RandomVariableDifferentiableAD(this.getValues().addRatio(numerator, denominator), Arrays.asList(this, numerator, denominator), OperatorType.ADDRATIO);
    }

    public RandomVariableInterface subRatio(RandomVariableInterface numerator, RandomVariableInterface denominator) {
        return new RandomVariableDifferentiableAD(this.getValues().subRatio(numerator, denominator), Arrays.asList(this, numerator, denominator), OperatorType.SUBRATIO);
    }

    public RandomVariableInterface isNaN() {
        return this.getValues().isNaN();
    }

    public IntToDoubleFunction getOperator() {
        return this.getValues().getOperator();
    }

    public DoubleStream getRealizationsStream() {
        return this.getValues().getRealizationsStream();
    }

    public RandomVariableInterface apply(DoubleUnaryOperator operator) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    public RandomVariableInterface apply(DoubleBinaryOperator operator, RandomVariableInterface argument) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    public RandomVariableInterface apply(DoubleTernaryOperator operator, RandomVariableInterface argument1, RandomVariableInterface argument2) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    private RandomVariableInterface getAverageAsRandomVariableAAD(RandomVariableInterface probabilities) {
        return new RandomVariableDifferentiableAD((RandomVariableInterface)new RandomVariable(this.getAverage(probabilities)), Arrays.asList(this, new RandomVariable(probabilities)), OperatorType.AVERAGE2);
    }

    private RandomVariableInterface getVarianceAsRandomVariableAAD(RandomVariableInterface probabilities) {
        return new RandomVariableDifferentiableAD((RandomVariableInterface)new RandomVariable(this.getVariance(probabilities)), Arrays.asList(this, new RandomVariable(probabilities)), OperatorType.VARIANCE2);
    }

    private RandomVariableInterface getStandardDeviationAsRandomVariableAAD(RandomVariableInterface probabilities) {
        return new RandomVariableDifferentiableAD((RandomVariableInterface)new RandomVariable(this.getStandardDeviation(probabilities)), Arrays.asList(this, new RandomVariable(probabilities)), OperatorType.STDEV2);
    }

    private RandomVariableInterface getStandardErrorAsRandomVariableAAD(RandomVariableInterface probabilities) {
        return new RandomVariableDifferentiableAD((RandomVariableInterface)new RandomVariable(this.getStandardError(probabilities)), Arrays.asList(this, new RandomVariable(probabilities)), OperatorType.STDERROR2);
    }

    public RandomVariableInterface getVarianceAsRandomVariableAAD() {
        return new RandomVariableDifferentiableAD((RandomVariableInterface)new RandomVariable(this.getVariance()), Arrays.asList(this), OperatorType.VARIANCE);
    }

    public RandomVariableInterface getSampleVarianceAsRandomVariableAAD() {
        return new RandomVariableDifferentiableAD((RandomVariableInterface)new RandomVariable(this.getSampleVariance()), Arrays.asList(this), OperatorType.SVARIANCE);
    }

    public RandomVariableInterface getStandardDeviationAsRandomVariableAAD() {
        return new RandomVariableDifferentiableAD((RandomVariableInterface)new RandomVariable(this.getStandardDeviation()), Arrays.asList(this), OperatorType.STDEV);
    }

    public RandomVariableInterface getStandardErrorAsRandomVariableAAD() {
        return new RandomVariableDifferentiableAD((RandomVariableInterface)new RandomVariable(this.getStandardError()), Arrays.asList(this), OperatorType.STDERROR);
    }

    public RandomVariableInterface getMinAsRandomVariableAAD() {
        return new RandomVariableDifferentiableAD((RandomVariableInterface)new RandomVariable(this.getMin()), Arrays.asList(this), OperatorType.MIN);
    }

    public RandomVariableInterface getMaxAsRandomVariableAAD() {
        return new RandomVariableDifferentiableAD((RandomVariableInterface)new RandomVariable(this.getMax()), Arrays.asList(this), OperatorType.MAX);
    }

    @Override
    public Map<Long, RandomVariableInterface> getTangents() {
        return null;
    }

    static /* synthetic */ AtomicLong access$000() {
        return indexOfNextRandomVariable;
    }

    private static class OperatorTreeNode {
        private final Long id = RandomVariableDifferentiableAD.access$000().getAndIncrement();
        private final OperatorType operatorType;
        private final List<OperatorTreeNode> arguments;
        private final List<RandomVariableInterface> argumentValues;
        private final Object operator;

        OperatorTreeNode(OperatorType operatorType, List<RandomVariableInterface> arguments, Object operator) {
            this(operatorType, arguments != null ? arguments.stream().map(x -> x != null && x instanceof RandomVariableDifferentiableAD ? ((RandomVariableDifferentiableAD)x).getOperatorTreeNode() : null).collect(Collectors.toList()) : null, arguments != null ? arguments.stream().map(x -> x != null && x instanceof RandomVariableDifferentiableAD ? ((RandomVariableDifferentiableAD)x).getValues() : x).collect(Collectors.toList()) : null, operator);
        }

        OperatorTreeNode(OperatorType operatorType, List<OperatorTreeNode> arguments, List<RandomVariableInterface> argumentValues, Object operator) {
            this.operatorType = operatorType;
            this.arguments = arguments;
            this.argumentValues = operatorType != null && operatorType.equals((Object)OperatorType.ADD) ? null : argumentValues;
            this.operator = operator;
            if (operatorType != null && (operatorType.equals((Object)OperatorType.ADD) || operatorType.equals((Object)OperatorType.SUB))) {
                argumentValues = null;
            } else if (operatorType != null && operatorType.equals((Object)OperatorType.AVERAGE)) {
                argumentValues = null;
            } else if (operatorType != null && operatorType.equals((Object)OperatorType.MULT)) {
                if (arguments.get(0) == null) {
                    argumentValues.set(1, null);
                }
                if (arguments.get(1) == null) {
                    argumentValues.set(0, null);
                }
            } else if (operatorType != null && operatorType.equals((Object)OperatorType.DIV)) {
                if (arguments.get(1) == null) {
                    argumentValues.set(0, null);
                }
            } else if (operatorType != null && operatorType.equals((Object)OperatorType.ADDPRODUCT)) {
                argumentValues.set(0, null);
                if (arguments.get(1) == null) {
                    argumentValues.set(2, null);
                }
                if (arguments.get(2) == null) {
                    argumentValues.set(1, null);
                }
            } else if (operatorType != null && operatorType.equals((Object)OperatorType.ACCRUE)) {
                if (arguments.get(1) == null && arguments.get(2) == null) {
                    argumentValues.set(0, null);
                }
                if (arguments.get(0) == null && arguments.get(1) == null) {
                    argumentValues.set(1, null);
                }
                if (arguments.get(0) == null && arguments.get(2) == null) {
                    argumentValues.set(2, null);
                }
            } else if (operatorType != null && operatorType.equals((Object)OperatorType.BARRIER) && arguments.get(0) == null) {
                argumentValues.set(1, null);
                argumentValues.set(2, null);
            }
        }

        private void propagateDerivativesFromResultToArgument(Map<Long, RandomVariableInterface> derivatives) {
            for (OperatorTreeNode argument : this.arguments) {
                if (argument == null) continue;
                Long argumentID = argument.id;
                if (!derivatives.containsKey(argumentID)) {
                    derivatives.put(argumentID, (RandomVariableInterface)new RandomVariable(0.0));
                }
                RandomVariableInterface partialDerivative = this.getPartialDerivative(argument);
                RandomVariableInterface derivative = derivatives.get(this.id);
                RandomVariableInterface argumentDerivative = derivatives.get(argumentID);
                if (this.operatorType == OperatorType.AVERAGE) {
                    derivative = derivative.average();
                }
                if (this.operatorType == OperatorType.CONDITIONAL_EXPECTATION) {
                    ConditionalExpectationEstimatorInterface estimator = (ConditionalExpectationEstimatorInterface)this.operator;
                    derivative = estimator.getConditionalExpectation(derivative);
                }
                argumentDerivative = argumentDerivative.addProduct(partialDerivative, derivative);
                derivatives.put(argumentID, argumentDerivative);
            }
        }

        private RandomVariableInterface getPartialDerivative(OperatorTreeNode differential) {
            if (!this.arguments.contains(differential)) {
                return new RandomVariable(0.0);
            }
            int differentialIndex = this.arguments.indexOf(differential);
            RandomVariableInterface X = this.arguments.size() > 0 && this.argumentValues != null ? this.argumentValues.get(0) : null;
            RandomVariableInterface Y = this.arguments.size() > 1 && this.argumentValues != null ? this.argumentValues.get(1) : null;
            RandomVariableInterface Z = this.arguments.size() > 2 && this.argumentValues != null ? this.argumentValues.get(2) : null;
            RandomVariableInterface resultrandomvariable = null;
            switch (this.operatorType) {
                case SQUARED: {
                    resultrandomvariable = X.mult(2.0);
                    break;
                }
                case SQRT: {
                    resultrandomvariable = X.sqrt().invert().mult(0.5);
                    break;
                }
                case EXP: {
                    resultrandomvariable = X.exp();
                    break;
                }
                case LOG: {
                    resultrandomvariable = X.invert();
                    break;
                }
                case SIN: {
                    resultrandomvariable = X.cos();
                    break;
                }
                case COS: {
                    resultrandomvariable = X.sin().mult(-1.0);
                    break;
                }
                case AVERAGE: {
                    resultrandomvariable = new RandomVariable(1.0);
                    break;
                }
                case CONDITIONAL_EXPECTATION: {
                    resultrandomvariable = new RandomVariable(1.0);
                    break;
                }
                case VARIANCE: {
                    resultrandomvariable = X.sub(X.getAverage() * (2.0 * (double)X.size() - 1.0) / (double)X.size()).mult(2.0 / (double)X.size());
                    break;
                }
                case STDEV: {
                    resultrandomvariable = X.sub(X.getAverage() * (2.0 * (double)X.size() - 1.0) / (double)X.size()).mult(2.0 / (double)X.size()).mult(0.5).div(Math.sqrt(X.getVariance()));
                    break;
                }
                case MIN: {
                    double min = X.getMin();
                    resultrandomvariable = X.apply(x -> x == min ? 1.0 : 0.0);
                    break;
                }
                case MAX: {
                    double max = X.getMax();
                    resultrandomvariable = X.apply(x -> x == max ? 1.0 : 0.0);
                    break;
                }
                case ABS: {
                    resultrandomvariable = X.barrier(X, (RandomVariableInterface)new RandomVariable(1.0), (RandomVariableInterface)new RandomVariable(-1.0));
                    break;
                }
                case STDERROR: {
                    resultrandomvariable = X.sub(X.getAverage() * (2.0 * (double)X.size() - 1.0) / (double)X.size()).mult(2.0 / (double)X.size()).mult(0.5).div(Math.sqrt(X.getVariance() * (double)X.size()));
                    break;
                }
                case SVARIANCE: {
                    resultrandomvariable = X.sub(X.getAverage() * (2.0 * (double)X.size() - 1.0) / (double)X.size()).mult(2.0 / (double)(X.size() - 1));
                    break;
                }
                case ADD: {
                    resultrandomvariable = new RandomVariable(1.0);
                    break;
                }
                case SUB: {
                    resultrandomvariable = new RandomVariable(differentialIndex == 0 ? 1.0 : -1.0);
                    break;
                }
                case MULT: {
                    resultrandomvariable = differentialIndex == 0 ? Y : X;
                    break;
                }
                case DIV: {
                    resultrandomvariable = differentialIndex == 0 ? Y.invert() : X.div(Y.squared()).mult(-1.0);
                    break;
                }
                case CAP: {
                    if (differentialIndex == 0) {
                        resultrandomvariable = X.barrier(X.sub(Y), (RandomVariableInterface)new RandomVariable(0.0), (RandomVariableInterface)new RandomVariable(1.0));
                        break;
                    }
                    resultrandomvariable = X.barrier(X.sub(Y), (RandomVariableInterface)new RandomVariable(1.0), (RandomVariableInterface)new RandomVariable(0.0));
                    break;
                }
                case FLOOR: {
                    if (differentialIndex == 0) {
                        resultrandomvariable = X.barrier(X.sub(Y), (RandomVariableInterface)new RandomVariable(1.0), (RandomVariableInterface)new RandomVariable(0.0));
                        break;
                    }
                    resultrandomvariable = X.barrier(X.sub(Y), (RandomVariableInterface)new RandomVariable(0.0), (RandomVariableInterface)new RandomVariable(1.0));
                    break;
                }
                case AVERAGE2: {
                    resultrandomvariable = differentialIndex == 0 ? Y : X;
                    break;
                }
                case VARIANCE2: {
                    resultrandomvariable = differentialIndex == 0 ? Y.mult(2.0).mult(X.mult(Y.add(X.getAverage(Y) * (double)(X.size() - 1)).sub(X.getAverage(Y)))) : X.mult(2.0).mult(Y.mult(X.add(Y.getAverage(X) * (double)(X.size() - 1)).sub(Y.getAverage(X))));
                    break;
                }
                case STDEV2: {
                    resultrandomvariable = differentialIndex == 0 ? Y.mult(2.0).mult(X.mult(Y.add(X.getAverage(Y) * (double)(X.size() - 1)).sub(X.getAverage(Y)))).div(Math.sqrt(X.getVariance(Y))) : X.mult(2.0).mult(Y.mult(X.add(Y.getAverage(X) * (double)(X.size() - 1)).sub(Y.getAverage(X)))).div(Math.sqrt(Y.getVariance(X)));
                    break;
                }
                case STDERROR2: {
                    resultrandomvariable = differentialIndex == 0 ? Y.mult(2.0).mult(X.mult(Y.add(X.getAverage(Y) * (double)(X.size() - 1)).sub(X.getAverage(Y)))).div(Math.sqrt(X.getVariance(Y) * (double)X.size())) : X.mult(2.0).mult(Y.mult(X.add(Y.getAverage(X) * (double)(X.size() - 1)).sub(Y.getAverage(X)))).div(Math.sqrt(Y.getVariance(X) * (double)Y.size()));
                    break;
                }
                case POW: {
                    resultrandomvariable = differentialIndex == 0 ? Y.mult(X.pow(Y.getAverage() - 1.0)) : new RandomVariable(0.0);
                    break;
                }
                case ADDPRODUCT: {
                    if (differentialIndex == 0) {
                        resultrandomvariable = new RandomVariable(1.0);
                        break;
                    }
                    if (differentialIndex == 1) {
                        resultrandomvariable = Z;
                        break;
                    }
                    resultrandomvariable = Y;
                    break;
                }
                case ADDRATIO: {
                    if (differentialIndex == 0) {
                        resultrandomvariable = new RandomVariable(1.0);
                        break;
                    }
                    if (differentialIndex == 1) {
                        resultrandomvariable = Z.invert();
                        break;
                    }
                    resultrandomvariable = Y.div(Z.squared()).mult(-1.0);
                    break;
                }
                case SUBRATIO: {
                    if (differentialIndex == 0) {
                        resultrandomvariable = new RandomVariable(1.0);
                        break;
                    }
                    if (differentialIndex == 1) {
                        resultrandomvariable = Z.invert().mult(-1.0);
                        break;
                    }
                    resultrandomvariable = Y.div(Z.squared());
                    break;
                }
                case ACCRUE: {
                    if (differentialIndex == 0) {
                        resultrandomvariable = Y.mult(Z).add(1.0);
                        break;
                    }
                    if (differentialIndex == 1) {
                        resultrandomvariable = X.mult(Z);
                        break;
                    }
                    resultrandomvariable = X.mult(Y);
                    break;
                }
                case DISCOUNT: {
                    if (differentialIndex == 0) {
                        resultrandomvariable = Y.mult(Z).add(1.0).invert();
                        break;
                    }
                    if (differentialIndex == 1) {
                        resultrandomvariable = X.mult(Z).div(Y.mult(Z).add(1.0).squared()).mult(-1.0);
                        break;
                    }
                    resultrandomvariable = X.mult(Y).div(Y.mult(Z).add(1.0).squared()).mult(-1.0);
                    break;
                }
                case BARRIER: {
                    if (differentialIndex == 0) {
                        resultrandomvariable = Y.sub(Z);
                        double epsilon = 0.2 * X.getStandardDeviation();
                        resultrandomvariable = resultrandomvariable.mult(X.barrier(X.add(epsilon / 2.0), (RandomVariableInterface)new RandomVariable(1.0), (RandomVariableInterface)new RandomVariable(0.0)));
                        resultrandomvariable = resultrandomvariable.mult(X.barrier(X.sub(epsilon / 2.0), (RandomVariableInterface)new RandomVariable(0.0), (RandomVariableInterface)new RandomVariable(1.0)));
                        resultrandomvariable = resultrandomvariable.div(epsilon);
                        break;
                    }
                    resultrandomvariable = differentialIndex == 1 ? X.barrier(X, (RandomVariableInterface)new RandomVariable(1.0), (RandomVariableInterface)new RandomVariable(0.0)) : X.barrier(X, (RandomVariableInterface)new RandomVariable(0.0), (RandomVariableInterface)new RandomVariable(1.0));
                }
            }
            return resultrandomvariable;
        }
    }

    private static enum OperatorType {
        ADD,
        MULT,
        DIV,
        SUB,
        SQUARED,
        SQRT,
        LOG,
        SIN,
        COS,
        EXP,
        INVERT,
        CAP,
        FLOOR,
        ABS,
        ADDPRODUCT,
        ADDRATIO,
        SUBRATIO,
        BARRIER,
        DISCOUNT,
        ACCRUE,
        POW,
        MIN,
        MAX,
        AVERAGE,
        VARIANCE,
        STDEV,
        STDERROR,
        SVARIANCE,
        AVERAGE2,
        VARIANCE2,
        STDEV2,
        STDERROR2,
        CONDITIONAL_EXPECTATION;

    }
}

