/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.Swaption;
import net.finmath.montecarlo.interestrate.products.SwaptionSimple;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.RegularSchedule;
import net.finmath.time.ScheduleInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class SwaptionATM
extends AbstractLIBORMonteCarloProduct {
    private final TimeDiscretizationInterface tenor;
    private final SwaptionSimple.ValueUnit valueUnit;

    public SwaptionATM(double[] swapTenor, SwaptionSimple.ValueUnit valueUnit) {
        this.tenor = new TimeDiscretization(swapTenor);
        this.valueUnit = valueUnit;
    }

    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        ForwardCurveInterface forwardCurve = model.getModel().getForwardRateCurve();
        DiscountCurveInterface discountCurve = model.getModel().getAnalyticModel() != null ? model.getModel().getAnalyticModel().getDiscountCurve(forwardCurve.getDiscountCurveName()) : null;
        double optionMaturity = this.tenor.getTime(0);
        double swapAnnuity = discountCurve != null ? SwapAnnuity.getSwapAnnuity((TimeDiscretizationInterface)this.tenor, (DiscountCurveInterface)discountCurve) : SwapAnnuity.getSwapAnnuity((TimeDiscretizationInterface)this.tenor, (ForwardCurveInterface)forwardCurve);
        double parSwapRate = Swap.getForwardSwapRate((ScheduleInterface)new RegularSchedule(this.tenor), (ScheduleInterface)new RegularSchedule(this.tenor), (ForwardCurveInterface)forwardCurve, (AnalyticModelInterface)model.getModel().getAnalyticModel());
        Swaption swaption = new Swaption(this.tenor.getTime(0), this.tenor, parSwapRate);
        RandomVariableInterface optionValue = swaption.getValue(evaluationTime, model);
        switch (this.valueUnit) {
            case VALUE: {
                return optionValue;
            }
            case VOLATILITYNORMAL: {
                return this.getImpliedBachelierATMOptionVolatility(optionValue, optionMaturity, swapAnnuity);
            }
            case INTEGRATEDNORMALVARIANCE: {
                return this.getImpliedBachelierATMOptionVolatility(optionValue, optionMaturity, swapAnnuity).squared().mult(optionMaturity);
            }
        }
        throw new IllegalArgumentException("Unknown valueUnit: " + this.valueUnit.name());
    }

    public RandomVariableInterface getImpliedBachelierATMOptionVolatility(RandomVariableInterface optionValue, double optionMaturity, double swapAnnuity) {
        return optionValue.average().mult(Math.sqrt(Math.PI * 2 / optionMaturity) / swapAnnuity);
    }
}

