/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.optimizer;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import net.finmath.montecarlo.automaticdifferentiation.RandomVariableDifferentiableInterface;
import net.finmath.optimizer.SolverException;
import net.finmath.optimizer.StochasticPathwiseLevenbergMarquardt;
import net.finmath.stochastic.RandomVariableInterface;

public abstract class StochasticPathwiseLevenbergMarquardtAD
extends StochasticPathwiseLevenbergMarquardt {
    private static final long serialVersionUID = -8852002990042152135L;

    public StochasticPathwiseLevenbergMarquardtAD(List<RandomVariableInterface> initialParameters, List<RandomVariableInterface> targetValues, int maxIteration, ExecutorService executorService) {
        super(initialParameters, targetValues, maxIteration, executorService);
    }

    public StochasticPathwiseLevenbergMarquardtAD(List<RandomVariableInterface> initialParameters, List<RandomVariableInterface> targetValues, int maxIteration, int numberOfThreads) {
        super(initialParameters, targetValues, maxIteration, numberOfThreads);
    }

    public StochasticPathwiseLevenbergMarquardtAD(RandomVariableInterface[] initialParameters, RandomVariableInterface[] targetValues, int maxIteration, int numberOfThreads) {
        super(initialParameters, targetValues, maxIteration, numberOfThreads);
    }

    public StochasticPathwiseLevenbergMarquardtAD(RandomVariableInterface[] initialParameters, RandomVariableInterface[] targetValues, RandomVariableInterface[] weights, RandomVariableInterface[] parameterSteps, int maxIteration, RandomVariableInterface errorTolerance, ExecutorService executorService) {
        super(initialParameters, targetValues, weights, parameterSteps, maxIteration, errorTolerance, executorService);
    }

    protected void prepareAndSetValues(RandomVariableInterface[] parameters, RandomVariableInterface[] values) throws SolverException {
        for (int i = 0; i < parameters.length; ++i) {
            if (!(parameters[i] instanceof RandomVariableDifferentiableInterface)) continue;
            parameters[i] = ((RandomVariableDifferentiableInterface)parameters[i]).getCloneIndependent();
        }
        this.setValues(parameters, values);
    }

    protected void prepareAndSetDerivatives(RandomVariableInterface[] parameters, RandomVariableInterface[] values, RandomVariableInterface[][] derivatives) throws SolverException {
        int valueIndex;
        boolean isRandomVariableDifferentiable = true;
        for (int parameterIndex = 0; parameterIndex < parameters.length && isRandomVariableDifferentiable; ++parameterIndex) {
            isRandomVariableDifferentiable = parameters[parameterIndex] instanceof RandomVariableDifferentiableInterface && isRandomVariableDifferentiable;
        }
        for (valueIndex = 0; valueIndex < values.length && isRandomVariableDifferentiable; ++valueIndex) {
            isRandomVariableDifferentiable = values[valueIndex] instanceof RandomVariableDifferentiableInterface && isRandomVariableDifferentiable;
        }
        if (isRandomVariableDifferentiable) {
            for (valueIndex = 0; valueIndex < values.length; ++valueIndex) {
                Map<Long, RandomVariableInterface> gradient = ((RandomVariableDifferentiableInterface)values[valueIndex]).getGradient();
                for (int parameterIndex = 0; parameterIndex < parameters.length; ++parameterIndex) {
                    derivatives[parameterIndex][valueIndex] = gradient.get(((RandomVariableDifferentiableInterface)parameters[parameterIndex]).getID());
                }
            }
        } else {
            this.setDerivatives(parameters, derivatives);
        }
    }
}

