/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.rootfinder;

import net.finmath.rootfinder.StochasticRootFinderUsingDerivative;
import net.finmath.stochastic.RandomVariableInterface;

public class StochasticNewtonMethod
implements StochasticRootFinderUsingDerivative {
    private RandomVariableInterface nextPoint;
    private RandomVariableInterface bestPoint;
    private int numberOfIterations = 0;
    private double accuracy = Double.MAX_VALUE;
    private boolean isDone = false;
    private MethodForAccuracy method;

    public StochasticNewtonMethod(RandomVariableInterface guess, MethodForAccuracy method) {
        this.bestPoint = guess;
        this.nextPoint = guess;
        this.method = method;
    }

    @Override
    public RandomVariableInterface getNextPoint() {
        return this.nextPoint;
    }

    @Override
    public void setValueAndDerivative(RandomVariableInterface value, RandomVariableInterface derivative) {
        double currentAccuracy;
        switch (this.method) {
            case AVERAGE: {
                currentAccuracy = value.abs().getAverage();
                break;
            }
            case MAX: {
                currentAccuracy = value.abs().getMax();
                break;
            }
            case MIN: {
                currentAccuracy = value.abs().getMin();
                break;
            }
            default: {
                throw new IllegalArgumentException("Method to get current accuracy from RandomVariableInterface not supported!");
            }
        }
        if (currentAccuracy < this.accuracy) {
            this.accuracy = currentAccuracy;
            this.bestPoint = this.nextPoint;
        }
        this.nextPoint = this.nextPoint.addRatio(value, derivative);
        ++this.numberOfIterations;
    }

    @Override
    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    @Override
    public double getAccuracy() {
        return this.accuracy;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public RandomVariableInterface getBestPoint() {
        return this.bestPoint;
    }

    public static enum MethodForAccuracy {
        AVERAGE,
        MAX,
        MIN;

    }
}

