/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.plots.GraphStyle;
import net.finmath.plots.Plot;
import net.finmath.plots.Plot2D;
import net.finmath.plots.Plotable2D;
import net.finmath.plots.PlotablePoints2D;
import net.finmath.plots.Point2D;
import net.finmath.plots.axis.NumberAxis;
import net.finmath.stochastic.RandomVariable;
import org.apache.commons.lang3.ArrayUtils;

public class Plots {
    public static Plot2D createScatter(List<Double> x, Map<String, List<Double>> mapOfValues, double xmin, double xmax, int dotSize) {
        ArrayList<Plotable2D> plotables = new ArrayList<Plotable2D>();
        for (Map.Entry<String, List<Double>> values : mapOfValues.entrySet()) {
            ArrayList<Point2D> series = new ArrayList<Point2D>();
            List<Double> valueDoubles = values.getValue();
            for (int i = 0; i < valueDoubles.size(); ++i) {
                series.add(new Point2D(x.get(i), valueDoubles.get(i)));
            }
            plotables.add(new PlotablePoints2D(values.getKey(), series, new GraphStyle(new Rectangle(dotSize, dotSize), null, null)));
        }
        return new Plot2D(plotables);
    }

    public static Plot createScatter(List<double[]> points, Double xmin, Double xmax, Double ymin, Double ymax, int dotSize) {
        List<Plotable2D> plotables = Arrays.asList(new PlotablePoints2D("Scatter", points.stream().map(point -> new Point2D(point[0], point[1])).collect(Collectors.toList()), xmin != null && xmax != null ? new NumberAxis(null, xmin, xmax, null) : null, ymin != null && ymax != null ? new NumberAxis(null, ymin, ymax, null) : null, new GraphStyle(new Rectangle(dotSize, dotSize), null, null)));
        return new Plot2D(plotables);
    }

    public static Plot2D createScatter(double[] xValues, double[] yValues, double xmin, double xmax, int dotSize) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (int i = 0; i < xValues.length; ++i) {
            points.add(new Point2D(xValues[i], yValues[i]));
        }
        List<Plotable2D> plotables = Arrays.asList(new PlotablePoints2D("Scatter", points, new GraphStyle(new Rectangle(dotSize, dotSize), null, null)));
        return new Plot2D(plotables);
    }

    public static Plot2D createScatter(List<Double> x, List<Double> y, double xmin, double xmax, int dotSize) {
        return Plots.createScatter(ArrayUtils.toPrimitive((Double[])x.toArray(new Double[x.size()])), ArrayUtils.toPrimitive((Double[])y.toArray(new Double[y.size()])), xmin, xmax, dotSize);
    }

    public static Plot2D updateScatter(Plot2D plot, double[] xValues, double[] yValues, double xmin, double xmax, int dotSize) {
        ArrayList<Point2D> series = new ArrayList<Point2D>();
        for (int i = 0; i < xValues.length; ++i) {
            series.add(new Point2D(xValues[i], yValues[i]));
        }
        List<Plotable2D> plotables = Arrays.asList(new PlotablePoints2D("Scatter", series, new GraphStyle(new Rectangle(dotSize, dotSize), null, null)));
        return plot.update(plotables);
    }

    public static Plot2D updatePlotScatter(Plot2D plot, List<Double> x, List<Double> y, double xmin, double xmax, int dotSize) {
        return Plots.updateScatter(plot, ArrayUtils.toPrimitive((Double[])x.toArray(new Double[x.size()])), ArrayUtils.toPrimitive((Double[])y.toArray(new Double[y.size()])), xmin, xmax, dotSize);
    }

    public static Plot2D createScatter(RandomVariable x, RandomVariable y, double xmin, double xmax, int dotSize) {
        return Plots.createScatter(x.getRealizations(), y.getRealizations(), xmin, xmax, dotSize);
    }

    public static Plot2D createScatter(RandomVariable x, RandomVariable y, double xmin, double xmax) {
        return Plots.createScatter(x, y, xmin, xmax, 1);
    }

    public static Plot2D createScatter(RandomVariable x, RandomVariable y) {
        return Plots.createScatter(x, y, x.getMin(), x.getMax());
    }

    public static Plot2D createHistogram(RandomVariable randomVariable, int numberOfPoints, double standardDeviations) {
        double[][] histogram = randomVariable.getHistogram(numberOfPoints, standardDeviations);
        ArrayList<Point2D> series = new ArrayList<Point2D>();
        for (int i = 0; i < histogram[0].length; ++i) {
            series.add(new Point2D(histogram[0][i], histogram[1][i]));
        }
        List<Plotable2D> plotables = Arrays.asList(new PlotablePoints2D("Histogram", series, new GraphStyle(new Rectangle(10, 2), null, Color.DARK_GRAY, Color.LIGHT_GRAY)));
        Plot2D plot = new Plot2D(plotables);
        plot.setXAxisLabel("values");
        plot.setYAxisLabel("frequency");
        return plot;
    }

    public static Plot2D createHistogram(List<Double> values, int numberOfPoints, double standardDeviations) {
        RandomVariableFromDoubleArray randomVariable = new RandomVariableFromDoubleArray(0.0, ArrayUtils.toPrimitive((Double[])values.toArray(new Double[values.size()])));
        return Plots.createHistogram((RandomVariable)randomVariable, numberOfPoints, standardDeviations);
    }

    public static Plot2D updateHistogram(Plot2D histogram, RandomVariable randomVariable, int numberOfPoints, double standardDeviations) {
        double[][] histogramValues = randomVariable.getHistogram(numberOfPoints, standardDeviations);
        ArrayList<Point2D> series = new ArrayList<Point2D>();
        for (int i = 0; i < histogramValues[0].length; ++i) {
            series.add(new Point2D(histogramValues[0][i], histogramValues[1][i]));
        }
        List<Plotable2D> plotables = Arrays.asList(new PlotablePoints2D("Histogram", series, new GraphStyle(new Rectangle(10, 2), null, Color.DARK_GRAY, Color.LIGHT_GRAY)));
        histogram.update(plotables);
        return histogram;
    }

    public static Plot2D updateHistogram(Plot2D histogram, List<Double> values, int numberOfPoints, double standardDeviations) {
        RandomVariableFromDoubleArray randomVariable = new RandomVariableFromDoubleArray(0.0, ArrayUtils.toPrimitive((Double[])values.toArray(new Double[values.size()])));
        return Plots.updateHistogram(histogram, (RandomVariable)randomVariable, numberOfPoints, standardDeviations);
    }

    public static Plot createHistogramBehindValues(RandomVariable randomVariableX, RandomVariable randomVariableY, int numberOfPoints, double standardDeviations) {
        return Plots.createHistogramBehindValues(randomVariableX, randomVariableY, numberOfPoints, standardDeviations, null, null);
    }

    public static Plot createHistogramBehindValues(RandomVariable randomVariableX, RandomVariable randomVariableY, int numberOfPoints, double standardDeviations, Double xmin, Double xmax) {
        double[][] histogram = randomVariableX.getHistogram(numberOfPoints, standardDeviations);
        ArrayList<Point2D> seriesForHistogram = new ArrayList<Point2D>();
        for (int i = 0; i < histogram[0].length; ++i) {
            seriesForHistogram.add(new Point2D(histogram[0][i], histogram[1][i]));
        }
        ArrayList<Point2D> seriesForScatter = new ArrayList<Point2D>();
        for (int i = 0; i < randomVariableX.size(); ++i) {
            seriesForScatter.add(new Point2D(randomVariableX.get(i), randomVariableY.get(i)));
        }
        NumberAxis domainAxis = new NumberAxis("underlying value", xmin, xmax);
        NumberAxis rangeAxisHistogram = new NumberAxis("frequency", null, null);
        NumberAxis rangeAxisScatter = new NumberAxis("value", null, null);
        List<Plotable2D> plotables = Arrays.asList(new PlotablePoints2D("Scatter", seriesForScatter, domainAxis, rangeAxisScatter, new GraphStyle(new Rectangle(new Point(-2, -2), new Dimension(4, 4)), null, Color.RED)), new PlotablePoints2D("Histogram", seriesForHistogram, domainAxis, rangeAxisHistogram, new GraphStyle(new Rectangle(2, 2), null, Color.DARK_GRAY, Color.LIGHT_GRAY)));
        return new Plot2D(plotables);
    }

    public static Plot2D createDensity(RandomVariable randomVariable, int numberOfPoints, double standardDeviations) {
        double[][] histogram = randomVariable.getHistogram(numberOfPoints, standardDeviations);
        double length = histogram[0][histogram[0].length - 1] - histogram[0][0];
        ArrayList<Point2D> series = new ArrayList<Point2D>();
        for (int i = 0; i < histogram[0].length; ++i) {
            series.add(new Point2D(histogram[0][i], histogram[1][i] * (double)numberOfPoints / length));
        }
        List<Plotable2D> plotables = Arrays.asList(new PlotablePoints2D("Histogram", series, new GraphStyle(new Rectangle(10, 2), null, Color.DARK_GRAY, Color.LIGHT_GRAY)));
        Plot2D plot = new Plot2D(plotables);
        plot.setXAxisLabel("values");
        plot.setYAxisLabel("relative frequency");
        return plot;
    }

    public static Plot2D createDensity(List<Double> values, int numberOfPoints, double standardDeviations) {
        RandomVariableFromDoubleArray randomVariable = new RandomVariableFromDoubleArray(0.0, ArrayUtils.toPrimitive((Double[])values.toArray(new Double[values.size()])));
        return Plots.createDensity((RandomVariable)randomVariable, numberOfPoints, standardDeviations);
    }

    public static Plot2D updateDensity(Plot2D histogram, RandomVariable randomVariable, int numberOfPoints, double standardDeviations) {
        double[][] histogramValues = randomVariable.getHistogram(numberOfPoints, standardDeviations);
        double length = histogramValues[0][histogramValues[0].length - 1] - histogramValues[0][0];
        ArrayList<Point2D> series = new ArrayList<Point2D>();
        for (int i = 0; i < histogramValues[0].length; ++i) {
            series.add(new Point2D(histogramValues[0][i], histogramValues[1][i] * (double)numberOfPoints / length));
        }
        List<Plotable2D> plotables = Arrays.asList(new PlotablePoints2D("Histogram", series, new GraphStyle(new Rectangle(10, 2), null, Color.DARK_GRAY, Color.LIGHT_GRAY)));
        histogram.update(plotables);
        return histogram;
    }

    public static Plot2D updateDensity(Plot2D histogram, List<Double> values, int numberOfPoints, double standardDeviations) {
        RandomVariableFromDoubleArray randomVariable = new RandomVariableFromDoubleArray(0.0, ArrayUtils.toPrimitive((Double[])values.toArray(new Double[values.size()])));
        return Plots.updateDensity(histogram, (RandomVariable)randomVariable, numberOfPoints, standardDeviations);
    }

    public static Plot createDensityBehindValues(RandomVariable randomVariableX, RandomVariable randomVariableY, int numberOfPoints, double standardDeviations) {
        return Plots.createDensityBehindValues(randomVariableX, randomVariableY, numberOfPoints, standardDeviations, null, null);
    }

    public static Plot createDensityBehindValues(RandomVariable randomVariableX, RandomVariable randomVariableY, int numberOfPoints, double standardDeviations, Double xmin, Double xmax) {
        double[][] histogram = randomVariableX.getHistogram(numberOfPoints, standardDeviations);
        double length = histogram[0][histogram[0].length - 1] - histogram[0][0];
        ArrayList<Point2D> seriesForHistogram = new ArrayList<Point2D>();
        for (int i = 0; i < histogram[0].length; ++i) {
            seriesForHistogram.add(new Point2D(histogram[0][i], histogram[1][i] * (double)numberOfPoints / length));
        }
        ArrayList<Point2D> seriesForScatter = new ArrayList<Point2D>();
        for (int i = 0; i < randomVariableX.size(); ++i) {
            seriesForScatter.add(new Point2D(randomVariableX.get(i), randomVariableY.get(i)));
        }
        NumberAxis domainAxis = new NumberAxis("underlying value", xmin, xmax);
        NumberAxis rangeAxisHistogram = new NumberAxis("frequency", null, null);
        NumberAxis rangeAxisScatter = new NumberAxis("value", null, null);
        List<Plotable2D> plotables = Arrays.asList(new PlotablePoints2D("Scatter", seriesForScatter, domainAxis, rangeAxisScatter, new GraphStyle(new Rectangle(new Point(-2, -2), new Dimension(4, 4)), null, Color.RED)), new PlotablePoints2D("Histogram", seriesForHistogram, domainAxis, rangeAxisHistogram, new GraphStyle(new Rectangle(2, 2), null, Color.DARK_GRAY, Color.LIGHT_GRAY)));
        return new Plot2D(plotables);
    }

    @Deprecated(forRemoval=true)
    public static Plot2D createPlotOfHistogram(RandomVariable randomVariable, int numberOfPoints, double standardDeviations) {
        return Plots.createHistogram(randomVariable, numberOfPoints, standardDeviations);
    }

    @Deprecated(forRemoval=true)
    public static Plot2D updatePlotOfHistogram(Plot2D histogram, RandomVariable randomVariable, int numberOfPoints, double standardDeviations) {
        return Plots.updateHistogram(histogram, randomVariable, numberOfPoints, standardDeviations);
    }

    @Deprecated(forRemoval=true)
    public static Plot createPlotOfHistogramBehindValues(RandomVariable randomVariableX, RandomVariable randomVariableY, int numberOfPoints, double standardDeviations) {
        return Plots.createHistogramBehindValues(randomVariableX, randomVariableY, numberOfPoints, standardDeviations);
    }

    @Deprecated(forRemoval=true)
    public static Plot createPlotOfHistogramBehindValues(RandomVariable randomVariableX, RandomVariable randomVariableY, int numberOfPoints, double standardDeviations, Double xmin, Double xmax) {
        return Plots.createHistogramBehindValues(randomVariableX, randomVariableY, numberOfPoints, standardDeviations, xmin, xmax);
    }

    @Deprecated(forRemoval=true)
    public static Plot2D createPlotScatter(double[] xValues, double[] yValues, double xmin, double xmax, int dotSize) {
        return Plots.createScatter(xValues, yValues, xmin, xmax, dotSize);
    }

    @Deprecated(forRemoval=true)
    public static Plot2D createPlotScatter(List<Double> x, List<Double> y, double xmin, double xmax, int dotSize) {
        return Plots.createScatter(x, y, xmin, xmax, dotSize);
    }

    @Deprecated(forRemoval=true)
    public static Plot2D updatePlotScatter(Plot2D plot, double[] xValues, double[] yValues, double xmin, double xmax, int dotSize) {
        return Plots.updateScatter(plot, xValues, yValues, xmin, xmax, dotSize);
    }

    @Deprecated(forRemoval=true)
    public static Plot2D createPlotScatter(RandomVariable x, RandomVariable y, double xmin, double xmax, int dotSize) {
        return Plots.createScatter(x, y, xmin, xmax, dotSize);
    }

    @Deprecated(forRemoval=true)
    public static Plot2D createPlotScatter(RandomVariable x, RandomVariable y, double xmin, double xmax) {
        return Plots.createScatter(x, y, xmin, xmax);
    }
}

