/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots.demo;

import java.util.Arrays;
import java.util.function.DoubleUnaryOperator;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.plots.Named;
import net.finmath.plots.Plot2D;

public class Plot2DDemo2 {
    public static void main(String[] args) throws Exception {
        double initialStockValue = 100.0;
        double riskFreeRate = 0.04;
        double volatility = 0.4;
        DoubleUnaryOperator function = strike -> {
            double optionMaturity = 1.0;
            double optionStrike = strike;
            double z = AnalyticFormulas.blackScholesOptionValue((double)100.0, (double)0.04, (double)0.4, (double)1.0, (double)optionStrike);
            return z;
        };
        DoubleUnaryOperator function2 = strike -> {
            double optionStrike = strike;
            double optionMaturity = 2.0;
            double z = AnalyticFormulas.blackScholesOptionValue((double)100.0, (double)0.04, (double)0.4, (double)2.0, (double)optionStrike);
            return z;
        };
        Plot2D plot = new Plot2D(0.0, 300.0, 100, Arrays.asList(new Named<DoubleUnaryOperator>("Maturity 1", function), new Named<DoubleUnaryOperator>("Maturity 2", function2)));
        plot.setTitle("Black-Scholes Model European Option Value").setXAxisLabel("strike").setYAxisLabel("value").setIsLegendVisible(true);
        plot.show();
    }
}

