/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots.demo;

import java.io.File;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.DoubleUnaryOperator;
import net.finmath.plots.Named;
import net.finmath.plots.Plot2D;

public class Plot2DDemo4 {
    private static final int numberOfPointsToPlot = 200;
    private static final boolean isSavePlotsToFile = true;

    public static void main(String[] args) throws Exception {
        double x = 0.0;
        DoubleUnaryOperator functionDerivativeCentralError = shiftScale -> {
            double shiftSize = Math.pow(10.0, -shiftScale);
            double valueUp = Math.exp(0.0 + shiftSize);
            double valueDown = Math.exp(0.0 - shiftSize);
            double derivativeFiniteDifference = (valueUp - valueDown) / 2.0 / shiftSize - 1.0;
            return derivativeFiniteDifference;
        };
        DoubleUnaryOperator functionDerivativeForwardError = shiftScale -> {
            double shiftSize = Math.pow(10.0, -shiftScale);
            double valueUp = Math.exp(0.0 + shiftSize);
            double value = Math.exp(0.0);
            double derivativeFiniteDifference = (valueUp - value) / shiftSize - 1.0;
            return derivativeFiniteDifference;
        };
        DoubleUnaryOperator functionDerivativeAnalytic = shiftScale -> Math.exp(0.0) - 1.0;
        Plot2D plotDerivativeForward = new Plot2D(1.0, 15.0, 200, List.of(new Named<DoubleUnaryOperator>("Finite Difference Approximation", functionDerivativeForwardError), new Named<DoubleUnaryOperator>("Analytic", functionDerivativeAnalytic)));
        plotDerivativeForward.setTitle("(One Sided Finite Difference) Derivative of exp(x) at x = 0.0").setXAxisLabel("scale (h = 10^{-scale})").setYAxisLabel("error (approx. value - 1.0)").setIsLegendVisible(true);
        plotDerivativeForward.setYAxisNumberFormat(new DecimalFormat("0.0E00"));
        plotDerivativeForward.show();
        plotDerivativeForward.saveAsPDF(new File("exp-x-forward-fd-large.pdf"), 900, 600);
        Plot2D plotDerivativeForward3 = new Plot2D(14.0, 16.5, 200, List.of(new Named<DoubleUnaryOperator>("Finite Difference Approximation", functionDerivativeForwardError), new Named<DoubleUnaryOperator>("Analytic", functionDerivativeAnalytic)));
        plotDerivativeForward3.setTitle("(One Sided Finite Difference) Derivative of exp(x) at x = 0.0").setXAxisLabel("scale (h = 10^{-scale})").setYAxisLabel("error (approx. value - 1.0)").setIsLegendVisible(true);
        plotDerivativeForward3.setYAxisNumberFormat(new DecimalFormat("0.0E00"));
        plotDerivativeForward3.show();
        plotDerivativeForward3.saveAsPDF(new File("exp-x-forward-fd-corner.pdf"), 900, 600);
        Plot2D plotDerivativeForward2 = new Plot2D(6.0, 10.0, 200, List.of(new Named<DoubleUnaryOperator>("Finite Difference Approximation", functionDerivativeForwardError), new Named<DoubleUnaryOperator>("Analytic", functionDerivativeAnalytic)));
        plotDerivativeForward2.setTitle("(One Sided Finite Difference) Derivative of exp(x) at x = 0.0").setXAxisLabel("scale (h = 10^{-scale})").setYAxisLabel("error (approx. value - 1.0)").setIsLegendVisible(true);
        plotDerivativeForward2.setYAxisNumberFormat(new DecimalFormat("0.0E00"));
        plotDerivativeForward2.show();
        plotDerivativeForward2.saveAsPDF(new File("exp-x-forward-fd-zoom.pdf"), 900, 600);
        Plot2D plotDerivativeCentral1 = new Plot2D(1.0, 20.0, 200, List.of(new Named<DoubleUnaryOperator>("Finite Difference Approximation", functionDerivativeCentralError), new Named<DoubleUnaryOperator>("Analytic", functionDerivativeAnalytic)));
        plotDerivativeCentral1.setTitle("(Central Finite Difference) Derivative of exp(x) at x = 0.0").setXAxisLabel("scale (h = 10^{-scale})").setYAxisLabel("error (approx. value - 1.0)").setIsLegendVisible(true);
        plotDerivativeCentral1.setYAxisNumberFormat(new DecimalFormat("0.0E00"));
        plotDerivativeCentral1.show();
        plotDerivativeCentral1.saveAsPDF(new File("exp-x-central-fd-large.pdf"), 900, 600);
        Plot2D plotDerivativeCentral2 = new Plot2D(4.0, 7.0, 200, List.of(new Named<DoubleUnaryOperator>("Finite Difference Approximation", functionDerivativeCentralError), new Named<DoubleUnaryOperator>("Analytic", functionDerivativeAnalytic)));
        plotDerivativeCentral2.setTitle("(Central Finite Difference) Derivative of exp(x) at x = 0.0").setXAxisLabel("scale (h = 10^{-scale})").setYAxisLabel("error (approx. value - 1.0)").setIsLegendVisible(true);
        plotDerivativeCentral2.setYAxisNumberFormat(new DecimalFormat("0.0E00"));
        plotDerivativeCentral2.setYRange(-5.0E-10, 5.0E-10);
        plotDerivativeCentral2.show();
        plotDerivativeCentral2.saveAsPDF(new File("exp-x-central-fd-zoom.pdf"), 900, 600);
    }
}

